/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.soap;

import java.io.IOException;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.message.SOAPHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.votable.TableContentHandler;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.soap.DelegatingSOAPHandler;

public class AxisTableDeserializer
extends DeserializerImpl
implements TableHandler {
    private final StoragePolicy storagePolicy_;
    private StarTable starTable_;
    private TableContentHandler voParser_;
    private RowStore rowStore_;
    private boolean done_;

    public AxisTableDeserializer(StoragePolicy storagePolicy) {
        this.storagePolicy_ = storagePolicy;
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes atts, DeserializationContext context) throws SAXException {
        if ("VOTABLE".equals(localName)) {
            this.voParser_ = new TableContentHandler(true);
            this.voParser_.setTableHandler(this);
            this.voParser_.startDocument();
            return new DelegatingSOAPHandler(this.voParser_);
        }
        throw new SAXException("Unexpected child element " + localName);
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.starTable_ != null) {
            this.valueComplete();
        }
    }

    public void startTable(StarTable meta) {
        this.rowStore_ = this.storagePolicy_.makeConfiguredRowStore(meta);
    }

    public void rowData(Object[] row) throws SAXException {
        try {
            this.rowStore_.acceptRow(row);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw (SAXException)new SAXParseException(e.getMessage(), this.voParser_.getLocator()).initCause(e);
        }
    }

    public void endTable() throws SAXException {
        try {
            this.rowStore_.endRows();
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw (SAXException)new SAXParseException(e.getMessage(), this.voParser_.getLocator()).initCause(e);
        }
        this.starTable_ = this.rowStore_.getStarTable();
    }

    public Object getValue() {
        return this.starTable_;
    }

    public boolean componentsReady() {
        return this.done_;
    }

    public void valueComplete() throws SAXException {
        if (!this.done_) {
            this.voParser_.endDocument();
            this.setValue(this.starTable_);
            this.done_ = true;
        }
        super.valueComplete();
    }
}

