/*
 * Decompiled with CFR 0.152.
 */
package skyview.sia;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ivoa.util.CGI;
import skyview.executive.Imager;
import skyview.executive.Settings;
import skyview.sia.SIAWriter;
import skyview.survey.Util;

public class SIA {
    private static FileWriter testLog;
    private static SIA lastSIA;
    private static String dftSurvey;
    private boolean doFits;
    private String quicklook;
    private double ra;
    private double dec;
    private double sizex;
    private double sizey;
    private String proj;
    private String csys;
    private double equinox;
    private int naxisx;
    private int naxisy;
    private String interp;
    private String survey;
    private static FileWriter logger;

    private boolean hasMetadata(String[] formats) {
        for (String format : formats) {
            if (!format.equals("metadata")) continue;
            return true;
        }
        return false;
    }

    private String getSurvey() {
        String want = Settings.get("survey");
        if (want == null) {
            return Settings.get("DefaultSIASurveys");
        }
        if (Settings.has(want)) {
            return Settings.get(want);
        }
        return want;
    }

    private String getQuicklook(String[] formats) {
        for (String format : formats) {
            if (format.equals("all") || format.equals("graphics-all") || formats.equals("image/jpeg") || formats.equals("image/jpg")) {
                return "jpeg";
            }
            if (format.equals("image/gif")) {
                return "gif";
            }
            if (format.equals("image/tiff")) {
                return "tiff";
            }
            if (!format.equals("image/png")) continue;
            return "png";
        }
        return null;
    }

    private boolean hasFits(String[] formats) {
        for (String format : formats) {
            if (!format.equals("all") && !format.equals("image/fits") && !format.equals("image/x-fits") && !format.equals("application/fits")) continue;
            return true;
        }
        return false;
    }

    private void getGeometry() {
        String[] pos = Settings.getArray("pos");
        if (pos.length != 2) {
            this.error("POS not specified or incorrectly formatted:" + Settings.get("pos"));
        }
        try {
            double ra = Double.parseDouble(pos[0].trim());
            double dec = Double.parseDouble(pos[1].trim());
            String[] sz = Settings.getArray("size");
            if (sz.length < 1 || sz.length > 2) {
                this.error("Invalid string in size:" + Settings.get("size"));
            }
            double sizex = Double.parseDouble(sz[0]);
            this.sizey = sz.length == 2 ? Double.parseDouble(sz[1]) : sizex;
        }
        catch (Exception e) {
            this.error("Error parsing POS or SIZE:" + Settings.get("pos") + " :: " + Settings.get("size"));
        }
        this.proj = this.getProjection();
        Settings.put("projection", this.proj);
        this.csys = this.getFrame();
        this.equinox = this.getEquinox();
        Settings.put("equinox", "" + this.equinox);
        int[] axes = this.getNaxes();
        this.naxisx = axes[0];
        this.naxisy = axes[1];
        this.interp = this.getInterpolation();
    }

    int[] getNaxes() {
        if (Settings.has("NAXIS")) {
            String[] ax = Settings.getArray("NAXIS");
            try {
                int nx = Integer.parseInt(ax[0].trim());
                int ny = ax.length > 1 ? Integer.parseInt(ax[1].trim()) : nx;
                return new int[]{nx, ny};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[]{300, 300};
    }

    String getProjection() {
        String xset;
        String set;
        if (Settings.has("proj") && (set = Settings.get("proj")).length() >= 3 && ((xset = set.substring(0, 1).toUpperCase() + set.substring(1, 3).toLowerCase()).equals("Tan") || xset.equals("Ait") || xset.equals("Sin") || xset.equals("Car") || xset.equals("Csc") || xset.equals("Zea"))) {
            return xset;
        }
        return "Tan";
    }

    String getFrame() {
        if (Settings.has("cframe")) {
            String frame = Settings.get("cframe").toUpperCase().trim();
            if (frame.equals("ICRS")) {
                return "ICRS";
            }
            if (frame.equals("FK4")) {
                return "B";
            }
            if (frame.equals("FK5")) {
                return "J";
            }
            if (frame.startsWith("G")) {
                return "Galactic";
            }
            if (frame.startsWith("E")) {
                return "E";
            }
        } else {
            Settings.put("cframe", "FK5");
        }
        return "J";
    }

    String getInterpolation() {
        if (Settings.has("Interpolation")) {
            String interp = Settings.get("Interpolation").toUpperCase();
            if (interp.equals("LI")) {
                return "LI";
            }
            if (interp.equals("NN")) {
                return "NN";
            }
            if (interp.equals("CLIP")) {
                return "Clip";
            }
            if (interp.startsWith("LANCZOS")) {
                return "Lanczos" + interp.substring(7);
            }
            if (interp.startsWith("SPLINE")) {
                return "Spline" + interp.substring(6);
            }
        }
        return "Clip";
    }

    double getEquinox() {
        if (Settings.has("equinox")) {
            try {
                return Double.parseDouble(Settings.get("equinox"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.csys.equals("B")) {
            return 1950.0;
        }
        return 2000.0;
    }

    public static void main(String[] args) {
        SIA mySIA;
        for (int i = 0; i < args.length; ++i) {
            Settings.updateFromFile(args[i]);
        }
        SIA.log("Starting");
        lastSIA = mySIA = new SIA();
        mySIA.run();
    }

    public void writeSIAHeader() {
        Pattern p = Pattern.compile("\\$(\\w+)\\W");
        BufferedReader bf = null;
        try {
            bf = new BufferedReader(new InputStreamReader(Util.getResourceOrFile("cgifiles/sia.header")));
        }
        catch (Exception e) {
            this.error("Error opening SIA header file:" + e);
        }
        try {
            String line;
            while ((line = bf.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (m.find()) {
                    String gr = m.group(1);
                    line = Settings.has(gr) ? m.replaceFirst("value=\"" + Settings.get(gr) + "\" ") : m.replaceFirst("");
                }
                System.out.println(line);
            }
            bf.close();
            System.out.flush();
        }
        catch (Exception e) {
            System.err.println("IO error reading SIA header:" + e);
        }
    }

    public void writeSIAFooter() {
        System.out.println("</TABLEDATA></DATA></TABLE>");
        System.out.println("<INFO name=\"QUERY_STATUS\" value=\"OK\" />");
        System.out.println("</RESOURCE></VOTABLE>");
        System.out.close();
        System.err.close();
        SIA.log("Exiting!!!");
        System.exit(1);
    }

    public void doMetadata() {
        this.writeSIAHeader();
        this.writeSIAFooter();
    }

    public void run() {
        SIA.log("Running");
        try {
            CGI params = new CGI();
            SIA.log("Got CGI");
            System.in.close();
            String[] keys = params.keys();
            HashMap newArgs = new HashMap();
            for (String key : keys) {
                String[] values;
                for (String val : values = params.values(key)) {
                    Settings.put(key, val);
                }
            }
            SIA.log("Got args");
            String[] formats = Settings.getArray("format");
            if (formats.length == 0) {
                Settings.put("format", "Image/FITS,Image/JPEG");
            }
            for (int i = 0; i < formats.length; ++i) {
                formats[i] = formats[i].trim().toLowerCase();
            }
            if (this.hasMetadata(formats)) {
                this.doMetadata();
                return;
            }
            this.doFits = this.hasFits(formats);
            this.quicklook = this.getQuicklook(formats);
            if (!this.doFits && this.quicklook == null) {
                this.doFits = true;
                this.quicklook = "jpeg";
            }
            this.getGeometry();
            this.survey = this.getSurvey();
            SIA.log("Got all params");
        }
        catch (Exception e) {
            this.error("Exception found:" + e);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("survey=" + this.survey);
        args.add("position=" + Settings.get("pos"));
        if (this.sizex != 0.0) {
            args.add("size=" + Settings.get("size"));
        }
        args.add("pixels=" + this.naxisx + "," + this.naxisy);
        Settings.put("pixels", this.naxisx + "," + this.naxisy);
        if (this.sizex == 0.0 && this.naxisx == 0) {
            this.error("Invalid defaults: cannot set both size and naxis to 0");
        }
        args.add("projection=" + this.proj);
        args.add("coordinates=" + this.csys);
        args.add("equinox=" + this.equinox);
        args.add("sampler=" + this.interp);
        Settings.put("sampler", this.interp);
        SIA.log("Set settings");
        args.add("nofits");
        args.add("noexit");
        args.add("imagefinder=skyview.sia.Checker");
        args.add("mosaicker=skyview.sia.SIAWriter");
        SIA.log("Set settings 2");
        this.writeSIAHeader();
        SIA.log("Wrote header");
        boolean xerror = false;
        try {
            SIA.log("Start imager at:" + new Date());
            Imager.main(args.toArray(new String[0]));
            SIA.log("End imager at:" + new Date());
        }
        catch (Exception e) {
            SIA.log("Exception:" + e);
            int count = SIAWriter.getCount();
            System.out.println("</TABLEDATA></DATA></TABLE>");
            System.out.println("<INFO name=\"QUERY_STATUS\" value=\"ERROR\" >");
            System.out.println("Error during processing:" + e + ".");
            System.out.println(count + " records processed before error");
            System.out.println("</INFO></RESOURCE></VOTABLE>");
            e.printStackTrace(System.err);
            xerror = true;
        }
        if (!xerror) {
            SIA.log("About to write footer");
            this.writeSIAFooter();
        }
    }

    void error(String msg) {
        SIA.log("Error:" + msg);
        System.out.println("Content-type: text/xml\n");
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">");
        System.out.println("<VOTABLE><RESOURCE type=\"results\">");
        System.out.println("<INFO name=\"QUERY_STATUS\" value=\"ERROR\">");
        System.err.println(msg);
        System.out.println("</INFO></RESOURCE></VOTABLE>");
        System.out.close();
        System.err.close();
        System.exit(0);
    }

    public static SIA getSIA() {
        return lastSIA;
    }

    public boolean useFits() {
        return this.doFits;
    }

    public String quicklook() {
        return this.quicklook;
    }

    public static void log(String msg) {
    }

    static {
        dftSurvey = "0408mhz,1420mhz,2massh,2massj,2massk,408mhz,4850mhz,co,cobe,cobeaam,cobezsma,dss,dss1b,dss1r,dss2b,dss2ir,dss2r,egrethard,egretsoft,euve83,euve171,euve405,euve555,first,gb6,granat_sigma_flux,granat_sigma_sig,halpha,heao1a,hri,integralspi_gc,iras12,iras25,iras60,iras100,iris12,iris25,iris60,iris100,neat,nh,nvss,pspc1int,pspc2int,rass.25kev,rass.75kev,rass1.5kev,rass,rasshb,rasssb,rass3bb,rass3hb,rass3sb,rxte3_20k_sig,rxte3_8k_sig,rxte8_20k_sig,sdssg,sdssi,sdssr,sdssu,sdssz,sfd100m,sfddust,shassa-c,shassa-cc,shassa-h,shassa-sm,sumss,wenss,wfcf1,wfcf2";
    }
}

