/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.ObservatorySite;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.RectangleAreaExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.summaryfeedback.FieldInfo;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.SourcePropertiesInfo;
import alma.obsprep.services.summaryfeedback.SpectralScanTuningInfo;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import alma.obsprep.services.summaryfeedback.TargetInfo;
import alma.obsprep.services.summaryfeedback.TuningInfo;
import alma.obsprep.services.summaryfeedback.VupComparator;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class ScienceGoalSummaryParameters
implements SummaryDocument {
    protected String proposalID;
    protected boolean isToO = false;
    protected List<ZonedDateTime[]> dateRanges;
    protected int sgIndex;
    protected int sbIndex;
    protected int numberOfSgs;
    protected String sgName;
    protected int numberOfTargets;
    protected String description;
    protected ReceiverBand receiverBand;
    protected CorrPolarization poln;
    protected List<ArrayScanType> arrayUsed;
    protected UserFrequency frequencyResolution;
    protected Angle desiredResolution;
    protected Angle desiredLargestStructure;
    protected UserSensitivity desiredSensitivity;
    protected Frequency sensitivityFrequencyWidth;
    protected Frequency representativeFrequencySky;
    protected Frequency representativeFrequencyRest;
    protected UserSensitivity continuumRms;
    protected UserSensitivity lineRms;
    protected Frequency continuumBandwidthPerPoln;
    protected String isNonStandardMode;
    protected boolean needsMoreTime;
    protected boolean isTimeConstrained;
    private boolean isACANeeded;
    private boolean isTPNeeded;
    protected TargetParameters repTarget;
    protected Map<ArrayScanType, FieldInfo> fieldInfoList;
    protected List<List<TargetInfo>> targetInfoLists;
    protected SourcePropertiesInfo sourcePropertiesInfo;
    protected TargetInfo repTargetInfo;
    protected TuningInfo tuningInfo;
    protected SpectralScanTuningInfo scanTuningInfo;
    protected boolean isMosaic = false;
    protected boolean isSpectralScan = false;
    private ScienceGoal sg;
    private final ProblemListModel problems = new DefaultProblemListModel();
    private ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator = null;
    private boolean isStandAloneACA;
    public AngularResolutionMode angularResolutionMode;

    static List<Integer> getTargetsIndexList(ScienceGoal scienceGoal, MinTuningsCalculator.TuningResult tuningResult) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        for (TargetParameters targetParameters : tuningResult.getTargets()) {
            for (int i = 0; i < targetParametersArray.length; ++i) {
                if (!targetParametersArray[i].matches(targetParameters)) continue;
                arrayList.add(i);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public ScienceGoalSummaryParameters() {
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        scienceGoal.setObsProposalParent(ObsProposal.createObsProposal());
        this.setScienceGoal(scienceGoal);
    }

    public ScienceGoalSummaryParameters(ScienceGoal scienceGoal) {
        this.setScienceGoal(scienceGoal);
    }

    public ScienceGoalSummaryParameters(ScienceGoal scienceGoal, ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator) {
        this.setScienceGoal(scienceGoal);
        this.obsProposalScienceGoalNavigator = obsProposalScienceGoalNavigator;
    }

    private void setScienceGoal(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        this.sg = scienceGoal;
        this.receiverBand = ReceiverBand.ILLEGAL_RECEIVER;
        this.representativeFrequencySky = Frequency.createFrequency();
        this.isNonStandardMode = scienceGoal.getMode().equals(ScienceGoal.MODE_OTHER) ? "Yes" : "No";
        this.continuumRms = UserSensitivity.createUserSensitivity();
        this.continuumRms.setObservingFrequency(this.representativeFrequencySky);
        this.continuumBandwidthPerPoln = Frequency.createFrequency();
        this.arrayUsed = new ArrayList<ArrayScanType>();
        this.frequencyResolution = UserFrequency.createUserFrequency();
        this.frequencyResolution.setObservingFrequency(this.representativeFrequencySky);
        this.desiredResolution = Angle.createAngle();
        this.angularResolutionMode = AngularResolutionMode.Single;
        this.desiredLargestStructure = Angle.createAngle();
        this.desiredSensitivity = UserSensitivity.createUserSensitivity();
        this.desiredSensitivity.setObservingFrequency(this.representativeFrequencySky);
        this.sensitivityFrequencyWidth = Frequency.createFrequency();
        this.fieldInfoList = new HashMap<ArrayScanType, FieldInfo>();
        this.targetInfoLists = new ArrayList<List<TargetInfo>>();
        this.sourcePropertiesInfo = new SourcePropertiesInfo();
    }

    public ScienceGoal getScienceGoal() {
        return this.sg;
    }

    public ScienceGoal getUserObject() {
        return this.getScienceGoal();
    }

    @Override
    public ProblemListModel getProblems() {
        return this.problems;
    }

    public ObsProposal getObsProposal() {
        return (ObsProposal)this.sg.getParent();
    }

    @Override
    public void collectInfo() {
        Object object;
        ReceiverBand receiverBand;
        ScienceGoal scienceGoal = this.getScienceGoal();
        this.isStandAloneACA = scienceGoal.isStandAloneACA();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        this.proposalID = this.getProposalID();
        this.isToO = this.getIsToO();
        this.dateRanges = this.getDateRange();
        this.sgIndex = this.getSgIndex();
        this.numberOfSgs = this.getNumberOfSgs();
        this.sbIndex = this.getSBClusterIndex();
        this.sgName = this.getScienceGoal().getNameOrDefault();
        this.numberOfTargets = this.getScienceGoal().getTargetParametersCount();
        this.description = this.getScienceGoal().getNote();
        this.representativeFrequencySky = this.getScienceGoal().getRepresentativeFrequencyInSky();
        this.representativeFrequencyRest = this.getScienceGoal().getRepresentativeFrequency();
        try {
            receiverBand = this.getReceiverBand();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.logger((Object)this).warning(illegalArgumentException.getMessage());
            object = DefaultProblem.createError(illegalArgumentException.getMessage(), "", (IBusinessObject)scienceGoal);
            this.problems.add((Problem)object);
            receiverBand = ReceiverBand.ILLEGAL_RECEIVER;
        }
        this.receiverBand = receiverBand;
        this.poln = this.getScienceGoal().getSpectralSetupParameters().getCorrPolarization();
        UserFrequency userFrequency = this.getFrequencyResolution();
        if (userFrequency != null) {
            this.frequencyResolution = userFrequency;
        }
        this.desiredResolution = performanceParameters.getDesiredAngularResolution();
        this.angularResolutionMode = performanceParameters.getAngularResolutionMode();
        this.desiredLargestStructure = performanceParameters.getDesiredLargestScale();
        this.desiredSensitivity = performanceParameters.getDesiredSensitivity();
        this.desiredSensitivity.setBeamsize(performanceParameters.getDesiredSensitivity().getBeamsize());
        this.continuumRms.setBeamsize(this.desiredResolution);
        this.continuumRms.setObservingFrequency(this.representativeFrequencySky);
        try {
            Frequency frequency;
            Object object2;
            object = this.isStandAloneACA ? Array.ARRAY_7M : Array.ARRAY_12M;
            this.sourcePropertiesInfo.onSourceTimePerPointing = this.calculateOnSourceTimePerPointing((Array)((Object)object));
            this.continuumBandwidthPerPoln = NonOverlappingBandwidthCalculator.getCalculator(spectralSetupParameters, scienceGoal.getSoleTargetParameters()).calculatePerPoln();
            boolean bl = null != this.continuumBandwidthPerPoln;
            Sensitivity sensitivity = Sensitivity.createSensitivity();
            Log.logger((Object)this).info("Calculating bandwidth using :");
            Log.logger((Object)this).info("Representative Frequency : " + String.valueOf((Object)this.representativeFrequencySky));
            if (bl) {
                Object object3;
                object2 = scienceGoal.getConsolidatedExpectedProperties();
                frequency = NonOverlappingBandwidthCalculator.getCalculator(spectralSetupParameters, (ExpectedPropertiesElements)object2).calculate();
                try {
                    if (spectralSetupParameters.isSpectralScan()) {
                        object3 = spectralSetupParameters.getSpectralScan();
                        SpectralScan.SpectralScanTunings spectralScanTunings = object3.getTunings();
                        FrequencyRange frequencyRange = spectralScanTunings.getAchievedScanRange();
                        frequency = (Frequency)((Object)frequencyRange.range());
                        if (spectralSetupParameters.isWalshSwitching()) {
                            frequency = (Frequency)frequency.multiply(2.0);
                        }
                    } else {
                        frequency = spectralSetupParameters.getDesiredSensitivityFrequencyWidth(PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH);
                    }
                }
                catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                    return;
                }
                Log.logger((Object)this).info("Bandwidth : " + String.valueOf((Object)frequency));
                object3 = (Frequency)frequency.multiply(spectralSetupParameters.getPolarizationFactor());
                sensitivity = this.getScienceGoal().getSinglePointOnSourceSensitivity((Array)((Object)object), this.sourcePropertiesInfo.onSourceTimePerPointing, this.representativeFrequencySky, (Frequency)((Object)object3));
            }
            this.continuumRms.setContentAndUnit((ValueUnitPair)sensitivity);
            object2 = performanceParameters.getSensitivityFrequencyWidthAsUF();
            this.sensitivityFrequencyWidth = object2;
            frequency = performanceParameters.getSensitivityFrequencyWidth();
            Log.logger((Object)this).finest("Sanity Check: Frequency is : " + String.valueOf((Object)frequency) + ",  as a UserFrequency it is :" + String.valueOf(object2));
            this.needsMoreTime = performanceParameters.getNeedsMoreTime();
            this.isTimeConstrained = performanceParameters.getIsTimeConstrained();
            this.isACANeeded = performanceParameters.getUseACA();
            this.isTPNeeded = this.isACANeeded ? performanceParameters.getUseTP() : false;
            this.repTarget = this.getScienceGoal().getSoleTargetParameters();
            this.setupArrayUsed(this.arrayUsed);
            this.setupFieldInfo(this.fieldInfoList);
            this.setupTargetInfoLists(this.targetInfoLists, 60);
            this.setupSourcePropertiesInfo(this.sourcePropertiesInfo);
            this.isSpectralScan = this.getScienceGoal().getSpectralSetupParameters().isSpectralScan();
            if (this.isSpectralScan) {
                this.scanTuningInfo = new SpectralScanTuningInfo(scienceGoal.getSpectralSetupParameters().getSpectralScan(), this.sourcePropertiesInfo.onSourceTimePerPointing, this.desiredResolution);
                this.tuningInfo = null;
            } else {
                this.tuningInfo = new TuningInfo(MinTuningsCalculator.getLO1Tunings(scienceGoal), scienceGoal.getSpectralSetupParameters(), this.sourcePropertiesInfo.onSourceTimePerPointing, this.desiredResolution);
                this.scanTuningInfo = new SpectralScanTuningInfo(null, this.sourcePropertiesInfo.onSourceTimePerPointing, this.desiredResolution);
            }
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException | MinTuningsCalculator.UnableToCalculateMinNumberOfTunings exception) {
            Log.logger((Object)this).finest(exception.getMessage());
        }
    }

    private int getSBClusterIndex() {
        if (this.obsProposalScienceGoalNavigator == null) {
            return 1;
        }
        return this.obsProposalScienceGoalNavigator.getSBIndex(this.getScienceGoal());
    }

    protected Frequency getRepresentativeFrequency() {
        return this.getScienceGoal().getRepresentativeFrequencyInSky();
    }

    protected String getProposalID() {
        String string;
        try {
            string = this.getObsProposal().getObsProject().getCode();
        }
        catch (UnknownEntityException unknownEntityException) {
            string = "No project found";
        }
        if (string == null || string.length() == 0) {
            string = "ID Not Assigned";
        }
        return string;
    }

    protected boolean getIsToO() {
        ObsProposal obsProposal = this.getObsProposal();
        return obsProposal == null ? false : obsProposal.isToO();
    }

    protected List<ZonedDateTime[]> getDateRange() {
        ArrayList<ZonedDateTime[]> arrayList = new ArrayList<ZonedDateTime[]>();
        PerformanceParameters performanceParameters = this.getScienceGoal().getPerformanceParameters();
        if (!performanceParameters.getIsTimeConstrained()) {
            return null;
        }
        for (TemporalParameters temporalParameters : performanceParameters.getTemporalParameters()) {
            arrayList.add(new ZonedDateTime[]{temporalParameters.getStartTimeInDate(), temporalParameters.getEndTimeInDate()});
        }
        return arrayList;
    }

    protected int getSgIndex() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        ObsPhase obsPhase = (ObsPhase)scienceGoal.getParent();
        int n = obsPhase.indexOf(scienceGoal);
        if (n == -1 && (scienceGoal = scienceGoal.getParentScienceGoal()) != null) {
            obsPhase = (ObsPhase)scienceGoal.getParent();
            n = obsPhase.indexOf(scienceGoal);
        }
        return n + 1;
    }

    protected int getNumberOfSgs() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        ObsPhase obsPhase = (ObsPhase)scienceGoal.getParent();
        return obsPhase.getAbstractScienceGoalScienceGoalCount();
    }

    protected ReceiverBand getReceiverBand() {
        return this.getScienceGoal().getReceiverBand();
    }

    protected Temperature getSystemTemperature(Frequency frequency) {
        ScienceGoal scienceGoal = this.getScienceGoal();
        try {
            Latitude latitude = ObservatorySite.SITE_CHAJNANTOR.getObservatoryLatitude();
            TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
            Latitude latitude2 = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
            int n = WaterVaporColumns.wvindexSelector(frequency, latitude2, Optional.ofNullable(scienceGoal.getSpectralSetupParameters().getReceiverBand()));
            double d = Double.NaN;
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            if (!spectralSetupParameters.isSpectralScan()) {
                d = spectralSetupParameters.getLO1Frequency().getContentInGHz();
            }
            return ExposureTimeCalculator.getTsys(targetParameters.getFieldCenterCoordinates(), latitude, frequency, n, d, Optional.ofNullable(spectralSetupParameters.getReceiverBand()));
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            Problem problem = DefaultProblem.createError(exception.getMessage(), "", (IBusinessObject)scienceGoal);
            this.problems.add(problem);
            Log.logger((Object)this).warning(exception.getMessage());
            return Temperature.createTemperature();
        }
    }

    protected double getAtmTau() {
        TargetParameters targetParameters = this.getScienceGoal().getSoleTargetParameters();
        Latitude latitude = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
        int n = WaterVaporColumns.wvindexSelector(this.getRepresentativeFrequency(), latitude, Optional.ofNullable(this.getScienceGoal().getSpectralSetupParameters().getReceiverBand()));
        AtmosphereTable atmosphereTable = AtmosphereTable.getInstance();
        float f = (float)this.getRepresentativeFrequency().getContentInGHz();
        AtmosphereTable.Data data = atmosphereTable.lookup(f, n);
        return data.getTau();
    }

    protected UserFrequency getFrequencyResolution() {
        UserFrequency userFrequency = this.getScienceGoal().getSpectralSetupParameters().getCriticalResolutionPerPolnSmoothed();
        if (userFrequency == null) {
            return null;
        }
        userFrequency.getObservingFrequency().setContentAndUnit((ValueUnitPair)this.getRepresentativeFrequency());
        return userFrequency;
    }

    protected void setupArrayUsed(List<ArrayScanType> list) {
        if (!this.isStandAloneACA) {
            list.add(ArrayScanType.ARRAY_12M_SMI);
        }
        if (this.isACANeeded) {
            list.add(ArrayScanType.ARRAY_7M_SMI);
        }
        if (this.isACANeeded) {
            list.add(ArrayScanType.ARRAY_TP_OTF);
        }
    }

    protected void setupFieldInfo(Map<ArrayScanType, FieldInfo> map) {
        boolean bl = this.sg.getPerformanceParameters().isSimultaneous12and7Observation();
        for (ArrayScanType arrayScanType : this.arrayUsed) {
            Object object;
            Object object2;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.array = arrayScanType.getArray();
            try {
                if (fieldInfo.array == Array.ARRAY_12M) {
                    if (!this.isStandAloneACA) {
                        fieldInfo.totalTime = this.getTotalTimeForSGWithoutACA();
                        fieldInfo.sciTime = this.getTotal12mExtendedTime();
                        fieldInfo.otherTime = this.calculateTotalRequestedTimeCompact();
                        fieldInfo.ppTime = this.calculateOnSourceTimePerPointing(Array.ARRAY_12M);
                    } else {
                        fieldInfo.otherTime = fieldInfo.ppTime = Time.createTimeSec(0.0);
                        fieldInfo.sciTime = fieldInfo.ppTime;
                        fieldInfo.totalTime = fieldInfo.ppTime;
                    }
                } else if (fieldInfo.array == Array.ARRAY_7M) {
                    object2 = this.calculateTotalRequestedTimeArray(bl ? Array.ARRAY_12M : Array.ARRAY_7M);
                    object = this.calculateTotalRequestedTimeArray(bl ? Array.ARRAY_12M : Array.ARRAY_TP);
                    fieldInfo.totalTime = object2.isGreaterThan((AbstractDoubleWithUnit)object) ? object2 : object;
                    fieldInfo.sciTime = object2;
                    fieldInfo.otherTime = object;
                    fieldInfo.ppTime = this.calculateOnSourceTimePerPointing(bl ? Array.ARRAY_12M : Array.ARRAY_7M);
                } else if (fieldInfo.array == Array.ARRAY_TP) {
                    fieldInfo.totalTime = this.calculateTotalRequestedTimeArray(bl ? Array.ARRAY_12M : Array.ARRAY_TP);
                    fieldInfo.sciTime = this.calculateOnSourceTimeArray(bl ? Array.ARRAY_12M : Array.ARRAY_TP);
                    fieldInfo.ppTime = this.calculateOnSourceTimePerPointing(bl ? Array.ARRAY_12M : Array.ARRAY_TP);
                }
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger((Object)this).warning(invalidObsProgramParametersException.getMessage());
            }
            fieldInfo.nPointings = this.getNPointings(arrayScanType);
            fieldInfo.areaSize = this.getAreaSize();
            fieldInfo.spacing = this.getSpacing(arrayScanType);
            fieldInfo.hpbw = this.getHpbw(arrayScanType);
            if (this.isTPNeeded && Array.ARRAY_7M == arrayScanType.getArray() && this.arrayUsed.contains((Object)ArrayScanType.ARRAY_TP_OTF)) {
                object2 = this.getDataRate(arrayScanType);
                object = this.getDataRate(ArrayScanType.ARRAY_TP_OTF);
                StorageVolume storageVolume = this.getDataVolume(arrayScanType);
                StorageVolume storageVolume2 = this.getDataVolume(ArrayScanType.ARRAY_TP_OTF);
                fieldInfo.dataRate = (DataRate)object2.plus((AbstractDoubleWithUnit)object);
                fieldInfo.dataVolume = (StorageVolume)storageVolume.plus((AbstractDoubleWithUnit)storageVolume2);
            } else {
                fieldInfo.dataRate = this.getDataRate(arrayScanType);
                fieldInfo.dataVolume = this.getDataVolume(arrayScanType);
            }
            map.put(arrayScanType, fieldInfo);
            this.isMosaic |= this.isMosaic(arrayScanType);
        }
    }

    protected Time getTotalTimeForSGWithoutACA() throws InvalidObsProgramParametersException {
        ScienceGoal scienceGoal = this.getScienceGoal();
        Time time = Time.createTime();
        try {
            time = scienceGoal.getTotalTimeForSGWithoutACA(false);
            time.convertToUnit(Time.UNIT_S);
        }
        catch (ObservingTimeCalculator.UnableToCalculateTimeEstimateException unableToCalculateTimeEstimateException) {
            throw new InvalidObsProgramParametersException(unableToCalculateTimeEstimateException);
        }
        return time;
    }

    protected Time getTotal12mExtendedTime() throws InvalidObsProgramParametersException {
        ScienceGoal scienceGoal = this.getScienceGoal();
        Time time = scienceGoal.getTotal12mExtendedTimeForSG();
        time.convertToUnit(Time.UNIT_S);
        return time;
    }

    protected Time calculateTotalRequestedTimeArray(Array array) throws InvalidObsProgramParametersException {
        ScienceGoal scienceGoal = this.getScienceGoal();
        Time time = scienceGoal.getTotalRequestedTime(array);
        time.convertToUnit(Time.UNIT_S);
        return time;
    }

    protected Time calculateTotalRequestedTimeCompact() throws InvalidObsProgramParametersException {
        ScienceGoal scienceGoal = this.getScienceGoal();
        Time time = scienceGoal.getTotalRequestedTimeCompact();
        time.convertToUnit(Time.UNIT_S);
        return time;
    }

    protected Time calculateOnSourceTimeArray(Array array) throws InvalidObsProgramParametersException {
        ScienceGoal scienceGoal = this.getScienceGoal();
        Time time = scienceGoal.getTotalOnSourceTime(array);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    protected Time calculateOnSourceTimePerPointing(Array array) throws InvalidObsProgramParametersException {
        ScienceGoal scienceGoal = this.getScienceGoal();
        Time time = scienceGoal.getSinglePointOnSourceTimeFromSB(array, scienceGoal.getSoleTargetParameters());
        time.convertToUnit(Time.UNIT_S);
        return time;
    }

    protected int getNPointings(ArrayScanType arrayScanType) {
        switch (arrayScanType.ordinal()) {
            case 0: {
                int n = 0;
                for (TargetParameters targetParameters : this.getScienceGoal().getTargetParameters()) {
                    for (Field field : targetParameters.getField()) {
                        n += field.getNumberOfPointings();
                    }
                }
                return n;
            }
            case 1: {
                int n = 0;
                for (TargetParameters targetParameters : this.getScienceGoal().getTargetParameters()) {
                    for (Field field : targetParameters.getField()) {
                        if (field instanceof SinglePoint) {
                            n += field.getNumberOfPointings();
                        }
                        if (!(field instanceof Rectangle)) continue;
                        RectangleAreaExpert rectangleAreaExpert = RectangleAreaExpert.of((Rectangle)((Object)field));
                        n += rectangleAreaExpert.getNumberOfPointings(Array.ARRAY_7M);
                    }
                }
                return n;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    protected boolean isMosaic(@NonNull ArrayScanType arrayScanType) {
        if (arrayScanType == null) {
            throw new NullPointerException("as is marked non-null but is null");
        }
        for (TargetParameters targetParameters : this.getScienceGoal().getTargetParameters()) {
            if (!targetParameters.isRectanglePattern() || arrayScanType.scanType != ScanType.SMI) continue;
            return true;
        }
        return false;
    }

    protected Rectangle getRectangle() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal == null) {
            return null;
        }
        int n = scienceGoal.getTargetParametersCount();
        if (n != 1) {
            return null;
        }
        TargetParameters targetParameters = scienceGoal.getTargetParameters(0);
        if (targetParameters.isRectanglePattern()) {
            return (Rectangle)((Object)targetParameters.getField(0));
        }
        return null;
    }

    protected Angle2D getAreaSize() {
        Rectangle rectangle = this.getRectangle();
        if (rectangle == null) {
            return null;
        }
        return new Angle2D(rectangle.getLong(), rectangle.getShort());
    }

    protected Angle getHpbw(ArrayScanType arrayScanType) {
        Antenna antenna = arrayScanType.getArray().antenna;
        return antenna.getBeamSize(this.representativeFrequencySky);
    }

    protected Angle getSpacing(ArrayScanType arrayScanType) {
        Rectangle rectangle = this.getRectangle();
        if (rectangle == null) {
            return Angle.createAngle();
        }
        UserAngle userAngle = rectangle.getSpacing();
        if (userAngle.inModelUnit()) {
            return userAngle;
        }
        switch (arrayScanType.ordinal()) {
            case 0: {
                return rectangle.getSpacing();
            }
            case 1: {
                Angle angle = Antenna.ANTENNA_7M.getBeamSize(rectangle.getReferenceFrequency());
                Angle angle2 = angle == null ? Angle.createAngle() : (Angle)angle.multiply(userAngle.getUserContent());
                return angle2;
            }
            case 2: {
                return rectangle.getSpacing();
            }
        }
        return rectangle.getSpacing();
    }

    protected DataRate getDataRate(@NonNull ArrayScanType arrayScanType) {
        if (arrayScanType == null) {
            throw new NullPointerException("as is marked non-null but is null");
        }
        ScienceGoal scienceGoal = this.getScienceGoal();
        return scienceGoal.getAverageDataRate(arrayScanType.array);
    }

    protected StorageVolume getDataVolume(@NonNull ArrayScanType arrayScanType) {
        StorageVolume storageVolume;
        if (arrayScanType == null) {
            throw new NullPointerException("as is marked non-null but is null");
        }
        ScienceGoal scienceGoal = this.getScienceGoal();
        try {
            storageVolume = scienceGoal.getDataVolume(arrayScanType.array);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            String string = invalidObsProgramParametersException.getCause() == null ? invalidObsProgramParametersException.getMessage() : invalidObsProgramParametersException.getCause().getMessage();
            Problem problem = DefaultProblem.createError(string, "", (IBusinessObject)scienceGoal);
            this.problems.add(problem);
            Log.logger((Object)this).warning(string);
            storageVolume = StorageVolume.createStorageVolume();
        }
        catch (ToBeSupportedException toBeSupportedException) {
            Problem problem = DefaultProblem.createWarning(toBeSupportedException.getMessage(), "", (IBusinessObject)scienceGoal);
            this.problems.add(problem);
            Log.logger((Object)this).warning(toBeSupportedException.getMessage());
            storageVolume = StorageVolume.createStorageVolume();
        }
        return storageVolume;
    }

    protected void setupTargetInfoLists(List<List<TargetInfo>> list, int n) {
        PerformanceParameters performanceParameters = this.getScienceGoal().getPerformanceParameters();
        performanceParameters.getDesiredSensitivity();
        TargetParameters[] targetParametersArray = this.getScienceGoal().getTargetParameters();
        String string = this.sg.getKeyTargetParameters().getSourceCoordinates().getSystem();
        ArrayList<TargetInfo> arrayList = new ArrayList<TargetInfo>();
        for (int i = 0; i < targetParametersArray.length; ++i) {
            if (i > 0 && i % n == 0) {
                list.add(arrayList);
                arrayList = new ArrayList();
            }
            TargetParameters targetParameters = targetParametersArray[i];
            TargetInfo targetInfo = new TargetInfo();
            targetParameters.getExpectedProperties();
            boolean bl = targetInfo.isRepresentative = targetParameters == this.getScienceGoal().getSoleTargetParameters();
            if (targetInfo.isRepresentative) {
                this.repTargetInfo = targetInfo;
            }
            targetInfo.targetName = targetParameters.getSourceName();
            SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
            if (skyCoordinates.isGalactic()) {
                targetInfo.coordinates = null;
                targetInfo.galactic = skyCoordinates.deepCopy();
                targetInfo.galactic.setSystem(string);
            } else {
                targetInfo.coordinates = skyCoordinates;
                targetInfo.coordinates.setSystem(string);
                targetInfo.galactic = null;
            }
            targetInfo.sourceVelocity = targetParameters.getSourceVelocity();
            arrayList.add(targetInfo);
        }
        if (!arrayList.isEmpty()) {
            list.add(arrayList);
        }
    }

    private void setupSourcePropertiesInfo(SourcePropertiesInfo sourcePropertiesInfo) {
        ScienceGoal scienceGoal = this.getScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        performanceParameters.getDesiredSensitivity();
        ArrayList<ExpectedProperties> arrayList = new ArrayList<ExpectedProperties>();
        for (TargetParameters targetParameters : this.getScienceGoal().getTargetParameters()) {
            arrayList.add(targetParameters.getExpectedProperties().deepCopy());
        }
        ExpectedProperties expectedProperties = this.collapseExpectedProperties(arrayList, scienceGoal);
        sourcePropertiesInfo.linewidth = expectedProperties.getExpectedLineWidth().asSpeed();
        sourcePropertiesInfo.fluxLine = expectedProperties.getExpectedPeakLineFluxDensity();
        sourcePropertiesInfo.fluxCont = expectedProperties.getExpectedPeakFluxDensity();
        sourcePropertiesInfo.maxFluxCont = this.getMaxContinuumFlux(arrayList);
        sourcePropertiesInfo.minFluxCont = this.getMinContinuumFlux(arrayList);
        sourcePropertiesInfo.polarizationLine = MiscUtils.minClosestToZero(expectedProperties.getDesiredLinePolarizationPercentage(), expectedProperties.getDesiredLineCircularPolarizationPercentage());
        sourcePropertiesInfo.polarizationCont = MiscUtils.minClosestToZero(expectedProperties.getDesiredPolarizationPercentage(), expectedProperties.getDesiredCircularPolarizationPercentage());
        sourcePropertiesInfo.reqLineRMS.setBeamsize(this.desiredResolution);
        sourcePropertiesInfo.reqLineRMS.setObservingFrequency(this.representativeFrequencySky);
        double d = expectedProperties.getExpectedLineWidth().getContentInGHz();
        double d2 = this.sensitivityFrequencyWidth.getContentInGHz();
        sourcePropertiesInfo.lineWidthRatio = sourcePropertiesInfo.linewidth.isZero() ? Double.valueOf(0.0) : Double.valueOf(d / d2);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        UserFrequency userFrequency = expectedProperties.getExpectedLineWidth().deepCopy().divide(3.0);
        Sensitivity sensitivity = this.calculateSensitivityForBandwidth(scienceGoal, spectralSetupParameters, (Frequency)((Object)userFrequency));
        double d3 = sensitivity.getContentInUnits(UserSensitivity.UNIT_MJY);
        sourcePropertiesInfo.reqLineRMS.setContentAndUnit(d3, UserSensitivity.UNIT_MJY);
        this.isNonStandardMode = scienceGoal.getMode().equals(ScienceGoal.MODE_OTHER) ? "Yes" : "No";
        sourcePropertiesInfo.snrLine = sourcePropertiesInfo.fluxLine.getmJy() / sourcePropertiesInfo.reqLineRMS.getContentInUnits(Sensitivity.UNIT_MJY);
        sourcePropertiesInfo.snrCont = sourcePropertiesInfo.minFluxCont.getmJy() / this.continuumRms.getContentInUnits(Sensitivity.UNIT_MJY);
        if (sourcePropertiesInfo.fluxLine.isZero() || sourcePropertiesInfo.maxFluxCont.isZero()) {
            sourcePropertiesInfo.dynamicRange = -1.0;
        } else if (spectralSetupParameters.isSingleContinuum() || d2 > 2.0 * d) {
            sourcePropertiesInfo.dynamicRange = sourcePropertiesInfo.maxFluxCont.getmJy() / d3;
        } else {
            Frequency frequency = spectralSetupParameters.getDesiredSensitivityFrequencyWidth();
            Sensitivity sensitivity2 = this.calculateSensitivityForBandwidth(scienceGoal, spectralSetupParameters, frequency);
            sourcePropertiesInfo.dynamicRange = sourcePropertiesInfo.maxFluxCont.getmJy() / sensitivity2.getContentInUnits(Sensitivity.UNIT_MJY);
        }
        userFrequency = expectedProperties.getLinePolarizationExpectedBW().deepCopy().divide(3.0);
        sensitivity = this.calculateSensitivityForBandwidth(scienceGoal, spectralSetupParameters, (Frequency)((Object)userFrequency));
        double d4 = sensitivity.getContentInUnits(UserSensitivity.UNIT_MJY);
        double d5 = expectedProperties.getExpectedPeakLinePolarizationFluxDensity().getmJy() / d4;
        sourcePropertiesInfo.polSnrLine = sourcePropertiesInfo.polarizationLine * d5 / 100.0;
        sourcePropertiesInfo.polSnrCont = this.getMinPolarizedContFlux(arrayList).getmJy() / this.continuumRms.getContentInUnits(Flux.UNIT_MJY);
    }

    private Sensitivity calculateSensitivityForBandwidth(@NonNull ScienceGoal scienceGoal, SpectralSetupParameters spectralSetupParameters, Frequency frequency) {
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        Time time = Time.createTime();
        try {
            object = this.isStandAloneACA ? Array.ARRAY_7M : Array.ARRAY_12M;
            time = scienceGoal.getSinglePointOnSourceTimeFromSB((Array)((Object)object));
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        time.convertToUnit(Time.UNIT_S);
        object = (Frequency)frequency.multiply(spectralSetupParameters.getPolarizationFactor());
        try {
            Array array = this.isStandAloneACA ? Array.ARRAY_7M : Array.ARRAY_12M;
            return scienceGoal.getSinglePointOnSourceSensitivity(array, time, this.representativeFrequencySky, (Frequency)((Object)object));
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            Log.logger((Object)this).finest("Incomplete info for calculating sensitivity : " + exception.getMessage());
            return null;
        }
    }

    private Flux getMaxContinuumFlux(@NonNull List<ExpectedProperties> list) {
        if (list == null) {
            throw new NullPointerException("expectedProperties is marked non-null but is null");
        }
        if (list.isEmpty()) {
            return Flux.createFlux();
        }
        ArrayList<Flux> arrayList = new ArrayList<Flux>();
        for (ExpectedProperties expectedProperties : list) {
            arrayList.add(expectedProperties.getExpectedPeakFluxDensity());
        }
        VupComparator vupComparator = new VupComparator();
        Collections.sort(arrayList, vupComparator);
        return (Flux)((Object)arrayList.get(arrayList.size() - 1));
    }

    private Flux getMinContinuumFlux(List<ExpectedProperties> list) {
        if (list.isEmpty()) {
            return Flux.createFlux();
        }
        ArrayList<Flux> arrayList = new ArrayList<Flux>();
        for (ExpectedProperties expectedProperties : list) {
            arrayList.add(expectedProperties.getExpectedPeakFluxDensity());
        }
        VupComparator vupComparator = new VupComparator();
        Collections.sort(arrayList, vupComparator);
        return (Flux)((Object)arrayList.get(0));
    }

    private Flux getMinPolarizedContFlux(List<ExpectedProperties> list) {
        if (list.isEmpty()) {
            return Flux.createFlux();
        }
        ArrayList<Flux> arrayList = new ArrayList<Flux>();
        for (ExpectedProperties expectedProperties : list) {
            double d = MiscUtils.minClosestToZero(expectedProperties.getDesiredPolarizationPercentage(), expectedProperties.getDesiredCircularPolarizationPercentage());
            if (!(d > 0.0)) continue;
            arrayList.add((Flux)expectedProperties.getExpectedPeakFluxDensity().multiply(d / 100.0));
        }
        if (arrayList.isEmpty()) {
            return Flux.createFlux();
        }
        Collections.sort(arrayList, new VupComparator());
        return (Flux)((Object)arrayList.get(0));
    }

    private ExpectedProperties collapseExpectedProperties(List<ExpectedProperties> list, ScienceGoal scienceGoal) {
        ExpectedProperties expectedProperties2;
        ExpectedProperties expectedProperties = ExpectedProperties.createExpectedProperties();
        if (list.isEmpty()) {
            return expectedProperties;
        }
        ArrayList<Flux> arrayList = new ArrayList<Flux>();
        ArrayList<Flux> arrayList2 = new ArrayList<Flux>();
        ArrayList<UserFrequency> arrayList3 = new ArrayList<UserFrequency>();
        SpectralSetupParameters spectralSetupParameters = this.sg.getSpectralSetupParameters();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        ExpectedProperties object2 = expectedProperties2 = list.get(0);
        ExpectedProperties object3 = expectedProperties2;
        for (ExpectedProperties object4 : list) {
            double d3;
            double bl = MiscUtils.minClosestToZero(object4.getDesiredLinePolarizationPercentage(), object4.getDesiredLineCircularPolarizationPercentage());
            double d4 = 0.0;
            if (bl > 0.0) {
                UserFrequency userFrequency = object4.getExpectedLineWidth().deepCopy().divide(3.0);
                Sensitivity sensitivity = this.calculateSensitivityForBandwidth(this.sg, spectralSetupParameters, (Frequency)((Object)userFrequency));
                d3 = sensitivity.getContentInUnits(UserSensitivity.UNIT_MJY);
                double flux = object4.getExpectedPeakLineFluxDensity().getmJy() / d3;
                d4 = bl * flux / 100.0;
            }
            if (d4 > 0.0 && d4 < d) {
                d = d4;
                object2 = object4;
            }
            double userFrequency = MiscUtils.minClosestToZero(object4.getDesiredPolarizationPercentage(), object4.getDesiredCircularPolarizationPercentage());
            d3 = 0.0;
            if (userFrequency > 0.0) {
                Flux flux = (Flux)object4.getExpectedPeakFluxDensity().multiply(userFrequency / 100.0);
                d3 = flux.getmJy() / this.continuumRms.getContentInUnits(Flux.UNIT_MJY);
            }
            if (d3 > 0.0 && d3 < d2) {
                d2 = d3;
                object3 = object4;
            }
            arrayList.add(object4.getExpectedPeakLineFluxDensity());
            arrayList2.add(object4.getExpectedPeakFluxDensity());
            arrayList3.add(object4.getExpectedLineWidth());
        }
        VupComparator vupComparator = new VupComparator();
        VupComparator vupComparator2 = new VupComparator();
        Collections.sort(arrayList, vupComparator);
        Collections.sort(arrayList2, vupComparator);
        Collections.sort(arrayList3, vupComparator2);
        expectedProperties.setExpectedPeakLineFluxDensity((Flux)((Object)arrayList.get(0)));
        expectedProperties.setExpectedPeakFluxDensity((Flux)((Object)arrayList2.get(0)));
        expectedProperties.setDesiredLinePolarizationPercentage(object2.getDesiredLinePolarizationPercentage());
        expectedProperties.setDesiredLineCircularPolarizationPercentage(object2.getDesiredLineCircularPolarizationPercentage());
        expectedProperties.setDesiredPolarizationPercentage(object3.getDesiredPolarizationPercentage());
        expectedProperties.setDesiredCircularPolarizationPercentage(object3.getDesiredCircularPolarizationPercentage());
        double d5 = object2.getDesiredLinePolarizationPercentage();
        double d6 = object2.getDesiredLineCircularPolarizationPercentage();
        boolean bl = d5 == 0.0 ? false : (d6 == 0.0 ? true : d5 < d6);
        expectedProperties.setExpectedPeakLinePolarizationFluxDensity(bl ? object2.getExpectedPeakLineFluxDensity() : object2.getExpectedPeakLineFluxDensity());
        expectedProperties.setlinePolarizationExpectedBW(bl ? object2.getExpectedLineWidth() : object2.getExpectedLineWidth());
        expectedProperties.setExpectedLineWidthAndReferenceFrequency((UserFrequency)arrayList3.get(0));
        return expectedProperties;
    }

    @Override
    public String getTitle() {
        return "";
    }

    public static enum ArrayScanType {
        ARRAY_12M_SMI(Array.ARRAY_12M, ScanType.SMI),
        ARRAY_7M_SMI(Array.ARRAY_7M, ScanType.SMI),
        ARRAY_TP_OTF(Array.ARRAY_TP, ScanType.OTF);

        private Array array;
        private ScanType scanType;

        private ArrayScanType(Array array, ScanType scanType) {
            this.array = array;
            this.scanType = scanType;
        }

        public Array getArray() {
            return this.array;
        }

        public ScanType getScanType() {
            return this.scanType;
        }
    }

    protected static class Angle2D {
        private Angle x;
        private Angle y;

        public Angle getX() {
            return this.x;
        }

        public Angle getY() {
            return this.y;
        }

        public Angle2D(Angle angle, Angle angle2) {
            this.x = angle;
            this.y = angle2;
        }
    }

    public static enum ScanType {
        SMI("Standard Mode Interferometry"),
        OTF("On-The-Fly Single Dish");

        private String label;

        private ScanType(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

