/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.services.summaryfeedback.JointProposalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ProposalSummaryParameters;
import alma.obsprep.services.summaryfeedback.SummaryFeedbackView;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import lombok.NonNull;

class BannerPanel
extends JPanel {
    private static final long serialVersionUID = 432421427355989828L;
    private SummaryFeedbackView summaryFeedbackView;
    private static final int MAX_TITLE_LENGTH = 120;
    private static final int MAX_TITLE_FIELD_COLS = 40;
    private final JTextArea titleLabel;
    private final JLabel codeLabel;

    BannerPanel(@NonNull SummaryFeedbackView summaryFeedbackView, @NonNull FieldID fieldID, boolean bl) {
        if (summaryFeedbackView == null) {
            throw new NullPointerException("view is marked non-null but is null");
        }
        if (fieldID == null) {
            throw new NullPointerException("fid is marked non-null but is null");
        }
        this.summaryFeedbackView = summaryFeedbackView;
        this.summaryFeedbackView.register(this, fieldID);
        this.setBorder(this.summaryFeedbackView.createBorder());
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), 1, 18);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        if (bl) {
            gridBagConstraints.weightx = 0.0;
            ImageIcon imageIcon = Icons.getIcon("alma_logo_45x64.png");
            JLabel jLabel = new JLabel(imageIcon);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
        }
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        int n = (int)Math.ceil(3.0);
        this.titleLabel = this.summaryFeedbackView.makeTextArea(n, 40);
        this.titleLabel.setFont(font2);
        this.titleLabel.setBorder(null);
        this.titleLabel.setLineWrap(true);
        this.titleLabel.setWrapStyleWord(true);
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        this.add(this.titleLabel);
        ++gridBagConstraints.gridx;
        this.codeLabel = this.summaryFeedbackView.makeLabel().setFontTo(font2).setBorderTo(null).setHorizontalAlignmentTo(4);
        gridBagLayout.setConstraints(this.codeLabel, gridBagConstraints);
        this.add(this.codeLabel);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        Component component = Box.createHorizontalStrut(5);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    void update(ProposalSummaryParameters proposalSummaryParameters) {
        String string = proposalSummaryParameters.getTitle();
        string = string == null ? "" : string;
        int n = (int)Math.ceil((float)string.length() / 40.0f);
        this.titleLabel.setRows(n);
        this.titleLabel.setText(string);
        this.codeLabel.setText(proposalSummaryParameters.projectCode);
    }

    void update(JointProposalSummaryParameters jointProposalSummaryParameters) {
        String string = jointProposalSummaryParameters.getTitle();
        string = string == null ? "" : string;
        int n = (int)Math.ceil((float)string.length() / 40.0f);
        this.titleLabel.setRows(n);
        this.titleLabel.setText(string);
    }
}

