/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ReceiverCalibrationParameters;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationConfigurationHelper;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimeQueryInterface;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimer;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationParametersException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import java.io.FileNotFoundException;
import java.util.EnumSet;
import javax.xml.bind.JAXBException;
import lombok.NonNull;

public class ConfigurationDrivenPhaseTimer
extends CalibrationTimer {
    private static final Time VLBI_DEFAULT_PHASE_INT_TIME = Time.createTimeSec(30.0);
    protected ScienceGoal scienceGoal = null;
    private CalibrationConfigurationHelper calibrationConfigurationHelper = null;
    private final RequestedArray array;

    public ConfigurationDrivenPhaseTimer(@NonNull ScienceGoal scienceGoal, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext, RequestedArray requestedArray) {
        super(spectralSpec, sBGenerationContext);
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.scienceGoal = scienceGoal;
        this.array = requestedArray;
        try {
            this.calibrationConfigurationHelper = CalibrationConfigurationHelper.getInstance();
        }
        catch (FileNotFoundException | JAXBException throwable) {
            Log.logger(ConfigurationDrivenPhaseTimer.class).warning("Unable to read in the configuration specific calibration parameter XML file: " + throwable.getMessage());
            throw new WizardSBGenerationException(throwable);
        }
    }

    private Time getAdjustedTimeParameter(@NonNull CalibrationTimeQueryInterface.CalibrationTimeType calibrationTimeType) throws Configuration.UnableToDetermineConfigurationException, InvalidConfigurationParametersException, SchedBlockExpert.UnableToDetermine12mCompactConfiguration {
        if (calibrationTimeType == null) {
            throw new NullPointerException("calibrationTimeType is marked non-null but is null");
        }
        return switch (calibrationTimeType) {
            case CalibrationTimeQueryInterface.CalibrationTimeType.DEFAULTINTEGRATIONTIME, CalibrationTimeQueryInterface.CalibrationTimeType.CYCLETIME -> this.fetchTime(calibrationTimeType);
            case CalibrationTimeQueryInterface.CalibrationTimeType.SUBSCANTIME -> this.getAlignedSubscanDuration(this.fetchTime(calibrationTimeType));
            default -> throw new IllegalArgumentException("calibrationTimeType of " + String.valueOf((Object)calibrationTimeType) + " is unknown: cannot process it");
        };
    }

    @Override
    public Time getScanDuration() {
        try {
            return this.fetchTime(CalibrationTimeQueryInterface.CalibrationTimeType.SUBSCANTIME);
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | SchedBlockExpert.UnableToDetermine12mCompactConfiguration exception) {
            throw new WizardSBGenerationException(exception);
        }
    }

    @Override
    public Time getDefaultIntegrationTime() {
        try {
            return this.getAdjustedTimeParameter(CalibrationTimeQueryInterface.CalibrationTimeType.DEFAULTINTEGRATIONTIME);
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | SchedBlockExpert.UnableToDetermine12mCompactConfiguration exception) {
            throw new WizardSBGenerationException(exception);
        }
    }

    private Time fetchTime(@NonNull CalibrationTimeQueryInterface.CalibrationTimeType calibrationTimeType) throws Configuration.UnableToDetermineConfigurationException, InvalidConfigurationParametersException, SchedBlockExpert.UnableToDetermine12mCompactConfiguration {
        Configuration configuration;
        Object object;
        if (calibrationTimeType == null) {
            throw new NullPointerException("calibrationTimeRequired is marked non-null but is null");
        }
        RequiredConfigurations requiredConfigurations = null;
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Frequency frequency = this.scienceGoal.getRepresentativeFrequencyInSky();
        try {
            object = this.scienceGoal.getObsProposal();
            if (object != null && ((ObsProposal)object).isVLBIorPhasedArray()) {
                return VLBI_DEFAULT_PHASE_INT_TIME.deepCopy();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ConfigurationDrivenPhaseTimer.class).warning("Unable to determine if project is a VLBI project");
            throw new WizardSBGenerationException("Unable to determine if project is a VLBI project");
        }
        object = this.sbContext.getSBType();
        if (this.array.isACA7M()) {
            configuration = Configuration.getACAConfiguration();
        } else {
            requiredConfigurations = this.scienceGoal.getScienceGoalType().equals((Object)ScienceGoal.ScienceGoalType.TUNINGSPECIFIC) ? ConfigurationHelper.getRecommended12mConfigurations(this.scienceGoal.getParentScienceGoal(), frequency) : ConfigurationHelper.getRecommended12mConfigurations(this.scienceGoal, frequency);
            configuration = ((Enum)object).equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION) ? requiredConfigurations.getTwelveMetreCompactConfig() : requiredConfigurations.getBest12mExtConfig();
        }
        if (!EnumSet.of(SBGeneratorTemplate.SchedBlockType.ACA7M, SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION, SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION).contains(object)) {
            throw new WizardSBGenerationException("A configuration-driven phase timer cannot be used with anything other than the 12-m array currently");
        }
        Time time = null;
        try {
            boolean bl = this.scienceGoal.getSpectralSetupParameters().isWalshSwitching();
            ReceiverCalibrationParameters receiverCalibrationParameters = this.calibrationConfigurationHelper.getCalibrationParameters(configuration, ObsType.PHASE, CorrelatorType.BL, this.ss.getReceiverBand().getNumber(), bl);
            time = CalibrationConfigurationHelper.getTime(calibrationTimeType, receiverCalibrationParameters);
        }
        catch (UnableToDetermineCalibrationParametersException unableToDetermineCalibrationParametersException) {
            throw new WizardSBGenerationException(unableToDetermineCalibrationParametersException);
        }
        assert (time != null);
        String string = String.format("For configuration %s at freq %.4g GHz the %s time is %.4g secs", configuration.getName(), performanceParameters.getRepresentativeFrequency().getContentInGHz(), calibrationTimeType.toString(), time.getContentInUnits(Time.UNIT_S));
        Log.logger(ConfigurationDrivenPhaseTimer.class).fine(string);
        return time;
    }

    @Override
    public Time getCycleTime() {
        try {
            return this.fetchTime(CalibrationTimeQueryInterface.CalibrationTimeType.CYCLETIME);
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | SchedBlockExpert.UnableToDetermine12mCompactConfiguration exception) {
            throw new WizardSBGenerationException(exception);
        }
    }
}

