/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.others;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.util.MiscUtils;

public class TestBoCanFindProjectValidator
extends AbstractValidator {
    private static final String ME = "chk01: ";
    private ObsProject obsProject;

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        if (businessObject instanceof ObsProject) {
            this.obsProject = (ObsProject)businessObject;
            return;
        }
        if (businessObject instanceof Entity) {
            return;
        }
        ObsProject obsProject = businessObject.findProject();
        if (obsProject == null) {
            Entity entity = businessObject.findEntity();
            if (entity == null) {
                problemListModel.add(DefaultProblem.createError("chk01: This object's findEntity() returned null", MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
                return;
            }
            ObsProject obsProject2 = entity.findProject();
            if (obsProject2 == null) {
                if (!(entity instanceof ObsAttachment)) {
                    problemListModel.add(DefaultProblem.createWarning("chk01: This object lives under an Entity that doesn't know its project", MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
                }
                return;
            }
            problemListModel.add(DefaultProblem.createError("chk01: This object's findProject() returned null", MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
            return;
        }
        if (this.obsProject == null) {
            problemListModel.add(DefaultProblem.createError("chk01: [validator internal problem] What obsproject is the expected one?", MiscUtils.packageClassnameHash(businessObject), null));
            return;
        }
        if (obsProject != this.obsProject) {
            problemListModel.add(DefaultProblem.createError("chk01: This object's findProject() returned a wrong project: @" + obsProject.hashCode(), MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
        }
    }
}

