/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.actions.AttachTASummaryInteractor;
import alma.obsprep.ot.actions.AttachTASummaryPerformer;
import alma.obsprep.ot.gui.toplevel.AbstractObservingToolController;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.ot.persistence.ProjectRepositoryHttp;
import alma.obsprep.ot.scripting.PyAction;
import alma.obsprep.ot.scripting.PyAdd;
import alma.obsprep.ot.scripting.PyExport;
import alma.obsprep.ot.scripting.PyGenerate;
import alma.obsprep.ot.scripting.PyImport;
import alma.obsprep.ot.scripting.PyNewProject;
import alma.obsprep.ot.scripting.PyQuery;
import alma.obsprep.ot.scripting.PyRetrieve;
import alma.obsprep.ot.scripting.PySetResubmissionEditor;
import alma.obsprep.ot.scripting.PyStore;
import alma.obsprep.ot.scripting.PythonEnv;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ValidatorSetFactory;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.network.exceptions.ConnectionException;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.util.GUIUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import lombok.NonNull;

public class BatchOT
extends AbstractObservingToolController {
    private PythonEnv python;

    public BatchOT() throws ConnectionException, IOException {
        this.heap().getUserAuthenticator().suppressGraphics = true;
        GUIUtilities.suppressAllMessageBoxes = true;
        String string = InitServices.getPropertyHandler().getProperty("ot.submission.host");
        if (string == null) {
            throw new IOException("ot.submission.host property is not defined");
        }
        ProjectRepositoryHttp projectRepositoryHttp = this.heap.getProjectRepository();
        projectRepositoryHttp.setUrl(string);
        String string2 = InitServices.getPropertyHandler().getProperty("ot.submission.user");
        String string3 = InitServices.getPropertyHandler().getProperty("ot.submission.pass");
        char[] cArray = string3 != null ? string3.toCharArray() : new char[]{};
        this.heap().getUserAuthenticator().setNameAndPasswordAndServer(string2, cArray, string);
        string2 = string2 == null ? "" : string2;
        string3 = string3 == null ? "" : string3;
        RoleDirectoryService roleDirectoryService = this.heap().getRoleDirectory();
        roleDirectoryService.setServerUrl(string);
        roleDirectoryService.setCredentials(string2, string3);
        try {
            roleDirectoryService.goOnline();
            roleDirectoryService.login();
        }
        catch (ConnectionException connectionException) {
            System.out.println("No connection to role server, cannot check user privileges: " + connectionException.getMessage());
            System.out.println("Cannot continue without authentication - exiting");
            System.exit(-1);
        }
    }

    public void setHostingEnv(PythonEnv pythonEnv) {
        this.python = pythonEnv;
    }

    public boolean confirm(String string) {
        try {
            this.python.getConsoleStream().print(string + " [y]: ");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = bufferedReader.readLine();
            return "".equals(string2) || "y".equals(string2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ObsProject importprj(String string) {
        PyImport pyImport = new PyImport(string);
        pyImport.perform();
        return pyImport.getObsProject();
    }

    public void exportprj(ObsProject obsProject, String string) {
        PyExport pyExport = new PyExport(string);
        pyExport.setItemToExport(obsProject);
        pyExport.perform();
    }

    public ObsProject retrieveprj(String string) {
        PyRetrieve pyRetrieve = new PyRetrieve(string, ProjectRepository.RetrieveVariant.retrieve, this);
        pyRetrieve.perform();
        return pyRetrieve.getObsProject();
    }

    public ObsProject retrieveprjInclReview(String string) {
        PyRetrieve pyRetrieve = new PyRetrieve(string, ProjectRepository.RetrieveVariant.retrieveIncludeReview, this);
        pyRetrieve.perform();
        return pyRetrieve.getObsProject();
    }

    public void setIsResubmission(ObsProject obsProject, boolean bl) {
        PySetResubmissionEditor pySetResubmissionEditor = new PySetResubmissionEditor();
        pySetResubmissionEditor.setIsResubmission(obsProject, bl);
    }

    public void setResubmissionProjectCode(ObsProject obsProject, String string) {
        PySetResubmissionEditor pySetResubmissionEditor = new PySetResubmissionEditor();
        pySetResubmissionEditor.setResubmisionProjectCode(obsProject, string);
    }

    public ObsProject storeprj(ObsProject obsProject) {
        PyStore pyStore = new PyStore(this, obsProject, ProjectRepository.StoreVariant.submit, false, false);
        pyStore.confirmSubmit = true;
        pyStore.confirmSubmitAsNonPI = true;
        pyStore.confirmSubmitToNewerCycle = true;
        pyStore.confirmResubmit = true;
        pyStore.perform();
        return pyStore.getProjectAfterStore();
    }

    public ObsProject storebackprj(ObsProject obsProject) {
        return this.storebackprj(obsProject, false);
    }

    public ObsProject storebackprj(ObsProject obsProject, boolean bl) {
        PyStore pyStore = new PyStore(this, obsProject, ProjectRepository.StoreVariant.storeback, false, bl);
        pyStore.confirmSubmitAsNonPI = true;
        pyStore.confirmResubmit = true;
        pyStore.perform();
        return pyStore.getProjectAfterStore();
    }

    public ObsProject storenewprj(ObsProject obsProject) {
        return this.storenewprj(obsProject, false);
    }

    public ObsProject storenewprj(ObsProject obsProject, boolean bl) {
        PyStore pyStore = new PyStore(this, obsProject, ProjectRepository.StoreVariant.submit, true, bl);
        pyStore.confirmAsNew = true;
        pyStore.confirmSubmit = true;
        pyStore.confirmSubmitAsNonPI = true;
        pyStore.confirmSubmitToNewerCycle = true;
        pyStore.perform();
        return pyStore.getProjectAfterStore();
    }

    public ObsProject newprj(String string) {
        PyNewProject pyNewProject = new PyNewProject(string);
        pyNewProject.perform();
        return pyNewProject.getObsProject();
    }

    public BusinessObject add(AddInteractor.ObjectType objectType, BusinessObject businessObject) {
        PyAdd pyAdd = new PyAdd();
        pyAdd.perform(objectType, businessObject);
        return pyAdd.getNewBO();
    }

    public String[] queryprj_bystatus(String string) {
        PyQuery pyQuery = new PyQuery(this);
        pyQuery.byStatus(string);
        pyQuery.perform();
        return pyQuery.getResults();
    }

    public String[] queryprj_byname(String string) {
        PyQuery pyQuery = new PyQuery(this);
        pyQuery.byName(string);
        pyQuery.perform();
        return pyQuery.getResults();
    }

    public String[] queryprj_bycode(String string) {
        PyQuery pyQuery = new PyQuery(this);
        pyQuery.byCode(string);
        pyQuery.perform();
        return pyQuery.getResults();
    }

    public void generate(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        PyGenerate.PhaseI phaseI = new PyGenerate.PhaseI(obsProposal);
        ((PyAction)phaseI).perform();
    }

    public void generate(@NonNull ObsProgram obsProgram) {
        if (obsProgram == null) {
            throw new NullPointerException("program is marked non-null but is null");
        }
        PyGenerate.PhaseII phaseII = new PyGenerate.PhaseII(obsProgram);
        phaseII.perform();
    }

    public void generate(@NonNull ObsProgram obsProgram, @NonNull List<ScienceGoal> list) {
        if (obsProgram == null) {
            throw new NullPointerException("program is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("scienceGoalsToBeRegenerated is marked non-null but is null");
        }
        PyGenerate.PhaseII phaseII = new PyGenerate.PhaseII(obsProgram, list);
        phaseII.perform();
    }

    public void generatePP(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        AttachTASummaryInteractor attachTASummaryInteractor = () -> obsProposal;
        AttachTASummaryPerformer attachTASummaryPerformer = new AttachTASummaryPerformer(attachTASummaryInteractor);
        attachTASummaryPerformer.perform();
    }

    public void cleanphase1(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("proposal is marked non-null but is null");
        }
        AbstractScienceGoal[] abstractScienceGoalArray = obsProposal.gettrueAbstractScienceGoal();
        for (AbstractScienceGoal iBusinessObject : abstractScienceGoalArray) {
            iBusinessObject.setObsUnitSet(null);
        }
        ObsUnitSet obsUnitSet = obsProposal.gettrueObsPlan();
        if (obsUnitSet != null) {
            List<ObsUnitSet> list = obsUnitSet.findObsUnitSets();
            for (ObsUnitSet obsUnitSet2 : list) {
                obsUnitSet2.removeFromParent();
            }
        }
    }

    public Problem[] validate(@NonNull BusinessObject businessObject) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        DefaultProblemListModel defaultProblemListModel = new DefaultProblemListModel();
        ValidatorSetFactory.createStandardValidatorSet().validate(businessObject, defaultProblemListModel);
        Problem[] problemArray = new Problem[defaultProblemListModel.getSize()];
        for (int i = 0; i < defaultProblemListModel.getSize(); ++i) {
            problemArray[i] = defaultProblemListModel.getProblemAt(i);
        }
        if (problemArray.length == 1 && "Success".equals(problemArray[0].getSeverity())) {
            problemArray = new Problem[]{};
        }
        return problemArray;
    }

    public Entity[] entities(ObsProject obsProject) throws UnknownEntityException {
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
        List<Entity> list = boBundle.entities();
        return list.toArray(new Entity[list.size()]);
    }
}

