/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.schedblock.SpectralSpecBaseEditor;
import alma.obsprep.ot.editors.spectralvisual.SchedBlockSpectralPanel;
import alma.obsprep.ot.editors.spectralvisual.ZoomObservable;
import alma.obsprep.ot.editors.spectralvisual.ZoomObserver;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.ReadonlyHandler;
import alma.obsprep.ot.models.schedblock.SchedBlockModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.valuetypes.Frequency;
import alma.valuetypes.Length;
import alma.valuetypes.Velocity;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SpectralSpecVisualEditor
extends SpectralSpecBaseEditor
implements ZoomObserver {
    public static FieldID spectralSelectOtherLinesFID;
    private SchedBlockSpectralPanel spectralPanel;
    protected JButton spectralPanButton;
    protected JButton spectralZoomButton;
    protected JComboBox spectralWaterVapourCombo;
    private FieldID spectralResetScaleFID;
    private FieldID spectralPanLineFID;
    private FieldID spectralZoomBandFID;
    private FieldID spectralDrawReceiverBandsFID;
    private FieldID spectralDrawCentreFrequenciesFID;
    private FieldID spectralDrawBasebandsFID;
    private FieldID spectralDrawOtherLinesFID;
    private FieldID spectralDrawSideBandsFID;
    private FieldID spectralDrawTransmissionFID;
    private FieldID spectralWaterVapourIndexFID;
    private FieldID spectralTrackSelectionFID;
    private FieldID spectralFoldBBCsFID;
    private FieldID spectralFoldSWsFID;
    private FieldID spectralZoomBasebandFID;
    private FieldID spectralZoomMirrorFID;
    private JButton spectralZoomMirrorButton;

    public SpectralSpecVisualEditor(Model model, ObservingToolController observingToolController) {
        super(model, observingToolController);
    }

    @Override
    protected void createSubclassWidgetsAndFIDs(String string) {
        this.spectralResetScaleFID = new FieldID(string + "SpectralResetScaleFID");
        this.spectralPanLineFID = new FieldID(string + "SpectralPanLineFID");
        this.spectralZoomBandFID = new FieldID(string + "SpectralZoomBandFID");
        this.spectralDrawReceiverBandsFID = new FieldID(string + "SpectralDrawReceiverBandsFID");
        this.spectralDrawCentreFrequenciesFID = new FieldID(string + "SpectralDrawBBCsFID");
        this.spectralDrawBasebandsFID = new FieldID(string + "SpectralDrawBasebandsFID");
        this.spectralDrawOtherLinesFID = new FieldID(string + "SpectralDrawOtherLinesFID");
        spectralSelectOtherLinesFID = new FieldID(string + "SpectralSelectOtherLinesFID");
        this.spectralDrawSideBandsFID = new FieldID(string + "SpectralDrawSideBandsFID");
        this.spectralDrawTransmissionFID = new FieldID(string + "SpectralDrawTransmissionFID");
        this.spectralWaterVapourIndexFID = new FieldID(string + "SpectralWaterVapourIndexFID");
        this.spectralTrackSelectionFID = new FieldID(string + "spectralTrackSelectionFID");
        this.spectralFoldBBCsFID = new FieldID(string + "spectralFoldBBCsFID");
        this.spectralFoldSWsFID = new FieldID(string + "spectralFoldSWsFID");
        this.spectralZoomBasebandFID = new FieldID(string + "spectralZoomBasebandFID");
        this.spectralZoomMirrorFID = new FieldID(string + "spectralZoomMirrorFID");
    }

    @Override
    protected void addComponents(String string) {
        SpectralSpecModel spectralSpecModel = this.getModel();
        this.addUsedByTargetInfoComponent();
        this.addSpectralPanelComponents(spectralSpecModel);
        this.addSpectralSpecComponents();
        JPanel jPanel = this.addCorrelatorConfigurationComponents();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-Instrument Setup-Correlator Configuration");
        jPanel = this.addBasebandConfigComponents();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-Instrument Setup-BaseBand Configurations");
    }

    @Override
    protected void setSubclassButtons(int n) {
        super.update(this.spectralDrawReceiverBandsFID, this.spectralPanel.isDrawReceiverBands());
        super.update(this.spectralDrawCentreFrequenciesFID, this.spectralPanel.isDrawCentreFrequencies());
        super.update(this.spectralDrawBasebandsFID, this.spectralPanel.isDrawBasebands());
        super.update(this.spectralDrawOtherLinesFID, this.spectralPanel.getDrawOtherLines());
        super.update(this.spectralDrawSideBandsFID, this.spectralPanel.isDrawSideBands());
        super.update(this.spectralDrawTransmissionFID, this.spectralPanel.isDrawTransmission());
        super.update(this.spectralTrackSelectionFID, this.spectralPanel.isTrackBasebandSelection());
        super.update(this.spectralFoldBBCsFID, this.spectralPanel.isFoldBasebands());
        super.update(this.spectralFoldSWsFID, this.spectralPanel.isSpectralWindowsFolded());
        this.spectralPanel.setSelectedBBC(n);
    }

    private void enableButtons() {
        this.spectralZoomMirrorButton.setEnabled(this.spectralPanel.canZoomToMirror());
    }

    @Override
    protected void setSubclassEditingACA(boolean bl) {
        this.spectralPanel.setACA(bl);
    }

    private JComponent heightSpacer() {
        JButton jButton = new JButton("");
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createRigidArea(new Dimension(0, 2 * jButton.getSize().height / 3)));
        return jPanel;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        SpectralSpecModel spectralSpecModel = this.getModel();
        SpectralSpec spectralSpec = (SpectralSpec)spectralSpecModel.getDocument();
        if (spectralSpec == null) {
            return;
        }
        if (fieldID == this.spectralTrackSelectionFID) {
            this.spectralPanel.setTrackBasebandSelection((Boolean)object);
        } else if (fieldID == this.spectralFoldBBCsFID) {
            this.spectralPanel.setFoldBasebands((Boolean)object);
        } else if (fieldID == this.spectralFoldSWsFID) {
            this.spectralPanel.setSpectralWindowsFolded((Boolean)object);
        } else if (fieldID == this.spectralResetScaleFID) {
            this.spectralPanel.resetFrequencyRange();
        } else if (fieldID == this.spectralPanLineFID) {
            this.spectralPanel.panToLine();
        } else if (fieldID == this.spectralZoomBandFID) {
            this.spectralPanel.zoomToBand();
        } else if (fieldID == this.spectralDrawReceiverBandsFID) {
            this.spectralPanel.setDrawReceiverBands((Boolean)object);
        } else if (fieldID == this.spectralDrawCentreFrequenciesFID) {
            this.spectralPanel.setDrawCentreFrequencies((Boolean)object);
        } else if (fieldID == this.spectralDrawBasebandsFID) {
            this.spectralPanel.setDrawBasebands((Boolean)object);
        } else if (fieldID == this.spectralDrawOtherLinesFID) {
            Boolean bl = (Boolean)object;
            this.spectralPanel.setDrawOtherLines(bl);
        } else if (fieldID == this.spectralDrawSideBandsFID) {
            this.spectralPanel.setDrawSideBands((Boolean)object);
        } else if (fieldID == this.spectralDrawTransmissionFID) {
            this.spectralPanel.setDrawTransmission((Boolean)object);
        } else if (fieldID == this.spectralWaterVapourIndexFID) {
            this.updateWaterVapourTransmission(object.toString());
        } else if (fieldID == this.spectralZoomBasebandFID) {
            this.spectralPanel.zoomToSelectedBaseband();
        } else if (fieldID == this.spectralZoomMirrorFID) {
            this.spectralPanel.zoomToMirror();
        } else if (spectralSelectOtherLinesFID.equals(fieldID)) {
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
                arrayList.addAll(list);
                ArrayList<SpectralLine> arrayList2 = new ArrayList<SpectralLine>();
                for (SpectralLine spectralLine : arrayList) {
                    if (!SpectralLine.Type.OBSERVED_TYPES.contains((Object)spectralLine.getType())) continue;
                    arrayList2.add(spectralLine);
                }
                arrayList.removeAll(arrayList2);
                this.spectralPanel.setLinesToDisplay(arrayList);
                this.spectralPanel.repaint();
            }
        } else {
            super.update(fieldID, object);
        }
        this.enableButtons();
        this.spectralPanel.repaint();
    }

    @Override
    public void setGuiApi(GuiApi guiApi) {
        this.spectralPanel.setPalette(guiApi.getColorPalette());
        super.setGuiApi(guiApi);
    }

    @Override
    public void update(ZoomObservable zoomObservable, boolean bl) {
        this.spectralPanButton.setEnabled(bl && this.spectralZoomButton.isEnabled());
    }

    private void addSpectralPanelComponents(SpectralSpecModel spectralSpecModel) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.getModel();
        this.spectralPanel = new SchedBlockSpectralPanel(this.getGuiApi().getColorPalette(), 1.0, 2.0);
        this.spectralPanel.setModel(spectralSpecModel);
        this.spectralPanel.addObserver(this);
        this.spectralPanel.putClientProperty("readonly-handler", new ReadonlyHandler(){

            @Override
            public void handleReadOnly(Component component) {
                SpectralSpecVisualEditor.this.spectralPanel.setAllowDragLO(false);
                SpectralSpecVisualEditor.this.spectralPanel.setAllowDragLines(false);
            }

            @Override
            public void handleNotReadOnly(Component component) {
                SpectralSpecVisualEditor.this.spectralPanel.setAllowDragLO(true);
                SpectralSpecVisualEditor.this.spectralPanel.setAllowDragLines(true);
            }
        });
        gridBagConstraints.weightx = 1.0;
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, this.spectralPanel);
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, this.heightSpacer());
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeCheckBox(this.spectralTrackSelectionFID, "Track selection", "Control whether or not to zoom to a newly selected baseband"));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeCheckBox(this.spectralFoldSWsFID, "Fold Spectral Windows", "Optimise the use of vertical space for drawing of spectral windows"));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeCheckBox(this.spectralFoldBBCsFID, "Fold Basebands", "Optimise the use of vertical space for drawing of basebands"));
        componentCollection.remember(this.makeLabel(""));
        this.addComponentArray(jPanel2, gridBagLayout2, gridBagConstraints2, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeCheckBox(this.spectralDrawBasebandsFID, "Basebands", "Toggle drawing of baseband ranges"));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeCheckBox(this.spectralDrawOtherLinesFID, "Overlay Lines", "Toggle drawing of overlay selected lines"));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeCheckBox(this.spectralDrawCentreFrequenciesFID, "BB Centre Frequencies", "Toggle drawing of the baseband config centre lines"));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeCheckBox(this.spectralDrawReceiverBandsFID, "Receiver Bands", "Toggle drawing of the receiver bands"));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeCheckBox(this.spectralDrawSideBandsFID, "Sidebands", "Toggle drawing of the receiver bands"));
        componentCollection.remember(this.makeLabel(""));
        this.addComponentArray(jPanel2, gridBagLayout2, gridBagConstraints2, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeCheckBox(this.spectralDrawTransmissionFID, "Transmission", "Toggle drawing of the atmospheric transmission"));
        componentCollection.space();
        componentCollection.remember(new JLabel("Water Vapour Column Density"));
        componentCollection.space();
        String[] stringArray = new String[AtmosphereTable.WV_MAP.length + 1];
        stringArray[0] = "Automatic Choice";
        for (int i = 0; i < AtmosphereTable.WV_MAP.length; ++i) {
            stringArray[i + 1] = AtmosphereTable.WV_MAP[i];
        }
        this.spectralWaterVapourCombo = new JComboBox<String>(stringArray);
        String string = "<html>Maximum allowed column density of precipatable water vapor. <br>\"OT Chooses\" :<br>" + WaterVaporColumns.getSelectorDescriptions(true) + "</html>";
        this.spectralWaterVapourCombo.setToolTipText(string);
        this.initEvents(this.spectralWaterVapourCombo, this.spectralWaterVapourIndexFID);
        componentCollection.remember(this.spectralWaterVapourCombo);
        this.configureWaterVaporTransmissionUpdater();
        this.addComponentArray(jPanel2, gridBagLayout2, gridBagConstraints2, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeLabel(""));
        JButton jButton = new JButton("Select Lines to Overlay");
        jButton.setToolTipText("Select other lines to display");
        jButton.addActionListener(actionEvent -> this.selectLinesToOverlayAction(jButton));
        componentCollection.remember(jButton);
        componentCollection.remember(this.makeLabel(""));
        JComponent[] jComponentArray = new JComponent[1];
        this.spectralPanButton = this.makeButton(this.spectralPanLineFID, "Pan to Representative", "Pan to the SchedBlock representative frequency");
        jComponentArray[0] = this.spectralPanButton;
        componentCollection.remember(jComponentArray);
        componentCollection.remember(this.makeLabel(""));
        JComponent[] jComponentArray2 = new JComponent[1];
        this.spectralZoomButton = this.makeButton(this.spectralZoomBandFID, "Zoom To Band", "Zoom to the current reciever band");
        jComponentArray2[0] = this.spectralZoomButton;
        componentCollection.remember(jComponentArray2);
        componentCollection.remember(this.makeLabel(""));
        JComponent[] jComponentArray3 = new JComponent[1];
        JButton jButton2 = this.makeButton(this.spectralResetScaleFID, "Reset", "Reset the scale");
        jComponentArray3[0] = jButton2;
        componentCollection.remember(jComponentArray3);
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeLabel(""));
        this.addComponentArray(jPanel2, gridBagLayout2, gridBagConstraints2, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeLabel(""));
        JComponent[] jComponentArray4 = new JComponent[1];
        JButton jButton3 = this.makeButton(this.spectralZoomBasebandFID, "Zoom to Selected Baseband", "Zoom to the selected baseband");
        jComponentArray4[0] = jButton3;
        componentCollection.remember(jComponentArray4);
        componentCollection.remember(this.makeLabel(""));
        this.spectralZoomMirrorButton = this.makeButton(this.spectralZoomMirrorFID, "Zoom to Mirror", "<html>Zoom to the mirror (in the LO1<br> frequency) of the current window</html>");
        componentCollection.remember(this.spectralZoomMirrorButton);
        this.addComponentArray(jPanel2, gridBagLayout2, gridBagConstraints2, componentCollection);
        this.spectralPanButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.spectralZoomButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        jButton2.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        jButton3.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.spectralZoomMirrorButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        int n = this.constraints.gridheight;
        this.constraints.gridheight = 3;
        JPanel jPanel3 = (JPanel)this.addNonCollapsingGroup(4, jPanel, "Receivers, Basebands & LO Visualisation");
        this.constraints.gridheight = n;
        CSH.setHelpIDString((Component)jPanel3, (String)"TOC-The Visual Editors-The Visual Spectral Editor-Visual Spectral Editor for Scheduling Blocks");
        spectralSpecModel.getRestFrequencyModel().subscribe(this);
        spectralSpecModel.getBaseBandConfigModel().getDesiredCenterFreqRestModel().subscribe(this);
    }

    private void updateWaterVapourTransmission(String string) {
        SpectralSpecModel spectralSpecModel = this.getModel();
        SpectralSpec spectralSpec = (SpectralSpec)spectralSpecModel.getDocument();
        int n = WaterVaporColumns.wvindexSelector(string);
        if (spectralSpec == null) {
            return;
        }
        if (n == -1) {
            SchedBlock schedBlock = (SchedBlock)spectralSpec.getParent();
            if (schedBlock == null) {
                return;
            }
            Length length = schedBlock.getPreconditions().getWeatherConstraints().getMaxPWVC();
            n = WaterVaporColumns.wvindexSelectorUsingLength(length);
            this.spectralPanel.setWaterVapourIndex(n);
        } else {
            this.spectralPanel.setWaterVapourIndex(n);
        }
        this.spectralPanel.resetTransmissionData();
    }

    public void refreshWaterVapourTransmission() {
        String string = this.spectralWaterVapourCombo.getSelectedItem().toString();
        this.updateWaterVapourTransmission(string);
    }

    private void configureWaterVaporTransmissionUpdater() {
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            if (fieldID == FieldIDs.maxPWVCValueFID) {
                this.refreshWaterVapourTransmission();
            }
        };
        ObservingToolGui observingToolGui = this.otc.getGui();
        EditorManager editorManager = observingToolGui.getEditors();
        SchedBlockModel schedBlockModel = (SchedBlockModel)editorManager.modelFor(SchedBlock.class);
        schedBlockModel.getMaxPWVCModel().subscribe(modelChangeSubscriber);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        super.modelChanged(model, fieldID, object);
        if (this.spectralWaterVapourCombo != null) {
            this.refreshWaterVapourTransmission();
        }
    }

    private void selectLinesToOverlayAction(JButton jButton) {
        Object object;
        jButton.setEnabled(false);
        SpectralSpec spectralSpec = this.getModel().getSpectralSpec();
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
        Frequency frequency = null;
        if (spectralSpec != null && (object = spectralSpec.getLO1Frequency()) != null && !object.isZero()) {
            frequency = object.deepCopy();
        }
        arrayList.addAll(this.spectralPanel.getLinesToDisplay());
        object = spectralSpec.getSourceVelocity();
        SpectralLineChooser spectralLineChooser = DialogSpectralLineChooser.getInstance();
        SpectralLinePublisher spectralLinePublisher = spectralLineChooser.createPublisher(this, spectralSelectOtherLinesFID, jButton);
        try {
            spectralLineChooser.chooseMultipleLinesForOverlay(spectralLinePublisher, (Velocity)((Object)object), arrayList, frequency, Optional.empty());
        }
        catch (RuntimeException runtimeException) {
            jButton.setEnabled(true);
            throw runtimeException;
        }
    }

    public static void main(String[] stringArray) {
        BLCorrelatorConfiguration bLCorrelatorConfiguration;
        InitServices.initModelSupportClasses();
        System.setProperty("otData.dir", "config/otData/");
        ObservingToolController observingToolController = new ObservingToolController();
        SpectralSpecModel spectralSpecModel = new SpectralSpecModel(null);
        SpectralSpecVisualEditor spectralSpecVisualEditor = new SpectralSpecVisualEditor((Model)spectralSpecModel, observingToolController);
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        ACACorrelatorConfiguration aCACorrelatorConfiguration = ACACorrelatorConfiguration.createACACorrelatorConfiguration();
        Object object = bLCorrelatorConfiguration = BLCorrelatorConfiguration.createBLCorrelatorConfiguration();
        if (stringArray.length > 0 && stringArray[0].equals("ACA")) {
            object = aCACorrelatorConfiguration;
        }
        spectralSpec.setCorrelatorConfiguration((AbstractCorrelatorConfiguration)object);
        spectralSpecModel.setDocument(spectralSpec);
        JFrame jFrame = new JFrame("SpectralSpecEditor");
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.setPreferredSize(new Dimension(800, 700));
        container.setLayout(new BoxLayout(container, 3));
        container.add(spectralSpecVisualEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

