/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.VLBIFrequencyBands;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.ValueUnitPairCellRenderer;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.obsproject.GoalTargetPropertiesTableModel;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetSelectorDialog;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.VelocityEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.CalibrationTargetParametersModel;
import alma.obsprep.ot.models.obsproject.GoalTargetParametersModel;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class CalibrationTargetParametersEditor
extends EditorWithGridBagLayout
implements TableModelListener,
ListSelectionListener {
    public static final FieldID CANCEL_BUTTON_FID = new FieldID("CalibrationTargetParametersEditor Cancel button FID");
    public static final FieldID DONE_BUTTON_FID = new FieldID("CalibrationTargetParametersEditor OK button FID");
    public static final FieldID SEARCH_CATALOGUE_BUTTON_FID = new FieldID("CalibrationTargetParametersEditor search catalogue button FID");
    private JButton okButton;
    private JButton cancelButton;
    private JLabel helpLabel;
    private JPanel panel;
    private JButton removePropertyButton;
    private JButton resolveSourceButton;
    private JButton searchCatalogueButton;
    private JList<String> solarSystemList;
    private JLabel solarSystemObjectLabel;
    private JRadioButton solarSystemRadioButton;
    private JScrollPane solarSystemScrollPane;
    private JLabel sourceNameLabel;
    private OTTextField sourceNameTextField;
    private JRadioButton userDefinedTargetRadioButton;
    private JLabel velocityLabel;
    private VelocityEditor velocityEditor;
    private JLabel positionLabel;
    private SkyCoordsEditor skyCoordsEditor;
    private final CalibrationTargetParametersModel calibrationTargetParametersModel;
    private JTable fluxDensityTable;
    private final GoalTargetPropertiesTableModel propertiesTableModel = new GoalTargetPropertiesTableModel();
    private ButtonGroup calibratorTypeButtonGroup;

    public CalibrationTargetParametersEditor(@NonNull CalibrationTargetParametersModel calibrationTargetParametersModel) {
        if (calibrationTargetParametersModel == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.setModel(calibrationTargetParametersModel);
        this.calibrationTargetParametersModel = calibrationTargetParametersModel;
        this.initTargetParametersPanel();
        this.build();
        calibrationTargetParametersModel.publish();
    }

    @Override
    protected void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panel, gridBagConstraints);
    }

    @Override
    protected void build() {
        super.build("CalibrationTargetParametersEditor");
        this.propertiesTableModel.addTableModelListener(this);
        this.fluxDensityTable.getSelectionModel().addListSelectionListener(this);
        this.solarSystemList.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (CalibrationTargetParametersModel.SIDEREAL_MOTION.equals(fieldID)) {
            this.setSiderealVisibleState(true);
        } else if (CalibrationTargetParametersModel.NON_SIDEREAL_MOTION.equals(fieldID)) {
            this.setSiderealVisibleState(false);
        } else if (CalibrationTargetParametersModel.SOLAR_SYSTEM_OBJECT.equals(fieldID)) {
            this.solarSystemList.setSelectedValue(object, true);
        } else if (GoalTargetParametersModel.CALIBRATION_TARGET_PROPERTIES.equals(fieldID)) {
            if (object != null) {
                CalibrationTargetProperties[] calibrationTargetPropertiesArray = (CalibrationTargetProperties[])object;
                this.propertiesTableModel.setCalibrationTargetProperties(calibrationTargetPropertiesArray);
            }
            this.setButtons();
        } else if (GoalTargetParametersModel.SOURCE_NAME.equals(fieldID) && object instanceof String) {
            this.setOkayButtonSensitivity((String)object);
        }
        super.update(fieldID, object);
    }

    private void setOkayButtonSensitivity(String string) {
        if (this.userDefinedTargetRadioButton.isSelected()) {
            this.getOkButton().setEnabled(StringUtils.isNotEmpty((CharSequence)string));
        } else {
            this.getOkButton().setEnabled(true);
        }
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (GoalTargetParametersModel.REMOVE_PROPERTY.equals(fieldID)) {
            ArrayList<CalibrationTargetProperties> arrayList = new ArrayList<CalibrationTargetProperties>();
            for (int n : this.fluxDensityTable.getSelectedRows()) {
                arrayList.add(this.propertiesTableModel.getCalibrationTargetPropertiesAt(n));
            }
            return arrayList;
        }
        if (SEARCH_CATALOGUE_BUTTON_FID.equals(fieldID)) {
            QuerySource querySource = QuerySource.createQuerySource();
            querySource.setMaxSources(100);
            SkyCoordinates skyCoordinates = (SkyCoordinates)this.calibrationTargetParametersModel.getSkyCoordsModel().getDocument();
            querySource.setQueryCenter(skyCoordinates.deepCopy());
            CalibrationTargetParameters calibrationTargetParameters = (CalibrationTargetParameters)this.calibrationTargetParametersModel.getDocument();
            ScienceGoal scienceGoal = calibrationTargetParameters.getScienceGoal();
            this.setupQueryForVLBIPassivePhasing(scienceGoal, querySource);
            QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
            CalibratorExpertModel calibratorExpertModel = this.calibrationTargetParametersModel.getCalibratorExpertModel();
            calibratorExpertModel.setDocument(querySourceAdapter);
            ObservatoryGoalTargetSelectorDialog observatoryGoalTargetSelectorDialog = new ObservatoryGoalTargetSelectorDialog(calibratorExpertModel, false);
            CalibrationTargetParametersEditor.resizeDialog(observatoryGoalTargetSelectorDialog);
            observatoryGoalTargetSelectorDialog.setVisible(true);
            List<Measurement> list = observatoryGoalTargetSelectorDialog.getCalibratorsSelected();
            if (list.size() == 1) {
                this.calibrationTargetParametersModel.setTargetFromMeasurement(list.get(0));
            }
            return list;
        }
        if (GoalTargetParametersModel.SOURCE_NAME.equals(fieldID) && object instanceof String) {
            boolean bl = StringUtils.isNotEmpty((CharSequence)((String)object));
            this.getOkButton().setEnabled(bl);
        }
        return object;
    }

    private void setupQueryForVLBIPassivePhasing(@NonNull ScienceGoal scienceGoal, @NonNull IQuerySource iQuerySource) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (iQuerySource == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        boolean bl = VLBIExpert.isPassivePhasingEnabled(scienceGoal);
        if (bl) {
            List<VLBIFrequencyBands.VLBIBands> list;
            ReceiverBand receiverBand = scienceGoal.getReceiverBand();
            if (receiverBand == null) {
                Log.logger(CalibrationTargetParametersEditor.class).warning("No rxb defined");
                return;
            }
            int n = receiverBand.getNumber();
            AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
            try {
                list = ObsProposal.isProposalPhasedArray() ? almaCapabilities.getVLBIPhaserBands().getVLBIBands() : almaCapabilities.getVLBIBands().getVLBIBands();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(CalibrationTargetParametersEditor.class).warning("Unable to determine if we are VLBI" + unknownEntityException.getMessage());
                return;
            }
            Optional<VLBIFrequencyBands.VLBIBands> optional = list.stream().filter(vLBIBands -> vLBIBands.getBand() == receiverBand.getNumber()).findFirst();
            optional.ifPresentOrElse(vLBIBands -> iQuerySource.setSearchRadius(OTConfigurationHelper.getAngle(vLBIBands.getPassivePhaseCalibratorSearchRadius())), () -> GUIUtilities.warning(null, "No passive phase calibrator search radius found for band " + n));
            iQuerySource.setMinFrequency(Frequency.createFrequencyGHZ(receiverBand.getRFMin()));
            iQuerySource.setMaxFrequency(Frequency.createFrequencyGHZ(receiverBand.getRFMax()));
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            int n = tableModelEvent.getFirstRow();
            if (n != tableModelEvent.getLastRow()) {
                return;
            }
            CalibrationTargetProperties calibrationTargetProperties = this.propertiesTableModel.getCalibrationTargetPropertiesAt(n);
            this.calibrationTargetParametersModel.setCalibrationTargetProperties(calibrationTargetProperties, n);
        }
    }

    private void setSiderealVisibleState(boolean bl) {
        this.solarSystemObjectLabel.setVisible(!bl);
        this.solarSystemScrollPane.setVisible(!bl);
        this.solarSystemRadioButton.setSelected(!bl);
        this.userDefinedTargetRadioButton.setSelected(bl);
        this.searchCatalogueButton.setVisible(bl);
        this.resolveSourceButton.setVisible(bl);
        this.velocityLabel.setVisible(bl);
        this.velocityEditor.setVisible(bl);
        this.skyCoordsEditor.setVisible(bl);
        this.sourceNameLabel.setVisible(bl);
        this.sourceNameTextField.setVisible(bl);
        this.positionLabel.setVisible(bl);
        this.helpLabel.setVisible(bl);
        if (!bl) {
            this.getOkButton().setEnabled(true);
        } else {
            boolean bl2 = StringUtils.isNotEmpty((CharSequence)((OTTextField)this.getComponent(GoalTargetParametersModel.SOURCE_NAME)).getText());
            this.getOkButton().setEnabled(bl2);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.fluxDensityTable.getSelectionModel())) {
            this.setButtons();
        } else if (listSelectionEvent.getSource().equals(this.solarSystemList.getSelectionModel())) {
            this.getController().widgetUpdated(this, CalibrationTargetParametersModel.SOLAR_SYSTEM_OBJECT, this.solarSystemList.getSelectedValue());
        }
    }

    private void setButtons() {
        this.removePropertyButton.setEnabled(this.fluxDensityTable.getSelectedRows().length > 0);
    }

    private void initTargetParametersPanel() {
        JButton jButton = this.makeButton(GoalTargetParametersModel.ADD_PROPERTY, "Add Flux Density Measurement", "Add a flux density measurement for this calibrator");
        JPanel jPanel = new JPanel();
        this.calibratorTypeButtonGroup = new ButtonGroup();
        JLabel jLabel = new JLabel();
        this.okButton = this.makeButton(DONE_BUTTON_FID, "OK", "Close this window and return to the calibrators editor");
        this.cancelButton = this.makeButton(CANCEL_BUTTON_FID, "Cancel", "Cancel this window");
        this.helpLabel = new JLabel();
        this.userDefinedTargetRadioButton = new JRadioButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.positionLabel = new JLabel();
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane();
        this.removePropertyButton = this.makeButton(GoalTargetParametersModel.REMOVE_PROPERTY, "Remove Selected Measurement", "Remove selected calibrator flux measurement");
        this.resolveSourceButton = this.makeButton(GoalTargetParametersModel.RESOLVE_SOURCE, "Resolve Source", "Resolve source name");
        this.skyCoordsEditor = this.makeSkyCoordsEditor(this.calibrationTargetParametersModel.getSkyCoordsModel(), "Target Coordinates");
        this.searchCatalogueButton = this.makeButton(SEARCH_CATALOGUE_BUTTON_FID, "Select from Source Catalogue", "Select an entry from the source catalog");
        this.solarSystemList = new JList();
        this.solarSystemObjectLabel = new JLabel();
        this.solarSystemRadioButton = new JRadioButton();
        this.solarSystemScrollPane = new ScrollWhenFocusedPane();
        this.sourceNameLabel = new JLabel();
        this.sourceNameTextField = this.makeTextField(GoalTargetParametersModel.SOURCE_NAME, true, "Target name");
        this.panel = new JPanel();
        this.velocityEditor = this.makeVelocityEditor(this.calibrationTargetParametersModel.getVelocityModel(), "Target velocity");
        this.velocityLabel = new JLabel();
        this.initEvents(this.userDefinedTargetRadioButton, CalibrationTargetParametersModel.SIDEREAL_MOTION);
        this.initEvents(this.solarSystemRadioButton, CalibrationTargetParametersModel.NON_SIDEREAL_MOTION);
        this.panel.setLayout(new GridBagLayout());
        jLabel.setText("Calibrator Type:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)jLabel, gridBagConstraints);
        this.calibratorTypeButtonGroup.add(this.solarSystemRadioButton);
        this.solarSystemRadioButton.setText("Solar System Target");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.solarSystemRadioButton, gridBagConstraints);
        this.calibratorTypeButtonGroup.add(this.userDefinedTargetRadioButton);
        this.userDefinedTargetRadioButton.setText("Sidereal Target");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.panel.add((Component)this.userDefinedTargetRadioButton, gridBagConstraints);
        this.solarSystemObjectLabel.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)this.solarSystemObjectLabel, gridBagConstraints);
        this.solarSystemList.setModel((ListModel<String>)new AbstractListModel<String>(){
            List<String> strings = CalibrationTargetParameters.getKnownSolarSystemCalibratorsList();

            @Override
            public int getSize() {
                return this.strings.size();
            }

            @Override
            public String getElementAt(int n) {
                return this.strings.get(n);
            }
        });
        this.solarSystemList.setSelectionMode(0);
        this.solarSystemScrollPane.setViewportView(this.solarSystemList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.solarSystemScrollPane, gridBagConstraints);
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.helpLabel.setText("<html><ul><li>Click <i>Select from Source Catalogue</i> to search for and select a calibrator from the source catalog.</li><li>If the catalog does not contain your desired calibrator, manually input the calibrator properties in the fields below.</li></ul></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.panel.add((Component)this.helpLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.panel.add((Component)this.searchCatalogueButton, gridBagConstraints);
        this.sourceNameLabel.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)this.sourceNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.sourceNameTextField, gridBagConstraints);
        this.positionLabel.setText("Position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)this.positionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.skyCoordsEditor, gridBagConstraints);
        this.velocityLabel.setText("Velocity:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panel.add((Component)this.velocityLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.panel.add((Component)this.velocityEditor, gridBagConstraints);
        jLabel2.setText("Flux Density:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.panel.add((Component)jLabel2, gridBagConstraints);
        this.fluxDensityTable = new Table(this.propertiesTableModel){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = this.getSelectedRow();
                super.tableChanged(tableModelEvent);
                if (n < this.getRowCount() && n >= 0) {
                    this.setRowSelectionInterval(n, n);
                }
            }
        };
        this.fluxDensityTable.getTableHeader().setReorderingAllowed(false);
        this.fluxDensityTable.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        this.fluxDensityTable.setDefaultEditor(Sensitivity.class, new ValueUnitPairCellEditor.SensitivityEditor());
        this.fluxDensityTable.setDefaultEditor(Angle.class, new ValueUnitPairCellEditor.AngleEditor());
        this.fluxDensityTable.setDefaultRenderer(AbstractDoubleWithUnit.class, new ValueUnitPairCellRenderer());
        this.fluxDensityTable.setSelectionMode(0);
        this.fluxDensityTable.setColumnSelectionAllowed(false);
        this.fluxDensityTable.getSelectionModel().addListSelectionListener(this);
        this.fluxDensityTable.setToolTipText("The known properties of the source at the indicated frequencies");
        scrollWhenFocusedPane.setViewportView(this.fluxDensityTable);
        scrollWhenFocusedPane.setToolTipText("Flux measurements can be edited by clicking on a value in the table");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)scrollWhenFocusedPane, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removePropertyButton)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jButton).addComponent(this.removePropertyButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.panel.add((Component)jPanel, gridBagConstraints);
        GroupLayout groupLayout2 = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.cancelButton).addComponent(this.okButton)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(18, 12, 12, 12);
        this.panel.add((Component)jPanel2, gridBagConstraints);
        jButton.setName("CalibrationTargetParametersEditor.addPropertyButton");
        jPanel.setName("CalibrationTargetParametersEditor.buttonPanel");
        jLabel.setName("CalibrationTargetParametersEditor.calibratorTypeLabel");
        this.okButton.setName("CalibrationTargetParametersEditor.closeButton");
        this.helpLabel.setName("CalibrationTargetParametersEditor.helpLabel");
        jPanel2.setName("CalibrationTargetParametersEditor.okButtonPanel");
        this.panel.setName("CalibrationTargetParametersEditor.panel");
        this.positionLabel.setName("CalibrationTargetParametersEditor.positionLabel");
        jLabel2.setName("CalibrationTargetParametersEditor.propertiesLabel");
        scrollWhenFocusedPane.setName("CalibrationTargetParametersEditor.propertiesScrollPane");
        this.fluxDensityTable.setName("CalibrationTargetParametersEditor.propertiesTable");
        this.removePropertyButton.setName("CalibrationTargetParametersEditor.removePropertyButton");
        this.resolveSourceButton.setName("CalibrationTargetParametersEditor.resolveSourceButton");
        this.searchCatalogueButton.setName("CalibrationTargetParametersEditor.searchCatalogueButton");
        this.skyCoordsEditor.setName("CalibrationTargetParametersEditor.skyCoordsEditor");
        this.solarSystemList.setName("CalibrationTargetParametersEditor.solarSystemList");
        this.solarSystemObjectLabel.setName("CalibrationTargetParametersEditor.solarSystemObjectLabel");
        this.solarSystemRadioButton.setName("CalibrationTargetParametersEditor.solarSystemRadioButton");
        this.solarSystemScrollPane.setName("CalibrationTargetParametersEditor.solarSystemScrollPane");
        this.sourceNameLabel.setName("CalibrationTargetParametersEditor.sourceNameLabel");
        this.sourceNameTextField.setName("CalibrationTargetParametersEditor.sourceNameTextField");
        this.userDefinedTargetRadioButton.setName("CalibrationTargetParametersEditor.userDefinedTargetRadioButton");
        this.velocityEditor.setName("CalibrationTargetParametersEditor.velocityEditor");
        this.velocityLabel.setName("CalibrationTargetParametersEditor.velocityLabel");
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        CalibrationTargetParameters calibrationTargetParameters = CalibrationTargetParameters.createCalibrationTargetParameters();
        calibrationTargetParameters.addCalibrationTargetProperties(CalibrationTargetProperties.createCalibrationTargetProperties(5.0, 1.0));
        calibrationTargetParameters.addCalibrationTargetProperties(CalibrationTargetProperties.createCalibrationTargetProperties(6.0, 2.0));
        CalibrationTargetParametersModel calibrationTargetParametersModel = new CalibrationTargetParametersModel(calibrationTargetParameters);
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(CalibrationTargetParametersEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            CalibrationTargetParametersEditor calibrationTargetParametersEditor = new CalibrationTargetParametersEditor(calibrationTargetParametersModel);
            JFrame jFrame = new JFrame("CalibrationTargetParametersEditor");
            jFrame.setDefaultCloseOperation(3);
            jFrame.getContentPane().add(calibrationTargetParametersEditor);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }
}

