/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.tools;

import alma.acs.logging.tools.CSVConverter;
import alma.acs.logging.tools.LogConverter;
import alma.acs.logging.tools.LogFileExtractor;
import alma.acs.logging.tools.LogFileSplitter;
import alma.acs.logging.tools.TextConverter;
import alma.acs.logging.tools.TwikiTableConverter;
import alma.acs.logging.tools.XMLConverter;
import alma.acs.util.CmdLineArgs;
import alma.acs.util.CmdLineOption;
import alma.acs.util.CmdLineRegisteredOption;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogAssistant {
    public static final String TIME_FORMAT = "yyyy'-'MM'-'dd'T'HH':'mm':'ss";
    private char command;
    private Date startDate = null;
    private Date endDate = null;
    private String filterFileName = null;
    private Integer num = null;
    private Integer minutes = null;
    private String[] sourceFileNames = null;
    private String destFileName = null;
    private LogConverter converter;
    private String cols = null;

    public LogAssistant(String[] args) {
        this.parseCommandLine(args);
    }

    public void work() throws Exception {
        if (this.checkState()) {
            if (this.command == 'x') {
                this.extractLogs();
            } else if (this.command == 'p') {
                this.splitFile();
            }
        }
    }

    private void parseCommandLine(String[] params) throws IllegalStateException {
        String[] val;
        String[] val2;
        CmdLineArgs cmdLineArgs = new CmdLineArgs();
        CmdLineRegisteredOption helpCmd = new CmdLineRegisteredOption("-h", "-help", 0);
        cmdLineArgs.registerOption(helpCmd);
        if (params.length == 1) {
            cmdLineArgs.parseArgs(params);
            if (cmdLineArgs.isSpecified(helpCmd)) {
                this.command = (char)104;
                return;
            }
        }
        if (params.length < 5) {
            throw new IllegalStateException("Wrong number of params");
        }
        CmdLineRegisteredOption extractCmd = new CmdLineRegisteredOption("-x", "-extract", 0);
        cmdLineArgs.registerOption(extractCmd);
        CmdLineRegisteredOption splitCmd = new CmdLineRegisteredOption("-p", "-split", 0);
        cmdLineArgs.registerOption(splitCmd);
        CmdLineRegisteredOption csvOtuputFormat = new CmdLineRegisteredOption("-csv", 0);
        cmdLineArgs.registerOption(csvOtuputFormat);
        CmdLineRegisteredOption txtOtuputFormat = new CmdLineRegisteredOption("-txt", 0);
        cmdLineArgs.registerOption(txtOtuputFormat);
        CmdLineRegisteredOption xmlOtuputFormat = new CmdLineRegisteredOption("-xml", 0);
        cmdLineArgs.registerOption(xmlOtuputFormat);
        CmdLineRegisteredOption twikiOtuputFormat = new CmdLineRegisteredOption("-twiki", 0);
        cmdLineArgs.registerOption(twikiOtuputFormat);
        CmdLineRegisteredOption startTime = new CmdLineRegisteredOption("-s", "-start", 1);
        cmdLineArgs.registerOption(startTime);
        CmdLineRegisteredOption endTime = new CmdLineRegisteredOption("-e", "-end", 1);
        cmdLineArgs.registerOption(endTime);
        CmdLineRegisteredOption filterName = new CmdLineRegisteredOption("-f", "-filter", 1);
        cmdLineArgs.registerOption(filterName);
        CmdLineRegisteredOption time = new CmdLineRegisteredOption("-t", "-time", 1);
        cmdLineArgs.registerOption(time);
        CmdLineRegisteredOption number = new CmdLineRegisteredOption("-n", "-num", 1);
        cmdLineArgs.registerOption(number);
        CmdLineRegisteredOption columns = new CmdLineRegisteredOption("-l", "-col", 0);
        cmdLineArgs.registerOption(columns);
        CmdLineRegisteredOption dstFileOption = new CmdLineRegisteredOption("-dest", 1);
        cmdLineArgs.registerOption(dstFileOption);
        CmdLineRegisteredOption sourceFilesOption = new CmdLineRegisteredOption("-src", 1);
        cmdLineArgs.registerOption(sourceFilesOption);
        cmdLineArgs.parseArgs(params);
        if (cmdLineArgs.isSpecified(extractCmd)) {
            this.command = (char)120;
        }
        if (cmdLineArgs.isSpecified(splitCmd)) {
            this.command = (char)112;
        }
        if (cmdLineArgs.isSpecified(startTime)) {
            val2 = cmdLineArgs.getValues((CmdLineOption)startTime);
            if (val2 == null || val2.length < 1) {
                throw new IllegalStateException("Start date missing/wrong yyyy'-'MM'-'dd'T'HH':'mm':'ss");
            }
            try {
                this.startDate = this.getDate(val2[0]);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Wrong date format yyyy'-'MM'-'dd'T'HH':'mm':'ss");
            }
        }
        if (cmdLineArgs.isSpecified(endTime)) {
            val2 = cmdLineArgs.getValues((CmdLineOption)endTime);
            if (val2 == null || val2.length < 1) {
                throw new IllegalStateException("End date missing/wrong yyyy'-'MM'-'dd'T'HH':'mm':'ss");
            }
            try {
                this.endDate = this.getDate(val2[0]);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Wrong date format yyyy'-'MM'-'dd'T'HH':'mm':'ss");
            }
        }
        if (cmdLineArgs.isSpecified(filterName)) {
            val2 = cmdLineArgs.getValues((CmdLineOption)filterName);
            if (val2 == null || val2.length < 1) {
                throw new IllegalStateException("Wrong or missing filter name");
            }
            this.filterFileName = val2[0];
        }
        if (cmdLineArgs.isSpecified(time)) {
            val2 = cmdLineArgs.getValues((CmdLineOption)time);
            if (val2 == null || val2.length < 1) {
                throw new IllegalStateException("Wrong or missing time (minutes)");
            }
            try {
                this.minutes = Integer.parseInt(val2[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Wrong format for the time (minutes)");
            }
        }
        if (cmdLineArgs.isSpecified(number)) {
            val2 = cmdLineArgs.getValues((CmdLineOption)number);
            if (val2 == null || val2.length < 1) {
                throw new IllegalStateException("Wrong or missing time (minutes)");
            }
            try {
                this.num = Integer.parseInt(val2[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Wrong format for the number of logs");
            }
        }
        if (cmdLineArgs.isSpecified(columns)) {
            val2 = cmdLineArgs.getValues((CmdLineOption)columns);
            if (val2 == null || val2.length < 1) {
                throw new IllegalStateException("Wrong or missing time (minutes)");
            }
            this.cols = val2[0];
        }
        int count = 0;
        if (cmdLineArgs.isSpecified(csvOtuputFormat)) {
            System.out.println("Set output format to CSV");
            this.converter = new CSVConverter(this.cols);
            ++count;
        }
        if (cmdLineArgs.isSpecified(xmlOtuputFormat)) {
            System.out.println("Set output format to XML");
            this.converter = new XMLConverter();
            ++count;
        }
        if (cmdLineArgs.isSpecified(txtOtuputFormat)) {
            System.out.println("Set output format to plain ASCII text");
            this.converter = new TextConverter(this.cols);
            ++count;
        }
        if (cmdLineArgs.isSpecified(twikiOtuputFormat)) {
            System.out.println("Set output format to Twiki table");
            this.converter = new TwikiTableConverter(this.cols);
            ++count;
        }
        if (count == 0) {
            this.converter = new XMLConverter();
            System.out.println("No output format specified: using default XML.");
        } else if (count > 1) {
            throw new IllegalStateException("Too many output format specified.");
        }
        if (cmdLineArgs.isSpecified(sourceFilesOption)) {
            this.sourceFileNames = cmdLineArgs.getValues((CmdLineOption)sourceFilesOption);
            if (this.sourceFileNames == null || this.sourceFileNames.length < 1) {
                throw new IllegalStateException("Wrong or missing source file names");
            }
        }
        if (cmdLineArgs.isSpecified(dstFileOption)) {
            val = cmdLineArgs.getValues((CmdLineOption)dstFileOption);
            if (val == null || val.length < 1) {
                throw new IllegalStateException("Wrong or missing time (minutes)");
            }
        } else {
            throw new IllegalStateException("No destination file in command line.");
        }
        this.destFileName = val[0];
    }

    private boolean checkState() {
        if (this.command != 'x' && this.command != 'p' && this.command != 'h') {
            System.out.println("Wrong command " + this.command);
            return false;
        }
        if (this.command == 'x') {
            if (this.endDate == null && this.startDate == null && this.filterFileName == null) {
                System.out.println("Selected extraction withouth criteria");
                System.out.println("Please, set start date and/or end date and/or a filter file name");
                return false;
            }
            if (this.filterFileName != null) {
                if (this.filterFileName.length() == 0) {
                    System.out.println("Invalid empty name for the filter");
                    return false;
                }
                File filterFile = new File(this.filterFileName);
                if (!filterFile.exists()) {
                    System.err.println(this.filterFileName + " does not exist!");
                    return false;
                }
                if (!filterFile.canRead()) {
                    System.out.println(this.filterFileName + " is unreadable");
                    return false;
                }
            }
            if (this.minutes != null || this.num != null) {
                System.out.println("Warning: minutes and number of logs are ignored while eXtracting");
            }
        } else if (this.command == 'p') {
            if (this.num == null && this.minutes == null) {
                System.out.println("Splitting selected without criteria");
                System.out.println("Please, set the number of log or the time");
                return false;
            }
            if (this.num != null && this.minutes != null) {
                System.out.println("Set only one between number of logs and time to sPlit");
                return false;
            }
            if (this.startDate != null || this.endDate != null || this.filterFileName != null) {
                System.out.println("Warning: start date, end date and the filter are ignored while sPlitting");
            }
        }
        if (this.sourceFileNames != null) {
            for (String fileName : this.sourceFileNames) {
                if (fileName == null || fileName.isEmpty()) {
                    System.out.println("Invalid source file name: " + fileName);
                    return false;
                }
                File inF = new File(fileName);
                if (!inF.exists()) {
                    System.err.println(fileName + " does not exist!");
                    return false;
                }
                if (inF.canRead()) continue;
                System.out.println(fileName + " is unreadable");
                return false;
            }
        }
        return true;
    }

    private Date getDate(String date) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(TIME_FORMAT);
        return df.parse(date);
    }

    private void extractLogs() throws Exception {
        LogFileExtractor extractor = new LogFileExtractor(this.sourceFileNames, this.destFileName, this.startDate, this.endDate, this.filterFileName, this.converter);
        extractor.extract();
    }

    private void splitFile() throws Exception {
        LogFileSplitter fileSplitter = new LogFileSplitter(this.sourceFileNames, this.destFileName, this.num, this.minutes, this.converter);
        fileSplitter.split();
    }

    private static void usage(String prgName) {
        System.out.println("USAGE: " + prgName + " command command_params [options] -dest <FileName> [-src <FileName> <FileName> ....]");
        System.out.println("command:");
        System.out.println("\t-extract|-x: extract logs depending on the command_params criteria");
        System.out.println("\tcommand_params for extraction (applied as AND):");
        System.out.println("\t\t-start|-s <start_date>: selects all the logs generated after the given date");
        System.out.println("\t\t-end|-e <end_date>: selects all the logs generated before the given date");
        System.out.println("\t\t-filter|-f <filter.xml>: selects all the logs that matches the filters specified in filter.xml");
        System.out.println("\t-split|-p: split the source file depending on the command params criteria");
        System.out.println("\tcommand_params for splitting:");
        System.out.println("\t\t-time|-t <min>: split by time in minutes");
        System.out.println("\t\t-num|-n  <num>: split by number of logs");
        System.out.println("\t-help|-h: print this help\n");
        System.out.println("options:");
        System.out.println("\t-xml: write the output as XML (default)");
        System.out.println("\t-csv: write the output as CSV");
        System.out.println("\t-txt: write the output as plain ASCII text");
        System.out.println("\t-twiki: write the output as Twiki table");
        System.out.println("\t-col|-l columns: select the columns to write in the csv (not supported by XML)");
        System.out.println("-dest <filename>: the name of the destionation file.");
        System.out.println("-src <filename>...: the name of the source files.");
        System.out.println("                    Can be omitted if log files are provided on stdin.");
        System.out.println("\nSee ACS manual for further details.\n");
    }

    public static void main(String[] args) {
        LogAssistant assistant = null;
        try {
            assistant = new LogAssistant(args);
        }
        catch (IllegalStateException ex) {
            System.err.println("Error in the parameters: " + ex.getMessage());
            LogAssistant.usage("acsLogAssistant");
            return;
        }
        if (assistant.command == 'h') {
            LogAssistant.usage("acsLogAssistant");
            return;
        }
        try {
            assistant.work();
        }
        catch (Throwable t) {
            System.err.println("Exception working on logs: " + t.getMessage());
            t.printStackTrace(System.err);
        }
    }
}

