/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs.main;

import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.settings.LogTypeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class LogToolBar
extends JToolBar {
    private JComboBox logLevelCB;
    private JComboBox discardLevelCB;
    private JButton pauseBtn;
    private boolean pauseBtnPaused;
    private ImageIcon pauseIcon;
    private ImageIcon playIcon;
    public static final String pauseStr = "<HTML><FONT size=-2>Pause</FONT>";
    public static final String playStr = "<HTML><FONT size=-2>Play</FONT>";
    private JButton clearLogsBtn;
    private JButton filtersBtn;
    private Boolean filtersBtnEnabledOverwrite = null;
    private JButton zoomBtn;
    private LogTypeHelper initialDiscardLevel;
    private LogTypeHelper initialLogLevel;

    public LogToolBar(LogTypeHelper initialLogLvl, LogTypeHelper intialDiscardLvl) {
        if (initialLogLvl == null) {
            throw new IllegalArgumentException("The initial log level can't be null");
        }
        this.setName("LogToolBar");
        this.initialLogLevel = initialLogLvl;
        this.initialDiscardLevel = intialDiscardLvl;
        this.setupToolBar();
    }

    private void setupToolBar() {
        this.setFloatable(true);
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new BorderLayout());
        JPanel userPanel = new JPanel();
        FlowLayout tbFlowL = new FlowLayout(0);
        tbFlowL.setHgap(10);
        userPanel.setLayout(tbFlowL);
        FlowLayout lyLevel = new FlowLayout();
        lyLevel.setHgap(2);
        JPanel tbLevelPanel = new JPanel(lyLevel);
        JLabel logLevelLbl = new JLabel("<HTML><FONT size=-2>Log level: </FONT></HTML>");
        tbLevelPanel.add(logLevelLbl);
        tbLevelPanel.add(this.getLogLevelCB());
        JLabel discardLevelLbl = new JLabel("<HTML><FONT size=-2>Discard level: </FONT></HTML>");
        tbLevelPanel.add(discardLevelLbl);
        tbLevelPanel.add(this.getDiscardLevelCB());
        tbLevelPanel.add(this.getPauseBtn());
        tbLevelPanel.add(this.getClearLogsBtn());
        tbLevelPanel.add(this.getFiltersBtn());
        tbLevelPanel.add(this.getZoomBtn());
        userPanel.add(tbLevelPanel);
        toolBarPanel.add((Component)userPanel, "West");
        Dimension d = this.discardLevelCB.getPreferredSize();
        d.height = this.pauseBtn.getPreferredSize().height;
        this.discardLevelCB.setPreferredSize(d);
        d = this.logLevelCB.getPreferredSize();
        d.height = this.pauseBtn.getPreferredSize().height;
        this.logLevelCB.setPreferredSize(d);
        this.add(toolBarPanel);
    }

    public void setEventHandler(ActionListener listener) {
        this.clearLogsBtn.addActionListener(listener);
        this.logLevelCB.addActionListener(listener);
        this.discardLevelCB.addActionListener(listener);
        this.pauseBtn.addActionListener(listener);
        this.filtersBtn.addActionListener(listener);
        this.zoomBtn.addActionListener(listener);
    }

    public JComboBox getDiscardLevelCB() {
        if (this.discardLevelCB == null) {
            LogTypeRenderer discardRendererCB = new LogTypeRenderer();
            String[] discardLevelStr = new String[LogTypeHelper.values().length + 1];
            discardLevelStr[0] = "None";
            int t = 0;
            for (LogTypeHelper logType : LogTypeHelper.values()) {
                discardLevelStr[++t] = logType.logEntryType;
            }
            this.discardLevelCB = new JComboBox<String>(discardLevelStr);
            this.discardLevelCB.setMaximumRowCount(discardLevelStr.length);
            if (this.initialDiscardLevel == null) {
                this.discardLevelCB.setSelectedIndex(0);
            } else {
                this.discardLevelCB.setSelectedIndex(this.initialDiscardLevel.ordinal() + 1);
            }
            this.discardLevelCB.setEditable(false);
            this.discardLevelCB.setRenderer(discardRendererCB);
        }
        return this.discardLevelCB;
    }

    public JComboBox getLogLevelCB() {
        if (this.logLevelCB == null) {
            LogTypeHelper[] types = LogTypeHelper.values();
            boolean t = false;
            this.logLevelCB = new JComboBox<LogTypeHelper>(types);
            LogTypeRenderer rendererCB = new LogTypeRenderer();
            this.logLevelCB.setSelectedItem(this.initialLogLevel);
            this.logLevelCB.setEditable(false);
            this.logLevelCB.setMaximumRowCount(LogTypeHelper.values().length);
            this.logLevelCB.setRenderer(rendererCB);
        }
        return this.logLevelCB;
    }

    public JButton getClearLogsBtn() {
        if (this.clearLogsBtn == null) {
            ImageIcon iconClear = new ImageIcon(LogTypeHelper.class.getResource("/delete.png"));
            this.clearLogsBtn = new JButton("<HTML><FONT size=-2>Clear logs</FONT>", iconClear);
        }
        return this.clearLogsBtn;
    }

    public JButton getPauseBtn() {
        if (this.pauseBtn == null) {
            this.pauseIcon = new ImageIcon(LogTypeHelper.class.getResource("/pause.png"));
            this.playIcon = new ImageIcon(LogTypeHelper.class.getResource("/play.png"));
            this.pauseBtn = new JButton(pauseStr, this.pauseIcon);
            this.pauseBtnPaused = false;
        }
        return this.pauseBtn;
    }

    public JButton getFiltersBtn() {
        if (this.filtersBtn == null) {
            ImageIcon filterIcon = new ImageIcon(LogTypeHelper.class.getResource("/filters.png"));
            this.filtersBtn = new JButton("<HTML><FONT size=-2>Filters</HTML>", filterIcon);
        }
        return this.filtersBtn;
    }

    public JButton getZoomBtn() {
        if (this.zoomBtn == null) {
            ImageIcon zoomIcon = new ImageIcon(LogTypeHelper.class.getResource("/zoom.png"));
            this.zoomBtn = new JButton("<HTML><FONT size=-2>Drill down</HTML>", zoomIcon);
        }
        return this.zoomBtn;
    }

    public boolean clickPauseBtn() {
        boolean bl = this.pauseBtnPaused = !this.pauseBtnPaused;
        if (this.pauseBtnPaused) {
            this.getPauseBtn().setIcon(this.playIcon);
            this.getPauseBtn().setText(playStr);
        } else {
            this.getPauseBtn().setIcon(this.pauseIcon);
            this.getPauseBtn().setText(pauseStr);
        }
        return this.pauseBtnPaused;
    }

    public boolean pause() {
        boolean ret = this.pauseBtnPaused;
        this.pauseBtnPaused = true;
        this.getPauseBtn().setIcon(this.playIcon);
        this.getPauseBtn().setText(playStr);
        return ret;
    }

    public boolean unpause() {
        boolean ret = this.pauseBtnPaused;
        this.pauseBtnPaused = false;
        this.getPauseBtn().setIcon(this.pauseIcon);
        this.getPauseBtn().setText(pauseStr);
        return ret;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getLogLevelCB().setEnabled(enabled);
        this.pauseBtn.setEnabled(enabled);
        this.clearLogsBtn.setEnabled(enabled);
        boolean filtersBtnEnabled = this.filtersBtnEnabledOverwrite != null ? this.filtersBtnEnabledOverwrite : enabled;
        this.filtersBtn.setEnabled(filtersBtnEnabled);
        this.getDiscardLevelCB().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void enableFiltersButtonOverwrite(Boolean enable) {
        this.filtersBtnEnabledOverwrite = enable;
    }

    public boolean isPaused() {
        return this.pauseBtnPaused;
    }

    public void setZoomable(boolean zoomable) {
        this.zoomBtn.setEnabled(zoomable);
    }
}

