/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.types.XSAnyURI;
import org.exolab.castor.builder.types.XSBase64Binary;
import org.exolab.castor.builder.types.XSBoolean;
import org.exolab.castor.builder.types.XSByte;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSDate;
import org.exolab.castor.builder.types.XSDateTime;
import org.exolab.castor.builder.types.XSDecimal;
import org.exolab.castor.builder.types.XSDouble;
import org.exolab.castor.builder.types.XSDuration;
import org.exolab.castor.builder.types.XSFloat;
import org.exolab.castor.builder.types.XSGDay;
import org.exolab.castor.builder.types.XSGMonth;
import org.exolab.castor.builder.types.XSGMonthDay;
import org.exolab.castor.builder.types.XSGYear;
import org.exolab.castor.builder.types.XSGYearMonth;
import org.exolab.castor.builder.types.XSHexBinary;
import org.exolab.castor.builder.types.XSId;
import org.exolab.castor.builder.types.XSIdRef;
import org.exolab.castor.builder.types.XSIdRefs;
import org.exolab.castor.builder.types.XSInt;
import org.exolab.castor.builder.types.XSInteger;
import org.exolab.castor.builder.types.XSLong;
import org.exolab.castor.builder.types.XSNCName;
import org.exolab.castor.builder.types.XSNMToken;
import org.exolab.castor.builder.types.XSNMTokens;
import org.exolab.castor.builder.types.XSNegativeInteger;
import org.exolab.castor.builder.types.XSNonNegativeInteger;
import org.exolab.castor.builder.types.XSNonPositiveInteger;
import org.exolab.castor.builder.types.XSNormalizedString;
import org.exolab.castor.builder.types.XSPositiveInteger;
import org.exolab.castor.builder.types.XSQName;
import org.exolab.castor.builder.types.XSShort;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSTime;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.builder.types.XSUnsignedByte;
import org.exolab.castor.builder.types.XSUnsignedInt;
import org.exolab.castor.builder.types.XSUnsignedLong;
import org.exolab.castor.builder.types.XSUnsignedShort;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Union;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JType;

public final class TypeConversion {
    private static final Log LOG = LogFactory.getLog(TypeConversion.class);
    private final BuilderConfiguration _config;

    public TypeConversion(BuilderConfiguration config) {
        if (config == null) {
            String error = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(error);
        }
        this._config = config;
    }

    public XSType convertType(SimpleType simpleType, boolean useJava50) {
        return this.convertType(simpleType, null, useJava50);
    }

    public XSType convertType(SimpleType simpleType, String packageName, boolean useJava50) {
        return this.convertType(simpleType, packageName, this._config.usePrimitiveWrapper(), useJava50, null);
    }

    public XSType convertType(SimpleType simpleType, String packageName, boolean useWrapper, boolean useJava50, String javaClassBindingName) {
        SimpleType base;
        if (simpleType == null) {
            return null;
        }
        XSType xsType = null;
        for (base = simpleType; base != null && !base.isBuiltInType(); base = (SimpleType)base.getBaseType()) {
        }
        if (simpleType.getStructureType() == 22) {
            return this.convertUnion(simpleType, packageName, useWrapper, useJava50);
        }
        if (base == null) {
            String className = this._config.getJavaNaming().toJavaClassName(simpleType.getName());
            return new XSClass(new JClass(className));
        }
        xsType = this.findXSTypeForEnumeration(simpleType, packageName, javaClassBindingName);
        if (xsType != null) {
            return xsType;
        }
        switch (base.getTypeCode()) {
            case 25: {
                return new XSId();
            }
            case 26: {
                return new XSIdRef();
            }
            case 27: {
                return new XSIdRefs("vector", useJava50);
            }
            case 30: {
                XSNMToken xsNMToken = new XSNMToken();
                xsNMToken.setFacets(simpleType);
                return xsNMToken;
            }
            case 31: {
                return new XSNMTokens("vector", useJava50);
            }
            case 17: {
                return new XSAnyURI();
            }
            case 12: {
                return new XSBase64Binary(useJava50);
            }
            case 13: {
                return new XSHexBinary(useJava50);
            }
            case 11: {
                return new XSBoolean(useWrapper);
            }
            case 38: {
                XSByte xsByte = new XSByte(useWrapper);
                if (!simpleType.isBuiltInType()) {
                    xsByte.setFacets(simpleType);
                }
                return xsByte;
            }
            case 5: {
                XSDate xsDate = new XSDate();
                if (!simpleType.isBuiltInType()) {
                    xsDate.setFacets(simpleType);
                }
                return xsDate;
            }
            case 3: {
                XSDateTime xsDateTime = new XSDateTime();
                if (!simpleType.isBuiltInType()) {
                    xsDateTime.setFacets(simpleType);
                }
                return xsDateTime;
            }
            case 15: {
                XSDouble xsDouble = new XSDouble(useWrapper);
                if (!simpleType.isBuiltInType()) {
                    xsDouble.setFacets(simpleType);
                }
                return xsDouble;
            }
            case 2: {
                XSDuration xsDuration = new XSDuration();
                if (!simpleType.isBuiltInType()) {
                    xsDuration.setFacets(simpleType);
                }
                return xsDuration;
            }
            case 16: {
                XSDecimal xsDecimal = new XSDecimal();
                if (!simpleType.isBuiltInType()) {
                    xsDecimal.setFacets(simpleType);
                }
                return xsDecimal;
            }
            case 14: {
                XSFloat xsFloat = new XSFloat(useWrapper);
                if (!simpleType.isBuiltInType()) {
                    xsFloat.setFacets(simpleType);
                }
                return xsFloat;
            }
            case 9: {
                XSGDay xsGDay = new XSGDay();
                if (!simpleType.isBuiltInType()) {
                    xsGDay.setFacets(simpleType);
                }
                return xsGDay;
            }
            case 8: {
                XSGMonthDay xsGMonthDay = new XSGMonthDay();
                if (!simpleType.isBuiltInType()) {
                    xsGMonthDay.setFacets(simpleType);
                }
                return xsGMonthDay;
            }
            case 10: {
                XSGMonth xsGMonth = new XSGMonth();
                if (!simpleType.isBuiltInType()) {
                    xsGMonth.setFacets(simpleType);
                }
                return xsGMonth;
            }
            case 6: {
                XSGYearMonth xsGYearMonth = new XSGYearMonth();
                if (!simpleType.isBuiltInType()) {
                    xsGYearMonth.setFacets(simpleType);
                }
                return xsGYearMonth;
            }
            case 7: {
                XSGYear xsGYear = new XSGYear();
                if (!simpleType.isBuiltInType()) {
                    xsGYear.setFacets(simpleType);
                }
                return xsGYear;
            }
            case 32: {
                XSInteger xsInteger = new XSInteger(useWrapper);
                if (!simpleType.isBuiltInType()) {
                    xsInteger.setFacets(simpleType);
                }
                return xsInteger;
            }
            case 36: {
                XSInt xsInt = new XSInt(useWrapper);
                if (!simpleType.isBuiltInType()) {
                    xsInt.setFacets(simpleType);
                }
                return xsInt;
            }
            case 22: {
                LOG.warn((Object)("Warning: Currently, the W3C datatype '" + simpleType.getName() + "' is supported only as a String by Castor Source Generator."));
                return new XSString();
            }
            case 35: {
                XSLong xsLong = new XSLong(useWrapper);
                if (!simpleType.isBuiltInType()) {
                    xsLong.setFacets(simpleType);
                }
                return xsLong;
            }
            case 24: {
                return new XSNCName();
            }
            case 33: {
                XSNonPositiveInteger xsNPInteger = new XSNonPositiveInteger(useWrapper);
                xsNPInteger.setFacets(simpleType);
                return xsNPInteger;
            }
            case 39: {
                XSNonNegativeInteger xsNNInteger = new XSNonNegativeInteger(useWrapper);
                xsNNInteger.setFacets(simpleType);
                return xsNNInteger;
            }
            case 34: {
                XSNegativeInteger xsNInteger = new XSNegativeInteger(useWrapper);
                xsNInteger.setFacets(simpleType);
                return xsNInteger;
            }
            case 41: {
                XSUnsignedInt xsUnsignedInt = new XSUnsignedInt(useWrapper);
                xsUnsignedInt.setFacets(simpleType);
                return xsUnsignedInt;
            }
            case 42: {
                XSUnsignedShort xsUnsignedShort = new XSUnsignedShort(useWrapper);
                xsUnsignedShort.setFacets(simpleType);
                return xsUnsignedShort;
            }
            case 43: {
                XSUnsignedByte xsUnsignedByte = new XSUnsignedByte(useWrapper);
                xsUnsignedByte.setFacets(simpleType);
                return xsUnsignedByte;
            }
            case 40: {
                XSUnsignedLong xsUnsignedLong = new XSUnsignedLong();
                xsUnsignedLong.setFacets(simpleType);
                return xsUnsignedLong;
            }
            case 20: {
                XSNormalizedString xsNormalString = new XSNormalizedString();
                if (!simpleType.isBuiltInType()) {
                    xsNormalString.setFacets(simpleType);
                }
                return xsNormalString;
            }
            case 44: {
                XSPositiveInteger xsPInteger = new XSPositiveInteger(useWrapper);
                xsPInteger.setFacets(simpleType);
                return xsPInteger;
            }
            case 18: {
                XSQName xsQName = new XSQName();
                xsQName.setFacets(simpleType);
                return xsQName;
            }
            case 1: {
                xsType = this.findXSTypeForEnumeration(simpleType, packageName, javaClassBindingName);
                if (xsType != null) break;
                XSString xsString = new XSString();
                if (!simpleType.isBuiltInType()) {
                    xsString.setFacets(simpleType);
                }
                xsType = xsString;
                break;
            }
            case 37: {
                XSShort xsShort = new XSShort(useWrapper);
                if (!simpleType.isBuiltInType()) {
                    xsShort.setFacets(simpleType);
                }
                return xsShort;
            }
            case 4: {
                XSTime xsTime = new XSTime();
                if (!simpleType.isBuiltInType()) {
                    xsTime.setFacets(simpleType);
                }
                return xsTime;
            }
            case 21: {
                LOG.warn((Object)"Warning: Currently, the W3C datatype 'token' is supported only as a String by Castor Source Generator.");
                XSString xsString = new XSString();
                if (!simpleType.isBuiltInType()) {
                    xsString.setFacets(simpleType);
                }
                return xsString;
            }
            default: {
                String name = simpleType.getName();
                if (name == null || name.length() == 0) {
                    name = simpleType.getBuiltInBaseType().getName();
                }
                LOG.warn((Object)("Warning: The W3C datatype '" + name + "' is not currently supported by Castor Source Generator."));
                String className = this._config.getJavaNaming().toJavaClassName(name);
                xsType = new XSClass(new JClass(className));
            }
        }
        return xsType;
    }

    private XSType convertUnion(SimpleType simpleType, String packageName, boolean useWrapper, boolean useJava50) {
        SimpleType currentUnion = simpleType;
        SimpleType common = TypeConversion.findCommonType((Union)currentUnion);
        while (common == null && currentUnion.getBaseType() != null && currentUnion.getBaseType().getStructureType() == 22) {
            currentUnion = (SimpleType)currentUnion.getBaseType();
            common = TypeConversion.findCommonType((Union)currentUnion);
        }
        if (common == null) {
            return new XSClass(SGTypes.OBJECT);
        }
        XSType convertedType = this.convertType(common, packageName, useWrapper, useJava50, null);
        Union unionType = (Union)simpleType;
        Enumeration<SimpleType> memberTypes = unionType.getMemberTypes();
        while (memberTypes.hasMoreElements()) {
            SimpleType memberType = memberTypes.nextElement();
            convertedType.setFacets(memberType);
        }
        return convertedType;
    }

    public static XSType convertType(String javaType) {
        if (javaType == null) {
            return null;
        }
        if (javaType.equals(TypeNames.BOOLEAN_OBJECT)) {
            return new XSBoolean(true);
        }
        if (javaType.equals(TypeNames.BOOLEAN_PRIMITIVE)) {
            return new XSBoolean(false);
        }
        if (javaType.equals(TypeNames.BYTE_OBJECT)) {
            return new XSByte(true);
        }
        if (javaType.equals(TypeNames.BYTE_PRIMITIVE)) {
            return new XSBoolean(false);
        }
        if (javaType.equals("org.exolab.castor.types.Date")) {
            return new XSDateTime();
        }
        if (javaType.equals("org.exolab.castor.types.Duration")) {
            return new XSDuration();
        }
        if (javaType.equals("org.exolab.castor.types.GDay")) {
            return new XSGDay();
        }
        if (javaType.equals("org.exolab.castor.types.GMonth")) {
            return new XSGMonth();
        }
        if (javaType.equals("org.exolab.castor.types.GMonthDay")) {
            return new XSGMonthDay();
        }
        if (javaType.equals("org.exolab.castor.types.GYear")) {
            return new XSGYear();
        }
        if (javaType.equals("org.exolab.castor.types.GYearMonth")) {
            return new XSGYearMonth();
        }
        if (javaType.equals("org.exolab.castor.types.Time")) {
            return new XSTime();
        }
        if (javaType.equals("java.util.Date")) {
            return new XSDate();
        }
        if (javaType.equals("java.math.BigDecimal")) {
            return new XSDecimal();
        }
        if (javaType.equals(TypeNames.DOUBLE_OBJECT)) {
            return new XSDouble(true);
        }
        if (javaType.equals(TypeNames.DOUBLE_PRIMITIVE)) {
            return new XSDouble(false);
        }
        if (javaType.equals(TypeNames.FLOAT_OBJECT)) {
            return new XSFloat(true);
        }
        if (javaType.equals(TypeNames.FLOAT_PRIMITIVE)) {
            return new XSDouble(false);
        }
        if (javaType.equals(TypeNames.INTEGER)) {
            return new XSInteger(true);
        }
        if (javaType.equals(TypeNames.INT)) {
            return new XSInt();
        }
        if (javaType.equals(TypeNames.SHORT_OBJECT)) {
            return new XSShort(true);
        }
        if (javaType.equals(TypeNames.SHORT_PRIMITIVE)) {
            return new XSShort(false);
        }
        if (javaType.equals("java.lang.String")) {
            return new XSString();
        }
        return new XSClass(new JClass(javaType));
    }

    private XSType findXSTypeForEnumeration(SimpleType simpleType, String packageName, String javaClassBindingName) {
        if (!simpleType.hasFacet("enumeration")) {
            return null;
        }
        XSClass xsType = null;
        Object typeName = simpleType.getName();
        if (!(typeName != null || javaClassBindingName == null || JNaming.isInJavaLang(javaClassBindingName) || JNaming.isReservedByCastor(javaClassBindingName) || JNaming.isReservedByWindows(javaClassBindingName))) {
            typeName = javaClassBindingName;
        }
        if (typeName == null) {
            Structure parent = simpleType.getParent();
            if (parent instanceof ElementDecl) {
                typeName = ((ElementDecl)parent).getName();
            } else if (parent instanceof AttributeDecl) {
                typeName = ((AttributeDecl)parent).getName();
            }
            typeName = (String)typeName + "Type";
        }
        Object className = this._config.getJavaNaming().toJavaClassName((String)typeName);
        Object typePackageName = packageName;
        if (typePackageName == null) {
            String ns = simpleType.getSchema().getTargetNamespace();
            typePackageName = this._config.lookupPackageByNamespace(ns);
        }
        typePackageName = typePackageName != null && ((String)typePackageName).length() > 0 ? (String)typePackageName + ".types" : "types";
        className = (String)typePackageName + "." + (String)className;
        xsType = new XSClass(new JClass((String)className));
        xsType.setAsEnumerated(true);
        return xsType;
    }

    private static SimpleType findCommonType(Union union) {
        SimpleType common = null;
        Enumeration<SimpleType> enumeration = union.getMemberTypes();
        while (enumeration.hasMoreElements()) {
            SimpleType type = enumeration.nextElement();
            type = type.getBuiltInBaseType();
            if (common == null) {
                common = type;
                continue;
            }
            if ((common = TypeConversion.findCommonType(common, type)) != null) continue;
            break;
        }
        return common;
    }

    private static SimpleType findCommonType(SimpleType aType, SimpleType bType) {
        int type2;
        int type1 = aType.getTypeCode();
        if (type1 == (type2 = bType.getTypeCode())) {
            return aType;
        }
        if (TypeConversion.isNumeric(aType) && TypeConversion.isNumeric(bType) || !TypeConversion.isString(aType) || TypeConversion.isString(bType)) {
            // empty if block
        }
        Schema schema = aType.getSchema();
        return schema.getSimpleType("string", schema.getSchemaNamespace());
    }

    private static boolean isNumeric(SimpleType type) {
        int code = type.getTypeCode();
        switch (code) {
            case 14: 
            case 15: 
            case 16: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    private static boolean isString(SimpleType type) {
        int code = type.getTypeCode();
        switch (code) {
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    protected static class TypeNames {
        protected static final String BOOLEAN_PRIMITIVE = JType.BOOLEAN.getName();
        protected static final String BOOLEAN_OBJECT = JType.BOOLEAN.getWrapperName();
        protected static final String BYTE_PRIMITIVE = JType.BYTE.getName();
        protected static final String BYTE_OBJECT = JType.BYTE.getWrapperName();
        protected static final String DATE = "java.util.Date";
        protected static final String CASTOR_DATE = "org.exolab.castor.types.Date";
        protected static final String CASTOR_TIME = "org.exolab.castor.types.Time";
        protected static final String CASTOR_DURATION = "org.exolab.castor.types.Duration";
        protected static final String CASTOR_GMONTH = "org.exolab.castor.types.GMonth";
        protected static final String CASTOR_GMONTHDAY = "org.exolab.castor.types.GMonthDay";
        protected static final String CASTOR_GYEAR = "org.exolab.castor.types.GYear";
        protected static final String CASTOR_GYEARMONTH = "org.exolab.castor.types.GYearMonth";
        protected static final String CASTOR_GDAY = "org.exolab.castor.types.GDay";
        protected static final String DECIMAL = "java.math.BigDecimal";
        protected static final String DOUBLE_PRIMITIVE = JType.DOUBLE.getName();
        protected static final String DOUBLE_OBJECT = JType.DOUBLE.getWrapperName();
        protected static final String FLOAT_PRIMITIVE = JType.FLOAT.getName();
        protected static final String FLOAT_OBJECT = JType.FLOAT.getWrapperName();
        protected static final String INT = JType.INT.getName();
        protected static final String INTEGER = JType.INT.getWrapperName();
        protected static final String SHORT_PRIMITIVE = JType.SHORT.getName();
        protected static final String SHORT_OBJECT = JType.SHORT.getWrapperName();
        protected static final String STRING = "java.lang.String";

        protected TypeNames() {
        }
    }
}

