/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.monitoring;

import alma.acs.util.StringOutputStream;
import java.io.PrintStream;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.management.openmbean.CompositeData;

public class RemoteThreadsUtil {
    public static ThreadInfo[] toThreadsInfo(CompositeData[] data) {
        ThreadInfo[] info = new ThreadInfo[data.length];
        for (int i = 0; i != data.length; ++i) {
            info[i] = ThreadInfo.from(data[i]);
        }
        return info;
    }

    public static String printThreadsInfo(ThreadInfo[] info, boolean grouped) {
        StringOutputStream stringOS = new StringOutputStream();
        PrintStream printer = new PrintStream(stringOS);
        RemoteThreadsUtil.printThreadsInfo(info, printer, grouped);
        printer.flush();
        return stringOS.toString();
    }

    public static void printThreadsInfo(ThreadInfo[] info, PrintStream printer, boolean grouped) {
        ArrayList<Data> threadStats = new ArrayList<Data>(info.length);
        printer.printf("%-50s%-15s", "Class name", "State");
        if (grouped) {
            printer.printf("%-5s", "#");
        }
        printer.print("\n==========                                        =====");
        if (grouped) {
            printer.print("          =");
        }
        printer.println();
        for (int i = 0; i != info.length; ++i) {
            StackTraceElement[] elements = info[i].getStackTrace();
            int idx = elements.length - 1;
            if (idx <= 1) continue;
            String className = elements[idx].getClassName();
            if (className.equals("java.lang.Thread")) {
                className = elements[--idx].getClassName();
            }
            if (!grouped) {
                printer.printf("%-50s%-15s\n", new Object[]{elements[idx].getClassName(), info[i].getThreadState()});
                continue;
            }
            boolean found = false;
            Data threadEntry = new Data(className, info[i].getThreadState(), 1);
            for (Data candidate : threadStats) {
                if (!threadEntry.equals(candidate)) continue;
                candidate.bumpCount();
                found = true;
                break;
            }
            if (found) continue;
            threadStats.add(threadEntry);
        }
        if (grouped) {
            Collections.sort(threadStats);
            Iterator iterator = threadStats.iterator();
            while (iterator.hasNext()) {
                if (iterator == null) continue;
                Data dat = (Data)iterator.next();
                printer.printf("%-50s%-15s%d\n", new Object[]{dat.getName(), dat.getState(), dat.getCount()});
            }
        }
    }

    private static class Data
    implements Comparable<Data> {
        private String name;
        private Thread.State state;
        private int count;

        public Data(String name, Thread.State state, int count) {
            this.name = name;
            this.state = state;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public void bumpCount() {
            ++this.count;
        }

        public String getName() {
            return this.name;
        }

        public Thread.State getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Data)) {
                return false;
            }
            Data test = (Data)o;
            return this.name.equals(test.getName()) && this.state.equals((Object)test.getState());
        }

        @Override
        public int compareTo(Data o) {
            if (o == null) {
                throw new NullPointerException();
            }
            int nameResult = o.getName().compareTo(this.getName());
            if (nameResult == 0) {
                return o.getState().compareTo(this.getState());
            }
            return nameResult;
        }
    }
}

