/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.classloading;

import alma.acs.makesupport.AcsJarFileFinder;
import java.io.File;
import java.lang.ref.Cleaner;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AcsComponentClassLoader
extends URLClassLoader {
    public static final String PROPERTY_JARDIRS = "acs.components.classpath.jardirs";
    public static final String PROPERTY_CLASSLOADERVERBOSE = "acs.components.classloader.verbose";
    private boolean verbose = Boolean.getBoolean("acs.components.classloader.verbose");
    private final Logger logger;
    private final String componentName;
    private static final Cleaner cleaner = Cleaner.create();

    protected static void doCleanUp(Logger logger, String componentName, boolean verbose) {
        if (verbose) {
            logger.finer("Class loader for component '" + componentName + "' about to be finalized.");
        }
    }

    public AcsComponentClassLoader(ClassLoader parent, Logger logger, String componentName) {
        super(new URL[0], parent);
        this.logger = logger;
        this.componentName = componentName;
        String jarDirPath = System.getProperty(PROPERTY_JARDIRS);
        if (this.verbose) {
            logger.fine("Property 'acs.components.classpath.jardirs' is set to " + jarDirPath);
        }
        File[] jarDirs = this.parseJarDirs(jarDirPath);
        AcsJarFileFinder jarFinder = new AcsJarFileFinder(jarDirs, null);
        jarFinder.setVerbose(this.verbose);
        File[] allJars = jarFinder.getAllFiles();
        for (int i = 0; i < allJars.length; ++i) {
            try {
                this.addURL(allJars[i].toURI().toURL());
                if (!this.verbose) continue;
                logger.finer("added " + allJars[i].getAbsolutePath() + " to the path of the component classloader for " + componentName);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "failed to add " + allJars[i].getAbsolutePath() + " to the path of the component classloader for " + componentName, e);
            }
        }
        cleaner.register(this, () -> AcsComponentClassLoader.doCleanUp(logger, componentName, this.verbose));
    }

    private File[] parseJarDirs(String jarDirPath) {
        StringTokenizer tok = new StringTokenizer(jarDirPath, File.pathSeparator);
        File[] jarDirs = new File[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            jarDirs[i] = new File(tok.nextToken());
            if (this.verbose) {
                this.logger.finer("Classloader for component '" + this.componentName + "' will look for jar files in directory " + jarDirs[i].getAbsolutePath());
            }
            ++i;
        }
        return jarDirs;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) {
                if (this.verbose) {
                    this.logger.finer("AcsComponentClassLoader will delegate loading '" + name + "' to parent CL, a " + this.getParent().getClass().getName());
                }
                c = super.loadClass(name, false);
            }
        } else if (this.verbose) {
            this.logger.finer("Class '" + name + "' already loaded by AcsComponentClassLoader for '" + this.componentName + "'. Nothing to do.");
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = super.findClass(name);
        if (this.verbose) {
            this.logger.finer("Class loader for component '" + this.componentName + "' loaded class " + name);
        }
        return clazz;
    }

    public String getSourceObject() {
        return this.componentName;
    }

    public String getProcessName() {
        String NS_CORBA = "alma.acs.corba";
        String NS_CONTAINER = "alma.acs.container";
        String NS_COMPONENT = "alma.component";
        String loggerName = this.logger.getName();
        if (loggerName != null) {
            try {
                if (loggerName.startsWith(NS_COMPONENT)) {
                    loggerName = loggerName.substring(NS_COMPONENT.length() + 1);
                } else if (loggerName.startsWith(NS_CONTAINER)) {
                    loggerName = loggerName.substring(NS_CONTAINER.length() + 1);
                } else if (loggerName.startsWith(NS_CORBA)) {
                    loggerName = loggerName.substring(NS_CORBA.length() + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return loggerName;
    }
}

