/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.model;

import alma.sourcecat.model.NamesComparator;
import alma.sourcecat.model.SourceName;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Measurement {
    private static final Log LOG = LogFactory.getLog(Measurement.class);
    @JsonView(value={FluxHistoryView.class})
    private int id;
    private String fakeId;
    private int catalogueId;
    private int sourceId;
    @JsonView(value={CommonView.class})
    private double ra;
    @JsonView(value={DownloadView.class})
    private String raUncertainty;
    @JsonView(value={CommonView.class})
    private double dec;
    @JsonView(value={DownloadView.class})
    private String decUncertainty;
    @JsonView(value={CommonView.class})
    private double frequency;
    @JsonView(value={CommonView.class})
    private double flux;
    @JsonView(value={DownloadView.class})
    private Double uvMin;
    @JsonView(value={DownloadView.class})
    private Double uvMax;
    @JsonView(value={CommonView.class})
    private String fluxUncertainty;
    private String degree;
    private String degreeUncertainty;
    private String angle;
    private String angleUncertainty;
    private String origin;
    @JsonView(value={CommonView.class})
    private Date dateObserved;
    private boolean valid;
    @JsonView(value={DownloadView.class})
    private Set<SourceName> names = new TreeSet<SourceName>(new NamesComparator());
    private List<Integer> types = new LinkedList<Integer>();
    @JsonView(value={DownloadView.class})
    private Double separationInDegrees;
    @JsonView(value={DownloadView.class})
    private String bandName;
    private String catalogueName;
    @JsonView(value={DownloadView.class})
    private Double sourceRaDeg;
    @JsonView(value={DownloadView.class})
    private Double sourceRaDegUncertainty;
    @JsonView(value={DownloadView.class})
    private Double sourceDecDeg;
    @JsonView(value={DownloadView.class})
    private Double sourceDecDegUncertainty;
    @JsonView(value={DownloadView.class})
    private Double spectralIndex;
    private String updateUser;
    private Date updateDate;
    private String updateComment;

    public static List<Measurement> convertResponse(Object[] xmlrpcResponse) throws IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> convertResponse");
        }
        LinkedList<Measurement> result = new LinkedList<Measurement>();
        for (Object o : xmlrpcResponse) {
            if (!(o instanceof Map)) continue;
            result.add(new Measurement((Map)o));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- convertResponse");
        }
        return result;
    }

    public static List<Measurement> convertResponse(Object xmlrpcResponse) throws IllegalArgumentException {
        return Measurement.convertResponse((Object[])xmlrpcResponse);
    }

    private Measurement(Map<?, ?> m) {
        Object distance;
        Object uvmax;
        Object uvmin;
        Object id = m.get("measurement_id");
        if (id == null || !(id instanceof Integer)) {
            throw new IllegalArgumentException("measurement_id");
        }
        this.id = (Integer)id;
        Object catalogueId = m.get("catalogue_id");
        if (catalogueId == null || !(catalogueId instanceof Integer)) {
            throw new IllegalArgumentException("catalogue_id");
        }
        this.catalogueId = (Integer)catalogueId;
        Object sourceId = m.get("source_id");
        if (sourceId == null || !(sourceId instanceof Integer)) {
            throw new IllegalArgumentException("source_id");
        }
        this.sourceId = (Integer)sourceId;
        Object ra = m.get("ra");
        if (ra == null || !(ra instanceof Double)) {
            throw new IllegalArgumentException("ra");
        }
        this.ra = (Double)ra;
        Object raUncertainty = m.get("ra_uncertainty");
        this.raUncertainty = (String)raUncertainty;
        Object dec = m.get("dec");
        if (dec == null || !(dec instanceof Double)) {
            throw new IllegalArgumentException("dec");
        }
        this.dec = (Double)dec;
        Object decUncertainty = m.get("dec_uncertainty");
        this.decUncertainty = (String)decUncertainty;
        Object frequency = m.get("frequency");
        if (frequency == null || !(frequency instanceof Double)) {
            throw new IllegalArgumentException("frequency");
        }
        this.frequency = (Double)frequency;
        Object flux = m.get("flux");
        if (flux == null || !(flux instanceof Double)) {
            throw new IllegalArgumentException("flux");
        }
        this.flux = (Double)flux;
        Object bandName = m.get("band_name");
        if (bandName != null && bandName instanceof String) {
            this.bandName = (String)bandName;
        }
        if ((uvmin = m.get("uvmin")) != null && uvmin instanceof Double) {
            this.uvMin = (Double)uvmin;
        }
        if ((uvmax = m.get("uvmax")) != null && uvmax instanceof Double) {
            this.uvMax = (Double)uvmax;
        }
        if ((distance = m.get("separation")) != null && distance instanceof Double) {
            this.separationInDegrees = (Double)distance;
        }
        Object fluxUncertainty = m.get("flux_uncertainty");
        this.fluxUncertainty = (String)fluxUncertainty;
        Object degree = m.get("degree");
        this.degree = this.convertToPercentage((String)degree);
        Object degreeUncertainty = m.get("degree_uncertainty");
        this.degreeUncertainty = this.convertToPercentage((String)degreeUncertainty);
        Object angle = m.get("angle");
        this.angle = (String)angle;
        Object angleUncertainty = m.get("angle_uncertainty");
        this.angleUncertainty = (String)angleUncertainty;
        Object origin = m.get("origin");
        this.origin = (String)origin;
        Object dateObserved = m.get("date_observed");
        if (dateObserved == null || !(dateObserved instanceof Date)) {
            throw new IllegalArgumentException("date_observed");
        }
        this.dateObserved = (Date)dateObserved;
        Object valid = m.get("valid");
        if (valid == null || !(valid instanceof Boolean)) {
            throw new IllegalArgumentException("valid");
        }
        this.valid = (Boolean)valid;
        Object[] names = this.convertToObjectArray(m.get("names"));
        if (names != null) {
            for (SourceName s : SourceName.convertResponse(names)) {
                this.names.add(s);
            }
        } else {
            throw new IllegalArgumentException("names");
        }
        Object[] types = this.convertToObjectArray(m.get("types"));
        if (types != null) {
            for (Object type : types) {
                if (!(type instanceof Integer)) {
                    LOG.error((Object)("Got a type: " + String.valueOf(type)));
                    throw new IllegalArgumentException("types");
                }
                this.types.add((Integer)type);
            }
        } else {
            throw new IllegalArgumentException("types");
        }
    }

    public Double getSeparationInDegrees() {
        return this.separationInDegrees;
    }

    public void setSeparationInDegrees(Double distance) {
        this.separationInDegrees = distance;
    }

    private Object[] convertToObjectArray(Object params) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"-> convertToObjectArray");
        }
        Object[] arrayOfParams = null;
        if (params instanceof Object[]) {
            arrayOfParams = (Object[])params;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"<- convertToObjectArray");
        }
        return arrayOfParams;
    }

    public Measurement(int id, int catalogueId, int sourceId, double ra, String raUncertainty, double dec, String decUncertainty, double frequency, double flux, String fluxUncertainty, String degree, String degreeUncertainty, String angle, String angleUncertainty, String origin, Date dateObserved, boolean valid, Double sourceRaDeg, Double sourceRaDegUncertainty, Double sourceDecDeg, Double sourceDecDegUncertainty) {
        this.id = id;
        this.catalogueId = catalogueId;
        this.sourceId = sourceId;
        this.ra = ra;
        this.raUncertainty = raUncertainty;
        this.dec = dec;
        this.decUncertainty = decUncertainty;
        this.frequency = frequency;
        this.flux = flux;
        this.fluxUncertainty = fluxUncertainty;
        this.degree = this.convertToPercentage(degree);
        this.degreeUncertainty = this.convertToPercentage(degreeUncertainty);
        this.angle = angle;
        this.angleUncertainty = angleUncertainty;
        this.origin = origin;
        this.dateObserved = dateObserved;
        this.valid = valid;
        this.sourceRaDeg = sourceRaDeg;
        this.sourceRaDegUncertainty = sourceRaDegUncertainty;
        this.sourceDecDeg = sourceDecDeg;
        this.sourceDecDegUncertainty = sourceDecDegUncertainty;
    }

    public Measurement() {
    }

    private String convertToPercentage(String value) {
        if (value == null) {
            return "";
        }
        double v = 0.0;
        try {
            v = Double.parseDouble(value);
            return Double.toString(v * 100.0);
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
    }

    public void addName(SourceName name) {
        this.names.add(name);
    }

    public void addTypeId(int typeId) {
        this.types.add(typeId);
    }

    public int getId() {
        return this.id;
    }

    public int getCatalogueId() {
        return this.catalogueId;
    }

    public void setCatalogueId(Integer catalogueId) {
        this.catalogueId = catalogueId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public double getRa() {
        return this.ra;
    }

    public String getRaUncertainty() {
        return this.raUncertainty;
    }

    public void setRaUncertainty(String raUncertainty) {
        this.raUncertainty = raUncertainty;
    }

    public double getDec() {
        return this.dec;
    }

    public String getDecUncertainty() {
        return this.decUncertainty;
    }

    public void setDecUncertainty(String decUncertainty) {
        this.decUncertainty = decUncertainty;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    public double getFlux() {
        return this.flux;
    }

    public String getFluxUncertainty() {
        return this.fluxUncertainty;
    }

    public void setFluxUncertainty(String fluxUncertainty) {
        this.fluxUncertainty = fluxUncertainty;
    }

    public static Double parseStringToDouble(String value) {
        double v = 0.0;
        if (value != null) {
            try {
                v = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e, (Throwable)e);
            }
        }
        return v;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        try {
            this.degree = degree == null || degree.isEmpty() ? degree : Double.toString(Double.valueOf(degree) / 100.0);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("parameter \"" + degree + "\""), (Throwable)e);
        }
    }

    public String getDegreeUncertainty() {
        return this.degreeUncertainty;
    }

    public void setDegreeUncertainty(String degreeUncertainty) {
        this.degreeUncertainty = degreeUncertainty == null || degreeUncertainty.isEmpty() ? degreeUncertainty : Double.toString(Double.valueOf(degreeUncertainty) / 100.0);
    }

    public String getAngle() {
        return this.angle;
    }

    public void setAngle(String angle) {
        this.angle = angle;
    }

    public String getAngleUncertainty() {
        return this.angleUncertainty;
    }

    public void setAngleUncertainty(String angleUncertainty) {
        this.angleUncertainty = angleUncertainty;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public Date getDateObserved() {
        return this.dateObserved;
    }

    public void setDateObserved(Date date) {
        this.dateObserved = date;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<SourceName> getNames() {
        return new ArrayList<SourceName>(this.names);
    }

    public List<Integer> getTypes() {
        return this.types;
    }

    public Double getUvMin() {
        return this.uvMin;
    }

    public String toString() {
        return "Measurement [id=" + this.id + ", fakeId=" + this.fakeId + ", catalogueId=" + this.catalogueId + ", sourceId=" + this.sourceId + ", ra=" + this.ra + ", raUncertainty=" + this.raUncertainty + ", dec=" + this.dec + ", decUncertainty=" + this.decUncertainty + ", frequency=" + this.frequency + ", flux=" + this.flux + ", uvMin=" + this.uvMin + ", uvMax=" + this.uvMax + ", fluxUncertainty=" + this.fluxUncertainty + ", degree=" + this.degree + ", degreeUncertainty=" + this.degreeUncertainty + ", angle=" + this.angle + ", angleUncertainty=" + this.angleUncertainty + ", origin=" + this.origin + ", dateObserved=" + String.valueOf(this.dateObserved) + ", valid=" + this.valid + ", names=" + String.valueOf(this.names) + ", types=" + String.valueOf(this.types) + ", separationInDegrees=" + this.separationInDegrees + ", bandName=" + this.bandName + ", catalogueName=" + this.catalogueName + ", sourceRaDeg=" + this.sourceRaDeg + ", sourceRaDegUncertainty=" + this.sourceRaDegUncertainty + ", sourceDecDeg=" + this.sourceDecDeg + ", sourceDecDegUncertainty=" + this.sourceDecDegUncertainty + "]";
    }

    public Double getUvMax() {
        return this.uvMax;
    }

    public void setUvMin(Double uvmin) {
        this.uvMin = uvmin;
    }

    public void setUvMax(Double uvmax) {
        this.uvMax = uvmax;
    }

    public String getBandName() {
        return this.bandName;
    }

    public void setBandName(String bandName) {
        this.bandName = bandName;
        this.fakeId = String.valueOf(this.id) + "-" + bandName;
    }

    public void setRa(double ra) {
        this.ra = ra;
    }

    public void setDec(double dec) {
        this.dec = dec;
    }

    public void setFlux(double flux) {
        this.flux = flux;
    }

    public String getCatalogueName() {
        return this.catalogueName;
    }

    public void setCatalogueName(String catalogueName) {
        this.catalogueName = catalogueName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Double getSourceRaDeg() {
        return this.sourceRaDeg;
    }

    public void setSourceRaDeg(Double sourceRaDeg) {
        this.sourceRaDeg = sourceRaDeg;
    }

    public Double getSourceRaDegUncertainty() {
        return this.sourceRaDegUncertainty;
    }

    public void setSourceRaDegUncertainty(Double sourceRaDegUncertainty) {
        this.sourceRaDegUncertainty = sourceRaDegUncertainty;
    }

    public Double getSourceDecDeg() {
        return this.sourceDecDeg;
    }

    public void setSourceDecDeg(Double sourceDecDeg) {
        this.sourceDecDeg = sourceDecDeg;
    }

    public Double getSourceDecDegUncertainty() {
        return this.sourceDecDegUncertainty;
    }

    public void setSourceDecDegUncertainty(Double sourceDecDegUncertainty) {
        this.sourceDecDegUncertainty = sourceDecDegUncertainty;
    }

    public Double getSpectralIndex() {
        return this.spectralIndex;
    }

    public void setSpectralIndex(Double spectralIndex) {
        this.spectralIndex = spectralIndex;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getUpdateComment() {
        return this.updateComment;
    }

    public void setUpdateComment(String updateComment) {
        this.updateComment = updateComment;
    }

    public void setValid(boolean isValid) {
        this.valid = isValid;
    }

    public String getFakeId() {
        return this.fakeId;
    }

    @Deprecated
    public String getFluxratio() {
        return null;
    }

    @Deprecated
    public Double getExtension() {
        return -1.0;
    }

    public static interface DownloadView
    extends CommonView {
    }

    public static interface FluxHistoryView
    extends CommonView {
    }

    private static interface CommonView {
    }
}

