/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.OnceRowPipe;
import uk.ac.starlink.table.RowPipe;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;

public abstract class StreamTableSink
implements TableSink {
    private RowPipe rowPipe_;
    private Thread writerThread_;
    private Throwable writerError_;

    protected abstract void scanTable(StarTable var1) throws IOException;

    public void acceptMetadata(StarTable meta) throws TableFormatException {
        StarTable outTable;
        this.rowPipe_ = new OnceRowPipe();
        this.rowPipe_.acceptMetadata(meta);
        try {
            outTable = this.rowPipe_.waitForStarTable();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.writerThread_ = new Thread("Table Writer"){

            public void run() {
                try {
                    StreamTableSink.this.scanTable(outTable);
                }
                catch (Throwable e) {
                    StreamTableSink.this.writerError_ = e;
                }
            }
        };
        this.writerThread_.start();
    }

    public void acceptRow(Object[] row) throws IOException {
        this.rowPipe_.acceptRow(row);
    }

    public void endRows() throws IOException {
        this.rowPipe_.endRows();
        try {
            this.writerThread_.join();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
        if (this.writerError_ != null) {
            throw (IOException)new IOException("Write error: " + this.writerError_.getMessage()).initCause(this.writerError_);
        }
    }
}

