/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.ACS.ComponentStates;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.component.ComponentStateManager;
import java.util.logging.Logger;

public class ComponentStateManagerImpl
implements ComponentStateManager {
    private ComponentStates m_currentState;
    private Logger m_logger;
    private String m_componentName;

    public ComponentStateManagerImpl(String componentName, Logger logger) {
        this.m_componentName = componentName;
        this.m_logger = logger;
        this.m_currentState = ComponentStates.COMPSTATE_NEW;
    }

    @Override
    public synchronized ComponentStates getCurrentState() {
        return this.m_currentState;
    }

    @Override
    public String getName(ComponentStates corbaStateObj) {
        switch (corbaStateObj.value()) {
            case 0: {
                return "NEW";
            }
            case 1: {
                return "INITIALIZING";
            }
            case 2: {
                return "INITIALIZED";
            }
            case 3: {
                return "OPERATIONAL";
            }
            case 4: {
                return "ERROR";
            }
            case 5: {
                return "DESTROYING";
            }
            case 6: {
                return "ABORTING";
            }
            case 7: {
                return "DEFUNCT";
            }
        }
        this.m_logger.warning("unknown component state " + corbaStateObj.value() + "encountered - need to update " + this.getClass().getName());
        return "unknown";
    }

    @Override
    public synchronized void setState(ComponentStates newState) throws ComponentLifecycleException {
        if (newState == this.getCurrentState()) {
            this.m_logger.fine("ignoring no-op transition from and to " + this.getName(newState));
        } else {
            this.m_logger.finer("switching state of component " + this.m_componentName + " from " + this.getName(this.m_currentState) + " to " + this.getName(newState));
            this.m_currentState = newState;
        }
    }

    synchronized void setStateByContainer(ComponentStates newState) throws ComponentLifecycleException {
        this.setState(newState);
    }
}

