/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatamodelInstanceChecker
extends DefaultHandler {
    public final Supplier<? extends IOException> dataModelNotFoundException = () -> new IOException("Unable to find data model version");
    public final Supplier<? extends IOException> revisionNumberNotFoundException = () -> new IOException("Unable to find revision number");
    private static final String UNDEFINED = "-1";
    private String datamodelVersion;
    private String schemaVersion;
    private String revision;

    public String getRevision() {
        return this.revision;
    }

    public ModelVersioning getDatamodelVersion(StringReader stringReader) {
        Object object;
        DatamodelInstanceChecker datamodelInstanceChecker = this;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            this.datamodelVersion = UNDEFINED;
            this.schemaVersion = UNDEFINED;
            this.revision = UNDEFINED;
            object = sAXParserFactory.newSAXParser();
            ((SAXParser)object).parse(new InputSource(stringReader), (DefaultHandler)datamodelInstanceChecker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        stringReader.close();
        if (this.schemaVersion != UNDEFINED) {
            this.datamodelVersion = this.schemaVersion;
        }
        object = new ModelVersioning();
        ((ModelVersioning)object).setDatamodelVersion(this.datamodelVersion);
        ((ModelVersioning)object).setSchemaVersion(this.schemaVersion);
        ((ModelVersioning)object).setRevision(this.revision);
        return object;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        int n;
        String string5 = string2;
        if ("".equals(string5)) {
            string5 = string3;
        }
        if (string5.endsWith("ObsProject") && attributes != null) {
            for (n = 0; n < attributes.getLength(); ++n) {
                string4 = attributes.getLocalName(n);
                if ("".equals(string4)) {
                    string4 = attributes.getQName(n);
                }
                if (!string4.equals("revision")) continue;
                this.revision = attributes.getValue(n);
            }
        }
        if (string5.endsWith("Entity") && attributes != null) {
            for (n = 0; n < attributes.getLength(); ++n) {
                string4 = attributes.getLocalName(n);
                if ("".equals(string4)) {
                    string4 = attributes.getQName(n);
                }
                if (string4.equals("datamodelVersion")) {
                    this.datamodelVersion = attributes.getValue(n);
                }
                if (!string4.equals("schemaVersion")) continue;
                this.schemaVersion = attributes.getValue(n);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
    }

    public static class ModelVersioning {
        private Optional<String> datamodelVersion;
        private Optional<String> schemaVersion;
        private Optional<String> revision;

        public Optional<String> getDatamodelVersion() {
            return this.datamodelVersion;
        }

        public void setDatamodelVersion(String string) {
            this.datamodelVersion = string.equals(DatamodelInstanceChecker.UNDEFINED) ? Optional.empty() : Optional.of(string);
        }

        public Optional<String> getSchemaVersion() {
            return this.schemaVersion;
        }

        public void setSchemaVersion(String string) {
            this.schemaVersion = string.equals(DatamodelInstanceChecker.UNDEFINED) ? Optional.empty() : Optional.of(string);
        }

        public Optional<String> getRevision() {
            return this.revision;
        }

        public void setRevision(String string) {
            this.revision = string.equals(DatamodelInstanceChecker.UNDEFINED) ? Optional.empty() : Optional.of(string);
        }
    }
}

