/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.losolutions.LOSolutionException;
import alma.obsprep.services.losolutions.LOToolEditor;
import alma.obsprep.services.losolutions.LOToolHelper;
import alma.obsprep.services.losolutions.LOToolParameters;
import alma.obsprep.services.losolutions.LOToolTuningParametersModel;
import alma.obsprep.services.losolutions.wrappers.BasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.DSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandPreferenceWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandSelectWrapper;
import alma.obsprep.services.losolutions.wrappers.TuningParametersWrapper;
import alma.valuetypes.Frequency;
import javax.swing.table.AbstractTableModel;

public class LOToolModel
extends Model {
    private final SSBbasebandSpecTableModel ssbTableModel = new SSBbasebandSpecTableModel();
    private final DSBbasebandSpecTableModel dsbTableModel = new DSBbasebandSpecTableModel();
    private final ValueUnitPairModel lo1Model = new ValueUnitPairModel();
    private final LOToolTuningParametersModel resultsModel;
    private final LOToolHelper helper;

    public LOToolModel(Object object2) {
        super(object2);
        this.registerSubModel(this.lo1Model);
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            if (this.isDSB()) {
                this.dsbTableModel.updateIF();
                this.dsbTableModel.fireTableDataChanged();
            } else {
                this.ssbTableModel.updateIF();
                this.ssbTableModel.fireTableDataChanged();
            }
        };
        this.lo1Model.subscribe(modelChangeSubscriber);
        this.resultsModel = new LOToolTuningParametersModel(null);
        this.registerSubModel(this.resultsModel);
        this.helper = new LOToolHelper();
    }

    public LOToolParameters getLOToolParameters() {
        return (LOToolParameters)this.getDocument();
    }

    public SSBbasebandSpecTableModel getSSBTableModel() {
        return this.ssbTableModel;
    }

    public DSBbasebandSpecTableModel getDSBTableModel() {
        return this.dsbTableModel;
    }

    public ValueUnitPairModel getLO1Model() {
        return this.lo1Model;
    }

    public LOToolTuningParametersModel getTuningParametersModel() {
        return this.resultsModel;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            LOToolParameters lOToolParameters = this.getLOToolParameters();
            this.publish(LOToolEditor.RECEIVERTYPE_FID, lOToolParameters.isDsbReceiver());
            ReceiverBand receiverBand = lOToolParameters.getRxb();
            String string = receiverBand.equals(ReceiverBand.ILLEGAL_RECEIVER) ? "Unspecified" : Integer.toString(receiverBand.getNumber());
            this.publish(LOToolEditor.RECEIVERBAND_FID, string);
        }
        this.publish(LOToolEditor.HARDWAREINFO_FID, this.helper.getHardwareInfo());
        this.ssbTableModel.fireTableDataChanged();
        this.dsbTableModel.fireTableDataChanged();
        this.lo1Model.publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == LOToolEditor.RECEIVERTYPE_FID) {
            LOToolEditor.ReceiverType receiverType = LOToolEditor.ReceiverType.getItem((String)object);
            this.getLOToolParameters().setDsbReceiver(receiverType.isDsb);
            if (receiverType.isDsb) {
                this.getLOToolParameters().setRxb(ReceiverBand.ILLEGAL_RECEIVER);
                this.publish();
            }
            this.ssbTableModel.fireTableDataChanged();
            this.dsbTableModel.fireTableDataChanged();
            return object;
        }
        if (fieldID == LOToolEditor.ADDBUTTON_FID) {
            LOToolEditor lOToolEditor = (LOToolEditor)editor;
            int n = lOToolEditor.getSelectedRow();
            this.getLOToolParameters().addNewBasebandParameters(n + 1);
            if (this.isDSB()) {
                this.dsbTableModel.fireTableRowsInserted(n + 1, n + 1);
            } else {
                this.ssbTableModel.fireTableRowsInserted(n + 1, n + 1);
            }
            return object;
        }
        if (fieldID == LOToolEditor.DELETEBUTTON_FID) {
            LOToolEditor lOToolEditor = (LOToolEditor)editor;
            int n = lOToolEditor.getSelectedRow();
            if (n != -1) {
                this.getLOToolParameters().removeBasebandParameters(n);
                if (this.isDSB()) {
                    this.dsbTableModel.fireTableRowsDeleted(n, n);
                } else {
                    this.ssbTableModel.fireTableRowsDeleted(n, n);
                }
            }
            return object;
        }
        if (fieldID == LOToolEditor.CALCBUTTON_FID) {
            try {
                TuningParametersWrapper tuningParametersWrapper = this.helper.computeSolutions(this.getLOToolParameters().getRxb());
                this.resultsModel.setDocument(tuningParametersWrapper);
                this.publish(LOToolEditor.FEEDBACK_FID, "");
            }
            catch (LOSolutionException lOSolutionException) {
                this.publish(LOToolEditor.FEEDBACK_FID, lOSolutionException.getMessage());
            }
        } else if (fieldID == LOToolEditor.REQUESTLO1_FID) {
            if (!((Boolean)object).booleanValue()) {
                this.getLOToolParameters().clearLO1();
                this.getLO1Model().publish();
            }
        } else if (fieldID == LOToolEditor.RECEIVERBAND_FID) {
            String string = (String)object;
            if (string.equals("Unspecified")) {
                this.getLOToolParameters().setRxb(ReceiverBand.ILLEGAL_RECEIVER);
            } else {
                this.getLOToolParameters().setRxb(ReceiverBand.getReceiverBand(Integer.valueOf(string)));
            }
        }
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.helper.setParameters((LOToolParameters)object);
        if (object != null) {
            LOToolParameters lOToolParameters = this.getLOToolParameters();
            this.lo1Model.setDocument((Object)lOToolParameters.getRequestedLO1());
        }
        this.publish();
    }

    private boolean isDSB() {
        boolean bl = false;
        if (this.getLOToolParameters() != null) {
            bl = this.getLOToolParameters().isDsbReceiver();
        }
        return bl;
    }

    private boolean isLO1Requested() {
        boolean bl = false;
        if (this.getLOToolParameters() != null) {
            bl = this.getLOToolParameters().getRequestedLO1().getContentInGHz() > 1.0;
        }
        return bl;
    }

    class DSBbasebandSpecTableModel
    extends AbstractTableModel {
        private final int SIDEBANDSELECT_COLINDEX = DSBbasebandSpecTableColumnDescriptor.SIDEBANDSELECT.ordinal();

        DSBbasebandSpecTableModel() {
        }

        @Override
        public int getColumnCount() {
            return DSBbasebandSpecTableColumnDescriptor.values().length;
        }

        @Override
        public int getRowCount() {
            LOToolParameters lOToolParameters = LOToolModel.this.getLOToolParameters();
            return lOToolParameters == null ? 0 : lOToolParameters.getBasebandParametersCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            LOToolParameters lOToolParameters = LOToolModel.this.getLOToolParameters();
            if (lOToolParameters == null) {
                return null;
            }
            DSBbasebandSpecWrapper dSBbasebandSpecWrapper = (DSBbasebandSpecWrapper)lOToolParameters.getBasebandParameters(n);
            SidebandSelectWrapper sidebandSelectWrapper = null;
            BasebandSpecWrapper basebandSpecWrapper = null;
            if (n2 != this.SIDEBANDSELECT_COLINDEX) {
                sidebandSelectWrapper = (SidebandSelectWrapper)((Object)this.getValueAt(n, this.SIDEBANDSELECT_COLINDEX));
                basebandSpecWrapper = dSBbasebandSpecWrapper.getPrimarySpec();
            }
            DSBbasebandSpecTableColumnDescriptor dSBbasebandSpecTableColumnDescriptor = DSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n2);
            switch (dSBbasebandSpecTableColumnDescriptor) {
                case SIDEBANDSELECT: {
                    return dSBbasebandSpecWrapper.getSidebandSelect();
                }
                case SKY_FREQUENCY_1: {
                    return basebandSpecWrapper.getSkyFrequency();
                }
                case WEIGHT_1: {
                    return basebandSpecWrapper.getWeight();
                }
                case IF_FREQUENCY_1: {
                    return basebandSpecWrapper.getIfFrequency();
                }
            }
            if (sidebandSelectWrapper != SidebandSelectWrapper.Both) {
                return null;
            }
            BasebandSpecWrapper basebandSpecWrapper2 = dSBbasebandSpecWrapper.getSubSpec();
            switch (dSBbasebandSpecTableColumnDescriptor) {
                case SKY_FREQUENCY_2: {
                    return basebandSpecWrapper2.getSkyFrequency();
                }
                case WEIGHT_2: {
                    return basebandSpecWrapper2.getWeight();
                }
                case IF_FREQUENCY_2: {
                    return basebandSpecWrapper2.getIfFrequency();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                return;
            }
            LOToolParameters lOToolParameters = LOToolModel.this.getLOToolParameters();
            if (lOToolParameters == null) {
                return;
            }
            DSBbasebandSpecWrapper dSBbasebandSpecWrapper = (DSBbasebandSpecWrapper)lOToolParameters.getBasebandParameters(n);
            BasebandSpecWrapper basebandSpecWrapper = dSBbasebandSpecWrapper.getPrimarySpec();
            BasebandSpecWrapper basebandSpecWrapper2 = dSBbasebandSpecWrapper.getSubSpec();
            DSBbasebandSpecTableColumnDescriptor dSBbasebandSpecTableColumnDescriptor = DSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n2);
            SidebandSelectWrapper sidebandSelectWrapper = null;
            if (n2 != this.SIDEBANDSELECT_COLINDEX) {
                sidebandSelectWrapper = (SidebandSelectWrapper)((Object)this.getValueAt(n, this.SIDEBANDSELECT_COLINDEX));
            }
            Frequency frequency = null;
            switch (dSBbasebandSpecTableColumnDescriptor) {
                case SIDEBANDSELECT: {
                    dSBbasebandSpecWrapper.setSidebandSelect((SidebandSelectWrapper)((Object)object));
                    return;
                }
                case SKY_FREQUENCY_1: {
                    frequency = (Frequency)((Object)object);
                    basebandSpecWrapper.getSkyFrequency().setContent(frequency.getContent());
                    basebandSpecWrapper.getSkyFrequency().setUnit(frequency.getUnit());
                    if (sidebandSelectWrapper == SidebandSelectWrapper.Either) {
                        basebandSpecWrapper2.getSkyFrequency().setContent(frequency.getContent());
                        basebandSpecWrapper2.getSkyFrequency().setUnit(frequency.getUnit());
                    }
                    this.updatePrimIF(n);
                    return;
                }
                case WEIGHT_1: {
                    double d = (Double)object;
                    basebandSpecWrapper.setWeight(d);
                    if (sidebandSelectWrapper == SidebandSelectWrapper.Either) {
                        basebandSpecWrapper2.setWeight(d);
                    }
                    return;
                }
                case IF_FREQUENCY_1: {
                    frequency = (Frequency)((Object)object);
                    basebandSpecWrapper.getIfFrequency().setContent(frequency.getContent());
                    basebandSpecWrapper.getIfFrequency().setUnit(frequency.getUnit());
                    if (sidebandSelectWrapper == SidebandSelectWrapper.Either) {
                        basebandSpecWrapper2.getIfFrequency().setContent(frequency.getContent());
                        basebandSpecWrapper2.getIfFrequency().setUnit(frequency.getUnit());
                    }
                    return;
                }
                case SKY_FREQUENCY_2: {
                    frequency = (Frequency)((Object)object);
                    basebandSpecWrapper2.getSkyFrequency().setContent(frequency.getContent());
                    basebandSpecWrapper2.getSkyFrequency().setUnit(frequency.getUnit());
                    this.updateSubIF(n);
                    return;
                }
                case WEIGHT_2: {
                    double d = (Double)object;
                    basebandSpecWrapper2.setWeight(d);
                    return;
                }
                case IF_FREQUENCY_2: {
                    frequency = (Frequency)((Object)object);
                    basebandSpecWrapper2.getIfFrequency().setContent(frequency.getContent());
                    basebandSpecWrapper2.getIfFrequency().setUnit(frequency.getUnit());
                    return;
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            switch (DSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n2)) {
                case SKY_FREQUENCY_2: 
                case WEIGHT_2: {
                    return this.getValueAt(n, this.SIDEBANDSELECT_COLINDEX) == SidebandSelectWrapper.Both;
                }
                case IF_FREQUENCY_2: {
                    return this.getValueAt(n, this.SIDEBANDSELECT_COLINDEX) == SidebandSelectWrapper.Both && !LOToolModel.this.isLO1Requested();
                }
                case IF_FREQUENCY_1: {
                    return !LOToolModel.this.isLO1Requested();
                }
            }
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return DSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n).getColumnClass();
        }

        @Override
        public String getColumnName(int n) {
            return DSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n).getColumnName();
        }

        public void updateIF() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.updatePrimIF(i);
                this.updateSubIF(i);
            }
        }

        public void updatePrimIF(int n) {
            DSBbasebandSpecWrapper dSBbasebandSpecWrapper = (DSBbasebandSpecWrapper)LOToolModel.this.getLOToolParameters().getBasebandParameters(n);
            Frequency frequency = dSBbasebandSpecWrapper.getPrimarySpec().getSkyFrequency();
            if (LOToolModel.this.isLO1Requested() && frequency.getContentInGHz() > 1.0) {
                Frequency frequency2 = LOToolModel.this.getLOToolParameters().getRequestedLO1();
                this.setValueAt((Object)this.calculateIF(frequency, frequency2), n, DSBbasebandSpecTableColumnDescriptor.IF_FREQUENCY_1.ordinal());
            }
        }

        public void updateSubIF(int n) {
            DSBbasebandSpecWrapper dSBbasebandSpecWrapper = (DSBbasebandSpecWrapper)LOToolModel.this.getLOToolParameters().getBasebandParameters(n);
            Frequency frequency = dSBbasebandSpecWrapper.getSubSpec().getSkyFrequency();
            if (LOToolModel.this.isLO1Requested()) {
                Frequency frequency2 = LOToolModel.this.getLOToolParameters().getRequestedLO1();
                this.setValueAt((Object)this.calculateIF(frequency, frequency2), n, DSBbasebandSpecTableColumnDescriptor.IF_FREQUENCY_2.ordinal());
            }
        }

        private Frequency calculateIF(Frequency frequency, Frequency frequency2) {
            Frequency frequency3 = frequency2.getContentInGHz() > frequency.getContentInGHz() ? (Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency) : (Frequency)frequency.minus((AbstractDoubleWithUnit)frequency2);
            return frequency3;
        }

        public Object[] getLongValues() {
            return new Object[]{SidebandSelectWrapper.Either, Frequency.createFrequencyGHZ(999.99999), 100.0, Frequency.createFrequencyGHZ(10.99999), Frequency.createFrequencyGHZ(999.99999), 100.0, Frequency.createFrequencyGHZ(10.99999)};
        }
    }

    class SSBbasebandSpecTableModel
    extends AbstractTableModel {
        SSBbasebandSpecTableModel() {
        }

        @Override
        public int getColumnCount() {
            return SSBbasebandSpecTableColumnDescriptor.values().length;
        }

        @Override
        public int getRowCount() {
            LOToolParameters lOToolParameters = LOToolModel.this.getLOToolParameters();
            return lOToolParameters == null ? 0 : lOToolParameters.getBasebandParametersCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            LOToolParameters lOToolParameters = LOToolModel.this.getLOToolParameters();
            if (lOToolParameters == null) {
                return null;
            }
            SSBbasebandSpecWrapper sSBbasebandSpecWrapper = (SSBbasebandSpecWrapper)lOToolParameters.getBasebandParameters(n);
            switch (SSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n2)) {
                case SIDEBAND_PREF: {
                    return sSBbasebandSpecWrapper.getSidebandPreference();
                }
                case SKY_FREQUENCY: {
                    return sSBbasebandSpecWrapper.getSkyFrequency();
                }
                case WEIGHT: {
                    return sSBbasebandSpecWrapper.getWeight();
                }
                case IF_FREQUENCY: {
                    return sSBbasebandSpecWrapper.getIfFrequency();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                return;
            }
            LOToolParameters lOToolParameters = LOToolModel.this.getLOToolParameters();
            if (lOToolParameters == null) {
                return;
            }
            SSBbasebandSpecWrapper sSBbasebandSpecWrapper = (SSBbasebandSpecWrapper)lOToolParameters.getBasebandParameters(n);
            Frequency frequency = null;
            switch (SSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n2)) {
                case SIDEBAND_PREF: {
                    sSBbasebandSpecWrapper.setSidebandPreference((SidebandPreferenceWrapper)((Object)object));
                    return;
                }
                case SKY_FREQUENCY: {
                    frequency = (Frequency)((Object)object);
                    sSBbasebandSpecWrapper.getSkyFrequency().setContent(frequency.getContent());
                    sSBbasebandSpecWrapper.getSkyFrequency().setUnit(frequency.getUnit());
                    this.updateIF(n);
                    return;
                }
                case WEIGHT: {
                    sSBbasebandSpecWrapper.setWeight((Double)object);
                    return;
                }
                case IF_FREQUENCY: {
                    frequency = (Frequency)((Object)object);
                    sSBbasebandSpecWrapper.getIfFrequency().setContent(frequency.getContent());
                    sSBbasebandSpecWrapper.getIfFrequency().setUnit(frequency.getUnit());
                    return;
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            switch (SSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n2)) {
                case SIDEBAND_PREF: 
                case SKY_FREQUENCY: 
                case WEIGHT: {
                    return true;
                }
                case IF_FREQUENCY: {
                    return !LOToolModel.this.isLO1Requested();
                }
            }
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return SSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n).getColumnClass();
        }

        @Override
        public String getColumnName(int n) {
            return SSBbasebandSpecTableColumnDescriptor.getColumnDescriptor(n).getColumnName();
        }

        public void updateIF() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.updateIF(i);
            }
        }

        public void updateIF(int n) {
            SSBbasebandSpecWrapper sSBbasebandSpecWrapper = (SSBbasebandSpecWrapper)LOToolModel.this.getLOToolParameters().getBasebandParameters(n);
            Frequency frequency = sSBbasebandSpecWrapper.getSkyFrequency();
            if (LOToolModel.this.isLO1Requested() && frequency.getContentInGHz() > 1.0) {
                Frequency frequency2 = LOToolModel.this.getLOToolParameters().getRequestedLO1();
                Frequency frequency3 = frequency2.getContentInGHz() > frequency.getContentInGHz() ? (Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency) : (Frequency)frequency.minus((AbstractDoubleWithUnit)frequency2);
                this.setValueAt((Object)frequency3, n, SSBbasebandSpecTableColumnDescriptor.IF_FREQUENCY.ordinal());
            }
        }

        public Object[] getLongValues() {
            return new Object[]{SidebandPreferenceWrapper.NoPreference, Frequency.createFrequencyGHZ(999.99999), 100.0, Frequency.createFrequencyGHZ(10.99999)};
        }
    }

    public static enum DSBbasebandSpecTableColumnDescriptor {
        SIDEBANDSELECT("SidebandSelect", SidebandSelectWrapper.class),
        SKY_FREQUENCY_1("Sky Frequency", Frequency.class),
        WEIGHT_1("Weight", Double.class),
        IF_FREQUENCY_1("IF Frequency", Frequency.class),
        SKY_FREQUENCY_2("Sky Frequency", Frequency.class),
        WEIGHT_2("Weight", Double.class),
        IF_FREQUENCY_2("IF Frequency", Frequency.class);

        String columnName;
        Class<?> columnClass;

        static DSBbasebandSpecTableColumnDescriptor getColumnDescriptor(int n) {
            return DSBbasebandSpecTableColumnDescriptor.values()[n];
        }

        private DSBbasebandSpecTableColumnDescriptor(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }

    public static enum SSBbasebandSpecTableColumnDescriptor {
        SIDEBAND_PREF("Sideband Pref", SidebandPreferenceWrapper.class),
        SKY_FREQUENCY("Sky Frequency", Frequency.class),
        WEIGHT("Weight", Double.class),
        IF_FREQUENCY("IF Frequency", Frequency.class);

        String columnName;
        Class<?> columnClass;

        static SSBbasebandSpecTableColumnDescriptor getColumnDescriptor(int n) {
            return SSBbasebandSpecTableColumnDescriptor.values()[n];
        }

        private SSBbasebandSpecTableColumnDescriptor(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

