/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.common.horizonsparser.HorizonParser;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.AbstractTargetParametersData;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameters;
import alma.obsprep.services.experts.MinBoundingBoxExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.targetcreator.ACACustomMosaicPointingCalculator;
import alma.obsprep.services.generator.refactored.targetcreator.FieldSourceWorkerUtils;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class TargetParametersFieldSourceWorker {
    private static final Collection<RequestedArray> arraysForWhichRectanglesAreConvertedToPointingMosaic = List.of(RequestedArray.TWELVE_M, RequestedArray.ACA, RequestedArray.SEVEN_M);

    public static FieldSource getFieldSource(TargetParameters targetParameters, RequestedArray requestedArray, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        TargetParametersFieldSourceWorker.validate(targetParameters);
        FieldSource fieldSource = TargetParametersFieldSourceWorker.setupFieldSource(targetParameters, requestedArray, spectralSpec, sBGenerationContext);
        fieldSource.addReference(FieldSourceWorkerUtils.getAtmosphericReferencePosition(spectralSpec, fieldSource));
        return fieldSource;
    }

    private static void validate(TargetParameters targetParameters) throws WizardSBGenerationException {
        String string = targetParameters.getType();
        if (TargetParameters.TYPE_F_MULTIPLEPOINTS.equals(string)) {
            if (targetParameters.getFieldSinglePointCount() != targetParameters.getFieldCount()) {
                String string2 = "Only SinglePoint is allowed for this field type : " + string;
                throw new WizardSBGenerationException(string2);
            }
            int n = 0;
            String string3 = targetParameters.getSourceName() + "-";
            for (SinglePoint singlePoint : targetParameters.getFieldSinglePoint()) {
                singlePoint.getCentre().setFieldName(string3 + ++n);
            }
        } else if (TargetParameters.TYPE_F_SINGLERECTANGLE.equals(string)) {
            Rectangle rectangle = (Rectangle)((Object)targetParameters.getField(0));
            if (rectangle.getLong().getContentInDefaultUnits() <= 0.0 || rectangle.getShort().getContentInDefaultUnits() <= 0.0 || rectangle.getSpacing().getContentInDefaultUnits() <= 0.0) {
                String string4 = "Mapping rectangle definition is invalid. Check your science goal";
                throw new WizardSBGenerationException(string4);
            }
        } else {
            throw new WizardSBGenerationException("Unknown TargetParameter type : " + string);
        }
    }

    private static FieldSource setupFieldSource(@NonNull TargetParameters targetParameters, RequestedArray requestedArray, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        Object object;
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        FieldSource fieldSource = FieldSource.createFieldSource();
        fieldSource.setName("Primary:");
        fieldSource.setSourceName(targetParameters.gettrueSourceName());
        fieldSource.setTargetParameters(targetParameters);
        Object object2 = targetParameters.gettrueSourceCoordinates();
        if (object2 != null) {
            object = null;
            object = ((SkyCoordinates)object2.deepCopy()).getICRSSkyCoordinates();
            fieldSource.setSourceCoordinates((SkyCoordinates)object);
        }
        if ((object2 = targetParameters.gettruePmRA()) != null) {
            fieldSource.setPMRA((AngularVelocity)object2.deepCopy());
        }
        if ((object2 = targetParameters.gettruePmDec()) != null) {
            fieldSource.setPMDec((AngularVelocity)object2.deepCopy());
        }
        if ((object2 = targetParameters.gettrueParallax()) != null) {
            fieldSource.setParallax((Angle)object2.deepCopy());
        }
        fieldSource.setNonSiderealMotion(targetParameters.gettrueNonSiderealMotion());
        String string = targetParameters.getSolarSystemObject();
        if (string != null) {
            fieldSource.setSolarSystemObject(string);
            if (fieldSource.gettrueSourceName().equals("")) {
                fieldSource.setSourceName(string);
            }
        }
        TargetParametersFieldSourceWorker.setEphemeris(targetParameters, requestedArray, fieldSource);
        object2 = targetParameters.gettrueSourceVelocity();
        if (object2 != null) {
            fieldSource.setSourceVelocity((Velocity)object2.deepCopy());
        }
        if (((Velocity)((Object)(object = fieldSource.getSourceVelocity()))).getReferenceSystem().equals(Velocity.REFERENCESYSTEM_HEL)) {
            ((Velocity)((Object)object)).setReferenceSystem(Velocity.REFERENCESYSTEM_BAR);
        }
        try {
            TargetParametersFieldSourceWorker.setupFieldPattern(targetParameters, fieldSource, requestedArray, spectralSpec, sBGenerationContext);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException("Unable to set up field source : " + incompleteCorrelatorSetupFoundException.getLocalizedMessage());
        }
        return fieldSource;
    }

    private static void setEphemeris(@NonNull TargetParameters targetParameters, @NonNull RequestedArray requestedArray, @NonNull FieldSource fieldSource) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("requestedArray is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        String string = targetParameters.gettrueSourceEphemeris();
        boolean bl = targetParameters.isSun();
        if (string != null && targetParameters.gettrueNonSiderealMotion() && targetParameters.getSolarSystemObject() != null && (targetParameters.getSolarSystemObject().equals(TargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS) || bl)) {
            fieldSource.setSourceEphemeris(string);
            if (bl) {
                fieldSource.initialiseFieldSourceAttributesWithEphemerisData(Optional.of(targetParameters.getSourceName()));
                if (requestedArray.isInterferometeric()) {
                    fieldSource.setSolarSystemObject(AbstractTargetParametersData.SOLARSYSTEMOBJECT_EPHEMERIS);
                }
            } else {
                fieldSource.initialiseFieldSourceAttributesWithEphemerisData(Optional.empty());
            }
            if (fieldSource.gettrueSourceName().equals("")) {
                fieldSource.setSourceName("Ephemeris Object");
            }
        }
    }

    private static void setupFieldPattern(@NonNull TargetParameters targetParameters, @NonNull FieldSource fieldSource, @NonNull RequestedArray requestedArray, @NonNull SpectralSpec spectralSpec, @NonNull SBGenerationContext sBGenerationContext) throws SpectralSpec.IncompleteCorrelatorSetupFoundException {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("requestedArray is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (targetParameters.isEphemerisSource() && !StringUtils.isEmpty((CharSequence)targetParameters.getSourceEphemeris())) {
            try {
                Class<TargetParametersFieldSourceWorker> clazz = TargetParametersFieldSourceWorker.class;
                Log.Logger logger = Log.logger(clazz);
                OTHorizonParser oTHorizonParser = new OTHorizonParser(new OTLoggerAdapter(logger, clazz.getName(), null), targetParameters.getSourceEphemeris());
                assert (oTHorizonParser != null);
                List list = oTHorizonParser.parseEphemeris();
                if (!list.isEmpty()) {
                    HorizonParser.ParsedEphemerisLine parsedEphemerisLine = (HorizonParser.ParsedEphemerisLine)list.get(0);
                    SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
                    skyCoordinates.setLatitude(Latitude.createLatitude((double)parsedEphemerisLine.declination, (String)Latitude.UNIT_RAD));
                    skyCoordinates.setLongitude(Longitude.createLongitude((double)parsedEphemerisLine.rightAscension, (String)Longitude.UNIT_RAD));
                    skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
                    skyCoordinates.setType(SkyCoordinates.TYPE_ABSOLUTE);
                }
            }
            catch (HorizonParser.UnableToParseEphemerisDataException | IOException | NullPointerException throwable) {
                // empty catch block
            }
        }
        if (targetParameters.isPointingPattern()) {
            TargetParametersFieldSourceWorker.configureFieldPatternForPointingPattern(targetParameters, fieldSource, requestedArray, spectralSpec, sBGenerationContext);
        } else if (targetParameters.isRectanglePattern()) {
            TargetParametersFieldSourceWorker.configureFieldPatternForRectanglePattern(targetParameters, fieldSource, requestedArray, spectralSpec, sBGenerationContext);
        }
        if (requestedArray.isTP()) {
            TargetParametersFieldSourceWorker.customiseTPFieldSourceForSolar(targetParameters, spectralSpec, fieldSource, requestedArray);
        }
    }

    private static void customiseTPFieldSourceForSolar(@NonNull TargetParameters targetParameters, @NonNull SpectralSpec spectralSpec, @NonNull FieldSource fieldSource, RequestedArray requestedArray) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        if (!requestedArray.isTP() || !targetParameters.isSun()) {
            return;
        }
        boolean bl = targetParameters.getSolarMapping() != null && targetParameters.getSolarMapping().equals(TargetParameters.SOLARMAPPING_FULLSOLARDISC);
        FillPattern fillPattern = FillPattern.createFillPattern();
        if (bl) {
            Log.logger(TargetParametersFieldSourceWorker.class).fine("Configuring field source in TP SB for full solar disc observing");
            fillPattern.setLatitudeLength(Angle.createAngleArcsec(2400.0));
            fillPattern.setLongitudeLength(Angle.createAngleArcsec(2400.0));
            fillPattern.setScanningCoordinateSystem(FillPattern.SCANNINGCOORDINATESYSTEM_HORIZON);
            fillPattern.setPatternType(FillPattern.PATTERNTYPE_CENTERED);
            ReceiverBand receiverBand = spectralSpec.getReceiverBand();
            OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand solarBand2 = AlmaCapabilities.getInstance().getSolarBands().stream().filter(solarBand -> solarBand.getBand() == receiverBand.getNumber()).findFirst().orElseThrow(WizardSBGenerationException::new);
            fillPattern.setSamplingLength(OTConfigurationHelper.getAngle(solarBand2.getStandardSolarSamplingLength()));
        } else {
            Log.logger(TargetParametersFieldSourceWorker.class).fine("Configuring field source in TP SB for solar disc regional mapping observing");
            fillPattern.setLatitudeLength(Angle.createAngleArcsec(2400.0));
            fillPattern.setLongitudeLength(Angle.createAngleArcsec(2400.0));
            fillPattern.setOrientation(Angle.createAngleDegs(0.0));
            fillPattern.setScanningCoordinateSystem(FillPattern.SCANNINGCOORDINATESYSTEM_HORIZON);
            fillPattern.setPatternType(FillPattern.PATTERNTYPE_CENTERED);
            ReceiverBand receiverBand = spectralSpec.getReceiverBand();
            OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand solarBand3 = AlmaCapabilities.getInstance().getSolarBands().stream().filter(solarBand -> solarBand.getBand() == receiverBand.getNumber()).findFirst().orElseThrow(WizardSBGenerationException::new);
            fillPattern.setSamplingLength(OTConfigurationHelper.getAngle(solarBand3.getStandardSolarSamplingLength()));
        }
        fillPattern.setPatternCenterCoordinates(fieldSource.getFieldPattern().getFieldCenterCoordinates().getOffsetCoordinates(targetParameters.getFieldCenterCoordinates()));
        fieldSource.setFieldPattern((FieldPattern)((Object)fillPattern));
    }

    private static void configureFieldPatternForRectanglePattern(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray, SpectralSpec spectralSpec, @NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
        fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
        TargetParametersFieldSourceWorker.setupRectanglePattern(targetParameters, rectanglePattern, requestedArray, spectralSpec, sBGenerationContext);
        if (arraysForWhichRectanglesAreConvertedToPointingMosaic.contains((Object)requestedArray)) {
            TargetParametersFieldSourceWorker.setupStandardPointingMosaic(targetParameters, fieldSource, requestedArray);
        }
    }

    private static void configureFieldPatternForPointingPattern(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) throws SpectralSpec.IncompleteCorrelatorSetupFoundException {
        boolean bl;
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
        boolean bl2 = bl = RequestedArray.SEVEN_M.equals((Object)requestedArray) && targetParameters.getIsMosaic() && !sBGenerationContext.getGoal().isStandAloneACA();
        if (bl) {
            ACACustomMosaicPointingCalculator.setupMinBoundingBoxACA7mPointingPattern(targetParameters, pointingPattern, spectralSpec);
            pointingPattern.matchSystemToOrigin();
        } else if (RequestedArray.TP.equals((Object)requestedArray)) {
            RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
            fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
            Rectangle rectangle = MinBoundingBoxExpert.getBoundingRectangle(targetParameters);
            assert (rectangle != null);
            Frequency frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
            assert (frequency != null);
            rectangle.setReferenceFrequency(frequency);
            rectangle.setSystemRotationApplied(true);
            TargetParametersFieldSourceWorker.setupRectanglePattern(rectangle, rectanglePattern, RequestedArray.TP, spectralSpec, targetParameters, sBGenerationContext);
        } else {
            TargetParametersFieldSourceWorker.setupPointingPattern(targetParameters, pointingPattern);
            pointingPattern.matchSystemToOrigin();
        }
    }

    private static void setupPointingPattern(@NonNull TargetParameters targetParameters, @NonNull PointingPattern pointingPattern) {
        if (targetParameters == null) {
            throw new NullPointerException("tp is marked non-null but is null");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("pp is marked non-null but is null");
        }
        for (SinglePoint singlePoint : targetParameters.getFieldSinglePoint()) {
            SkyCoordinates skyCoordinates = singlePoint.getCentre().deepCopy();
            if (skyCoordinates.isAbsoluteCoordinates()) {
                skyCoordinates = skyCoordinates.getOffsetCoordinates(targetParameters.getSourceCoordinates());
            }
            pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
        }
        if (pointingPattern != null) {
            pointingPattern.setIsMosaic(targetParameters.getIsMosaic());
        }
    }

    private static void setupRectanglePattern(TargetParameters targetParameters, RectanglePattern rectanglePattern, RequestedArray requestedArray, SpectralSpec spectralSpec, @NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        rectangle.setTargetParameters(targetParameters);
        TargetParametersFieldSourceWorker.setupRectanglePattern(rectangle, rectanglePattern, requestedArray, spectralSpec, targetParameters, sBGenerationContext);
    }

    private static void setupRectanglePattern(Rectangle rectangle, RectanglePattern rectanglePattern, RequestedArray requestedArray, SpectralSpec spectralSpec, TargetParameters targetParameters, SBGenerationContext sBGenerationContext) {
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            TargetParametersFieldSourceWorker.setupTPRectanglePattern(rectangle, rectanglePattern, spectralSpec, targetParameters, sBGenerationContext);
        } else {
            TargetParametersFieldSourceWorker.setupInterferometricRectanglePattern(rectangle, rectanglePattern, spectralSpec, targetParameters);
        }
    }

    private static void setupInterferometricRectanglePattern(Rectangle rectangle, RectanglePattern rectanglePattern, SpectralSpec spectralSpec, TargetParameters targetParameters) {
        SkyCoordinates skyCoordinates = rectangle.getCentre().deepCopy();
        skyCoordinates.setSystem(targetParameters.getSourceCoordinates().getSystem());
        rectanglePattern.setPatternCenterCoordinates(skyCoordinates);
        rectanglePattern.setScanningCoordinateSystem(RectanglePattern.SCANNINGCOORDINATESYSTEM_ICRS);
        rectanglePattern.setOrientation(rectangle.getPALong().deepCopy());
        Angle angle = Angle.createAngle();
        angle.setContentAndUnit(rectangle.getSpacing().getContentInUnits(UserAngle.UNIT_ARCSEC), Angle.UNIT_ARCSEC);
        rectanglePattern.setOrthogonalStep(angle);
        rectanglePattern.getLongitudeLength().setContent(rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLongitudeLength().setUnit(Angle.UNIT_ARCSEC);
        rectanglePattern.getLatitudeLength().setContent(rectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLatitudeLength().setUnit(Angle.UNIT_ARCSEC);
        TargetParametersFieldSourceWorker.performGalacticToICRSRectangleRotation(targetParameters, rectanglePattern, SystemRotationConversion.GalacticToICRS);
    }

    private static void setupTPRectanglePattern(@NonNull Rectangle rectangle, @NonNull RectanglePattern rectanglePattern, @NonNull SpectralSpec spectralSpec, @NonNull TargetParameters targetParameters, SBGenerationContext sBGenerationContext) {
        Frequency frequency;
        if (rectangle == null) {
            throw new NullPointerException("rectangle is marked non-null but is null");
        }
        if (rectanglePattern == null) {
            throw new NullPointerException("rectanglePattern is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        boolean bl = rectangle.isSystemRotationApplied();
        if ((rectangle = rectangle.getTPArrayRectangle(spectralSpec)).getLong().isGreaterThanOrEqualTo((AbstractDoubleWithUnit)rectangle.getShort())) {
            rectanglePattern.setScanDirection(RectanglePattern.SCANDIRECTION_LONGITUDE);
        } else {
            rectanglePattern.setScanDirection(RectanglePattern.SCANDIRECTION_LATITUDE);
        }
        SkyCoordinates skyCoordinates = rectangle.getCentre().deepCopy();
        if (!targetParameters.isPointingPattern()) {
            skyCoordinates.setSystem(targetParameters.getSourceCoordinates().getSystem());
        }
        rectanglePattern.setPatternCenterCoordinates(skyCoordinates);
        rectanglePattern.setScanningCoordinateSystem(RectanglePattern.SCANNINGCOORDINATESYSTEM_ICRS);
        rectanglePattern.setOrientation(rectangle.getPALong().deepCopy());
        try {
            frequency = spectralSpec.getSpectralSpec().getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        UserAngle userAngle = UserAngle.createUserAngle(0.31, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        Angle angle = Angle.createAngle();
        angle.setContentAndUnit(((Angle)userAngle.multiply(1.0)).getArcsec(), Angle.UNIT_ARCSEC);
        rectanglePattern.setOrthogonalStep(angle);
        rectanglePattern.getLongitudeLength().setContent(rectangle.getLong().getArcsec());
        rectanglePattern.getLongitudeLength().setUnit(Angle.UNIT_ARCSEC);
        rectanglePattern.getLatitudeLength().setContent(rectangle.getShort().getArcsec());
        rectanglePattern.getLatitudeLength().setUnit(Angle.UNIT_ARCSEC);
        if (!bl) {
            TargetParametersFieldSourceWorker.performGalacticToICRSRectangleRotation(targetParameters, rectanglePattern, SystemRotationConversion.GalacticToICRS);
        }
    }

    private static void performGalacticToICRSRectangleRotation(@NonNull TargetParameters targetParameters, @NonNull RectanglePattern rectanglePattern, SystemRotationConversion systemRotationConversion) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (rectanglePattern == null) {
            throw new NullPointerException("rectPatt is marked non-null but is null");
        }
        if (!targetParameters.getSourceCoordinates().isGalactic()) {
            return;
        }
        TargetParameters targetParameters2 = TargetParameters.getPointingSourceInICRS(targetParameters);
        SkyCoordinates skyCoordinates = targetParameters2.getSourceCoordinates();
        double d = skyCoordinates.getLongitude().getContentInDeg();
        double d2 = skyCoordinates.getLatitude().getContentInDeg();
        double d3 = rectanglePattern.getOrientation().getContentInUnits(Angle.UNIT_DEG);
        double d4 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(d3, d, d2, systemRotationConversion);
        Log.logger(TargetParametersFieldSourceWorker.class).fine("Rectangle PA in Galactic " + d3 + " converted to " + d4 + " degrees");
        rectanglePattern.setOrientation(Angle.createAngle((double)d4, (String)Angle.UNIT_DEG));
    }

    public static double transformPABetweenCoordinateSystems(double d, double d2, double d3, SystemRotationConversion systemRotationConversion) {
        if (systemRotationConversion.equals((Object)SystemRotationConversion.NoConversionRequired)) {
            return d;
        }
        double d4 = systemRotationConversion.equals((Object)SystemRotationConversion.GalacticToICRS) ? 1.0 : -1.0;
        double d5 = Math.toRadians(192.85948);
        double d6 = Math.toRadians(27.12825);
        double d7 = Math.toRadians(d2);
        double d8 = Math.toRadians(d3);
        double d9 = Math.cos(d6) * Math.sin(d7 - d5);
        double d10 = Math.sin(d6) * Math.cos(d8) - Math.cos(d6) * Math.sin(d8) * Math.cos(d7 - d5);
        double d11 = Math.toDegrees(Math.toRadians(d) + (Math.atan(d10 / d9) - Math.toRadians(90.0)) * d4);
        return d11;
    }

    private static void setupStandardPointingMosaic(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray) {
        RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
        MosaicParameters mosaicParameters = rectanglePattern.getMosaicParameters();
        mosaicParameters.getFrequency().setContentAndUnit((ValueUnitPair)targetParameters.getSingleFrequency());
        mosaicParameters.setAntenna(requestedArray.getAntenna());
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        UserAngle userAngle = rectangle.getSpacing().deepCopy();
        if (!userAngle.inModelUnit()) {
            userAngle.setAntenna(requestedArray.getAntenna());
        }
        mosaicParameters.setSpacing(userAngle.getContentInUnits(Angle.UNIT_ARCSEC));
        mosaicParameters.updateOverlap();
        RectangleMosaic rectangleMosaic = new RectangleMosaic(rectanglePattern, requestedArray.getAntenna()){

            @Override
            public boolean abortsByTooManyPointings() {
                return false;
            }
        };
        PointingPattern pointingPattern = rectangleMosaic.getPointingPattern();
        pointingPattern.setDerivedFromRectangle(true);
        if (pointingPattern != null) {
            pointingPattern.setIsMosaic(true);
        }
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
    }

    public static void main(String[] stringArray) {
        double d = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(100.0, 269.78767782647594, -23.750156939233786, SystemRotationConversion.GalacticToICRS);
        double d2 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(d, 269.78767782647594, -23.750156939233786, SystemRotationConversion.ICRSToGalactic);
        System.out.println(d + " " + d2);
    }

    private TargetParametersFieldSourceWorker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum SystemRotationConversion {
        NoConversionRequired,
        GalacticToICRS,
        ICRSToGalactic;

    }
}

