/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.targetcreator.FieldSourceCreator;
import alma.obsprep.services.generator.refactored.targetcreator.ITargetCreatorHelper;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreatorHelper;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.Optional;
import lombok.NonNull;

public final class TargetCreator {
    public static Target createTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, int n, SBGenerationContext sBGenerationContext) {
        return TargetCreator.createTarget(null, targetWithIntent, spectralSetupParameters, n, sBGenerationContext);
    }

    public static Target createTarget(ScienceGoal scienceGoal, @NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, int n, @NonNull SBGenerationContext sBGenerationContext) {
        boolean bl;
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        RequestedArray requestedArray = sBGenerationContext.getArray();
        ITargetCreatorHelper iTargetCreatorHelper = TargetCreatorHelper.getFactory(requestedArray, targetWithIntent, spectralSetupParameters, n, sBGenerationContext);
        SpectralSpec spectralSpec = iTargetCreatorHelper.getSpectralSpec();
        ObservingParameters observingParameters = iTargetCreatorHelper.getObservingParameters();
        FieldSource fieldSource = FieldSourceCreator.getFieldSource(targetWithIntent, requestedArray, spectralSpec, sBGenerationContext);
        boolean bl2 = bl = ObsType.SCIENCE.equals((Object)targetWithIntent.getObsType()) && observingParameters instanceof ScienceParameters;
        if (bl) {
            TargetCreator.adaptForScienceTarget(scienceGoal, targetWithIntent, spectralSetupParameters, n, sBGenerationContext, requestedArray, spectralSpec, observingParameters, fieldSource);
        }
        return TargetCreator.assembleTarget(fieldSource, spectralSpec, observingParameters, n);
    }

    private static void adaptForScienceTarget(ScienceGoal scienceGoal, TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, int n, SBGenerationContext sBGenerationContext, RequestedArray requestedArray, SpectralSpec spectralSpec, ObservingParameters observingParameters, FieldSource fieldSource) {
        boolean bl;
        ScienceParameters scienceParameters = (ScienceParameters)((Object)observingParameters);
        SchedBlockExpert schedBlockExpert = SchedBlockExpert.getInstance(scienceGoal == null ? spectralSetupParameters.getScienceGoal() : scienceGoal);
        ScienceGoal scienceGoal2 = sBGenerationContext.getGoal();
        assert (scienceGoal2 != null);
        ScienceGoal.ScienceGoalMode scienceGoalMode = null;
        try {
            scienceGoalMode = scienceGoal2.getScienceGoalMode();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException("Unable to determine if SG is standalone ACA");
        }
        assert (scienceGoalMode != null);
        boolean bl2 = sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR);
        boolean bl3 = bl = sBGenerationContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE) && bl2;
        if (RequestedArray.TWELVE_M.equals((Object)requestedArray)) {
            TargetCreator.adaptScienceTargetFor12m(targetWithIntent, sBGenerationContext, requestedArray, spectralSpec, fieldSource, scienceParameters, schedBlockExpert, scienceGoal2);
        } else if (scienceGoalMode.equals((Object)ScienceGoal.ScienceGoalMode.STANDALONEACA)) {
            TargetCreator.adaptScienceTargetForSACA(targetWithIntent, requestedArray, fieldSource, scienceParameters, schedBlockExpert, scienceGoal2);
        } else if (bl) {
            TargetCreator.adaptForSolarTPScienceTarget(scienceParameters);
        } else {
            TargetCreator.adaptScienceTargetForACA(scienceGoal, targetWithIntent, spectralSetupParameters, n, sBGenerationContext, requestedArray, scienceParameters, scienceGoal2);
        }
    }

    private static void adaptForSolarTPScienceTarget(ScienceParameters scienceParameters) {
        IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource((double)AlmaPolicies.getInstance().getItosForSolarSource().getSecs(), (String)IntTimeSource.UNIT_S);
        scienceParameters.setIntegrationTime(intTimeSource);
    }

    private static void adaptScienceTargetForACA(ScienceGoal scienceGoal, TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, int n, SBGenerationContext sBGenerationContext, RequestedArray requestedArray, ScienceParameters scienceParameters, ScienceGoal scienceGoal2) {
        SBGenerationContext sBGenerationContext2 = sBGenerationContext.deepCopy();
        sBGenerationContext2.setArray(RequestedArray.TWELVE_M);
        sBGenerationContext2.setSBType(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
        PerformanceParameters performanceParameters = scienceGoal2.getPerformanceParameters();
        assert (performanceParameters != null);
        Frequency frequency = scienceGoal2.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, scienceGoal2);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            throw new WizardSBGenerationException("Unable to determine the 12m configuration when determining the integration time for the " + requestedArray);
        }
        assert (configuration != null);
        sBGenerationContext2.setConfiguration(configuration);
        boolean bl = scienceGoal.isUsing4bitCorrelatorModes();
        ScienceGoal scienceGoal3 = scienceGoal;
        SpectralSetupParameters spectralSetupParameters2 = spectralSetupParameters;
        if (bl) {
            scienceGoal3 = TargetCreator.create2bitScienceGoal(scienceGoal);
            sBGenerationContext2.setScienceGoal(scienceGoal3);
            spectralSetupParameters2 = scienceGoal3.getSpectralSetupParameters();
            scienceGoal3.setTwoBitRepresentationOfFourBitSG(true);
            spectralSetupParameters2.getRepresentativeSpectralWindow().setSpectralResolution(scienceGoal.getSpectralSetupParameters().getRepresentativeSpectralWindow().getSpectralResolution().deepCopy());
        }
        Target target = TargetCreator.createTarget(scienceGoal3, targetWithIntent, spectralSetupParameters2, n, sBGenerationContext2);
        IntTimeSource intTimeSource = target.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new).getIntegrationTime();
        scienceParameters.setIntegrationTime(intTimeSource.deepCopy());
        if (bl) {
            scienceParameters.setTwoBitTotalTMITOSTime(Optional.of(intTimeSource.deepCopy()));
        }
    }

    private static ScienceGoal create2bitScienceGoal(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoalToClone is marked non-null but is null");
        }
        ScienceGoal scienceGoal2 = scienceGoal.deepCopy();
        for (ScienceSpectralWindow scienceSpectralWindow : scienceGoal2.getSpectralSetupParameters().getAbstractScienceSpectralWindowScienceSpectralWindow()) {
            CorrConfigMode corrConfigMode = scienceSpectralWindow.getCorrConfigMode();
            if (!CorrBits.is4x4(corrConfigMode.getBits())) continue;
            CorrConfigMode corrConfigMode2 = CorrConfigMode.get2bitEquivalentCorrelatorMode(corrConfigMode);
            scienceSpectralWindow.setCorrConfigMode(corrConfigMode2);
            scienceSpectralWindow.getAdvancedWindowSetup().setAddedSensitivity(false);
        }
        return scienceGoal2;
    }

    private static void adaptScienceTargetForSACA(TargetWithIntent targetWithIntent, RequestedArray requestedArray, FieldSource fieldSource, ScienceParameters scienceParameters, SchedBlockExpert schedBlockExpert, ScienceGoal scienceGoal) {
        if (!(targetWithIntent instanceof TargetParameters)) {
            throw new WizardSBGenerationException("Logic error in createTarget");
        }
        TargetParameters targetParameters = (TargetParameters)targetWithIntent;
        Time time = null;
        try {
            time = schedBlockExpert.timeCalculate(targetParameters, RequestedArray.SEVEN_M);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            throw new WizardSBGenerationException("Unable to generate the integration time " + exception.getMessage());
        }
        assert (time != null);
        time = TargetCreator.adjustIntegrationTimeFor4bitSG(scienceGoal, time);
        time = (Time)time.multiply(fieldSource.getNumberOfPointings());
        Log.logger(TargetCreator.class).fine(String.format("Integration time for %s is %s for the %s array with %d pointing(s)", new Object[]{targetParameters.getSourceName(), time, requestedArray, fieldSource.getNumberOfPointings()}));
        scienceParameters.getIntegrationTime().setContentAndUnit(time.getContent(), time.getUnit());
    }

    private static Time adjustIntegrationTimeFor4bitSG(@NonNull ScienceGoal scienceGoal, @NonNull Time time) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (time == null) {
            throw new NullPointerException("integrationTime is marked non-null but is null");
        }
        String string = scienceGoal.getPerformanceParameters().getDesiredSensitivityFrequencyMeasure();
        if ((scienceGoal.isTwoBitRepresentationOfFourBitSG() || scienceGoal.isStandAloneACA()) && (string.equals(PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_REPRESENTATIVEWINDOWRESOLUTION) || string.equals(PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_FINESTRESOLUTION))) {
            return (Time)time.divide(4.0);
        }
        return time;
    }

    private static void adaptScienceTargetFor12m(TargetWithIntent targetWithIntent, SBGenerationContext sBGenerationContext, RequestedArray requestedArray, SpectralSpec spectralSpec, FieldSource fieldSource, ScienceParameters scienceParameters, SchedBlockExpert schedBlockExpert, ScienceGoal scienceGoal) {
        try {
            if (!(targetWithIntent instanceof TargetParameters)) {
                throw new WizardSBGenerationException("Logic error in createTarget");
            }
            TargetParameters targetParameters = (TargetParameters)targetWithIntent;
            boolean bl = spectralSpec.isACASpectralSpec();
            Time time = bl ? schedBlockExpert.timeCalculateACA() : schedBlockExpert.timeCalculate(targetParameters, requestedArray);
            time = TargetCreator.adjustIntegrationTimeFor4bitSG(scienceGoal, time);
            time = (Time)time.multiply(fieldSource.getNumberOfPointings());
            Log.logger(TargetCreator.class).fine("Integration time for " + targetParameters.getSourceName() + " is " + time + " for the " + requestedArray + " array number of pointings " + fieldSource.getNumberOfPointings());
            scienceParameters.getIntegrationTime().setContentAndUnit(time.getContent(), time.getUnit());
            if (Configuration.isLongBaselineConfiguration(sBGenerationContext.getConfiguration())) {
                scienceParameters.setSubScanDuration(Time.createTimeSec(18.144));
            }
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            throw new WizardSBGenerationException(exception);
        }
    }

    private static Target assembleTarget(FieldSource fieldSource, SpectralSpec spectralSpec, ObservingParameters observingParameters, Integer n) {
        Target target = Target.createTarget();
        target.addToIntendedObservingGroupList(n);
        target.setFieldSource(fieldSource);
        target.setSpectralSpec(spectralSpec);
        target.addObservingParameters(observingParameters);
        return target;
    }

    private TargetCreator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

