/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.MinBoundingBoxExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import lombok.NonNull;
import org.apache.commons.math3.util.ArithmeticUtils;

public class TPReferencePositionWorker {
    public static void setupReferencePosition(@NonNull Target target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SpectralSpec spectralSpec = target.getSpectralSpec();
        if (!target.hasAmplitudeCalParameters() && !target.hasScienceParameters()) {
            throw new WizardSBGenerationException("Only ampcals and science targets may have a reference position attached.");
        }
        for (Reference reference : target.getFieldSource().getReference()) {
            Time time;
            Object object;
            SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
            skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
            double d = TPReferencePositionWorker.isExtraGalacticSource(target) ? 600.0 : TPReferencePositionWorker.getDefaultOffPosition(target);
            skyCoordinates.setLongitude(Longitude.createLongitude((double)d, (String)Longitude.UNIT_ARCSEC));
            reference.setReferenceCoordinates(skyCoordinates);
            Time time2 = TPReferencePositionWorker.getFieldReferenceIntegrationTime(target, d);
            reference.setIntegrationTime(time2);
            if (target.hasAmplitudeCalParameters()) {
                object = target.getAmplitudeCalParametersList()[0];
                time = (Time)object.getSubScanDuration().multiply(0.95);
            } else if (target.hasScienceParameters()) {
                object = target.getScienceParametersList()[0];
                time = (Time)object.getSubScanDuration().multiply(0.95);
            } else {
                throw new WizardSBGenerationException("Unable to determine reference cycle time for any other target type but science and amp cal");
            }
            reference.setCycleTime(time);
            double d2 = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration().getContentInUnits(Time.UNIT_MS);
            double d3 = time2.getContentInUnits(Time.UNIT_MS);
            long l = ArithmeticUtils.lcm((long)((long)d2), (long)48L);
            double d4 = Math.ceil(d3 / (double)l) * (double)l;
            Time time3 = Time.createTime((double)(d4 / 1000.0), (String)Time.UNIT_S);
            reference.setSubScanDuration(time3);
        }
    }

    private static double getDefaultOffPosition(@NonNull Target target) {
        double d;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SpectralSpec spectralSpec = target.getSpectralSpec();
        FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
        if (fieldPattern instanceof RectanglePattern) {
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
            d = rectanglePattern.getLatitudeLength().isGreaterThan((AbstractDoubleWithUnit)rectanglePattern.getLongitudeLength()) ? rectanglePattern.getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC) : rectanglePattern.getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC);
        } else if (fieldPattern instanceof PointingPattern) {
            TargetParameters targetParameters = target.getFieldSource().getTargetParameters();
            if (targetParameters == null) {
                throw new WizardSBGenerationException("Unable to determine target parameters associated with field source " + target.getFieldSource().getName());
            }
            Rectangle rectangle = null;
            try {
                rectangle = MinBoundingBoxExpert.getBoundingRectangle(targetParameters).getTPArrayRectangle(spectralSpec);
                Log.logger(TPReferencePositionWorker.class).fine("TP bounding rectangle dimensions (arcsec) are : Long " + rectangle.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC) + " Short " + rectangle.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.logger(SpectralSpecFactory.class).warning("Unable to determine minimum bounding box around pointings: " + illegalArgumentException.getMessage());
                throw new WizardSBGenerationException(illegalArgumentException);
            }
            assert (rectangle != null);
            d = rectangle.getLatitudeLength().isGreaterThan(rectangle.getLongitudeLength()) ? rectangle.getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC) : rectangle.getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC);
        } else if (fieldPattern instanceof FillPattern) {
            d = Longitude.createLongitude((double)2.0, (String)Longitude.UNIT_DEG).getContentInUnits(Longitude.UNIT_ARCSEC);
        } else {
            throw new WizardSBGenerationException("Unable to handle this pointing pattern type when setting up the TP reference position");
        }
        return d;
    }

    private static Time getFieldReferenceIntegrationTime(@NonNull Target target, double d) {
        double d2;
        Object object;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SpectralSpec spectralSpec = target.getSpectralSpec();
        if (target.hasAmplitudeCalParameters()) {
            object = target.getAmplitudeCalParametersList()[0];
            d2 = object.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        } else if (target.hasScienceParameters()) {
            object = target.getScienceParametersList()[0];
            d2 = object.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        } else {
            throw new WizardSBGenerationException("Unable to determine t_sub for any other target but science and amp cal");
        }
        try {
            object = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        UserAngle userAngle = UserAngle.createUserAngle(6.3, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, (Frequency)((Object)object));
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        double d3 = userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC) * 1.0;
        double d4 = Math.sqrt(1.0 * (d2 + 1.0) * (d3 * d2 / d / 5.0));
        return Time.createTimeSec(d4);
    }

    private static boolean isExtraGalacticSource(@NonNull Target target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        TargetParameters targetParameters = target.getFieldSource().getTargetParameters();
        if (!targetParameters.getSourceCoordinates().isGalactic()) {
            return false;
        }
        boolean bl = target.getFieldSource().getSourceVelocity().getCenterVelocity().isGreaterThan((AbstractDoubleWithUnit)Speed.createSpeed((double)150.0, (String)Speed.UNIT_KM_S));
        boolean bl2 = targetParameters.getFieldCenterCoordinates().getLatitude().isGreaterThan((AbstractDoubleWithUnit)Latitude.createLatitude((double)15.0, (String)Latitude.UNIT_DEG));
        return bl2 && bl;
    }
}

