/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AbstractIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

abstract class StandardCalIntermediateTarget
extends AbstractIntermediateTarget {
    private ObsType intent;
    protected ArrayList<SpectralSetupParameters> sspsDerivedFromSpectralScanTuning = new ArrayList();
    private Integer observingGroupPointer = null;
    private ObservingGroupManager.ObservingGroupType observingGroupType = ObservingGroupManager.ObservingGroupType.CALIBRATOR;
    private Integer observingGroupIndex = null;

    protected abstract void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent var1, SpectralSetupParameters var2, RequestedArray var3, Integer var4);

    public StandardCalIntermediateTarget(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull ObsType obsType, ObservingGroupManager observingGroupManager, Integer n, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, @NonNull SBGenerationContext sBGenerationContext) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.observingGroupPointer = n;
        this.schemaToUseForSBGeneration = enumSet;
        this.sbContext = sBGenerationContext;
        this.setupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, obsType, observingGroupManager);
    }

    public StandardCalIntermediateTarget(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull ObsType obsType, ObservingGroupManager observingGroupManager, Integer n, ObservingGroupManager.ObservingGroupType observingGroupType, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, @NonNull SBGenerationContext sBGenerationContext) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.observingGroupPointer = n;
        this.observingGroupType = observingGroupType;
        this.schemaToUseForSBGeneration = enumSet;
        this.sbContext = sBGenerationContext;
        this.setupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, obsType, observingGroupManager);
    }

    public StandardCalIntermediateTarget(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull ObsType obsType, ObservingGroupManager observingGroupManager, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Integer n, @NonNull SBGenerationContext sBGenerationContext) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.observingGroupIndex = n;
        this.schemaToUseForSBGeneration = enumSet;
        this.sbContext = sBGenerationContext;
        this.setupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, obsType, observingGroupManager);
    }

    private void setupIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObsType obsType, ObservingGroupManager observingGroupManager) {
        this.setObservingGroupManager(observingGroupManager);
        this.intent = obsType;
        assert (this.observingGroupPointer != null);
        if (this.observingGroupIndex == null) {
            this.observingGroupIndex = observingGroupManager.getObservingGroupIndex(this.observingGroupType, this.observingGroupPointer);
        }
        if (this.schemaToUseForSBGeneration.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
            Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, this.observingGroupIndex, this.sbContext);
            this.completeTargetConstruction(target, spectralSetupParameters, requestedArray, targetWithIntent);
        } else if (this.schemaToUseForSBGeneration.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            this.assignMultipleVelocitySourceTargetsToObservingGroups(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, this.observingGroupPointer));
        } else if (this.schemaToUseForSBGeneration.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            this.determineAdditionalTargetsRequiredForSpectralScans(targetWithIntent, spectralSetupParameters, requestedArray, this.observingGroupIndex);
        } else {
            throw new WizardSBGenerationException("Unknown SB generation schema : " + this.schemaToUseForSBGeneration);
        }
    }

    protected void completeTargetConstruction(Target target, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, TargetWithIntent targetWithIntent) {
        Velocity velocity = spectralSetupParameters.getSourceVelocity();
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(this.sbContext);
        SpectralSpec spectralSpec = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, this.intent, Optional.of(targetWithIntent));
        Time time = null;
        try {
            boolean bl = !spectralSpec.isPureTDM();
            time = this.determineIntegrationTimes(bl, spectralSetupParameters, requestedArray);
            if (time != null) {
                for (ObservingParameters observingParameters : target.getObservingParameters()) {
                    boolean bl2 = CalibratorParameters.class.isAssignableFrom(observingParameters.getClass());
                    if (!bl2) continue;
                    CalibratorParameters calibratorParameters = (CalibratorParameters)((Object)observingParameters);
                    calibratorParameters.setDefaultIntegrationTime(time);
                }
            }
        }
        catch (IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException integrationTimeUndeterminedException) {
            this.logger.fine(this.getClass().getName() + " No array/band specific integration time associated with this calibrator");
        }
        target.setSpectralSpec(spectralSpec);
        this.targets.add(target);
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        orderedTarget.setTarget(target);
        this.orderedTargets.add(orderedTarget);
    }

    public List<SpectralSetupParameters> getSSPsDerivedFromSpectralScanTuning() {
        return this.sspsDerivedFromSpectralScanTuning;
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n) {
        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n, this.sbContext);
        this.completeTargetConstruction(target, spectralSetupParameters, requestedArray, targetWithIntent);
    }

    public Integer getObservingGroupPointer() {
        return this.observingGroupPointer;
    }
}

