/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.ScienceIntermediateTargetBuilder;
import alma.obsprep.services.generator.refactored.intermediatetarget.ScienceIntermediateTargetCreatorInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class InterferometricSpectralScanScienceIntermediateTargetBuilder
extends ScienceIntermediateTargetBuilder
implements ScienceIntermediateTargetCreatorInterface {
    @Override
    public Target createScienceIntermediateTargets(ScienceGoal scienceGoal, TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, ObservingGroupManager observingGroupManager, int n, SBGenerationContext sBGenerationContext, List<Target> list, List<OrderedTarget> list2) {
        if (!sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            throw new IllegalArgumentException("Expecting spectral scan SB generation schema");
        }
        Target target = null;
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            int n2 = 1;
            for (ArrayList<Frequency> arrayList : spectralScanTunings.getTunings()) {
                SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, arrayList);
                Integer n3 = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n2);
                target = TargetCreator.createTarget(scienceGoal, targetWithIntent, spectralSetupParameters2, n3, sBGenerationContext);
                ++n2;
                if (sBGenerationContext.getArray().isTP()) {
                    this.modifyScienceTargetForTPArray(target, scienceGoal);
                }
                list.add(target);
                OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
                orderedTarget.setTarget(target);
                list2.add(orderedTarget);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to add spectral scan tunings to target ", (Throwable)exception);
        }
        return targetWithIntent == spectralSetupParameters.getScienceGoal().getSoleTargetParameters() ? target : null;
    }
}

