/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.PhaseCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Time;
import java.util.EnumSet;
import lombok.NonNull;

public class CheckSourceIntermediateTarget
extends StandardCalIntermediateTarget {
    public CheckSourceIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.CHECKSOURCE, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
        if (sBGenerationContext.getArray().equals((Object)RequestedArray.TWELVE_M) && sBGenerationContext.getConfiguration().isLongBaselineConfiguration()) {
            this.getOrderedTargets().stream().filter(orderedTarget -> targetWithIntent.getObsType().equals((Object)ObsType.CHECKSOURCE)).forEach(orderedTarget -> orderedTarget.getTarget().getCheckSourceCalParametersList()[0].setSubScanDuration(Time.createTimeSec(18.144)));
        }
    }

    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Integer n) {
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n) {
    }

    @Override
    public Time getTPFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) {
        return Time.createTime((double)20.0, (String)Time.UNIT_S);
    }

    @Override
    public Time getTPTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) {
        return Time.createTime((double)20.0, (String)Time.UNIT_S);
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        time = this.determineLongBaselineConfigurationIntegrationTime();
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for non-longbaseline configurations");
        }
        return time;
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        time = this.determineLongBaselineConfigurationIntegrationTime();
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for non-longbaseline configurations");
        }
        return time;
    }

    private Time determineLongBaselineConfigurationIntegrationTime() {
        if (this.sbContext.getConfiguration().isLongBaselineConfiguration()) {
            return Time.createTimeSec(18.0);
        }
        return null;
    }

    public static void setCheckSourceCycleTimes(@NonNull SchedBlock schedBlock, double d) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            Time time = Time.createTime();
            Time time2 = null;
            Time time3 = null;
            Target target = null;
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target2 = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : target2.getScienceParametersList()) {
                    time.aggregate(scienceParameters.getIntegrationTime().getTime());
                }
                if (target2.hasPhaseCalParameters()) {
                    time2 = target2.getPhaseCalParametersList()[0].getCycleTime();
                    time3 = target2.getPhaseCalParametersList()[0].getSubScanDuration();
                }
                if (!target2.hasCheckSourceCalParameters()) continue;
                target = target2;
            }
            if (time.isZero() || time2 == null || target == null) continue;
            Time time4 = (Time)time.multiply(0.3333333333333333);
            Time time5 = (Time)((Time)((Time)time2.plus((AbstractDoubleWithUnit)Time.createTimeSec(7.0))).plus((AbstractDoubleWithUnit)time3)).multiply(d);
            CheckSourceCalParameters checkSourceCalParameters = target.getCheckSourceCalParametersList()[0];
            if (time5.isGreaterThan((AbstractDoubleWithUnit)time4)) {
                checkSourceCalParameters.setCycleTime(time5);
                continue;
            }
            checkSourceCalParameters.setCycleTime(time4);
        }
    }

    public static boolean isLongBaselineInBandChecksourceCustomisationRequired(@NonNull SBGenerationContext sBGenerationContext) {
        Configuration configuration;
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (!sBGenerationContext.isTM1SB()) {
            return false;
        }
        SpectralSetupParameters spectralSetupParameters = sBGenerationContext.getGoal().getSpectralSetupParameters();
        try {
            configuration = Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
            throw new WizardSBGenerationException("Unable to determine most extended 12-m configuration for setup: " + exception.getMessage());
        }
        if (ReceiverBand.isReceiverBandInSet(spectralSetupParameters.getReceiverBand(), 1, 2, 3, 4, 5, 6, 7) && configuration.isLongBaselineConfiguration()) {
            return true;
        }
        return PhaseCalIntermediateTarget.HIGHBANDS.contains(spectralSetupParameters.getReceiverBand()) && ConfigurationHelper.isConfigurationInSet(configuration, 8, 9, 10);
    }
}

