/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.dgcpostprocessor;

import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.B2BParameterConfigurator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BFrequencySetup;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BReferenceSpectralSpecBuilderBase;
import alma.valuetypes.Time;
import java.util.EnumSet;
import java.util.List;

public class B2BACADGCParameterConfigurator
extends B2BParameterConfigurator {
    private static final int ACA_DGC_ITOS_DEFAULT_S = 30;

    public B2BACADGCParameterConfigurator(SchedBlock schedBlock) {
        super(schedBlock);
    }

    @Override
    public void configureCheckSourceCalibrators() {
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        List<Target> list2 = this.sb.getAllTargets(CheckSourceCalParameters.CheckSourceParametersFilter);
        if (list2.isEmpty()) {
            return;
        }
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        SpectralSpec spectralSpec = list.get(0).getSpectralSpec();
        DGCB2BFrequencySetup dGCB2BFrequencySetup = DGCB2BReferenceSpectralSpecBuilderBase.lookUpDGCB2BRefData(spectralSpec.getReceiverBand(), spectralSpec.getLO1Frequency(), this.sb.getSbGenerationContext());
        Time time = dGCB2BFrequencySetup.getCheckSourceIntTime();
        if (time != null) {
            list2.forEach(target -> target.getFirstCheckSourceCalParameters().ifPresent(checkSourceCalParameters -> {
                checkSourceCalParameters.setDefaultIntegrationTime(time);
                checkSourceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(time, target));
                this.setCheckSourceCycleTime((CheckSourceCalParameters)((Object)((Object)checkSourceCalParameters)));
            }));
        }
    }

    @Override
    public void configureDGCRefCalibrators() {
        if (!this.sb.getSbGenerationContext().getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.ACA7M)) {
            return;
        }
        List<Target> list = this.sb.getAllTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        Time time = Time.createTimeSec(30.0);
        list.forEach(target -> target.getFirstDGCReferenceParameters().ifPresent(dGCReferenceCalParameters -> {
            dGCReferenceCalParameters.setDefaultIntegrationTime(time);
            dGCReferenceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(time, target));
        }));
    }

    @Override
    public void configureDGCScienceCalibrators() {
        if (!this.sb.getSbGenerationContext().getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.ACA7M)) {
            return;
        }
        List<Target> list = this.sb.getAllTargets(DGCScienceCalParameters.DGCScienceCalParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        Time time = Time.createTimeSec(30.0);
        list.forEach(target -> target.getFirstDGCScienceParameters().ifPresent(dGCScienceCalParameters -> {
            dGCScienceCalParameters.setDefaultIntegrationTime(time);
            dGCScienceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(time, target));
        }));
    }
}

