/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.OUSLocator;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ExecutiveFraction;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.ProposalFeedback;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.AQUADataProcessingFlagGenerator;
import alma.obsprep.services.generator.refactored.ArraySBGroupPostProcessorFactory;
import alma.obsprep.services.generator.refactored.DGCPostProcessor;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerFactory;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerInterface;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.SchedblockExecutionTimeAdjuster;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.ScienceParametersSensitivityCalculator;
import alma.obsprep.services.generator.refactored.SolarSBConfigurator;
import alma.obsprep.services.generator.refactored.SpectralLineSBPostProcessor;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.services.generator.refactored.StandardOUSStructureAssemblerFactory;
import alma.obsprep.services.generator.refactored.TargetCache;
import alma.obsprep.services.generator.refactored.TotalPowerIntegrationTimeCalculator;
import alma.obsprep.services.generator.refactored.intermediatetarget.CheckSourceIntermediateTarget;
import alma.obsprep.services.generator.refactored.obsparams.AbstractObservingParametersFactory;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimerInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.spectralspec.Walsh90DegConfiguratorFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.KeywordValue;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SchedBlockPostProcessor {
    private final SpectralLineSBPostProcessor spectralLineSBPostProcessor = new SpectralLineSBPostProcessor();
    private final Log.Logger logger = Log.logger((Object)this);
    private final boolean isSBGenerationUserInitiated;
    private final ScienceGoal piDefinedScienceGoal;
    private final ObsUnitSet rootOUS;
    private SchedblockExecutionTimeAdjuster schedblockExecutionTimeAdjuster;

    public void postProcessSBGroup(Integer n, PerformanceParameters performanceParameters, Boolean bl, int n2, ScienceGoal scienceGoal, ObsUnitSet obsUnitSet, Collection<Collection<SchedBlock>> collection, Optional<Map<ObsUnitSet, Collection<SchedBlock>>> optional) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.enforceMinimumExecutionTimes(bl, n2, obsUnitSet, scienceGoal);
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                try {
                    this.postProcessSB(scienceGoal, schedBlock);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new WizardSBGenerationException(exception);
                }
            }
            ArraySBGroupPostProcessorFactory.getSBGroupPostProcessor(collection2).ifPresent(arraySBGroupPostProcessorInterface -> arraySBGroupPostProcessorInterface.postProcessSBArrayGroup(collection2, scienceGoal));
        }
        this.setSBSchedulingConstraintsDynamicRange(collection, scienceGoal, optional);
        stopwatch.stop();
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine("Time to post process SB group " + stopwatch.toString());
    }

    private void setSBSchedulingConstraintsDynamicRange(@NonNull Collection<Collection<SchedBlock>> collection, @NonNull ScienceGoal scienceGoal, @NonNull Optional<Map<ObsUnitSet, Collection<SchedBlock>>> optional) {
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("ousesToBeProcessed is marked non-null but is null");
        }
        if (scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation()) {
            this.setDynamicRangeForSim12m7mSGs(collection, optional);
        } else {
            Optional<SchedBlock> optional2 = Optional.empty();
            block0: for (Collection<SchedBlock> collection2 : collection) {
                for (SchedBlock schedBlock : collection2) {
                    if (!(scienceGoal.isStandAloneACA() ? schedBlock.isACA7mArraySB() : schedBlock.is12mExtendedArraySB())) continue;
                    optional2 = Optional.of(schedBlock);
                    continue block0;
                }
            }
            for (Collection<SchedBlock> collection2 : collection) {
                for (SchedBlock schedBlock : collection2) {
                    this.setDynamicRangeAttributes(collection, schedBlock, optional2);
                }
            }
        }
    }

    private void setDynamicRangeForSim12m7mSGs(@NonNull Collection<Collection<SchedBlock>> collection, @NonNull Optional<Map<ObsUnitSet, Collection<SchedBlock>>> optional) {
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("ousesToBeProcessed is marked non-null but is null");
        }
        Optional<SchedBlock> optional2 = Optional.empty();
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                if (schedBlock.is12mCompactArraySB() || schedBlock.isACA7mArraySB()) {
                    String[] stringArray = schedBlock.getSchedulingConstraints().getSimultaneousSbUid();
                    block2: for (Collection<SchedBlock> collection3 : optional.orElseThrow(() -> new WizardSBGenerationException("No OUSes provided for sim12+7m")).values()) {
                        for (SchedBlock schedBlock2 : collection3) {
                            boolean bl = Stream.of(stringArray).anyMatch(string -> schedBlock2.getEntityID().equals(string) && schedBlock2.is12mExtendedArraySB());
                            if (!bl) continue;
                            optional2 = Optional.of(schedBlock2);
                            break block2;
                        }
                    }
                }
                this.setDynamicRangeAttributes(collection, schedBlock, optional2);
            }
        }
    }

    private void enforceMinimumExecutionTimes(boolean bl, int n, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        boolean bl2 = scienceGoal.isStandAloneACA();
        ObsUnitSet obsUnitSet2 = null;
        Integer n2 = null;
        SBGeneratorTemplate.SchedBlockType schedBlockType = null;
        if (bl2) {
            n2 = 1;
            schedBlockType = SBGeneratorTemplate.SchedBlockType.ACA7M;
        } else {
            schedBlockType = SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION;
            try {
                n2 = scienceGoal.getNumberOf12MAntennaConfigurations();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                this.logger.warning("Unable to determine number of 12m antenna configurations");
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
        }
        assert (n2 != null && schedBlockType != null);
        try {
            obsUnitSet2 = this.findOUS(obsUnitSet, schedBlockType);
        }
        catch (UnknownEntityException unknownEntityException) {
            this.logger.warning("Unable to find SBs in OUS structure");
            throw new WizardSBGenerationException(unknownEntityException);
        }
        finally {
            if (obsUnitSet2 == null) {
                return;
            }
        }
        if (bl) {
            this.schedblockExecutionTimeAdjuster.enforceSBExecutionTimesForContinuousMonitoring(n, obsUnitSet2, scienceGoal);
        } else if (n2 > 1) {
            ObsUnitSet obsUnitSet3 = null;
            try {
                obsUnitSet3 = this.findOUS(obsUnitSet, SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION);
            }
            catch (UnknownEntityException unknownEntityException) {
                this.logger.warning("Unable to find SBs in OUS structure");
                throw new WizardSBGenerationException(unknownEntityException);
            }
            finally {
                if (obsUnitSet3 == null) {
                    throw new WizardSBGenerationException("Unable to find 12m compact array SBs in OUS structure");
                }
            }
            this.enforceSBExecutionTimesForMultiple12mConfigurations(obsUnitSet3, obsUnitSet2, scienceGoal);
        } else if (scienceGoal.getPerformanceParameters().getNeedsMoreTime()) {
            this.enforceSBExecutionTimeForTimeOverrides(obsUnitSet2, scienceGoal);
        } else if (scienceGoal.isPolarizationObservation()) {
            this.enforcePolarizationTime(scienceGoal, obsUnitSet);
        }
    }

    private void enforcePolarizationTime(@NonNull ScienceGoal scienceGoal, ObsUnitSet obsUnitSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        List<SchedBlock> list = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(list, obsUnitSet);
        list = list.stream().filter(schedBlock -> schedBlock.is12mCompactArraySB() || schedBlock.isACA7mArraySB() || schedBlock.is12mExtendedArraySB()).collect(Collectors.toList());
        assert (list != null);
        if (!list.isEmpty()) {
            this.schedblockExecutionTimeAdjuster.enforceMinSBExecutionTime(AlmaPolicies.getInstance().getMinTimeForPolarisationSB(), list, scienceGoal);
        }
    }

    private void enforceSBExecutionTimeForTimeOverrides(ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        Time time2 = scienceGoal.getPerformanceParameters().getDesiredTime().deepCopy();
        if (time2 == null || time2.isZero()) {
            throw new WizardSBGenerationException("Time override requested is either not specified or zero");
        }
        if (scienceGoal.isPolarizationObservation()) {
            this.schedblockExecutionTimeAdjuster.enforceProjectExecutionTime(Time.max(time2, time), obsUnitSet, scienceGoal);
        } else {
            this.schedblockExecutionTimeAdjuster.enforceProjectExecutionTime(time2, obsUnitSet, scienceGoal);
        }
    }

    private void enforceSBExecutionTimesForMultiple12mConfigurations(ObsUnitSet obsUnitSet, ObsUnitSet obsUnitSet2, ScienceGoal scienceGoal) {
        assert (obsUnitSet != null);
        assert (obsUnitSet2 != null);
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        boolean bl = scienceGoal.getPerformanceParameters().getNeedsMoreTime();
        Time time2 = null;
        if (bl) {
            Time time3 = scienceGoal.getPerformanceParameters().getDesiredTime().deepCopy();
            if (time3 == null || time3.isZero()) {
                throw new WizardSBGenerationException("Time override requested is either not specified or zero");
            }
            Time time4 = null;
            try {
                time4 = (Time)time3.multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal));
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException("Unable to determine 12m compact array time multiplier: " + invalidObsProgramParametersException.getMessage());
            }
            assert (time4 != null);
            Time time5 = null;
            Time time6 = null;
            if (scienceGoal.isPolarizationObservation()) {
                time6 = Time.max(time3, time);
                time5 = Time.max(time4, time);
            } else {
                time5 = time4;
                time6 = time3;
            }
            assert (time5 != null);
            assert (time6 != null);
            this.schedblockExecutionTimeAdjuster.enforceProjectExecutionTime(time6, obsUnitSet2, scienceGoal);
            this.schedblockExecutionTimeAdjuster.enforceProjectExecutionTime(time5, obsUnitSet, scienceGoal);
        } else if (scienceGoal.isPolarizationObservation()) {
            this.enforcePolarizationTime(scienceGoal, obsUnitSet);
            this.enforcePolarizationTime(scienceGoal, obsUnitSet2);
        } else {
            try {
                for (SchedBlock schedBlock : obsUnitSet2.getSchedBlock()) {
                    if (!schedBlock.is12mExtendedArraySB()) continue;
                    time2 = (Time)ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal));
                }
            }
            catch (Exception exception) {
                this.logger.warning("Unable to determine execution time 12m extended array");
                throw new WizardSBGenerationException(exception);
            }
            finally {
                if (time2 == null) {
                    this.logger.warning("Unable to determine the minimum execution time for the 12m compact array");
                    throw new WizardSBGenerationException("Unable to determine the minimum execution time for the 12m compact array");
                }
            }
            assert (time2 != null);
            this.schedblockExecutionTimeAdjuster.enforceProjectExecutionTime(time2, obsUnitSet, scienceGoal);
        }
    }

    private void postProcessSB(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) throws WizardSBGenerationException, Exception {
        Object object;
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        List<ObsUnitSet> list;
        Object object2;
        Object object3;
        boolean bl;
        boolean bl2;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        boolean bl3 = sBGenerationContext.is7mSB();
        if (bl3 && !scienceGoal.isStandAloneACA()) {
            this.baseACA7mScienceParameterTimingsBasedOnTMTimings(schedBlock, scienceGoal);
        }
        if (bl3) {
            this.flag7mHighFrequencySBs(schedBlock);
        }
        if (!sBGenerationContext.isTPScienceSB() && scienceGoal.isSpectralScan()) {
            this.ensureSpectralScanPhaseCalsUseScienceSpectralSpecs(schedBlock);
        }
        if (!VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal)) {
            this.spectralLineSBPostProcessor.performRestLinePostProcessing(scienceGoal, schedBlock);
        }
        if (bl2 = scienceGoal.isSolarScienceGoal()) {
            SolarExecutionTimeCalculator solarExecutionTimeCalculator = new SolarExecutionTimeCalculator();
            int n = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).size();
            SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult = solarExecutionTimeCalculator.calculateSolarIntegrationTimes(scienceGoal.getPerformanceParameters().getDesiredTime(), scienceGoal.getReceiverBand().getNumber(), n, scienceGoal.getIsTPSolarRegionalMappingEnabled());
            new SolarSBConfigurator(schedBlock, solarExecutionTimeResult).configureSBForSolar();
        }
        if (bl = sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching()) {
            this.walshSwitching90DegreePostProcessing(schedBlock);
        } else {
            this.setCorrelatorTimingsToTDMDefaults();
        }
        if (scienceGoal.isSpectralScan()) {
            this.setRepresentativeWindowInSpectralScan(schedBlock);
        }
        boolean bl4 = scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation();
        try {
            object3 = new OUSLocator.Builder();
            ((OUSLocator.Builder)object3).rootOUS(this.rootOUS).scienceGoal(scienceGoal).simultaneousArrayOperation(bl4);
            object2 = new OUSLocator((OUSLocator.Builder)object3);
            list = ((OUSLocator)object2).locateOUS();
        }
        catch (OUSLocator.UnableToLocateObsUnitSetException unableToLocateObsUnitSetException) {
            throw new WizardSBGenerationException(unableToLocateObsUnitSetException);
        }
        object3 = StandardOUSStructureAssemblerFactory.getStandardOUSStructureAssembler(bl4 ? StandardOUSStructureAssemblerFactory.OUSStructureFormat.SIMULTANEOUS_12M_ACA : StandardOUSStructureAssemblerFactory.OUSStructureFormat.STANDARD_FORMAT);
        object2 = object3.assembleStandardOUSStructure(list);
        ObservingTimeCalculator.Builder builder = new ObservingTimeCalculator.Builder();
        builder.noSBGeneration(true).obsUnitSet((ObsUnitSet)object2).scienceGoal(scienceGoal);
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(builder);
        try {
            enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, schedBlock.getObsUnitControl().getArrayRequested());
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + unknownEntityException.getMessage());
            throw new WizardSBGenerationException(unknownEntityException);
        }
        RequestedArray requestedArray = RequestedArray.valueOf(ControlBlockTArrayRequestedType.valueOf((String)schedBlock.getObsUnitControl().getArrayRequested()));
        boolean bl5 = this.isLongbaselineConfigurationScheduled(scienceGoal, schedBlock, bl2, requestedArray);
        if (!bl2) {
            if (schedBlock.isTotalPowerScienceSB()) {
                this.setupNonSolarTPSB(scienceGoal, schedBlock, list, observingTimeCalculator);
            } else {
                this.quantizeParametersInInterferometricSBs(schedBlock, requestedArray, enumSet, bl5);
            }
        }
        this.setupTPSpectralScanSBs(schedBlock);
        this.setupPolarizationCalibratorSubscanDurations(scienceGoal, schedBlock);
        try {
            SchedBlockPostProcessor.reviseCheckSourceObservingParameters(schedBlock, scienceGoal);
        }
        catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
            this.logger.warning("Unable to adjust check source cycle: " + unableToFindParentScienceGoalException);
        }
        this.setEstimatedTimeForSBInOUS(schedBlock, observingTimeCalculator, requestedArray);
        try {
            object = new ScienceParametersSensitivityCalculator();
            ((ScienceParametersSensitivityCalculator)object).setScienceParametersSensitivity(schedBlock, requestedArray, observingTimeCalculator, scienceGoal, this.piDefinedScienceGoal);
        }
        catch (ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException unableToDetermineSensitivityException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).warning("Error when determining the sensitivity: " + unableToDetermineSensitivityException.getMessage());
        }
        this.copyExecutiveSharesIntoSB(scienceGoal, schedBlock);
        if (this.isSBGenerationUserInitiated) {
            StaleSBDetector.getInstance().setSBInSyncWithGeneratingSG(schedBlock, this.piDefinedScienceGoal);
        }
        if (this.isSBDGCCompatible(schedBlock)) {
            new DGCPostProcessor(schedBlock).postProcessDGCTargets();
        }
        this.removeUnusedP2Components(schedBlock);
        object3.resetOUSStructure();
        object = new AQUADataProcessingFlagGenerator(this.piDefinedScienceGoal);
        ((AQUADataProcessingFlagGenerator)object).setAQUASBDataProcessingFlags(schedBlock, this.isSBDGCCompatible(schedBlock));
    }

    private void flag7mHighFrequencySBs(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (!schedBlock.getSbGenerationContext().is7mSB()) {
            throw new WizardSBGenerationException("schedBlock should be a 7m SB");
        }
        ReceiverBand receiverBand = schedBlock.getSbGenerationContext().getGoal().getReceiverBand();
        schedBlock.getSchedulingConstraints().setSbRequiresTPAntennas(ReceiverBand.isReceiverBandInSet(receiverBand, 8, 9, 10));
    }

    private boolean isSBDGCCompatible(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = schedBlock.getSbGenerationContext().getSchemaToUseForSBGeneration();
        return !schedBlock.isTP() && SBGeneratorTemplate.SBGenerationSchema.isDGC(enumSet) && !this.piDefinedScienceGoal.getCalibrationSetupParameters().getIsDGCOverride();
    }

    private void ensureSpectralScanPhaseCalsUseScienceSpectralSpecs(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            if (observingGroup.getIndex() == 1) continue;
            List<Target> list = observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter);
            List<Target> list2 = observingGroup.getAllOrderedTargets(PhaseCalParameters.phaseCalParametersFilter);
            if (list2.size() != 1) {
                throw new WizardSBGenerationException("Expected a single phase cal per tuning in a spectral scan setup, found " + list2.size());
            }
            if (list.isEmpty()) {
                throw new WizardSBGenerationException("Expected to find a science target in a spectral scan tuning");
            }
            list2.get(0).setSpectralSpec(list.get(0).getSpectralSpec());
        }
    }

    private void setRepresentativeWindowInSpectralScan(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        double d = schedBlock.getSchedulingConstraints().getRepresentativeFrequency().getContentInGHz();
        ArrayList arrayList = new ArrayList(100);
        for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
            for (BaseBand baseBand : spectralSpec.getBaseBand()) {
                Collections.addAll(arrayList, baseBand.getSingleSpectralWindow());
            }
        }
        Object object = null;
        double d2 = -1.0;
        for (Object object2 : arrayList) {
            object2.setRepresentativeWindow(false);
            if (object == null) {
                object = object2;
                d2 = Math.abs(object.getCenterFrequency().getContentInGHz() - d);
                continue;
            }
            double d3 = ((AbstractSpectralWindow)object2).getSideBandUse().equals((Object)SideBandUse.SIDEBANDUSE_USB) ? ((AbstractSpectralWindow)object2).getSkyFrequencyUSB().getContentInGHz() : ((AbstractSpectralWindow)object2).getSkyFrequencyLSB().getContentInGHz();
            double d4 = d3;
            double d5 = Math.abs(d4 - d);
            if (!(d5 < d2)) continue;
            d2 = d5;
            object = object2;
        }
        assert (object != null);
        double d6 = ((AbstractSpectralWindow)object).getSideBandUse().equals((Object)SideBandUse.SIDEBANDUSE_USB) ? ((AbstractSpectralWindow)object).getSkyFrequencyUSB().getContentInGHz() : ((AbstractSpectralWindow)object).getSkyFrequencyLSB().getContentInGHz();
        String string = ((AbstractSpectralWindow)object).getBaseBandConfig().getBaseBandName();
        Log.logger(SchedBlockPostProcessor.class).fine("Baseband Name " + string + " spwRepWindowCentreGHZ: " + d6 + " SB RF(GHz) : " + d);
        object.setRepresentativeWindow(true);
    }

    private void setDynamicRangeAttributes(@NonNull Collection<Collection<SchedBlock>> collection, @NonNull SchedBlock schedBlock, @NonNull Optional<SchedBlock> optional) {
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sbToProcess is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("principalArray is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal() || scienceGoal.getObsProposal().isVLBIorPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SchedBlockPostProcessor.class).warning("Unable to determine if solar/VLBI: " + unknownEntityException.getMessage());
        }
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (schedBlock.isTP() || bl) {
            schedulingConstraints.setSpectralDynamicRange(0.0);
            schedulingConstraints.setDynamicRange(0.0);
            schedulingConstraints.setSpectralDynamicRangeBandwidth(Frequency.createFrequencyMHZ(0.0));
        } else {
            boolean bl2;
            boolean bl3 = bl2 = !scienceGoal.isStandAloneACA() && (schedBlock.is12mCompactArraySB() || schedBlock.isACA7mArraySB());
            if (bl2) {
                ExpectedPropertiesElements expectedPropertiesElements = scienceGoal.getConsolidatedExpectedProperties(SchedBlockWorker.createTargetParametersSBMap(optional.orElseThrow(WizardSBGenerationException::new)));
                this.scaleDRForSmallerArray(schedBlock, expectedPropertiesElements, collection);
                schedulingConstraints.setSpectralDynamicRangeBandwidth(Frequency.createFrequencyMHZ(expectedPropertiesElements.getBandwidthForSpectralDynamicRange().getContentInMHz()));
            } else {
                ExpectedPropertiesElements expectedPropertiesElements = scienceGoal.getConsolidatedExpectedProperties(SchedBlockWorker.createTargetParametersSBMap(schedBlock));
                schedulingConstraints.setSpectralDynamicRange(expectedPropertiesElements.getSpectralDynamicRange());
                schedulingConstraints.setDynamicRange(expectedPropertiesElements.getImagingDynamicRange());
                schedulingConstraints.setSpectralDynamicRangeBandwidth(Frequency.createFrequencyMHZ(expectedPropertiesElements.getBandwidthForSpectralDynamicRange().getContentInMHz()));
            }
        }
    }

    private void scaleDRForSmallerArray(@NonNull SchedBlock schedBlock, @NonNull ExpectedPropertiesElements expectedPropertiesElements, @NonNull Collection<Collection<SchedBlock>> collection) {
        double d;
        Sensitivity sensitivity;
        Target target2;
        SensitivityArrayCounterparts sensitivityArrayCounterparts;
        if (schedBlock == null) {
            throw new NullPointerException("sbToProcess is marked non-null but is null");
        }
        if (expectedPropertiesElements == null) {
            throw new NullPointerException("consolidatedExpectedProperties is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        TargetParameters targetParameters = expectedPropertiesElements.getTargetUsedForImagingDynamicRange();
        TargetParameters targetParameters2 = expectedPropertiesElements.getTargetUsedForSpectralDynamicRange();
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{targetParameters.getSourceName()}) || StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{targetParameters2.getSourceName()})) {
            throw new WizardSBGenerationException("A source has been defined in the field setup without a source name");
        }
        try {
            sensitivityArrayCounterparts = this.findSensitivityGoalForCorrespondingTargetInTM1SB(expectedPropertiesElements, collection);
        }
        catch (UnableToFindCounterPartSensitivityException unableToFindCounterPartSensitivityException) {
            Log.logger(SchedBlockPostProcessor.class).warning("Unable to scale dynamic range for the smaller array");
            return;
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        Optional<Target> optional = list.stream().filter(target -> target.getFieldSource().getSourceName().equals(targetParameters2.getSourceName())).findFirst();
        Optional<Target> optional2 = list.stream().filter(target -> target.getFieldSource().getSourceName().equals(targetParameters2.getSourceName())).findFirst();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (optional.isPresent()) {
            target2 = optional.get();
            sensitivity = target2.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new).getSensitivityGoal();
            d = expectedPropertiesElements.getSpectralDynamicRange() * sensitivityArrayCounterparts.getSpectralSensitivity().getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / sensitivity.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT);
            Log.logger(SchedBlockPostProcessor.class).fine("spectral DR is " + d + " using " + target2.getFieldSource().getSourceName() + " for array " + schedBlock.getSbGenerationContext().getSBType());
            schedulingConstraints.setSpectralDynamicRange(d);
        }
        if (optional2.isPresent()) {
            target2 = optional2.get();
            sensitivity = target2.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new).getSensitivityGoal();
            d = expectedPropertiesElements.getImagingDynamicRange() * sensitivityArrayCounterparts.getImagingSensitivity().getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / sensitivity.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT);
            Log.logger(SchedBlockPostProcessor.class).fine("imaging DR is " + d + " using " + target2.getFieldSource().getSourceName() + " for array " + schedBlock.getSbGenerationContext().getSBType());
            schedulingConstraints.setDynamicRange(d);
        }
    }

    private SensitivityArrayCounterparts findSensitivityGoalForCorrespondingTargetInTM1SB(@NonNull ExpectedPropertiesElements expectedPropertiesElements, @NonNull Collection<Collection<SchedBlock>> collection) throws UnableToFindCounterPartSensitivityException {
        Object object;
        Object object2;
        if (expectedPropertiesElements == null) {
            throw new NullPointerException("consolidatedExpectedProperties is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        TargetParameters targetParameters = expectedPropertiesElements.getTargetUsedForSpectralDynamicRange();
        Sensitivity sensitivity = null;
        block0: for (Collection<SchedBlock> object5 : collection) {
            for (Object object3 : object5) {
                if (!((SchedBlock)object3).is12mExtendedArraySB()) continue;
                Object object4 = ((SchedBlock)object3).getAllTargets(ScienceParameters.scienceParametersFilter);
                object2 = targetParameters.getSourceName();
                if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{object2})) {
                    throw new WizardSBGenerationException("A source name has not been defined in the field setup");
                }
                object = object4.stream().filter(arg_0 -> SchedBlockPostProcessor.lambda$findSensitivityGoalForCorrespondingTargetInTM1SB$6((String)object2, arg_0)).findFirst();
                if (!((Optional)object).isPresent()) continue;
                sensitivity = ((Target)((Optional)object).get()).getFirstScienceParameters().get().getSensitivityGoal();
                break block0;
            }
        }
        Object object7 = null;
        block2: for (Collection<SchedBlock> collection2 : collection) {
            for (Object object4 : collection2) {
                if (!((SchedBlock)object4).is12mExtendedArraySB()) continue;
                object2 = ((SchedBlock)object4).getAllTargets(ScienceParameters.scienceParametersFilter);
                object = targetParameters.getSourceName();
                if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{object})) {
                    throw new WizardSBGenerationException("A source name has not been defined in the field setup");
                }
                Optional<Target> optional = object2.stream().filter(arg_0 -> SchedBlockPostProcessor.lambda$findSensitivityGoalForCorrespondingTargetInTM1SB$6((String)object, arg_0)).findFirst();
                if (!optional.isPresent()) continue;
                object7 = optional.get().getFirstScienceParameters().get().getSensitivityGoal();
                break block2;
            }
        }
        if (object7 == null || sensitivity == null) {
            throw new UnableToFindCounterPartSensitivityException();
        }
        return new SensitivityArrayCounterparts((Sensitivity)((Object)object7), sensitivity);
    }

    private void removeUnusedP2Components(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        List<Target> list = schedBlock.getAllTargets(Optional.empty());
        List list2 = Stream.of(schedBlock.getSpectralSpec()).filter(spectralSpec -> list.stream().noneMatch(target -> target.getSpectralSpec().equals(spectralSpec))).collect(Collectors.toList());
        list2.stream().forEach(spectralSpec -> schedBlock.removeSpectralSpec((SpectralSpec)spectralSpec));
    }

    private void setupPolarizationCalibratorSubscanDurations(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        for (Target target : schedBlock.getTargets(ObsType.POLARIZATION)) {
            CalibrationTimerInterface calibrationTimerInterface = AbstractObservingParametersFactory.CalibrationTimerFactory.getCalibrationTimer(scienceGoal, target.getSpectralSpec(), ObsType.POLARIZATION, sBGenerationContext.getArray(), sBGenerationContext);
            PolarizationCalParameters polarizationCalParameters = target.getPolarizationCalParametersList()[0];
            polarizationCalParameters.setSubScanDuration(calibrationTimerInterface.getScanDuration(polarizationCalParameters.getDefaultIntegrationTime()));
        }
    }

    private void baseACA7mScienceParameterTimingsBasedOnTMTimings(SchedBlock schedBlock, ScienceGoal scienceGoal) throws TargetCache.TargetNotFoundException {
        Object object;
        Object object2;
        if (scienceGoal.isStandAloneACA()) {
            return;
        }
        if (Log.logger(SchedBlockWorker.class).fine()) {
            Time time = SchedBlockExpert.getTotalTOSForSB(schedBlock).getTime();
            Log.logger(SchedBlockWorker.class).fine("SB (start) total time for " + schedBlock.getName() + " is " + time);
        }
        boolean bl = scienceGoal.isUsing4bitCorrelatorModes();
        TargetCache targetCache = TargetCache.getInstance();
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        for (Object object3 : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            Object object4;
            object2 = object3.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new);
            if (hashSet.contains(object2)) continue;
            double d = schedBlock.getSbGenerationContext().getAntennaRelatedTOSTimeMultiplier();
            if (bl) {
                object4 = object2.getTwoBitTotalTMITOSTime().orElseThrow(WizardSBGenerationException::new);
                object2.setIntegrationTime((IntTimeSource)((Object)object4));
            } else {
                object4 = targetCache.getTarget((Target)object3, SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
                ScienceParameters scienceParameters = ((Target)object4).getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new);
                SchedBlock schedBlock2 = (SchedBlock)scienceParameters.getParent();
                int n = schedBlock2.getSchedBlockControl().getExecutionCount();
                IntTimeSource intTimeSource = (IntTimeSource)((IntTimeSource)scienceParameters.getIntegrationTime().multiply(d)).multiply(n);
                object2.setIntegrationTime(intTimeSource);
            }
            hashSet.add((ScienceParameters)((Object)object2));
        }
        if (Log.logger(SchedBlockWorker.class).fine()) {
            object = SchedBlockExpert.getTotalTOSForSB(schedBlock).getTime();
            Log.logger(SchedBlockWorker.class).fine("SB (1) total time for " + schedBlock.getName() + " is " + (Time)object);
        }
        try {
            Object object3;
            object = SchedBlockExpert.getInstance(scienceGoal);
            object3 = schedBlock.getSchedBlockControl();
            SchedBlockWorker.setupSchedBlockControl((SchedBlockExpert)object, (SchedBlockControl)((Object)object3), RequestedArray.SEVEN_M, schedBlock.getSbGenerationContext().getSchemaToUseForSBGeneration());
            if (Log.logger(SchedBlockWorker.class).fine()) {
                object2 = SchedBlockExpert.getTotalTOSForSB(schedBlock).getTime();
                Log.logger(SchedBlockWorker.class).fine("SB (2) total time for " + schedBlock.getName() + " is " + (Time)object2);
            }
            SchedBlockWorker.quantizeScienceIntegrationTimes(schedBlock, schedBlock.getSbGenerationContext().getSchemaToUseForSBGeneration());
        }
        catch (UnableToFindSolutionException | SourceNeverVisibleException | InvalidFrequencyException exception) {
            Log.logger(SchedBlockPostProcessor.class).warning("Unable to revise the ACA 7-m SB " + exception.getMessage());
            throw new WizardSBGenerationException(exception);
        }
        if (Log.logger(SchedBlockWorker.class).fine()) {
            object = SchedBlockExpert.getTotalTOSForSB(schedBlock).getTime();
            Log.logger(SchedBlockWorker.class).fine("SB (3) total time for " + schedBlock.getName() + " is " + (Time)object);
        }
    }

    private boolean isLongbaselineConfigurationScheduled(ScienceGoal scienceGoal, SchedBlock schedBlock, boolean bl, RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        boolean bl2 = false;
        if (requestedArray.equals((Object)RequestedArray.TWELVE_M) && !scienceGoal.isStandAloneACA() && !bl) {
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            if (scienceGoalConfigurations.isEmpty()) {
                throw new WizardSBGenerationException("Unable to determine configurations");
            }
            Optional<Configuration> optional = schedBlock.is12mCompactArraySB() ? ((ConfigurationSet)scienceGoalConfigurations.get(0)).getTM2Configuration() : ((ConfigurationSet)scienceGoalConfigurations.get(0)).getTM1Configuration();
            bl2 = Configuration.isLongBaselineConfiguration(optional.orElse(Configuration.NO_CONFIG));
        }
        return bl2;
    }

    private void quantizeParametersInInterferometricSBs(@NonNull SchedBlock schedBlock, @NonNull RequestedArray requestedArray, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, boolean bl) throws UnknownEntityException, InvalidObsProgramParametersException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("arrayRequested is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        boolean bl2 = bl;
        IntegerMosaicEnforcerInterface integerMosaicEnforcerInterface = IntegerMosaicEnforcerFactory.getIntegerMosaicEnforcer(bl2 ? IntegerMosaicEnforcerFactory.MosaicEnforcer.FIXED_SUBSCAN_MOSAIC_ENFORCER : IntegerMosaicEnforcerFactory.MosaicEnforcer.VARIABLE_SUBSCAN_MOSAIC_ENFORCER);
        if (!integerMosaicEnforcerInterface.enforceCompleteMosaicScansPerSBExec(schedBlock, requestedArray, enumSet)) {
            try {
                SchedBlockWorker.quantizeIntegrationTimesOnSourceBySubscanDuration(schedBlock, enumSet);
            }
            catch (SchedBlockWorker.UnableToQuantizeIntegrationTimeException unableToQuantizeIntegrationTimeException) {
                Log.logger(ScienceGoalSchedBlockGenerator.class).fine("Unable to quantize integration time");
            }
        }
    }

    private void setupNonSolarTPSB(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock2, List<ObsUnitSet> list, @NonNull ObservingTimeCalculator observingTimeCalculator) throws UnknownEntityException, Exception {
        Time time;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock2 == null) {
            throw new NullPointerException("tpSB is marked non-null but is null");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("observingTimeCalculator is marked non-null but is null");
        }
        if (scienceGoal.isSolarScienceGoal()) {
            throw new IllegalArgumentException("Logic error: this method should not be run with a solar science goal");
        }
        try {
            time = observingTimeCalculator.getTotalArraySBScienceIntegrationTime(true, Array.ARRAY_7M);
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + throwable.getMessage());
            throw new WizardSBGenerationException(throwable);
        }
        TotalPowerIntegrationTimeCalculator.adjustSourceRasterTimes(schedBlock2);
        SBGeneratorTemplate.enforceMinimumOnSourceTimePerSB(schedBlock2);
        List<SchedBlock> list2 = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(list2, list);
        list2 = list2.stream().filter(schedBlock -> schedBlock.isACA7mArraySB()).collect(Collectors.toList());
        assert (list2.size() == 1);
        int n = TotalPowerIntegrationTimeCalculator.getTPSBExecutionCount(schedBlock2, time, scienceGoal, list, list2.get(0));
        schedBlock2.getSchedBlockControl().setExecutionCount(n);
    }

    private void copyExecutiveSharesIntoSB(ScienceGoal scienceGoal, SchedBlock schedBlock) {
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            this.copyExecutiveSharesIntoSBs(schedBlock, obsProposal);
        }
        catch (UnknownEntityException unknownEntityException) {
            String string = "Unable to copy across executive fractions to SB : " + unknownEntityException.getMessage();
            Log.logger(ScienceGoalSchedBlockGenerator.class).warning(string);
            throw new WizardSBGenerationException(string);
        }
        this.copyPhase1ParametersToSB(schedBlock, scienceGoal);
    }

    public void setEstimatedTimeForSBInOUS(SchedBlock schedBlock, ObservingTimeCalculator observingTimeCalculator, RequestedArray requestedArray) {
        Time time = null;
        try {
            time = schedBlock.isTotalPowerAmpcalSB() ? Time.createTime((double)45.0, (String)Time.UNIT_MIN) : observingTimeCalculator.getTotalRequestedTime(requestedArray.getArray(), true, schedBlock.is12mCompactArraySB(), true);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + invalidObsProgramParametersException.getMessage());
            throw new WizardSBGenerationException(invalidObsProgramParametersException.getMessage());
        }
        schedBlock.getObsUnitControl().getEstimatedExecutionTime().setContentAndUnit((ValueUnitPair)time.convertToFriendlyUnit());
    }

    private void copyPhase1ParametersToSB(SchedBlock schedBlock, ScienceGoal scienceGoal) {
        Object object;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (schedBlock.getSbGenerationContext().isVLBI()) {
            schedulingConstraints.setScienceGoalLargestAngularScale(Angle.createAngle((double)1.0, (String)Angle.UNIT_MAS));
            schedulingConstraints.setScienceGoalDesiredResolution(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        } else {
            object = Angle.createAngle((double)performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
            schedulingConstraints.setScienceGoalLargestAngularScale((Angle)((Object)object));
            Angle angle = Angle.createAngle((double)performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
            schedulingConstraints.setScienceGoalDesiredResolution(angle);
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            schedulingConstraints.addNominalConfiguration("TP");
        } else if (schedBlock.isACA7mArraySB()) {
            schedulingConstraints.addNominalConfiguration("7M");
        } else if (schedBlock.is12mCompactArraySB() || schedBlock.is12mExtendedArraySB()) {
            object = null;
            try {
                object = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                String string = "Unable to determine configurations : " + invalidObsProgramParametersException.getMessage();
                Log.logger(ScienceGoalSchedBlockGenerator.class).info(string);
                throw new WizardSBGenerationException(string);
            }
            assert (object != null);
            Collections.sort(object);
            if (schedBlock.is12mCompactArraySB()) {
                object.stream().forEach(configurationSet -> configurationSet.getTM2Configuration().ifPresent(configuration -> schedulingConstraints.addNominalConfiguration(configuration.getName())));
            } else {
                object.stream().forEach(configurationSet -> configurationSet.getTM1Configuration().ifPresent(configuration -> schedulingConstraints.addNominalConfiguration(configuration.getName())));
            }
            double d = Configuration.determineAverageDeclination(scienceGoal.getTargetParameters()).getDegs();
            schedulingConstraints.setMaxAllowedBeamAxialRatio(SchedulingConstraints.calculateMaxExpectedAxialRatio(d));
        } else {
            throw new WizardSBGenerationException("Unable to determine type of SB");
        }
    }

    private void copyExecutiveSharesIntoSBs(@NonNull SchedBlock schedBlock, @NonNull ObsProposal obsProposal) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        ProposalFeedback proposalFeedback = obsProposal.getProposalFeedback();
        if (proposalFeedback != null) {
            TimeAllocationBreakdown timeAllocationBreakdown = schedBlock.getTimeAllocationBreakdown();
            timeAllocationBreakdown.clearExecutiveFraction();
            for (String string : ExecutiveFraction.getKnownNameList()) {
                ExecutiveFraction executiveFraction = proposalFeedback.getTimeAllocationBreakdown().getExecutiveFraction(string);
                timeAllocationBreakdown.addExecutiveFraction(executiveFraction.deepCopy());
            }
        }
    }

    public static void reviseCheckSourceObservingParameters(@NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) throws SchedBlock.UnableToFindParentScienceGoalException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        boolean bl = CheckSourceIntermediateTarget.isLongBaselineInBandChecksourceCustomisationRequired(sBGenerationContext);
        double d = bl ? 4.0 : 3.0;
        CheckSourceIntermediateTarget.setCheckSourceCycleTimes(schedBlock, d);
    }

    private ObsUnitSet findOUS(ObsUnitSet obsUnitSet, SBGeneratorTemplate.SchedBlockType schedBlockType) throws UnknownEntityException {
        ObsUnitSetComponent obsUnitSetComponent2;
        if (SBGeneratorTemplate.SchedBlockType.TPSCIENCE.equals((Object)schedBlockType)) {
            throw new RuntimeException("There can be multiple TP science SBs: this method cannot support that");
        }
        ObsUnitSet obsUnitSet2 = null;
        for (ObsUnitSetComponent obsUnitSetComponent2 : obsUnitSet.getSchedBlock()) {
            if (!obsUnitSetComponent2.getSbGenerationContext().getSBType().equals((Object)schedBlockType)) continue;
            return obsUnitSet;
        }
        ObsUnitSetComponent[] obsUnitSetComponentArray = obsUnitSet.getObsUnitSet();
        int n = obsUnitSetComponentArray.length;
        for (int i = 0; i < n && (obsUnitSet2 = this.findOUS((ObsUnitSet)(obsUnitSetComponent2 = obsUnitSetComponentArray[i]), schedBlockType)) == null; ++i) {
        }
        return obsUnitSet2;
    }

    void setCorrelatorTimingsToTDMDefaults() {
        if (this.piDefinedScienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (this.rootOUS == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
        }
        SpectralSetupParameters spectralSetupParameters = this.piDefinedScienceGoal.getSpectralSetupParameters();
        if (!spectralSetupParameters.isSpectralLine()) {
            return;
        }
        boolean bl = true;
        for (ScienceSpectralWindow targetArray : spectralSetupParameters.getScienceSpectralWindow()) {
            if (targetArray.isModeFilterTDM()) continue;
            bl = false;
            break;
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            SchedBlockWorker.findSBsUnderOUS((List<SchedBlock>)arrayList, this.rootOUS);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SchedBlock schedBlock = (SchedBlock)iterator.next();
                if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) continue;
                for (Target target : schedBlock.getTarget()) {
                    if (!target.hasScienceParameters()) continue;
                    SpectralSpecFactory.calculateTDMTimeAndDurations(true, target.getSpectralSpec(), schedBlock.getSbGenerationContext());
                }
            }
        }
    }

    private void walshSwitching90DegreePostProcessing(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        if (!sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching()) {
            return;
        }
        Walsh90DegConfiguratorFactory.Walsh90DegSpectralSpecConfigurator walsh90DegSpectralSpecConfigurator = null;
        HashSet<SpectralSpec> hashSet = new HashSet<SpectralSpec>();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            if (!spectralSpec.getAbstractCorrelatorConfiguration().getEnable90DegreeWalshFunction()) continue;
            hashSet.add(spectralSpec);
        }
        for (Target target : schedBlock.getAllTargets(Optional.empty())) {
            if (walsh90DegSpectralSpecConfigurator == null) {
                walsh90DegSpectralSpecConfigurator = Walsh90DegConfiguratorFactory.getConfigurator(target.getSpectralSpec().getAbstractCorrelatorConfiguration());
            }
            walsh90DegSpectralSpecConfigurator.configureObservingParameters(target, sBGenerationContext);
            walsh90DegSpectralSpecConfigurator.setupRepresentativeWindows(sBGenerationContext, target.getSpectralSpec());
            if (!hashSet.contains(target.getSpectralSpec())) continue;
            walsh90DegSpectralSpecConfigurator.configureFieldSource(target, sBGenerationContext);
        }
    }

    private void setupTPSpectralScanSBs(@NonNull SchedBlock schedBlock) {
        Object object;
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (!schedBlock.isTotalPowerScienceSB() || !schedBlock.getSbGenerationContext().getGoal().isSpectralScan()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
            if (!fieldPattern.isRectanglePattern()) continue;
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
            int n = rectanglePattern.getRowCount();
            arrayList.addAll(Stream.of(target.getScienceParametersList()).map(scienceParameters -> (int)Math.round(scienceParameters.getIntegrationTime().getSecs() / (scienceParameters.getSubScanDuration().getSecs() * (double)n))).collect(Collectors.toList()));
        }
        if (arrayList.stream().distinct().count() != 1L) {
            object = "The nTuningCycle varies in the SB " + schedBlock.getName();
            Log.logger(SchedBlockPostProcessor.class).warning(object);
            throw new WizardSBGenerationException((String)object);
        }
        object = KeywordValue.createKeywordValue();
        object.setKeyword("nTuningCycle");
        object.setValue(Integer.toString((Integer)arrayList.get(0)));
        schedBlock.addExpertParameter((KeywordValue)((Object)object));
    }

    private SchedBlockPostProcessor(Builder builder) {
        this.isSBGenerationUserInitiated = builder.isSBGenerationUserInitiated;
        this.piDefinedScienceGoal = builder.userDefinedScienceGoal;
        this.rootOUS = builder.rootOUS;
        this.schedblockExecutionTimeAdjuster = new SchedblockExecutionTimeAdjuster(this.logger);
    }

    private static /* synthetic */ boolean lambda$findSensitivityGoalForCorrespondingTargetInTM1SB$6(String string, Target target) {
        return target.getFieldSource().getSourceName().equals(string);
    }

    public static class Builder {
        private boolean isSBGenerationUserInitiated;
        private ScienceGoal userDefinedScienceGoal;
        private ObsUnitSet rootOUS;

        public Builder isSBGenerationUserInitiated(boolean bl) {
            this.isSBGenerationUserInitiated = bl;
            return this;
        }

        public Builder userDefinedScienceGoal(ScienceGoal scienceGoal) {
            this.userDefinedScienceGoal = scienceGoal;
            return this;
        }

        public Builder rootOUS(ObsUnitSet obsUnitSet) {
            this.rootOUS = obsUnitSet;
            return this;
        }

        public SchedBlockPostProcessor build() {
            return new SchedBlockPostProcessor(this);
        }
    }

    public class UnableToFindCounterPartSensitivityException
    extends Exception {
    }

    private static class SensitivityArrayCounterparts {
        private Sensitivity imagingSensitivity;
        private Sensitivity spectralSensitivity;

        public SensitivityArrayCounterparts(Sensitivity sensitivity, Sensitivity sensitivity2) {
            this.imagingSensitivity = sensitivity;
            this.spectralSensitivity = sensitivity2;
        }

        public Sensitivity getImagingSensitivity() {
            return this.imagingSensitivity;
        }

        public Sensitivity getSpectralSensitivity() {
            return this.spectralSensitivity;
        }

        public void setImagingSensitivity(Sensitivity sensitivity) {
            this.imagingSensitivity = sensitivity;
        }

        public void setSpectralSensitivity(Sensitivity sensitivity) {
            this.spectralSensitivity = sensitivity;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SensitivityArrayCounterparts)) {
                return false;
            }
            SensitivityArrayCounterparts sensitivityArrayCounterparts = (SensitivityArrayCounterparts)object;
            if (!sensitivityArrayCounterparts.canEqual(this)) {
                return false;
            }
            Sensitivity sensitivity = this.getImagingSensitivity();
            Sensitivity sensitivity2 = sensitivityArrayCounterparts.getImagingSensitivity();
            if (sensitivity == null ? sensitivity2 != null : !((Object)((Object)sensitivity)).equals((Object)sensitivity2)) {
                return false;
            }
            Sensitivity sensitivity3 = this.getSpectralSensitivity();
            Sensitivity sensitivity4 = sensitivityArrayCounterparts.getSpectralSensitivity();
            return !(sensitivity3 == null ? sensitivity4 != null : !((Object)((Object)sensitivity3)).equals((Object)sensitivity4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SensitivityArrayCounterparts;
        }

        public int hashCode() {
            int n = 1;
            Sensitivity sensitivity = this.getImagingSensitivity();
            n = n * 59 + (sensitivity == null ? 43 : ((Object)((Object)sensitivity)).hashCode());
            Sensitivity sensitivity2 = this.getSpectralSensitivity();
            n = n * 59 + (sensitivity2 == null ? 43 : ((Object)((Object)sensitivity2)).hashCode());
            return n;
        }

        public String toString() {
            return "SchedBlockPostProcessor.SensitivityArrayCounterparts(imagingSensitivity=" + this.getImagingSensitivity() + ", spectralSensitivity=" + this.getSpectralSensitivity() + ")";
        }
    }
}

