/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.valdef.schedblock.SpectralSpecValidator;
import alma.obsprep.services.experts.ReceiverExpert;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class BaseBandDeployer {
    private final Set<ReceiverBand> B4B5 = Set.of(ReceiverBand.getReceiverBand(4), ReceiverBand.getReceiverBand(5));
    protected BaseBandList basebands;
    protected SpectralSetupParameters ssp;
    private static final String DEFAULTERRORMESSAGE = "Can not allocate these spectral windows in one receiver band.";
    public static final Frequency BASEBANDWIDTH = Frequency.createFrequencyGHZ(2.0);
    public static final double HALFBASEBANDWITHGHZ = ((Frequency)BASEBANDWIDTH.half(true)).getContentInGHz();
    public static final Frequency FREQ_OFFSET = Frequency.createFrequencyGHZ(1.0E-10);
    protected static final boolean EFFECTIVE = true;
    protected static final boolean NOMINAL = false;
    protected Integer spectralScanTuningIndex = 0;
    public static final Frequency dummyFrequency = Frequency.createFrequencyGHZ(-1.0);

    public BaseBandDeployer(@NonNull SpectralSetupParameters spectralSetupParameters, Integer n) throws BaseBandNotDeployableException {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        this.ssp = spectralSetupParameters;
        this.spectralScanTuningIndex = n;
        if (!spectralSetupParameters.isSpectralScan()) {
            throw new BaseBandNotDeployableException("Spectral setup should be a spectral scan");
        }
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
        this.basebands = new BaseBandList(velocity);
        SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        try {
            spectralScanTunings = spectralScan.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            throw new BaseBandNotDeployableException(unableToFindSolutionException);
        }
        if (n > spectralScanTunings.getNumberOfTunings()) {
            throw new BaseBandNotDeployableException("Tuning index in the spectral scan is out of range");
        }
        try {
            for (Frequency frequency : spectralScanTunings.getTuning(n)) {
                BaseBand baseBand = new BaseBand();
                Frequency frequency2 = frequency;
                UserFrequency userFrequency = spectralScan.getBandWidth();
                baseBand.addSpectralWindow(new SpectralWindow(frequency2, (Frequency)((Object)userFrequency), velocity));
                if (((Frequency)((Object)baseBand.getRange(true).range())).isGreaterThan((AbstractDoubleWithUnit)BASEBANDWIDTH)) {
                    String string = "The spectral window range exceeds the baseband width : " + baseBand.getRange(true).range();
                    throw new BaseBandNotDeployableException(string);
                }
                baseBand.setCenter();
                this.basebands.add(baseBand);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            throw new BaseBandNotDeployableException(spectralScanTuningException);
        }
    }

    public BaseBandDeployer(@NonNull SpectralSetupParameters spectralSetupParameters) throws BaseBandNotDeployableException {
        Object object;
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindow();
        boolean bl = VLBIExpert.isScienceGoalLegalVLBISpectralLine(spectralSetupParameters.getScienceGoal());
        this.ssp = spectralSetupParameters;
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
        try {
            if (!(spectralSetupParameters.isDerivedSSP() || spectralSetupParameters.isSingleContinuum() && spectralSetupParameters.getScienceSpectralWindow(0).getIsSkyFrequency())) {
                velocity = spectralSetupParameters.getSourceVelocity();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new BaseBandNotDeployableException();
        }
        if (spectralSetupParameters.getScienceSpectralWindowCount() == 0) {
            throw new BaseBandNotDeployableException();
        }
        if (!spectralSetupParameters.getScienceSpectralWindow(0).getIsSkyFrequency() && !spectralSetupParameters.isDerivedForDGCCalibrator()) {
            velocity = spectralSetupParameters.getSourceVelocity();
        }
        this.basebands = new BaseBandList(velocity);
        boolean bl2 = false;
        try {
            if (spectralSetupParameters.getScienceGoal() != null) {
                object = spectralSetupParameters.getScienceGoal().getObsProposal();
                if (object == null) {
                    throw new BaseBandNotDeployableException("Unable to determine if this is a VLBI project");
                }
                bl2 = object.isVLBIorPhasedArray();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new BaseBandNotDeployableException("Unable to determine if this is a VLBI project");
        }
        if (spectralSetupParameters.isSingleContinuum() && !bl2) {
            object = spectralSetupParameters.getScienceSpectralWindow(0);
            Frequency frequency = Frequency.createFrequencyGHZ(2.0);
            if (object == null) {
                throw new BaseBandNotDeployableException("At least 1 spectral window is needed.");
            }
            Frequency frequency2 = spectralSetupParameters.getSingleContinuumFrequency();
            Frequency frequency3 = object.getIsSkyFrequency() || spectralSetupParameters.isDerivedForDGCCalibrator() ? frequency2 : velocity.dopplerShift(frequency2);
            SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(frequency3);
            Range<Frequency>[] rangeArray = null;
            try {
                rangeArray = singleContinuumExpert.singleContinuumBasebands(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BaseBandNotDeployableException(illegalArgumentException);
            }
            for (Range<Frequency> range : rangeArray) {
                BaseBand baseBand = new BaseBand();
                Frequency frequency4 = range.mid();
                baseBand.setCenterRest(frequency4);
                baseBand.addNewSpectralWindow(frequency4, frequency);
                this.basebands.add(baseBand);
            }
        } else {
            try {
                object = spectralSetupParameters.getGroupIndexSet();
            }
            catch (InvalidGroupIndexException invalidGroupIndexException) {
                throw new BaseBandNotDeployableException(invalidGroupIndexException);
            }
            if (object.isEmpty()) {
                throw new BaseBandNotDeployableException("At least 1 spectral window is needed.");
            }
            if (object.contains(-1) && object.size() > 1) {
                throw new BaseBandNotDeployableException("ScienceSpectralWindow has an invalid group index : -1");
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Integer n = (Integer)iterator.next();
                BaseBand baseBand = new BaseBand();
                baseBand.setGroupIndex(n);
                for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
                    if (scienceSpectralWindow.getGroupIndex() != n.intValue()) continue;
                    Frequency frequency = scienceSpectralWindow.getCenterFrequency();
                    object2 = scienceSpectralWindow.getBandWidth();
                    baseBand.addSpectralWindow(new SpectralWindow(frequency, (Frequency)((Object)object2), bl ? Velocity.createVelocity() : velocity));
                }
                FrequencyRange frequencyRange = baseBand.getRange(true);
                BigDecimal bigDecimal = BigDecimal.valueOf(((Frequency)((Object)frequencyRange.min())).getContentInGHz());
                BigDecimal bigDecimal2 = BigDecimal.valueOf(((Frequency)((Object)frequencyRange.max())).getContentInGHz());
                double d = bigDecimal2.subtract(bigDecimal, new MathContext(14)).doubleValue();
                if (d > BASEBANDWIDTH.getContentInGHz()) {
                    object2 = "The spectral window range exceeds the baseband width : " + frequencyRange.range();
                    throw new BaseBandNotDeployableException((String)object2);
                }
                baseBand.setCenter();
                this.basebands.add(baseBand);
            }
        }
    }

    BaseBandList createBaseBandList(Velocity velocity) {
        return new BaseBandList(velocity);
    }

    public boolean isDeployable(boolean bl) throws BaseBandNotDeployableException {
        for (ReceiverBand receiverBand : this.getSuitableReceiverSet()) {
            if (!this.isDeployable(receiverBand, bl)) continue;
            return true;
        }
        return false;
    }

    public Optional<ReceiverBand> getReceiverBand(boolean bl) throws BaseBandNotDeployableException {
        Set<ReceiverBand> set = this.getSuitableReceiverSet(bl);
        if (set.containsAll(this.B4B5)) {
            return Optional.of(ReceiverBand.getReceiverBand(5));
        }
        for (ReceiverBand receiverBand : set) {
            if (!this.isDeployable(receiverBand, bl)) continue;
            return Optional.of(receiverBand);
        }
        return Optional.empty();
    }

    private boolean isDeployable(@NonNull ReceiverBand receiverBand, boolean bl) {
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax() * 2.0);
        Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getIFMin() * 2.0);
        FrequencyRange frequencyRange = this.basebands.getWholeRange(bl);
        Frequency frequency4 = (Frequency)((Object)frequencyRange.range());
        if (!receiverBand.getRFRange().contains(frequencyRange)) {
            return false;
        }
        if (frequency4.isGreaterThan((AbstractDoubleWithUnit)frequency2)) {
            return false;
        }
        if (frequency4.isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
            return true;
        }
        if (receiverBand.getReceiverType() == ReceiverType.SSB) {
            return false;
        }
        FrequencyRange frequencyRange2 = this.basebands.basebandWidestFrequencyGap(bl);
        if (frequencyRange2 == null) {
            return false;
        }
        if (((Frequency)((Object)frequencyRange2.range())).isLessThan((AbstractDoubleWithUnit)frequency3)) {
            return false;
        }
        FrequencyRange frequencyRange3 = this.basebands.getLSBBasebands().getWholeRange(bl);
        FrequencyRange frequencyRange4 = this.basebands.getUSBBasebands().getWholeRange(bl);
        if (((Frequency)((Object)frequencyRange3.range())).isGreaterThan((AbstractDoubleWithUnit)frequency) || ((Frequency)((Object)frequencyRange4.range())).isGreaterThan((AbstractDoubleWithUnit)frequency)) {
            return false;
        }
        if (receiverBand.getReceiverType().equals((Object)ReceiverType.TSB)) {
            BaseBandList baseBandList = this.basebands.getLSBBasebands();
            BaseBandList baseBandList2 = this.basebands.getUSBBasebands();
            if (baseBandList.size() == 3 && baseBandList2.size() == 1 || baseBandList.size() == 1 && baseBandList2.size() == 3) {
                return false;
            }
        }
        return this.testLO1Constraints(receiverBand, bl);
    }

    private boolean testLO1UpperConstraints(@NonNull ReceiverBand receiverBand, boolean bl) {
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getHardRFRange().max())).minus((AbstractDoubleWithUnit)frequency2)).minus((AbstractDoubleWithUnit)frequency);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(bl);
        return ((Frequency)((Object)frequencyRange.min())).isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency3);
    }

    private boolean testLO1LowerConstraints(@NonNull ReceiverBand receiverBand, boolean bl) {
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getHardRFRange().min())).plus((AbstractDoubleWithUnit)frequency2, true)).plus((AbstractDoubleWithUnit)frequency, true);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(bl);
        return ((Frequency)((Object)frequencyRange.max())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency3);
    }

    private boolean testLO1Constraints(ReceiverBand receiverBand, boolean bl) {
        return this.testLO1UpperConstraints(receiverBand, bl) && this.testLO1LowerConstraints(receiverBand, bl);
    }

    private Set<ReceiverBand> getSuitableReceiverSet(boolean bl) throws BaseBandNotDeployableException {
        if (this.basebands.isEmpty()) {
            throw new BaseBandNotDeployableException("Ranges must have at least one element.");
        }
        FrequencyRange frequencyRange = this.basebands.getWholeRange(bl);
        return ReceiverExpert.getInstance().getSuitableReceiverSet(frequencyRange);
    }

    private Set<ReceiverBand> getSuitableReceiverSet() throws BaseBandNotDeployableException {
        return this.getSuitableReceiverSet(true);
    }

    private ReceiverBand getOneSuitableReceiverBand() throws BaseBandNotDeployableException {
        ReceiverBand receiverBand;
        Set<ReceiverBand> set;
        Set<ReceiverBand> set2 = this.getSuitableReceiverSet();
        if (set2.isEmpty()) {
            throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
        }
        Set<ReceiverBand> set3 = set = ReceiverBand.getReceiverBand(2) != null ? Set.of(ReceiverBand.getReceiverBand(3), ReceiverBand.getReceiverBand(2)) : Set.of(ReceiverBand.getReceiverBand(3));
        if (set.equals(set2)) {
            receiverBand = ReceiverBand.getReceiverBand(FrequencySetup.RECEIVERBAND_ALMA_RB_03);
        } else if (this.B4B5.equals(set2)) {
            receiverBand = this.ssp.getReceiverBand();
            if (receiverBand == null) {
                throw new BaseBandNotDeployableException("Unable to resolve B4/B5 overlap");
            }
        } else {
            receiverBand = set2.toArray(new ReceiverBand[1])[0];
        }
        return receiverBand;
    }

    public Frequency[] getAdjustedBaseBandCenterFrequenciesRest() throws BaseBandNotDeployableException {
        return this.getAdjustedBaseBandCenterFrequencies(ObservedFrame.Rest);
    }

    public Frequency[] getAdjustedBaseBandCenterFrequenciesSky() throws BaseBandNotDeployableException {
        return this.getAdjustedBaseBandCenterFrequencies(ObservedFrame.Sky);
    }

    public Frequency[] getAdjustedBaseBandCenterFrequencies(@NonNull ObservedFrame observedFrame) throws BaseBandNotDeployableException {
        if (observedFrame == null) {
            throw new NullPointerException("observedFrame is marked non-null but is null");
        }
        if (this.isDeployable(false)) {
            return this.relabelling(observedFrame);
        }
        if (!this.isDeployable(true)) {
            throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
        }
        ReceiverBand receiverBand = this.getOneSuitableReceiverBand();
        for (BaseBand baseBand : this.basebands) {
            if (receiverBand.getRFMax() <= ((Frequency)((Object)baseBand.max())).getContentInGHz()) {
                baseBand.setCenterSky(Frequency.createFrequencyGHZ(receiverBand.getRFMax() - 1.0 - 1.0E-9));
            }
            if (!(receiverBand.getRFMin() >= ((Frequency)((Object)baseBand.min())).getContentInGHz())) continue;
            baseBand.setCenterSky(Frequency.createFrequencyGHZ(receiverBand.getRFMin() + 1.0 + 1.0E-9));
        }
        if (this.isDeployable(false)) {
            return this.relabelling(observedFrame);
        }
        switch (receiverBand.getReceiverType()) {
            case SSB: {
                this.adjustSSB(receiverBand);
                this.relocateBBWhenSPWsInfringeBBEdges();
                break;
            }
            case TSB: 
            case DSB: {
                this.adjustTSB(receiverBand);
                this.relocateBBWhenSPWsInfringeBBEdges();
                break;
            }
            default: {
                throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
            }
        }
        if (!this.isDeployable(false)) {
            throw new BaseBandNotDeployableException("Unexpected failure: configuration failed");
        }
        return this.relabelling(observedFrame);
    }

    private void relocateBBWhenSPWsInfringeBBEdges() {
        boolean bl = false;
        Map<BaseBand, Frequency> map = this.basebands.stream().collect(Collectors.toMap(baseBand -> baseBand, baseBand -> baseBand.getCenterSky().deepCopy()));
        block7: for (BaseBand baseBand2 : this.basebands) {
            switch (this.isSPWWithin30MHzOfBBEdge(baseBand2)) {
                case HI_BB_EDGE_INFRINGEMENT: {
                    baseBand2.setCenterSky((Frequency)baseBand2.getCenterSky().plus((AbstractDoubleWithUnit)SpectralSpecValidator.BASEBAND_EDGE_MARGIN));
                    bl = true;
                    continue block7;
                }
                case LOW_BB_EDGE_INFRINGEMENT: {
                    baseBand2.setCenterSky((Frequency)baseBand2.getCenterSky().minus((AbstractDoubleWithUnit)SpectralSpecValidator.BASEBAND_EDGE_MARGIN));
                    bl = true;
                    continue block7;
                }
                case NO_INFRINGEMENT: {
                    continue block7;
                }
            }
            throw new RuntimeException("Unknown BBInfringementStateEnum encountered");
        }
        boolean bl2 = false;
        try {
            bl2 = this.isDeployable(false);
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            Log.logger(BaseBandDeployer.class).warning("Unable to shift the basebands so that its SPWs are not on the band edges");
            bl2 = false;
        }
        if (bl && !bl2) {
            map.keySet().stream().forEach(baseBand -> baseBand.setCenterSky((Frequency)((Object)((Object)map.get(baseBand)))));
        }
    }

    private Frequency[] relabelling(@NonNull ObservedFrame observedFrame) throws BaseBandNotDeployableException {
        int n;
        if (observedFrame == null) {
            throw new NullPointerException("observedFrame is marked non-null but is null");
        }
        boolean bl = observedFrame.equals((Object)ObservedFrame.Rest);
        Frequency[] frequencyArray = bl ? this.basebands.getCenterFrequenciesRest() : this.basebands.getCenterFrequenciesSky();
        Frequency[] frequencyArray2 = this.basebands.getCenterFrequenciesSky();
        ReceiverBand receiverBand = this.getOneSuitableReceiverBand();
        if (!receiverBand.getReceiverType().equals((Object)ReceiverType.TSB)) {
            return frequencyArray;
        }
        FrequencyRange frequencyRange = this.basebands.getWholeRange(false);
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        if (frequency.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.range())))) {
            return frequencyArray;
        }
        Frequency frequency2 = (Frequency)((Object)frequencyRange.mid());
        int n2 = this.basebands.size();
        Frequency[] frequencyArray3 = new Frequency[n2];
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            frequencyArray3[n] = frequencyArray[n];
            blArray[n] = frequencyArray2[n].isLessThan((AbstractDoubleWithUnit)frequency2);
        }
        switch (n2) {
            case 1: {
                return frequencyArray;
            }
            case 2: {
                if (blArray[0] == blArray[1]) {
                    return frequencyArray;
                }
                return new Frequency[]{frequencyArray3[0], dummyFrequency, frequencyArray3[1]};
            }
            case 3: {
                if (blArray[0] == blArray[1]) {
                    return frequencyArray;
                }
                if (blArray[0] == blArray[2]) {
                    boolean bl2;
                    Optional<BaseBand> optional = this.basebands.stream().filter(baseBand -> baseBand.getGroupIndex().equals(2)).findFirst();
                    Optional<BaseBand> optional2 = this.basebands.stream().filter(baseBand -> baseBand.getGroupIndex().equals(3)).findFirst();
                    boolean bl3 = bl2 = optional2.isPresent() && optional.isPresent();
                    if (bl2 && optional2.get().getCenterSky().isLessThan((AbstractDoubleWithUnit)optional.get().getCenterSky())) {
                        this.ssp.swapGroupIndex(1, 3);
                    } else {
                        this.ssp.swapGroupIndex(1, 2);
                    }
                    return new Frequency[]{frequencyArray3[0], frequencyArray3[2], frequencyArray3[1]};
                }
                return new Frequency[]{frequencyArray3[0], dummyFrequency, frequencyArray3[1], frequencyArray3[2]};
            }
            case 4: {
                n = 0;
                for (boolean bl4 : blArray) {
                    if (!bl4) continue;
                    ++n;
                }
                switch (n) {
                    case 0: 
                    case 4: {
                        return frequencyArray;
                    }
                    case 1: 
                    case 3: {
                        throw new BaseBandNotDeployableException("Basebands pairs 0/1 and 2/3 must use the same sideband within the pair");
                    }
                    case 2: {
                        if (blArray[0] == blArray[1]) {
                            return frequencyArray;
                        }
                        if (blArray[0] == blArray[2]) {
                            this.ssp.swapGroupIndex(1, 2);
                            return new Frequency[]{frequencyArray3[0], frequencyArray3[2], frequencyArray3[1], frequencyArray3[3]};
                        }
                        this.ssp.swapGroupIndex(1, 3);
                        return new Frequency[]{frequencyArray3[0], frequencyArray3[3], frequencyArray3[1], frequencyArray3[2]};
                    }
                }
                throw new BaseBandNotDeployableException("Unexpected error");
            }
        }
        throw new BaseBandNotDeployableException("Unexpected error");
    }

    private void adjustSSB(@NonNull ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        this.clipRange(receiverBand);
    }

    private void adjustTSB(@NonNull ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        BaseBandList baseBandList;
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax() * 2.0);
        Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getIFMin() * 2.0);
        FrequencyRange frequencyRange = this.basebands.getWholeRange(true);
        Frequency frequency4 = (Frequency)((Object)frequencyRange.range());
        if (frequency4.isLessThan((AbstractDoubleWithUnit)frequency)) {
            this.clipRange(receiverBand);
            return;
        }
        BaseBandList baseBandList2 = this.basebands.getLSBBasebands();
        BaseBandList baseBandList3 = this.basebands.getUSBBasebands();
        if (receiverBand.getReceiverType().equals((Object)ReceiverType.TSB) && (baseBandList2.size() == 3 && baseBandList3.size() == 1 || baseBandList2.size() == 1 && baseBandList3.size() == 3)) {
            throw new BaseBandNotDeployableException("Can not allocate 3 bandbands to one sideband and 1 to the other.");
        }
        BaseBandList baseBandList4 = this.basebands.getLSBBasebands();
        if (((Frequency)((Object)baseBandList4.getWholeRange(false).range())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
            this.clipRange(receiverBand, baseBandList4, frequency);
        }
        if (((Frequency)((Object)(baseBandList = this.basebands.getUSBBasebands()).getWholeRange(false).range())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
            this.clipRange(receiverBand, baseBandList, frequency);
        }
        if (this.isDeployable(false)) {
            return;
        }
        if (((Frequency)((Object)this.basebands.getWholeRange(false).range())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency2)) {
            this.clipOutside(receiverBand);
        }
        if (this.isDeployable(false)) {
            return;
        }
        if (((Frequency)((Object)this.basebands.basebandWidestFrequencyGap(false).range())).isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency3)) {
            this.clipInside(receiverBand);
        }
        if (this.isDeployable(false)) {
            return;
        }
        if (!this.testLO1UpperConstraints(receiverBand, false)) {
            this.clipLO1UpperConstraints(receiverBand);
        } else if (!this.testLO1LowerConstraints(receiverBand, false)) {
            this.clipLO1LowerConstraints(receiverBand);
        }
        if (this.isDeployable(false)) {
            return;
        }
        throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
    }

    private void clipRange(@NonNull ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        this.clipRange(receiverBand, this.basebands, frequency);
    }

    private void clipRange(@NonNull ReceiverBand receiverBand, @NonNull BaseBandList baseBandList, @NonNull Frequency frequency) throws BaseBandNotDeployableException {
        Object object;
        Object object22;
        Object object32;
        Object object42;
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        if (baseBandList == null) {
            throw new NullPointerException("bblist is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("widthIF is marked non-null but is null");
        }
        FrequencyRange frequencyRange = baseBandList.getWholeRange(true);
        Frequency frequency2 = (Frequency)((Object)frequencyRange.range());
        if (frequency2.isGreaterThan((AbstractDoubleWithUnit)frequency)) {
            throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
        }
        boolean bl = true;
        boolean bl2 = true;
        BaseBandList baseBandList2 = new BaseBandList(baseBandList.v);
        BaseBandList baseBandList3 = new BaseBandList(baseBandList.v);
        BaseBandList baseBandList4 = new BaseBandList(baseBandList.v);
        for (Object object42 : baseBandList) {
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).min())).isEqual((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.min())))) {
                baseBandList2.add(object42);
                continue;
            }
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).max())).isEqual((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.max())))) {
                baseBandList3.add(object42);
                continue;
            }
            baseBandList4.add(object42);
        }
        Object object5 = (Frequency)((Object)baseBandList3.getWholeRange(false).max());
        object42 = (Frequency)((Object)baseBandList2.getWholeRange(false).min());
        FrequencyRange frequencyRange2 = new FrequencyRange((Frequency)((Object)object42), (Frequency)((Object)object5));
        Frequency frequency3 = (Frequency)((Frequency)((Object)frequencyRange2.range())).minus((AbstractDoubleWithUnit)frequency, true);
        Frequency frequency4 = BASEBANDWIDTH;
        Object object6 = BASEBANDWIDTH;
        for (Object object32 : baseBandList2) {
            object22 = (Frequency)((Object)((BaseBand)object32).getLeftMargin().range());
            if (!object22.isLessThan((AbstractDoubleWithUnit)((Frequency)frequency3.half(true)))) continue;
            bl = false;
            if (!object22.isLessThan((AbstractDoubleWithUnit)frequency4)) continue;
            frequency4 = object22;
        }
        for (Object object32 : baseBandList3) {
            object22 = (Frequency)((Object)((BaseBand)object32).getRightMargin().range());
            if (!object22.isLessThan((AbstractDoubleWithUnit)((Frequency)frequency3.half(true)))) continue;
            bl2 = false;
            if (!object22.isLessThan((AbstractDoubleWithUnit)object6)) continue;
            object6 = object22;
        }
        if (bl && bl2) {
            if (frequency3.isZero()) {
                frequency3 = FREQ_OFFSET;
            }
            for (Object object32 : baseBandList2) {
                ((BaseBand)object32).shift((Frequency)frequency3.half(true));
            }
            for (Object object32 : baseBandList3) {
                ((BaseBand)object32).shift((Frequency)((Frequency)frequency3.half(true)).multiply(-1.0, true));
            }
        } else if (bl) {
            object = (Frequency)frequency3.minus((AbstractDoubleWithUnit)object6, true);
            for (Object object22 : baseBandList2) {
                ((BaseBand)object22).shift((Frequency)((Object)object));
            }
            for (Object object22 : baseBandList3) {
                ((BaseBand)object22).shift((Frequency)object6.multiply(-1.0));
            }
        } else {
            object = (Frequency)frequency3.minus((AbstractDoubleWithUnit)frequency4, true);
            for (Object object22 : baseBandList3) {
                ((BaseBand)object22).shift((Frequency)object.multiply(-1.0));
            }
            for (Object object22 : baseBandList2) {
                ((BaseBand)object22).shift(frequency4);
            }
        }
        object = (Frequency)((Object)baseBandList2.getWholeRange(false).min());
        object32 = (Frequency)((Object)baseBandList3.getWholeRange(false).max());
        for (BaseBand baseBand : baseBandList4) {
            if (((Frequency)((Object)baseBand.min())).isLessThan((AbstractDoubleWithUnit)object)) {
                baseBand.shift((Frequency)object.minus((AbstractDoubleWithUnit)((Frequency)((Object)baseBand.min())), true));
            }
            if (!((Frequency)((Object)baseBand.max())).isGreaterThan((AbstractDoubleWithUnit)object32)) continue;
            baseBand.shift((Frequency)object32.minus((AbstractDoubleWithUnit)((Frequency)((Object)baseBand.max())), true));
        }
    }

    private void clipOutside(@NonNull ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() * 2.0);
        this.clipRange(receiverBand, this.basebands, frequency);
    }

    private void clipInside(@NonNull ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        if (receiverBand == null) {
            throw new NullPointerException("rb is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin() * 2.0);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(true);
        Frequency frequency2 = (Frequency)((Object)frequencyRange.range());
        if (frequency2.isLessThan((AbstractDoubleWithUnit)frequency)) {
            throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
        }
        boolean bl = true;
        boolean bl2 = true;
        BaseBandList baseBandList = new BaseBandList(this.basebands.v);
        BaseBandList baseBandList2 = new BaseBandList(this.basebands.v);
        BaseBandList baseBandList3 = new BaseBandList(this.basebands.v);
        for (Object object42 : this.basebands) {
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).min())).isEqual((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.max())))) {
                baseBandList.add(object42);
                continue;
            }
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).max())).isEqual((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.min())))) {
                baseBandList2.add(object42);
                continue;
            }
            baseBandList3.add(object42);
        }
        Object object5 = (Frequency)((Object)baseBandList.getWholeRange(false).min());
        object42 = (Frequency)((Object)baseBandList2.getWholeRange(false).max());
        FrequencyRange frequencyRange2 = new FrequencyRange((Frequency)((Object)object42), (Frequency)((Object)object5));
        Frequency frequency3 = (Frequency)frequency.minus((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange2.range())), true);
        Frequency frequency4 = BASEBANDWIDTH;
        Frequency frequency5 = BASEBANDWIDTH;
        Frequency frequency6 = (Frequency)frequency3.half(true);
        for (Object object32 : baseBandList) {
            object2 = (Frequency)((Object)object32.getLeftMargin().range());
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency6)) continue;
            bl = false;
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency4)) continue;
            frequency4 = object2;
        }
        for (Object object32 : baseBandList2) {
            object2 = (Frequency)((Object)object32.getRightMargin().range());
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency6)) continue;
            bl2 = false;
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency5)) continue;
            frequency5 = object2;
        }
        if (bl && bl2) {
            for (Object object32 : baseBandList) {
                object32.shift(frequency6);
            }
            for (Object object32 : baseBandList2) {
                object32.shift((Frequency)frequency6.multiply(-1.0));
            }
        } else {
            object = (Frequency)((Frequency)((Frequency)frequency4.plus((AbstractDoubleWithUnit)frequency5, true)).minus((AbstractDoubleWithUnit)frequency3, true)).half();
            if (frequency4.isLessThan((AbstractDoubleWithUnit)frequency5)) {
                object32 = (Frequency)frequency4.minus((AbstractDoubleWithUnit)object, true);
                if (object32.getContent() <= 0.0) {
                    object32 = Frequency.createFrequencyGHZ(0.0);
                }
                object2 = (Frequency)((Frequency)frequency3.minus((AbstractDoubleWithUnit)object32, true)).plus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
            } else {
                object2 = (Frequency)frequency5.minus((AbstractDoubleWithUnit)object, true);
                if (object2.getContent() <= 0.0) {
                    object2 = Frequency.createFrequencyGHZ(0.0);
                }
                object32 = (Frequency)((Frequency)frequency3.minus((AbstractDoubleWithUnit)object2, true)).plus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
            }
            for (Object object6 : baseBandList) {
                ((BaseBand)object6).shift((Frequency)((Object)object32));
            }
            for (Object object6 : baseBandList2) {
                ((BaseBand)object6).shift((Frequency)object2.multiply(-1.0, true));
            }
        }
        if (!baseBandList3.isEmpty()) {
            object = (Frequency)((Object)baseBandList2.getWholeRange(false).max());
            object32 = (Frequency)((Object)baseBandList.getWholeRange(false).min());
            for (Object object7 : baseBandList3) {
                Frequency frequency7;
                Object object6;
                object6 = (Frequency)((Object)((VupRange)object7).min());
                if (object6.isGreaterThan((AbstractDoubleWithUnit)object) && object6.isLessThan((AbstractDoubleWithUnit)object32)) {
                    ((BaseBand)object7).shift((Frequency)object32.minus((AbstractDoubleWithUnit)object6, true));
                }
                if (!(frequency7 = (Frequency)((Object)((VupRange)object7).max())).isLessThan((AbstractDoubleWithUnit)object32) || !frequency7.isGreaterThan((AbstractDoubleWithUnit)object)) continue;
                ((BaseBand)object7).shift((Frequency)object.minus((AbstractDoubleWithUnit)frequency7, true));
            }
        }
    }

    private void clipLO1UpperConstraints(ReceiverBand receiverBand) {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getRFRange().max())).minus((AbstractDoubleWithUnit)frequency2, true)).minus((AbstractDoubleWithUnit)frequency, true);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(false);
        Frequency frequency4 = (Frequency)frequency3.minus((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.min())), true);
        for (BaseBand baseBand : this.basebands) {
            if (!((Frequency)((Object)baseBand.max())).isEqual((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.min())))) continue;
            baseBand.shift(frequency4);
        }
    }

    private void clipLO1LowerConstraints(ReceiverBand receiverBand) {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getRFRange().min())).plus((AbstractDoubleWithUnit)frequency2, true)).plus((AbstractDoubleWithUnit)frequency, true);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(false);
        Frequency frequency4 = (Frequency)frequency3.minus((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.max())), true);
        for (BaseBand baseBand : this.basebands) {
            if (!((Frequency)((Object)baseBand.min())).isEqual((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.max())))) continue;
            baseBand.shift(frequency4);
        }
    }

    public Collection<BaseBand> getBasebands() {
        ArrayList<BaseBand> arrayList = new ArrayList<BaseBand>();
        arrayList.addAll(this.basebands);
        return Collections.unmodifiableCollection(arrayList);
    }

    public BaseBandList getBaseBandList() {
        return this.basebands;
    }

    public BBInfringementStateEnum isSPWWithin30MHzOfBBEdge(@NonNull BaseBand baseBand) {
        if (baseBand == null) {
            throw new NullPointerException("baseband is marked non-null but is null");
        }
        BBInfringementStateEnum bBInfringementStateEnum = BBInfringementStateEnum.NO_INFRINGEMENT;
        Frequency frequency = Frequency.createFrequencyGHZ(1.875);
        for (SpectralWindow spectralWindow : baseBand.getSpectralWindowArray()) {
            Frequency frequency2 = (Frequency)((Frequency)((Object)spectralWindow.max())).minus((AbstractDoubleWithUnit)((Frequency)((Object)spectralWindow.min())));
            if (!frequency2.isLessThan((AbstractDoubleWithUnit)frequency)) continue;
            Frequency frequency3 = (Frequency)frequency2.half(true);
            Frequency frequency4 = (Frequency)((Object)spectralWindow.mid());
            Frequency frequency5 = (Frequency)((Frequency)((Object)baseBand.min())).plus((AbstractDoubleWithUnit)SpectralSpecValidator.BASEBAND_EDGE_MARGIN);
            Frequency frequency6 = (Frequency)((Frequency)((Object)baseBand.max())).minus((AbstractDoubleWithUnit)SpectralSpecValidator.BASEBAND_EDGE_MARGIN);
            Frequency frequency7 = (Frequency)frequency4.minus((AbstractDoubleWithUnit)frequency3);
            if (frequency7.isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency5)) {
                return BBInfringementStateEnum.LOW_BB_EDGE_INFRINGEMENT;
            }
            Frequency frequency8 = (Frequency)frequency4.plus((AbstractDoubleWithUnit)frequency3);
            if (!frequency8.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency6)) continue;
            return BBInfringementStateEnum.HI_BB_EDGE_INFRINGEMENT;
        }
        return bBInfringementStateEnum;
    }

    public String toString() {
        return "BaseBandDeployer(B4B5=" + this.B4B5 + ", basebands=" + this.getBasebands() + ", ssp=" + this.ssp + ", spectralScanTuningIndex=" + this.spectralScanTuningIndex + ")";
    }

    public class BaseBandList
    extends ArrayList<BaseBand> {
        private final Velocity v;

        public BaseBandList(Velocity velocity) {
            this.v = velocity == null ? Velocity.createVelocity() : velocity;
        }

        public Frequency[] getCenterFrequenciesSky() {
            ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
            for (BaseBand baseBand : this) {
                arrayList.add(baseBand.centerSky);
            }
            return arrayList.toArray(new Frequency[arrayList.size()]);
        }

        public Frequency[] getCenterFrequenciesRest() {
            ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
            for (BaseBand baseBand : this) {
                arrayList.add(this.v.reverseShift(baseBand.centerSky));
            }
            return arrayList.toArray(new Frequency[arrayList.size()]);
        }

        public FrequencyRange getWholeRange(boolean bl) {
            Range[] rangeArray = new FrequencyRange[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                rangeArray[i] = ((BaseBand)this.get(i)).getRange(bl);
            }
            return FrequencyRange.wholeRange(rangeArray);
        }

        public BaseBand addNewBaseBand(Frequency frequency) {
            BaseBand baseBand = new BaseBand(frequency, this.v);
            this.add(baseBand);
            return baseBand;
        }

        public FrequencyRange basebandWidestFrequencyGap(boolean bl) {
            List<FrequencyRange> list = this.getBasebandFrequencyGaps(bl);
            if (list.size() == 0) {
                return null;
            }
            FrequencyRange frequencyRange = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                FrequencyRange frequencyRange2 = list.get(i);
                if (!((Frequency)((Object)frequencyRange2.range())).isGreaterThan((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange.range())))) continue;
                frequencyRange = frequencyRange2;
            }
            return frequencyRange;
        }

        public BaseBandList getLSBBasebands() {
            FrequencyRange frequencyRange = this.basebandWidestFrequencyGap(false);
            if (frequencyRange == null) {
                return this;
            }
            Frequency frequency = (Frequency)((Object)frequencyRange.mid());
            BaseBandList baseBandList = new BaseBandList(this.v);
            for (BaseBand baseBand : this) {
                if (!((Frequency)((Object)baseBand.mid())).isLessThan((AbstractDoubleWithUnit)frequency)) continue;
                baseBandList.add(baseBand);
            }
            return baseBandList;
        }

        public BaseBandList getUSBBasebands() {
            FrequencyRange frequencyRange = this.basebandWidestFrequencyGap(false);
            if (frequencyRange == null) {
                return this;
            }
            Frequency frequency = (Frequency)((Object)frequencyRange.mid());
            BaseBandList baseBandList = new BaseBandList(this.v);
            for (BaseBand baseBand : this) {
                if (!((Frequency)((Object)baseBand.mid())).isGreaterThan((AbstractDoubleWithUnit)frequency)) continue;
                baseBandList.add(baseBand);
            }
            return baseBandList;
        }

        protected List<FrequencyRange> getBasebandFrequencyGaps(boolean bl) {
            ArrayList<FrequencyRange> arrayList = new ArrayList<FrequencyRange>();
            Comparator comparator = (frequencyRange, frequencyRange2) -> {
                if (!((Frequency)((Object)((Object)frequencyRange.min()))).equals(frequencyRange2.min())) {
                    return ((Frequency)((Object)((Object)frequencyRange.min()))).compareTo((AbstractDoubleWithUnit)((Frequency)((Object)((Object)frequencyRange2.min()))));
                }
                return ((Frequency)((Object)((Object)frequencyRange.max()))).compareTo((AbstractDoubleWithUnit)((Frequency)((Object)((Object)frequencyRange2.max()))));
            };
            List list = this.stream().map(baseBand -> baseBand.getRange(bl)).collect(Collectors.toList());
            list.sort(comparator);
            FrequencyRange frequencyRange3 = (FrequencyRange)list.get(0);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FrequencyRange frequencyRange4;
                FrequencyRange frequencyRange5 = frequencyRange4 = (FrequencyRange)iterator.next();
                if (((Frequency)((Object)frequencyRange3.max())).isLessThan((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange5.min())))) {
                    arrayList.add(new FrequencyRange((Frequency)((Object)frequencyRange3.max()), (Frequency)((Object)frequencyRange5.min())));
                    frequencyRange3 = frequencyRange5;
                    continue;
                }
                if (!((Frequency)((Object)frequencyRange5.max())).isGreaterThan((AbstractDoubleWithUnit)((Frequency)((Object)frequencyRange3.max())))) continue;
                frequencyRange3 = frequencyRange5;
            }
            return arrayList;
        }

        @Override
        public String toString() {
            return "BaseBandDeployer.BaseBandList(v=" + this.v + ")";
        }
    }

    public class BaseBand
    extends FrequencyRange {
        Integer groupIndex;
        Frequency centerSky;
        Velocity v;
        List<SpectralWindow> windowList;
        private final Frequency freqTolerance;

        public BaseBand() {
            super(null, null);
            this.groupIndex = null;
            this.windowList = new ArrayList<SpectralWindow>();
            this.freqTolerance = Frequency.createFrequencyGHZ(1.0E-9);
            this.v = Velocity.createVelocity();
        }

        public BaseBand(Frequency frequency, Velocity velocity) {
            super(null, null);
            this.groupIndex = null;
            this.windowList = new ArrayList<SpectralWindow>();
            this.freqTolerance = Frequency.createFrequencyGHZ(1.0E-9);
            this.v = velocity == null ? Velocity.createVelocity() : velocity;
            this.setCenterRest(frequency);
        }

        private void setCenterRest(Frequency frequency) {
            this.centerSky = frequency.dopplerShifted(this.v);
            this.setRange();
        }

        private void setCenterSky(Frequency frequency) {
            this.centerSky = frequency;
            this.setRange();
        }

        private void setRange() {
            double d = this.centerSky.getContentInGHz();
            this.setMin(Frequency.createFrequencyGHZ(d - HALFBASEBANDWITHGHZ));
            this.setMax(Frequency.createFrequencyGHZ(d + HALFBASEBANDWITHGHZ));
        }

        private void setCenter() {
            this.setCenterSky((Frequency)((Object)this.getRange(true).mid()));
        }

        public SpectralWindow addNewSpectralWindow(Frequency frequency, Frequency frequency2) throws BaseBandNotDeployableException {
            SpectralWindow spectralWindow = new SpectralWindow(frequency, frequency2, this.v);
            this.addSpectralWindow(spectralWindow);
            return spectralWindow;
        }

        private void addSpectralWindow(SpectralWindow spectralWindow) {
            this.windowList.add(spectralWindow);
        }

        public SpectralWindow[] getSpectralWindowArray() {
            SpectralWindow[] spectralWindowArray = new SpectralWindow[this.windowList.size()];
            return this.windowList.toArray(spectralWindowArray);
        }

        public FrequencyRange getRange(boolean bl) {
            if (bl) {
                return FrequencyRange.wholeRange(this.getSpectralWindowArray());
            }
            return new FrequencyRange((Frequency)((Object)this.min()), (Frequency)((Object)this.max()));
        }

        FrequencyRange getLeftMargin() {
            FrequencyRange frequencyRange = this.getRange(true);
            return new FrequencyRange((Frequency)((Object)this.min()), (Frequency)((Object)frequencyRange.min()));
        }

        FrequencyRange getRightMargin() {
            FrequencyRange frequencyRange = this.getRange(true);
            return new FrequencyRange((Frequency)((Object)frequencyRange.max()), (Frequency)((Object)this.max()));
        }

        private boolean isBasebandShiftable(Frequency frequency) {
            double d;
            if (frequency.getContent() >= 0.0) {
                double d2;
                Frequency frequency2 = (Frequency)((Frequency)((Object)this.getRightMargin().range())).minus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
                if (frequency.isLessThan((AbstractDoubleWithUnit)frequency2)) {
                    return true;
                }
                double d3 = frequency.getContentInGHz();
                return Math.abs(d3 - (d2 = frequency2.getContent())) < this.freqTolerance.getContentInGHz();
            }
            Frequency frequency3 = (Frequency)((Frequency)((Object)this.getLeftMargin().range())).plus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
            if (((Frequency)frequency.multiply(-1.0)).isLessThan((AbstractDoubleWithUnit)frequency3)) {
                return true;
            }
            double d4 = frequency.getContentInGHz() * -1.0;
            return Math.abs(d4 - (d = frequency3.getContent())) < this.freqTolerance.getContentInGHz();
        }

        private boolean shift(Frequency frequency) {
            boolean bl = this.isBasebandShiftable(frequency);
            if (bl) {
                Frequency frequency2 = frequency.getContent() >= 0.0 ? (Frequency)frequency.plus((AbstractDoubleWithUnit)FREQ_OFFSET, true) : (Frequency)frequency.minus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
                this.centerSky = (Frequency)this.centerSky.plus((AbstractDoubleWithUnit)frequency2, true);
                this.setRange();
            }
            return bl;
        }

        @Override
        public String toString() {
            return "BaseBandDeployer.BaseBand(groupIndex=" + this.getGroupIndex() + ", centerSky=" + this.getCenterSky() + ", v=" + this.v + ", windowList=" + this.windowList + ", freqTolerance=" + this.freqTolerance + ")";
        }

        public void setGroupIndex(Integer n) {
            this.groupIndex = n;
        }

        public Integer getGroupIndex() {
            return this.groupIndex;
        }

        public Frequency getCenterSky() {
            return this.centerSky;
        }
    }

    public class SpectralWindow
    extends FrequencyRange {
        public SpectralWindow(@NonNull Frequency frequency, @NonNull Frequency frequency2, Velocity velocity) throws BaseBandNotDeployableException {
            super(null, null);
            if (frequency == null) {
                throw new NullPointerException("centerRest is marked non-null but is null");
            }
            if (frequency2 == null) {
                throw new NullPointerException("width is marked non-null but is null");
            }
            if (velocity == null) {
                throw new NullPointerException("v is marked non-null but is null");
            }
            try {
                this.setRange(frequency.dopplerShifted(velocity), frequency2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BaseBandNotDeployableException(numberFormatException);
            }
        }

        public SpectralWindow(@NonNull ScienceSpectralWindow scienceSpectralWindow, Velocity velocity) throws BaseBandNotDeployableException {
            super(null, null);
            if (scienceSpectralWindow == null) {
                throw new NullPointerException("ssw is marked non-null but is null");
            }
            if (velocity == null) {
                throw new NullPointerException("v is marked non-null but is null");
            }
            try {
                if (scienceSpectralWindow.getIsSkyFrequency()) {
                    this.setRange(scienceSpectralWindow.getCenterFrequency(), (Frequency)((Object)scienceSpectralWindow.getBandwidth()));
                } else {
                    this.setRange(scienceSpectralWindow.getCenterFrequency().dopplerShifted(velocity), (Frequency)((Object)scienceSpectralWindow.getBandwidth()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BaseBandNotDeployableException(numberFormatException);
            }
        }

        private void setRange(@NonNull Frequency frequency, @NonNull Frequency frequency2) {
            if (frequency == null) {
                throw new NullPointerException("centerSky is marked non-null but is null");
            }
            if (frequency2 == null) {
                throw new NullPointerException("width is marked non-null but is null");
            }
            MathContext mathContext = new MathContext(13);
            BigDecimal bigDecimal = new BigDecimal(((Frequency)frequency2.half(true)).getContentInGHz(), mathContext);
            BigDecimal bigDecimal2 = new BigDecimal(frequency.getContentInGHz(), mathContext);
            this.setMin(Frequency.createFrequencyGHZ(bigDecimal2.subtract(bigDecimal).doubleValue()));
            this.setMax(Frequency.createFrequencyGHZ(bigDecimal2.add(bigDecimal).doubleValue()));
        }

        @Override
        public String toString() {
            return "BaseBandDeployer.SpectralWindow()";
        }
    }

    public static enum BBInfringementStateEnum {
        NO_INFRINGEMENT,
        LOW_BB_EDGE_INFRINGEMENT,
        HI_BB_EDGE_INFRINGEMENT;

    }

    public static enum ObservedFrame {
        Sky,
        Rest;

    }
}

