/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import java.util.Optional;

public class ConfigurationSet
implements Comparable<ConfigurationSet> {
    private Optional<Configuration> tm1Configuration = Optional.empty();
    private Optional<Configuration> tm2Configuration = Optional.empty();
    private Optional<Configuration> aca7mConfiguration = Optional.empty();
    private boolean isACA7mRequired = false;
    private boolean isTPRequired = false;

    public String toString() {
        return "ConfigurationSet [tm1Configuration=" + this.tm1Configuration + ", tm2Configuration=" + this.tm2Configuration + ", aca7mConfiguration=" + this.aca7mConfiguration + ", isACA7mRequired=" + this.isACA7mRequired + ", isTPRequired=" + this.isTPRequired + "]";
    }

    public Optional<Configuration> getTM1Configuration() {
        return this.tm1Configuration;
    }

    public void setTM1Configuration(Configuration configuration) {
        this.tm1Configuration = Optional.of(configuration);
    }

    public Optional<Configuration> getTM2Configuration() {
        return this.tm2Configuration;
    }

    public void setTM2Configuration(Configuration configuration) {
        this.tm2Configuration = Optional.of(configuration);
    }

    public void removeTM2Configuration() {
        this.tm2Configuration = Optional.empty();
    }

    public boolean isACA7mRequired() {
        return this.isACA7mRequired;
    }

    public void setACA7mRequired(boolean bl) {
        this.isACA7mRequired = bl;
    }

    public boolean isTPRequired() {
        return this.isTPRequired;
    }

    public void setTPRequired(boolean bl) {
        this.isTPRequired = bl;
    }

    public int getNoOfArrayRequired() {
        int n = 0;
        if (this.tm1Configuration.isPresent()) {
            ++n;
        }
        if (this.tm2Configuration.isPresent()) {
            ++n;
        }
        if (this.isACA7mRequired) {
            ++n;
        }
        if (this.isTPRequired) {
            ++n;
        }
        return n;
    }

    public Optional<Configuration> getAca7mConfiguration() {
        return this.aca7mConfiguration;
    }

    public void setAca7mConfiguration(Configuration configuration) {
        this.aca7mConfiguration = Optional.of(configuration);
    }

    public static ConfigurationSet getConfigurationRequiringMostTime(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, RequestedArray requestedArray) {
        if (scienceGoalConfigurations == null || scienceGoalConfigurations.isEmpty()) {
            throw new IllegalArgumentException("configurationSet is null/empty");
        }
        ConfigurationSet configurationSet = (ConfigurationSet)scienceGoalConfigurations.get(0);
        for (ConfigurationSet configurationSet2 : scienceGoalConfigurations) {
            Configuration configuration;
            Configuration configuration2 = requestedArray.equals((Object)RequestedArray.TWELVE_M) ? configurationSet2.getTM1Configuration().get() : configurationSet2.getAca7mConfiguration().get();
            Configuration configuration3 = configuration = requestedArray.equals((Object)RequestedArray.TWELVE_M) ? configurationSet.getTM1Configuration().get() : configurationSet.getAca7mConfiguration().get();
            if (!(configuration2.getMaxBaseline() > configuration.getMaxBaseline())) continue;
            configurationSet = configurationSet2;
        }
        return configurationSet;
    }

    public static Configuration getConfigurationWithCoarsestAR(Frequency frequency, ScienceGoal scienceGoal, ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, RequestedArray requestedArray) throws InvalidConfigurationParametersException {
        if (scienceGoalConfigurations == null || scienceGoalConfigurations.isEmpty()) {
            throw new IllegalArgumentException("configurationSet is null/empty");
        }
        Configuration configuration = null;
        for (ConfigurationSet configurationSet : scienceGoalConfigurations) {
            Configuration configuration2 = requestedArray.equals((Object)RequestedArray.TWELVE_M) ? configurationSet.getTM1Configuration().get() : configurationSet.getAca7mConfiguration().get();
            Angle angle = null;
            Angle angle2 = null;
            try {
                angle2 = configuration2.getAchievableAngularResolutionForClusters(scienceGoal, SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST, frequency, requestedArray);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new InvalidConfigurationParametersException();
            }
            assert (angle2 != null);
            if (angle == null) {
                angle = angle2;
                configuration = configuration2;
                continue;
            }
            if (!angle2.isGreaterThan((AbstractDoubleWithUnit)angle)) continue;
            angle = angle2;
            configuration = configuration2;
        }
        assert (configuration != null);
        return configuration;
    }

    public static boolean isConfigurationInSet(Configuration configuration, RequestedArray requestedArray, String ... stringArray) throws Configuration.UnableToDetermineConfigurationException {
        if (configuration == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: configuration");
        }
        if (requestedArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: array");
        }
        if (stringArray.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            Configuration configuration2 = Configuration.getConfiguration(string, requestedArray);
            if (configuration != configuration2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ConfigurationSet configurationSet) {
        if (configurationSet == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: o");
        }
        if (!configurationSet.getTM1Configuration().isPresent() || !this.getTM1Configuration().isPresent()) {
            throw new IllegalArgumentException("Illegal argument. The argument cannot be null: o");
        }
        double d = this.getTM1Configuration().get().getMaxBaseline();
        double d2 = configurationSet.getTM1Configuration().get().getMaxBaseline();
        if (d2 == d) {
            return 0;
        }
        return d < d2 ? -1 : 1;
    }
}

