/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.valuetypes.Time;

public class TimeSummary {
    private Long numExec = 0L;
    private final CalType type;
    private final Time time = Time.createTimeSec(0.0);
    private boolean isAtmCalIncluded = false;
    private CalObs calibrationObservation;
    String calibrationStrategyUsed;

    TimeSummary(CalType calType) {
        this.type = calType;
    }

    public void addTime(Time time) {
        this.time.aggregate(time);
    }

    public Time getTotalTime() {
        return this.time.deepCopy();
    }

    public void addNumExec(Long l) {
        this.numExec = this.numExec + l;
    }

    public boolean isStandardSystemCalibrationStrategyUsed() {
        return this.calibrationStrategyUsed.equals(CalibrationSetupParameters.SELECTION_SYSTEM);
    }

    public boolean isSSOCalibrationStrategyUsed() {
        return this.calibrationStrategyUsed.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE);
    }

    public String toString() {
        return "TimeSummary(numExec=" + this.getNumExec() + ", type=" + this.getType() + ", time=" + this.time + ", isAtmCalIncluded=" + this.isAtmCalIncluded() + ", calibrationObservation=" + this.getCalibrationObservation() + ", calibrationStrategyUsed=" + this.getCalibrationStrategyUsed() + ")";
    }

    public Long getNumExec() {
        return this.numExec;
    }

    public CalType getType() {
        return this.type;
    }

    public boolean isAtmCalIncluded() {
        return this.isAtmCalIncluded;
    }

    public void setCalibrationObservation(CalObs calObs) {
        this.calibrationObservation = calObs;
    }

    public CalObs getCalibrationObservation() {
        return this.calibrationObservation;
    }

    public String getCalibrationStrategyUsed() {
        return this.calibrationStrategyUsed;
    }

    public void setCalibrationStrategyUsed(String string) {
        this.calibrationStrategyUsed = string;
    }
}

