/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.PointingPatternAdapter;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.CompleteLinkageStrategy;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import jsky.coords.WorldCoords;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class SourceClusterDetector {
    private static CacheAccess<Integer, Collection<ScienceGoal>> sourceClusterCache = JCS.getInstance((String)"sourceClusterCache");
    private static CacheAccess<Integer, List<Set<TargetParameters>>> clusteredTargetsCache;
    private static CacheAccess<Integer, List<ScienceGoal.SourcePoint>> skyPointCache;
    protected final ScienceGoal originalScienceGoal;

    public SourceClusterDetector(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("primaryScienceGoal is marked non-null but is null");
        }
        this.originalScienceGoal = scienceGoal;
    }

    public Collection<ScienceGoal> splitScienceGoalIntoSourceClusters() throws InvalidObsProgramParametersException {
        List<ScienceGoal> list;
        List<Object> list2;
        Object object;
        Integer n = this.originalScienceGoal.toXml().hashCode();
        Collection collection = (Collection)sourceClusterCache.get((Object)n);
        if (collection != null) {
            return collection;
        }
        boolean bl = true;
        Object object2 = this.originalScienceGoal.getTargetParameters();
        int n2 = ((TargetParameters[])object2).length;
        for (int i = 0; i < n2; ++i) {
            object = object2[i];
            if (!object.getNonSiderealMotion()) continue;
            bl = false;
            break;
        }
        if ((object2 = this.getSiderealFieldCentresForAllSources(this.originalScienceGoal, n)).isEmpty()) {
            bl = false;
        }
        if (bl) {
            object = AlmaPolicies.getInstance();
            Integer object3 = Objects.hash(n, ((AlmaPolicies)object).getMaxConeDiameter().getArcsec());
            List list3 = (List)clusteredTargetsCache.get((Object)object3);
            if (list3 != null) {
                list2 = list3;
            } else {
                list2 = this.divideSourcesIntoClusters((List<ScienceGoal.SourcePoint>)object2, ((AlmaPolicies)object).getMaxConeDiameter());
                clusteredTargetsCache.put((Object)object3, list2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (Log.logger(SourceClusterDetector.class).isLoggable(Level.FINE)) {
                for (Set set : list2) {
                    stringBuilder.append(" New Cluster [");
                    for (TargetParameters targetParameters : set) {
                        stringBuilder.append(targetParameters.gettrueSourceName() + " , ");
                    }
                    stringBuilder.append("]");
                }
                Log.logger(SourceClusterDetector.class).info(stringBuilder.toString());
            }
            if (this.isLongBaselineScheduledInClusteredSGs(list = this.groupSpatiallyAdjacentSourcesIntoScienceGoals(list2))) {
                Integer n3 = Objects.hash(n, ((AlmaPolicies)object).getMaxConeDiameterLongBaseline().getArcsec());
                list3 = (List)clusteredTargetsCache.get((Object)n3);
                if (list3 != null) {
                    list2 = list3;
                } else {
                    list2 = this.divideSourcesIntoClusters((List<ScienceGoal.SourcePoint>)object2, ((AlmaPolicies)object).getMaxConeDiameterLongBaseline());
                    clusteredTargetsCache.put((Object)n3, list2);
                }
                list = this.groupSpatiallyAdjacentSourcesIntoScienceGoals(list2);
            }
        } else {
            object = new HashSet<TargetParameters>(50);
            for (TargetParameters targetParameters : this.originalScienceGoal.getTargetParameters()) {
                object.add(targetParameters);
            }
            list2 = new ArrayList<HashSet<TargetParameters>>(50);
            list2.add(object);
            list = this.groupSpatiallyAdjacentSourcesIntoScienceGoals(list2);
        }
        if (list != null && !list.isEmpty()) {
            for (ScienceGoal scienceGoal : list) {
                ScienceGoal.determineACAScheduling(scienceGoal);
            }
        }
        sourceClusterCache.put((Object)n, list);
        return list;
    }

    private boolean isLongBaselineScheduledInClusteredSGs(List<ScienceGoal> list) {
        if (list == null || list.isEmpty()) {
            throw new NullPointerException("Illegal argument. The argument cannot be null or empty : clusteredScienceGoals");
        }
        Optional<ScienceGoal> optional = list.stream().filter(scienceGoal -> scienceGoal.isStandAloneACA()).findFirst();
        if (optional.isPresent()) {
            return false;
        }
        return list.stream().filter(scienceGoal -> {
            try {
                return this.isLongBaselineScheduled((ScienceGoal)scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(SourceClusterDetector.class).warning("Unable to determine if science goal use a long baseline configuration " + invalidObsProgramParametersException.getMessage());
                return false;
            }
        }).findFirst().isPresent();
    }

    private boolean isLongBaselineScheduled(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (scienceGoal.isStandAloneACA()) {
            return false;
        }
        ConfigurationSet configurationSet = Configuration.getConfigurationsToBeScheduled(scienceGoal).getConfigurationRequiringMostTime(RequestedArray.TWELVE_M);
        return configurationSet.getTM1Configuration().map(configuration -> configuration.isLongBaselineConfiguration()).orElse(false);
    }

    private List<ScienceGoal.SourcePoint> getSiderealFieldCentresForAllSources(@NonNull ScienceGoal scienceGoal, @NonNull Integer n) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("sgHash is marked non-null but is null");
        }
        List list = (List)skyPointCache.get((Object)n);
        if (list != null) {
            return list;
        }
        ArrayList<ScienceGoal.SourcePoint> arrayList = new ArrayList<ScienceGoal.SourcePoint>(30);
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (targetParameters.getNonSiderealMotion()) continue;
            if (targetParameters.isPointingPattern()) {
                PointingPatternAdapter pointingPatternAdapter = targetParameters.getPointingPattern();
                assert (pointingPatternAdapter.getPhaseCenterCoordinatesCount() > 0);
                SkyCoordinates skyCoordinates = pointingPatternAdapter.getPhaseCenterCoordinates(0);
                SkyPoint skyPoint = targetParameters.isAbsolutePointingPattern() ? skyCoordinates.getAbsoluteSkyPointInICRSDeg() : skyCoordinates.getAbsoluteCoordinates(targetParameters.getFieldCenterCoordinates()).getAbsoluteSkyPointInICRSDeg();
                arrayList.add(new ScienceGoal.SourcePoint(targetParameters, skyPoint));
            } else {
                arrayList.add(new ScienceGoal.SourcePoint(targetParameters, targetParameters.getFieldCenterCoordinates().getAbsoluteSkyPointInICRSDeg()));
            }
            assert (!arrayList.isEmpty());
        }
        skyPointCache.put((Object)n, arrayList);
        return arrayList;
    }

    protected synchronized List<ScienceGoal> groupSpatiallyAdjacentSourcesIntoScienceGoals(@NonNull List<Set<TargetParameters>> list) {
        if (list == null) {
            throw new NullPointerException("clustersOfSpatiallyAdjacentSources is marked non-null but is null");
        }
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>(30);
        PerformanceParameters performanceParameters = this.originalScienceGoal.getPerformanceParameters();
        if (list.size() == 1) {
            ScienceGoal scienceGoal = this.originalScienceGoal.deepCopy();
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            PerformanceParameters performanceParameters2 = scienceGoal.getPerformanceParameters();
            spectralSetupParameters.setRepresentativeFrequency(this.originalScienceGoal.getRepresentativeFrequency().deepCopy());
            performanceParameters2.setRepresentativeFrequency(performanceParameters.getRepresentativeFrequency().deepCopy());
            performanceParameters2.setDesiredSensitivityReferenceFrequencyWidth(performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().deepCopy());
            scienceGoal.setObsUnitSet(null);
            arrayList.add(scienceGoal);
            return arrayList;
        }
        assert (list.size() > 1);
        int n = 1;
        for (Set<TargetParameters> set : list) {
            ScienceGoal scienceGoal = this.originalScienceGoal.deepCopy();
            scienceGoal.setObsUnitSet(null);
            scienceGoal.setSchedBlockExpert(null);
            scienceGoal.getSpectralSetupParameters().setRepresentativeFrequency(this.originalScienceGoal.getRepresentativeFrequency().deepCopy());
            scienceGoal.getPerformanceParameters().setRepresentativeFrequency(performanceParameters.getRepresentativeFrequency().deepCopy());
            scienceGoal.getPerformanceParameters().setDesiredSensitivityReferenceFrequencyWidth(performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().deepCopy());
            scienceGoal.setName(this.originalScienceGoal.getName() + " cluster " + n);
            TargetParameters[] targetParametersArray = new TargetParameters[set.size()];
            set.toArray(targetParametersArray);
            TargetParameters targetParameters = this.originalScienceGoal.getKeyTargetParameters();
            assert (targetParametersArray.length > 0);
            for (int i = 0; i < targetParametersArray.length; ++i) {
                TargetParameters targetParameters2 = targetParametersArray[i];
                if (!targetParameters2.equals(targetParameters)) continue;
                if (i == 0) break;
                TargetParameters targetParameters3 = targetParametersArray[0];
                targetParametersArray[0] = targetParameters;
                targetParametersArray[i] = targetParameters3;
                break;
            }
            TargetParameters[] targetParametersArray2 = new TargetParameters[targetParametersArray.length];
            for (int i = 0; i < targetParametersArray.length; ++i) {
                targetParametersArray2[i] = targetParametersArray[i].deepCopy();
            }
            scienceGoal.setTargetParameters(targetParametersArray2);
            scienceGoal.setKeyTargetParameters(0);
            scienceGoal.setClusterIndex(n++);
            arrayList.add(scienceGoal);
        }
        assert (!arrayList.isEmpty());
        return arrayList;
    }

    private List<Set<TargetParameters>> divideSourcesIntoClusters(@NonNull List<ScienceGoal.SourcePoint> list, Angle angle) throws InvalidObsProgramParametersException {
        Cloneable cloneable;
        Object object;
        if (list == null) {
            throw new NullPointerException("allSiderealSkyPointsInSG is marked non-null but is null");
        }
        int n = list.size();
        if (n == 0) {
            throw new IllegalArgumentException("Illegal argument: allSiderealSkyPointsInSG.size() (" + n + ") did not pass the test: allSiderealSkyPointsInSG.size() == 0");
        }
        String[] stringArray = new String[n];
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            object = list.get(i).getSkyPoint();
            for (int j = 0; j < n; ++j) {
                cloneable = list.get(j).getSkyPoint();
                dArray[i][j] = WorldCoords.dist((double)((SkyPoint)object).getX(), (double)((SkyPoint)object).getY(), (double)((SkyPoint)cloneable).getX(), (double)((SkyPoint)cloneable).getY()) / 60.0;
            }
            stringArray[i] = list.get(i).getTargetParameters().getSourceName();
        }
        DefaultClusteringAlgorithm defaultClusteringAlgorithm = new DefaultClusteringAlgorithm();
        try {
            object = defaultClusteringAlgorithm.performClustering(dArray, stringArray, new CompleteLinkageStrategy());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObsProgramParametersException("Unable to execute the source clustering algorithm : " + illegalArgumentException.getMessage());
        }
        assert (object != null);
        cloneable = new ArrayList(10);
        return this.groupOutputOfClusteringAlgorithm((List<Set<TargetParameters>>)((Object)cloneable), (Cluster)object, angle);
    }

    private List<Set<TargetParameters>> groupOutputOfClusteringAlgorithm(List<Set<TargetParameters>> list, Cluster cluster, Angle angle) {
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        double d2 = cluster.getMaxDistance();
        Log.logger(SourceClusterDetector.class).fine("Cluster maximum distance : " + d2);
        if (d2 > d) {
            for (Cluster cluster2 : cluster.getChildren()) {
                this.groupOutputOfClusteringAlgorithm(list, cluster2, angle);
            }
        } else {
            TargetParameters[] targetParametersArray = this.originalScienceGoal.getTargetParameters();
            assert (targetParametersArray != null && targetParametersArray.length > 0);
            TreeSet<TargetParameters> treeSet = new TreeSet<TargetParameters>((targetParameters, targetParameters2) -> targetParameters.getSourceName().compareTo(targetParameters2.getSourceName()));
            list.add(this.addTargetParametersToSourceCluster(targetParametersArray, treeSet, cluster));
        }
        return list;
    }

    private Set<TargetParameters> addTargetParametersToSourceCluster(TargetParameters[] targetParametersArray, Set<TargetParameters> set, Cluster cluster) {
        boolean bl = false;
        if (cluster.getChildren().isEmpty()) {
            String string = cluster.getName();
            for (TargetParameters targetParameters : targetParametersArray) {
                if (!targetParameters.getSourceName().equals(string)) continue;
                set.add(targetParameters);
                bl = true;
                break;
            }
            if (!bl) {
                throw new WizardSBGenerationException("Unable to locate target parameters in cluster tree");
            }
        }
        for (Cluster cluster2 : cluster.getChildren()) {
            this.addTargetParametersToSourceCluster(targetParametersArray, set, cluster2);
        }
        return set;
    }

    static {
        skyPointCache = JCS.getInstance((String)"skyPointCache");
        clusteredTargetsCache = JCS.getInstance((String)"clusteredTargetsCache");
    }
}

