/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.schedblock.ObservingParametersValidator;
import alma.obsprep.ot.valdef.schedblock.ValidatorUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;

public class ScienceParametersValidator
extends ObservingParametersValidator {
    protected static double FREQMINGHZ = 31.2;
    protected static double FREQMAXGHZ = 1000.0;
    protected static double BWMINGHZ = 3.125E-6;
    protected static double BWMAXGHZ = 16.0;

    public ScienceParametersValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        double d;
        double d2;
        Problem problem;
        super.localValidate(businessObject, problemListModel);
        ScienceParameters scienceParameters = (ScienceParameters)businessObject;
        if (scienceParameters.getIntegrationTime().getContentInUnits(IntTimeSource.UNIT_S) <= 0.0) {
            problem = DefaultProblem.createError("Science integration time is invalid", "Set the integration time to a sensible value", (IBusinessObject)scienceParameters);
            problemListModel.add(problem);
        }
        if (scienceParameters.getSensitivityGoal().getContentInUnits(Sensitivity.UNIT_JY) <= 0.0) {
            problem = DefaultProblem.createError("Science target sensitivity goal is invalid", "Set the sensitivity goal to a sensible value", (IBusinessObject)scienceParameters);
            problemListModel.add(problem);
        }
        if (!((d2 = scienceParameters.getRepresentativeFrequency().getContentInUnits(Frequency.UNIT_GHZ)) > FREQMINGHZ) || !(d2 < FREQMAXGHZ)) {
            problem = DefaultProblem.createError("Representative frequency for science target is not valid", "Set the frequency to within the ALMA range", (IBusinessObject)scienceParameters);
            problemListModel.add(problem);
        }
        if (!((d = scienceParameters.getRepresentativeBandwidth().getContentInUnits(Frequency.UNIT_GHZ)) >= BWMINGHZ) || !(d <= BWMAXGHZ)) {
            problem = DefaultProblem.createError("Representative bandwidth for science target is not valid", "Set the bandwidth within the range " + BWMINGHZ + " to " + BWMAXGHZ + " GHz", (IBusinessObject)scienceParameters);
            problemListModel.add(problem);
        }
        if (scienceParameters.getSubScanDuration().getContentInDefaultUnits() <= 0.0) {
            problem = DefaultProblem.createError("Science subscan duration is invalid", "Set the time to a sensible value", (IBusinessObject)scienceParameters);
            problemListModel.add(problem);
        }
        for (Target target : scienceParameters.getTargetList()) {
            if (target.getAbstractInstrumentSpec() == null || target.getAbstractInstrumentSpec() instanceof OpticalCameraSpec) continue;
            Time time = ((SpectralSpec)((Object)target.getAbstractInstrumentSpec())).getCorrelatorConfiguration().getIntegrationDuration();
            Time time2 = scienceParameters.getSubScanDuration();
            if (!ValidatorUtils.isIntegralMultipleTime(time2, time)) {
                problem = DefaultProblem.createError("Subscan duration in science parameters is not a multiple of the integration duration in the associated instrument setup", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (ValidatorUtils.isIntegralMultipleControlRequiredBase(time2)) continue;
            problem = DefaultProblem.createError("Subscan duration in science parameters is not a multiple of 48.0 ms", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

