/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.models.schedblock.RectanglePatternModel;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.EphemerisValidator;
import alma.obsprep.ot.valdef.schedblock.ValidatorUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import jsky.coords.WorldCoords;
import lombok.NonNull;

public class FieldSourceValidator
extends AbstractValidator {
    private static final int MAX_NUMBER_POINTINGS = 10000;
    private final Log.Logger logger = Log.logger((Object)this);

    public FieldSourceValidator() {
        this.setValidatorThreadSafe(false);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Object object;
        boolean bl;
        boolean bl2;
        FieldPattern fieldPattern;
        Problem problem;
        FieldSource fieldSource = (FieldSource)businessObject;
        fieldSource.setSourceName(MiscUtils.getSanitizedSourceName(fieldSource.getSourceName()));
        if (fieldSource.getUsedCount() == 0) {
            problem = DefaultProblem.createWarning("Field source " + fieldSource.getName() + " is not used by any target", " ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        SchedBlock schedBlock = (SchedBlock)fieldSource.getParent();
        this.logger.fine("Obs Mode = " + schedBlock.getModeName());
        if (fieldSource.getFieldPattern() == null) {
            problem = DefaultProblem.createError("No Field Pattern has been specified for the FieldSource", "Navigate to the FieldSource, select a field pattern type, and fill in the details of that field pattern", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (fieldSource.getFieldPatternType().equals(FieldPattern.TYPE_POINT) && ((PointingPattern)((Object)fieldSource.getFieldPattern())).getPhaseCenterCoordinatesCount() == 0) {
            problem = DefaultProblem.createError("Number of pointings in the Pointing Field Pattern is 0", "Navigate to the FieldSource and add at least one pointing position to the field pattern", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((fieldPattern = fieldSource.getFieldPattern()).isRectanglePattern()) {
            double d;
            double d2;
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
            double d3 = rectanglePattern.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC);
            double d4 = rectanglePattern.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC);
            double d5 = 0.0;
            double d6 = 0.0;
            try {
                d5 = RectanglePatternModel.calculateSamplesPerBeam(rectanglePattern, d3, d4, RectanglePatternModel.Axis.LATITUDE);
            }
            catch (RectanglePatternModel.UnableToCalculateSamplesPerBeamException unableToCalculateSamplesPerBeamException) {
                problem = DefaultProblem.createWarning("Unable to establish latitudinal samples per beam", "Contact ARC representative", (IBusinessObject)businessObject);
                problemListModel.add(problem);
                return;
            }
            try {
                d6 = RectanglePatternModel.calculateSamplesPerBeam(rectanglePattern, d3, d4, RectanglePatternModel.Axis.LONGITUDE);
            }
            catch (RectanglePatternModel.UnableToCalculateSamplesPerBeamException unableToCalculateSamplesPerBeamException) {
                return;
            }
            String string = null;
            String string2 = null;
            if (RectanglePattern.SCANDIRECTION_LATITUDE.equals(rectanglePattern.getScanDirection())) {
                d2 = 4.95;
                d = 2.95;
                string = "Revise the orthogonal step";
                string2 = "Revise the latitudinal length";
            } else {
                d2 = 2.95;
                d = 4.95;
                string = "Revise the longitudinal length";
                string2 = "Revise the orthogonal step";
            }
            assert (d2 > 0.0);
            assert (d > 0.0);
            assert (string != null);
            assert (string2 != null);
            if (d6 < d) {
                problem = DefaultProblem.createWarning("Longitudinal samples per beam is less than " + d, string, (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (d5 < d2) {
                problem = DefaultProblem.createWarning("Latitudinal samples per beam is less than " + d2, string2, (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        if (bl2 = fieldSource.getIsQuery()) {
            return;
        }
        if (fieldSource.getName().equals("")) {
            problem = DefaultProblem.createWarning("Fieldsource name is blank", "Navigate to the FieldSource and enter a name", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (fieldSource.getSourceName().equals("")) {
            problem = DefaultProblem.createError("FieldSource source name is blank", "Navigate to the FieldSource and enter a name", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        SkyCoordinates skyCoordinates = fieldSource.getSourceCoordinates().getJ2000SkyCoordinates();
        double d = Math.abs(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_DEG) - latitude.getContentInUnits(Latitude.UNIT_DEG));
        if (d > 90.0) {
            problem = DefaultProblem.createError("Target declination is never visible from " + siteCharacteristics.getObsName(), "Choose another target", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!(bl = fieldSource.getNonSiderealMotion()) && !bl2) {
            if (skyCoordinates.getLatitude().getContent() == 0.0 && skyCoordinates.getLongitude().getContent() == 0.0) {
                problem = DefaultProblem.createWarning("Your field source coordinates are 0.0, 0.0", "Please be sure you mean this", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (fieldSource.getSourceCoordinates().getSystem().equals(SkyCoordinates.SYSTEM_J2000)) {
                problem = DefaultProblem.createError("FK5 is no longer supported.", "Change coordinate system to ICRS.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        String string = fieldSource.getSolarSystemObject();
        if (bl && string.equals(FieldSource.SOLARSYSTEMOBJECT_UNSPECIFIED)) {
            problem = DefaultProblem.createError("You have selected a solar system target without specifying one", "Choose a solar system object from the list", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (bl && (string.equals(FieldSource.SOLARSYSTEMOBJECT_EPHEMERIS) || string.equals(FieldSource.SOLARSYSTEMOBJECT_SUN))) {
            object = new EphemerisValidator(this.logger);
            ((EphemerisValidator)object).validateEphemeris(fieldSource.getSourceEphemeris(), (BusinessObject)fieldSource, problemListModel, false);
        }
        if (((Velocity)((Object)(object = fieldSource.getSourceVelocity()))).getReferenceSystem().equals(Velocity.REFERENCESYSTEM_HEL)) {
            problem = DefaultProblem.createWarning("Helio-centric velocity reference frames are not possible in Control", "The frame has been changed to barycentric - or you may choose something else", (IBusinessObject)businessObject);
            problemListModel.add(problem);
            ((Velocity)((Object)object)).setReferenceSystem(Velocity.REFERENCESYSTEM_BAR);
        }
        this.validateReferencePosition(problemListModel, fieldSource);
        if (fieldPattern.isPointingPattern() && ((PointingPattern)((Object)fieldPattern)).getPhaseCenterCoordinatesCount() > 10000) {
            problem = DefaultProblem.createError("Too many pointings is the field pattern (limit is 10000)", "Select the Field Source reduce the number of pointings", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        this.validatePointingsNotTooFarFromFieldSourceCentralCoordinate(businessObject, problemListModel, fieldSource);
    }

    private void validateReferencePosition(@NonNull ProblemListModel problemListModel, @NonNull FieldSource fieldSource) {
        Reference[] referenceArray;
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        for (Reference reference : referenceArray = fieldSource.getReference()) {
            double d;
            Problem problem;
            double d2 = reference.getIntegrationTime().getContentInUnits(Time.UNIT_S);
            if (d2 <= 0.0) {
                problem = DefaultProblem.createError("Reference position integration time is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
                problemListModel.add(problem);
            }
            if ((d = reference.getCycleTime().getContentInUnits(Time.UNIT_S)) <= 0.0) {
                problem = DefaultProblem.createError("Reference position cycle time is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
                problemListModel.add(problem);
            }
            if (reference.getSubScanDuration().getContentInDefaultUnits() <= 0.0) {
                problem = DefaultProblem.createError("Reference position subscan duration is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
                problemListModel.add(problem);
            }
            for (Target target : fieldSource.getTargetList()) {
                Time time;
                if (target.getAbstractInstrumentSpec() == null || target.getAbstractInstrumentSpec() instanceof OpticalCameraSpec) continue;
                Time time2 = reference.getSubScanDuration();
                if (!ValidatorUtils.isIntegralMultipleTime(time2, time = ((SpectralSpec)((Object)target.getAbstractInstrumentSpec())).getCorrelatorConfiguration().getIntegrationDuration())) {
                    problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of the integration duration in the associated instrument setup", "Correct the value of the subscan duration", (IBusinessObject)reference);
                    problemListModel.add(problem);
                }
                if (ValidatorUtils.isIntegralMultipleControlRequiredBase(time2)) continue;
                problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of 48.0 ms", "Correct the value of the subscan duration", (IBusinessObject)reference);
                problemListModel.add(problem);
            }
        }
    }

    private void validatePointingsNotTooFarFromFieldSourceCentralCoordinate(BusinessObject businessObject, ProblemListModel problemListModel, FieldSource fieldSource) {
        double d = AlmaPolicies.getInstance().getMaxSeparationFromSourceCoordinate().getContentInUnits(Angle.UNIT_DEG);
        SkyPoint skyPoint = fieldSource.getSourceCoordinates().getAbsoluteSkyPointInJ2000Deg();
        if (fieldSource.getFieldPattern().isPointingPattern()) {
            SkyCoordinates[] skyCoordinatesArray;
            PointingPattern pointingPattern = (PointingPattern)((Object)fieldSource.getFieldPattern());
            for (SkyCoordinates skyCoordinates : skyCoordinatesArray = pointingPattern.getPhaseCenterCoordinates()) {
                SkyCoordinates skyCoordinates2 = skyCoordinates;
                if (skyCoordinates2.isOffsetCoordinates()) {
                    skyCoordinates2 = skyCoordinates2.getAbsoluteCoordinates(fieldSource.getTargetCenter());
                }
                SkyPoint skyPoint2 = skyCoordinates2.getAbsoluteSkyPointInJ2000Deg();
                double d2 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0;
                if (!(d2 >= d)) continue;
                Problem problem = DefaultProblem.createError(String.format("A pointing is more than %.0f degrees of separation from the source coordinate", d), "Please revise you field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
                break;
            }
        } else if (fieldSource.getFieldPattern().isRectanglePattern()) {
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
            SkyCoordinates skyCoordinates = rectanglePattern.getPatternCenterCoordinates();
            if (rectanglePattern.getPatternCenterCoordinates().isOffsetCoordinates()) {
                skyCoordinates = skyCoordinates.getAbsoluteCoordinates(fieldSource.getTargetCenter());
            }
            SkyPoint skyPoint3 = skyCoordinates.getAbsoluteSkyPointInJ2000Deg();
            double d3 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint3.getX(), (double)skyPoint3.getY()) / 60.0;
            if (d3 >= d) {
                Problem problem = DefaultProblem.createError(String.format("Rectangle field pattern is offset by more than %.0f degrees of separation from the source coordinate", d), "Please revise you field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        } else {
            Log.logger(FieldSourceValidator.class).warning("Unknown pattern type detected");
        }
    }
}

