/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.TechnicalJustificationValidator;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.Phase1DataRateCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.DGCExpertInterface;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedblockExecutionTimeAdjuster;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import jsky.coords.WorldCoords;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ScienceGoalValidator
extends AbstractValidator {
    static AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    static int MAX_TEXTAREA_CHARACTERS = almaPolicies.getMaxTextAreaCharacters();
    static int MAX_TUNINGS_PER_GOAL = almaPolicies.getMaxRetuningsPerGoal();
    static final boolean TJ_REQUIRED = almaPolicies.isTechnicalJustificationRequired();
    private static String DEFAULT_SUGGESTION = "Revise the spectral setup or move some of the targets to a different Science Goal";
    private final Log.Logger logger = Log.logger((Object)this);

    public ScienceGoalValidator() {
        this.setValidatorThreadSafe(false);
    }

    @Override
    public void localValidate(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        Collection<ScienceGoal> collection;
        Object object;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        ScienceGoal scienceGoal = (ScienceGoal)businessObject;
        scienceGoal.clearLo1Tunings();
        Log.logger(ScienceGoalValidator.class).info("science goal validator executed");
        if (scienceGoal.isPhase2ScienceGoal()) {
            object = UserEditRestrictionController.getInstance();
        } else {
            scienceGoal.resetTechnicalJustifications();
        }
        this.validateAllSourcesHaveUniqueNames(problemListModel, scienceGoal);
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(ScienceGoalValidator.class).info("Unable to run source cluster algorithm : " + invalidObsProgramParametersException.getMessage());
            return;
        }
        boolean bl = false;
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.getNonSiderealMotion()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.validateNonSiderealTargetSeparation(businessObject, problemListModel, scienceGoal);
        }
        for (ScienceGoal scienceGoal2 : collection) {
            try {
                MinTuningsCalculator.getLO1Tunings(scienceGoal2);
            }
            catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
                object = DefaultProblem.createError("The OT cannot process this many separate velocities", "Distribute your sources over multiple Science Goals", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer((Problem)object);
                return;
            }
            this.validateDataRates(businessObject, problemListModel, scienceGoal2);
            this.validateLegalNumberOfSourcesDefined(businessObject, problemListModel, scienceGoal2);
            this.validateAllTargetsWillProduceValidSpectralSetups(businessObject, problemListModel, scienceGoal2);
            this.validateFullPolarisationIsDisabledWithACA(businessObject, problemListModel, scienceGoal2);
            this.validateStandAloneACA(businessObject, problemListModel, scienceGoal2);
            int n = 0;
            int n2 = AlmaPolicies.getInstance().getMaxNumberPointings();
            boolean bl2 = false;
            try {
                bl2 = scienceGoal2.getScienceGoalMode().equals((Object)ScienceGoal.ScienceGoalMode.STANDALONEACA);
            }
            catch (UnknownEntityException unknownEntityException) {
                object = DefaultProblem.createError("Cannot determine if the science goal is standalone ACA", "Review your science goal configuration", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer((Problem)object);
            }
            if (!scienceGoal.isSpectralScan()) {
                List<MinTuningsCalculator.TuningResult> list = null;
                try {
                    list = MinTuningsCalculator.getLO1Tunings(scienceGoal2);
                }
                catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
                    object = DefaultProblem.createError("The OT cannot process this many separate velocities", "Distribute your sources over multiple Science Goals", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer((Problem)object);
                    return;
                }
                assert (list != null);
                n = list.size();
                if (n > MAX_TUNINGS_PER_GOAL) {
                    problemListModel.addProblemToBuffer(DefaultProblem.createError("Goal requires more than " + MAX_TUNINGS_PER_GOAL + " tunings", "Package targets with different velocities into separate science goals", (IBusinessObject)scienceGoal));
                }
                int n3 = 0;
                for (MinTuningsCalculator.TuningResult tuningResult : list) {
                    for (TargetParameters targetParameters : tuningResult.getTargets()) {
                        n3 += targetParameters.getNumberOfPointings(bl2 ? Array.ARRAY_7M : Array.ARRAY_12M);
                    }
                }
                this.logger.log(Log.DEBUG, "Max Number of Targets Check - MAX is          : " + n2);
                this.logger.log(Log.DEBUG, "Number of Pointing across Tunings is          : " + n3);
                this.logger.log(Log.DEBUG, "Number of Tunings is                          : " + n);
                if (n3 > n2) {
                    object = DefaultProblem.createError("There are too many pointing-tuning combinations specified", "Select the Field Setup in the Science Goal and ensure there are no more than " + n2 + " pointings", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer((Problem)object);
                }
            } else {
                try {
                    n = scienceGoal2.getSpectralSetupParameters().getSpectralScan().getTunings().getNumberOfTunings();
                }
                catch (UnableToFindSolutionException unableToFindSolutionException) {
                    Log.logger(ScienceGoalValidator.class).fine("Unable to determine solution for spectral scan in " + scienceGoal.getName());
                }
                if (n * scienceGoal2.getTargetParameters().length > n2) {
                    object = DefaultProblem.createError("There are too many pointing-tuning combinations specified", "Select the Field Setup in the Science Goal and ensure there are no more than " + n2 + " pointings", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer((Problem)object);
                }
            }
            this.validateSingleTuningDoesNotExceedMaxNoOfSBExecs(problemListModel, scienceGoal, n, businessObject);
            this.validateTPFieldSetup(businessObject, problemListModel, scienceGoal);
            this.validateNoMultipleTuningsWithDGC(problemListModel, n, scienceGoal2);
            this.validateDGCCalibratorSelectionConfigurations(problemListModel, scienceGoal2, scienceGoal);
            this.validateTPSpectralScansAreValid(problemListModel, scienceGoal);
        }
        this.validateVLBIProjects(problemListModel, scienceGoal);
        this.validateSpectralAveragingNotEnabledInSpectralScans(businessObject, problemListModel, scienceGoal);
        this.validateTJParameters(businessObject, problemListModel, scienceGoal);
        this.validateNoToOAndSolarSelection(problemListModel, scienceGoal);
        this.validateAllSourcesAreSolar(problemListModel, scienceGoal);
        this.validateSolarRegionalMapping(problemListModel, scienceGoal);
        this.validateNoSunSelectedWithSACA(problemListModel, scienceGoal);
        this.validateTimeOverrideNotUsedToReduceObservingTime(problemListModel, scienceGoal);
    }

    private void validateTimeOverrideNotUsedToReduceObservingTime(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        try {
            boolean bl;
            boolean bl2 = bl = scienceGoal.getObsProposal().isVLBIorPhasedArray() || scienceGoal.isSolarScienceGoal();
            if (!bl && scienceGoal.getPerformanceParameters().getNeedsMoreTime()) {
                this.validateTimeOverrideDoesNotReduceCalculatedSensitivityTime(problemListModel, scienceGoal);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to determine if the science goal is solar/VLBI/Phased array: " + unknownEntityException.getMessage());
        }
    }

    private void validateSolarRegionalMapping(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        int n = scienceGoal.getTargetParametersCount();
        if (n == 1) {
            return;
        }
        long l = Stream.of(scienceGoal.getTargetParameters()).filter(targetParameters -> targetParameters.isSun() && targetParameters.getSolarMapping() != null && targetParameters.getSolarMapping().equals(AbstractTargetParameters.SOLARMAPPING_REGIONALMAPPING)).count();
        if (l > 1L) {
            Problem problem = DefaultProblem.createError("If solar TP regional mapping is required then only one solar region can be observed per Science Goal.", "Please place your sources into separate SGs or deselect regional mapping.", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateTimeOverrideDoesNotReduceCalculatedSensitivityTime(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        ObsUnitSet obsUnitSet = ObsUnitSet.createObsUnitSet();
        ScienceGoal scienceGoal2 = scienceGoal.deepCopy();
        scienceGoal2.getPerformanceParameters().setNeedsMoreTime(false);
        try {
            new ScienceGoalSchedBlockGenerator(scienceGoal2, obsUnitSet, false).generate();
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            this.logger.warning("Unable to create SBs in SB post processor : " + wizardSBGenerationException.getMessage());
            return;
        }
        Time time = null;
        try {
            time = SchedblockExecutionTimeAdjuster.determineOUSExecutionTime(obsUnitSet, scienceGoal2);
        }
        catch (Exception exception) {
            this.logger.warning("Unable to determine the project execution time : " + exception.getMessage());
            throw new WizardSBGenerationException(exception);
        }
        assert (time != null) : "The SG execution time should not be null";
        if (time.isGreaterThan((AbstractDoubleWithUnit)scienceGoal.getPerformanceParameters().getDesiredTime())) {
            Problem problem = DefaultProblem.createError("Time overrides can only be used to increase the time request", "Deselect the override and adjust inputs such as sensitivity, sensitivity bandwidth and representative frequency", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateNoMultipleTuningsWithDGC(@NonNull ProblemListModel problemListModel, int n, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (n == 1 && !scienceGoal.isSpectralScan()) {
            return;
        }
        Set<DGCExpert.DGCTypeEnum> set = DGCExpert.getExpert().dgcObservingStrategiesRequired(scienceGoal, true);
        if (!set.contains((Object)DGCExpert.DGCTypeEnum.None)) {
            Problem problem = DefaultProblem.createError("Multiple tunings/spectral scans are not currently possible with DGC observing.", "Split your tunings into different Science Goals.", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateNoSunSelectedWithSACA(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (!scienceGoal.isStandAloneACA()) {
            return;
        }
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.isSun()) continue;
            Problem problem = DefaultProblem.createError("Solar observations cannot be carried out with the Stand-alone ACA", "Select a different angular resolution option for solar observations", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
            return;
        }
    }

    private void validateDGCCalibratorSelectionConfigurations(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, ScienceGoal scienceGoal2) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        this.validateDGCB2BSelection(problemListModel, scienceGoal, scienceGoal2);
        this.validateDGCBWSWSelection(problemListModel, scienceGoal, scienceGoal2);
    }

    private void validateDGCBWSWSelection(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, ScienceGoal scienceGoal2) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        DGCExpert.BWSWSchedulingOutcome bWSWSchedulingOutcome = DGCExpert.getExpert().isBWSWScheduled(scienceGoal, true);
        boolean bl = scienceGoal2.isPhase2ScienceGoal();
        if (!bl && bWSWSchedulingOutcome.isBWSWToBeScheduled()) {
            problemListModel.addProblemToBuffer(DefaultProblem.createWarning("Bandwidth Switching observing is required", "Increase the available bandwidth if possible. Special calibration strategies might be required at Phase 2", (IBusinessObject)scienceGoal2));
        } else if (bl && bWSWSchedulingOutcome.equals((Object)DGCExpert.BWSWSchedulingOutcome.BWSWWeakCalibratorFound)) {
            problemListModel.addProblemToBuffer(DefaultProblem.createWarning("A weak calibrator is found and low aggregate bandwidth used", "Increase the available bandwidth, if possible, for optimal calibration", (IBusinessObject)scienceGoal2));
        }
    }

    private void validateDGCB2BSelection(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, @NonNull ScienceGoal scienceGoal2) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (scienceGoal2 == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        DGCExpertInterface dGCExpertInterface = DGCExpert.getExpert();
        DGCExpert.B2BSchedulingOutcome b2BSchedulingOutcome = dGCExpertInterface.isB2BScheduled(scienceGoal, true);
        String string = null;
        String string2 = null;
        boolean bl = true;
        switch (b2BSchedulingOutcome) {
            case Scheduled: {
                string2 = "An in-band calibrator could not be found so band-to-band observing will be used.";
                string = "A suitable band-to-band calibrator appears to be available.";
                break;
            }
            case B2BWeakCalibratorFound: {
                string2 = "Band-to-band observing will be used with a weak calibrator.";
                string = "A cone search will be conducted close to observing time to check feasibility.";
                break;
            }
            case UnuseableB2BCalibratorFound: 
            case NoCalibratorFoundInCatalogue: {
                string2 = "Band-to-band observing is required, but no calibrator appears to be available.";
                string = "It does not appear possible to observe this source with ALMA at this frequency.";
                bl = false;
                break;
            }
            case FailedToCommunicateWithCalibratorServer: {
                string2 = "The calibrator catalogue is not available - use of band-to-band observing will be assumed.";
                string = "Check your internet connection or try later in order to allow a search for an in-band calibrator.";
                break;
            }
            case UseBWSW: {
                string2 = "Spectral setup has low aggregate bandwidth";
                string = "Calibration will use bandwidth switching. Increase the bandwidth if possible";
                break;
            }
        }
        boolean bl2 = scienceGoal.getCalibrationSetupParameters().getIsDGCOverride();
        if (bl2) {
            b2BSchedulingOutcome = dGCExpertInterface.isB2BScheduled(scienceGoal, false);
            if (b2BSchedulingOutcome.isB2BToBeScheduled()) {
                string2 = "DGC required but overridden";
                string = "Calibration should use band-to-band but this has been overridden";
            } else if (b2BSchedulingOutcome.equals((Object)DGCExpert.B2BSchedulingOutcome.UseBWSW)) {
                string2 = "DGC required but overridden";
                string = "Calibration should use bandwidth switching but this has been overridden";
            }
        }
        if (string2 != null && string != null) {
            Problem problem = bl ? DefaultProblem.createWarning(string2, string, (IBusinessObject)scienceGoal2) : DefaultProblem.createError(string2, string, (IBusinessObject)scienceGoal2);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateNoToOAndSolarSelection(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        boolean bl = false;
        try {
            bl = scienceGoal.getObsProposal().isToO();
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        if (!bl) {
            return;
        }
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.getNonSiderealMotion() || !targetParameters.getSolarSystemObject().equals(AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN)) continue;
            Problem problem = DefaultProblem.createError("The OT cannot be configured for Solar when the proposal type is Target of Opportunity", "Select a different proposal type or choose a different solar system object in the target parameters.", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
            return;
        }
    }

    private void validateAllSourcesAreSolar(ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (scienceGoal.getObsProposal().isVLBIorPhasedArray()) {
                return;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (targetParameters.getNonSiderealMotion() && targetParameters.getSolarSystemObject().equals(AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN)) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl && bl2) {
            Problem problem = DefaultProblem.createError("The Sun and a non-solar target have been selected.", "Place the non-solar target into a different Science Goal.", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateVLBIProjects(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ObsProposal obsProposal = null;
        try {
            obsProposal = scienceGoal.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalValidator.class).fine("Unable to determine obsProposal for science goal");
            return;
        }
        if (obsProposal == null) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to find obsProposal associated with science goal");
            return;
        }
        if (obsProposal.isVLBIorPhasedArray() && scienceGoal.getTargetParametersCount() > 1) {
            Problem problem = DefaultProblem.createError("Only a single target per science goal can be specified with a VLBI proposal", "Move targets into other science goals", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateStandAloneACA(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        ScienceGoal.ScienceGoalMode scienceGoalMode;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        try {
            scienceGoalMode = scienceGoal.getScienceGoalMode();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to determine science goal mode " + unknownEntityException.getMessage());
            return;
        }
        assert (scienceGoalMode != null);
        if (scienceGoalMode.equals((Object)ScienceGoal.ScienceGoalMode.STANDALONEACA)) {
            boolean bl;
            Object object;
            String string;
            EnumSet<SingleFieldScienceGoalModel.NonStandardMode> enumSet = null;
            try {
                enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal);
            }
            catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
                this.logger.warning("Unable to determine non-standard observing modes: " + unableToDetermineObservingModesException.getMessage());
                return;
            }
            if (enumSet.contains((Object)SingleFieldScienceGoalModel.NonStandardMode.BANDWIDTH_SWITCHING)) {
                string = "Narrow aggregate bandwidths are not allowed with the stand-alone ACA";
                object = "Try and add additional spectral windows or widen existing ones";
                problemListModel.addProblemToBuffer(DefaultProblem.createError(string, (String)object, (IBusinessObject)businessObject));
            }
            if (!(bl = Telescope.isOTConfiguredAs(Telescope.CSVALMA)) && enumSet.contains((Object)SingleFieldScienceGoalModel.NonStandardMode.USERDEFINED_CALIBRATION)) {
                string = "User-defined calibration is not allowed with the stand-alone ACA";
                object = "Change to system-defined calibration";
                problemListModel.addProblemToBuffer(DefaultProblem.createError(string, (String)object, (IBusinessObject)businessObject));
            }
            if (scienceGoal.getSpectralSetupParameters().isFullPolarisation()) {
                for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                    if (targetParameters.getNumberOfPointings(Array.ARRAY_7M) <= 1) continue;
                    string = "ACA full polarization can only be used with single-pointing fields.";
                    object = "Reduce the number of pointings for " + targetParameters.getSourceName() + ".";
                    problemListModel.addProblemToBuffer(DefaultProblem.createError(string, (String)object, (IBusinessObject)businessObject));
                }
            }
        }
    }

    private void validateLegalNumberOfSourcesDefined(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("boCast is marked non-null but is null");
        }
        if (almaPolicies.getMaxSourcesPerGoal() > 0 && scienceGoal.getTargetParametersCount() > almaPolicies.getMaxSourcesPerGoal()) {
            Problem problem = DefaultProblem.createError("Too many sources in the Science Goal (maximum is " + almaPolicies.getMaxSourcesPerGoal() + ")", "Put some of these sources into a separate science goal", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateFullPolarisationIsDisabledWithACA(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (scienceGoal.isStandAloneACA()) {
            return;
        }
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal() && scienceGoal.getReceiverBand().getNumber() == 3;
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        if (!bl && scienceGoal.getPerformanceParameters().getUseACA() && scienceGoal.getSpectralSetupParameters().isFullPolarisation() && !Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
            Problem problem = DefaultProblem.createError("ACA observations are not permitted when full polarization is selected ", "De-select the request for ACA observations", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateDataRates(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (!scienceGoal.isStandAloneACA()) {
            this.validate12mDataRates(businessObject, problemListModel, scienceGoal);
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        boolean bl = performanceParameters.gettrueUseACA();
        boolean bl2 = performanceParameters.gettrueUseTP();
        try {
            if (bl && !scienceGoal.isSolarScienceGoal()) {
                this.validate7mDataRates(businessObject, problemListModel, scienceGoal);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to determine if a solar science goal" + unknownEntityException.getMessage());
        }
        if (bl2) {
            try {
                this.validateTPDataRates(businessObject, problemListModel, scienceGoal);
            }
            catch (Exception exception) {
                Log.logger(ScienceGoalValidator.class).warning("Unable to validate TP data rates");
            }
        }
    }

    private void validateTPDataRates(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        List<Phase1DataRateCalculator.SpectralSpecDataRate> list = null;
        try {
            list = scienceGoal.getInstantaneousBasebandDataRates(RequestedArray.TP);
        }
        catch (Exception exception) {
            Problem problem = DefaultProblem.createError("Unable to determine instantaneous data rates", "Is the setup of the science goal valid?", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
            return;
        }
        assert (list != null && !list.isEmpty());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        DataRate dataRate = DataRate.createDataRate((double)AlmaPolicies.getInstance().getInstantaneousTPDataRateMBPS(), (String)DataRate.UNIT_MB_S);
        for (Phase1DataRateCalculator.SpectralSpecDataRate object : list) {
            for (AbstractBaseBandConfig abstractBaseBandConfig : object.keySet()) {
                DataRate dataRate2 = abstractBaseBandConfig.getInstantaneousDataRate();
                if (!dataRate2.isGreaterThan((AbstractDoubleWithUnit)dataRate)) continue;
                hashSet.add(abstractBaseBandConfig.getBaseBandIndex());
            }
        }
        if (!hashSet.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            hashSet.stream().forEach(n -> {
                n = n + 1;
                stringBuilder.append(n + ",");
            });
            String string = String.format("TP array peak data rate in basebands [%s] exceeds the max allowed (%.2f MiB/s)", StringUtils.chop((String)stringBuilder.toString()), dataRate.getContentInUnits(DataRate.UNIT_MB_S));
            Problem problem = DefaultProblem.createError(string, "Use/increase spectral averaging or reduce mapping area", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validate7mDataRates(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        Problem problem;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        List<Phase1DataRateCalculator.SpectralSpecDataRate> list = null;
        try {
            list = scienceGoal.getInstantaneousBasebandDataRates(RequestedArray.SEVEN_M);
        }
        catch (Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            problem = DefaultProblem.createError("Unable to determine instantaneous data rates", "Is the setup of the science goal valid?", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
        if (list == null || list.isEmpty()) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to determine instantaneous data rates");
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        DataRate dataRate = DataRate.createDataRate((double)AlmaPolicies.getInstance().getInstantaneous7mDataRateMBPS(), (String)DataRate.UNIT_MB_S);
        for (Phase1DataRateCalculator.SpectralSpecDataRate object : list) {
            for (AbstractBaseBandConfig abstractBaseBandConfig : object.keySet()) {
                DataRate dataRate2 = abstractBaseBandConfig.getInstantaneousDataRate();
                if (!dataRate2.isGreaterThan((AbstractDoubleWithUnit)dataRate)) continue;
                hashSet.add(abstractBaseBandConfig.getBaseBandIndex());
            }
        }
        if (!hashSet.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            hashSet.stream().forEach(n -> {
                n = n + 1;
                stringBuilder.append(n + ",");
            });
            String string = String.format("7-m array peak data rate in basebands [%s] exceeds the max allowed (%.2f MiB/s)", StringUtils.chop((String)stringBuilder.toString()), dataRate.getContentInUnits(DataRate.UNIT_MB_S));
            problem = DefaultProblem.createError(string, "Use/increase spectral averaging", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validate12mDataRates(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        Problem problem;
        String string;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Map<SpectralSpec, DataRate> map = null;
        try {
            map = scienceGoal.getInstantaneousDataRates(RequestedArray.TWELVE_M);
        }
        catch (Exception exception) {
            Problem problem2 = DefaultProblem.createError("Unable to determine instantaneous data rates", "Is the setup of the science goal valid?", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem2);
            return;
        }
        DataRate dataRate = DataRate.createDataRate((double)AlmaPolicies.getInstance().getInstantaneous12mDataRateMBPS(), (String)DataRate.UNIT_MB_S);
        for (DataRate dataRate2 : map.values()) {
            if (!dataRate2.isGreaterThan((AbstractDoubleWithUnit)dataRate)) continue;
            string = String.format("12-m array peak data rate (%.2f MB/s) exceeds the max allowed (%.2f MB/s)", dataRate2.getContentInUnits(DataRate.UNIT_MB_S), dataRate.getContentInUnits(DataRate.UNIT_MB_S));
            problem = DefaultProblem.createError(string, "Use/increase spectral averaging", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
        double d = scienceGoal.getAverageDataRate(Array.ARRAY_12M).getContentInUnits(DataRate.UNIT_MB_S);
        if (d > almaPolicies.getMax12mDataRateMBPS()) {
            string = String.format("12-m array average data rate (%.2f MB/s) exceeds the max allowed (%.2f MB/s)", d, almaPolicies.getMax12mDataRateMBPS());
            problem = DefaultProblem.createError(string, "The data rate can be lowered by using/increasing spectral averaging", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
        if (d > almaPolicies.getWarning12mDataRateMBPS()) {
            string = String.format("12-m array average data rate (%.2f MB/s) exceeds %.2f MB/s", d, almaPolicies.getWarning12mDataRateMBPS());
            problem = DefaultProblem.createWarning(string, "The PI may be contacted during Phase 2 to see if there is a possibility to reduce the data rate", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateSpectralAveragingNotEnabledInSpectralScans(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        SpectralScan spectralScan;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("boCast is marked non-null but is null");
        }
        if (scienceGoal.getSpectralSetupParameters().isSpectralScan() && (spectralScan = scienceGoal.getSpectralSetupParameters().getSpectralScan()) != null && spectralScan.getSpectralAverageFactor() != 1 && spectralScan.getCorrConfigMode().getFilter().equals((Object)CorrFilter.TDM)) {
            Problem problem = DefaultProblem.createError("Spectral scan averaging factor must be set to 1 in TDM mode", "Set averaging factor to 1", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateAllTargetsWillProduceValidSpectralSetups(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        Problem problem;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        HashSet<ReceiverBand> hashSet = new HashSet<ReceiverBand>();
        if (scienceGoal.getTargetParametersCount() > 0) {
            TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            int n = scienceGoal.getKeyTargetParametersPosition();
            for (int i = 0; i < targetParametersArray.length; ++i) {
                if (!targetParametersArray[i].getNonSiderealMotion()) {
                    scienceGoal.setKeyTargetParameters(i);
                    try {
                        this.checkTuningsAreDeployable(businessObject, problemListModel, spectralSetupParameters, scienceGoal);
                    }
                    catch (BaseBandNotDeployableException baseBandNotDeployableException) {
                        problem = DefaultProblem.createError(String.format("Spectral setup is not valid for the target %s", scienceGoal.getKeyTargetParameters().getSourceName()), DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    ReceiverBand receiverBand = this.determineReceiverBand(spectralSetupParameters);
                    if (receiverBand != null) {
                        hashSet.add(receiverBand);
                    }
                }
                if (spectralSetupParameters.isSpectralScan()) break;
            }
            scienceGoal.setKeyTargetParameters(n);
        }
        if (hashSet.size() > 1) {
            problem = DefaultProblem.createError("Science goal requires too many receiver bands (" + hashSet.size() + ")", DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateSingleTuningDoesNotExceedMaxNoOfSBExecs(ProblemListModel problemListModel, ScienceGoal scienceGoal, int n, BusinessObject businessObject) {
        try {
            if (n > 1 && this.scienceGoalPrincipalArraySBHasMultipleExecs(scienceGoal)) {
                problemListModel.addProblemToBuffer(DefaultProblem.createWarning("Multiple-tuning projects which require multiple SB executions are currently inefficient time-wise", "Try splitting the different tunings into different Science Goals", (IBusinessObject)businessObject));
            }
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            // empty catch block
        }
    }

    private void validateTPFieldSetup(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        if (scienceGoal.getPerformanceParameters().getUseTP()) {
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                if (targetParameters.getIsMosaic() || targetParameters.getNumberOfPointings(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M) <= 1) continue;
                Problem problem = DefaultProblem.createError("When TP is scheduled, non-mosaic targets must only have a single pointing", "Adjust the pointing setup for " + targetParameters.getSourceName(), (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private void validateAllSourcesHaveUniqueNames(ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        HashSet<String> hashSet = new HashSet<String>();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.getSourceName().trim().equals("") && hashSet.contains(targetParameters.getSourceName().trim())) {
                Problem problem = DefaultProblem.createError("All source names in a science goal must be unique", targetParameters.getSourceName() + " is a duplicate source name, please change its name", (IBusinessObject)targetParameters);
                problemListModel.addProblemToBuffer(problem);
            }
            hashSet.add(targetParameters.getSourceName().trim());
        }
    }

    private List<ScienceGoal.SourcePoint> validateNonSiderealTargetSeparation(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        List<ScienceGoal.SourcePoint> list = scienceGoal.getAllSiderealSourceFieldCentres();
        double d = AlmaPolicies.getInstance().getMaxConeDiameter().getContentInUnits(Angle.UNIT_DEG);
        double d2 = d * 60.0;
        this.logger.log(Log.DEBUG, " Science Goal Spacing Check - Number of Target Parameters is " + list.size());
        this.logger.log(Log.DEBUG, "  (Max Size of Cone is " + d + " Deg or " + d2 + " arcmin)");
        block0: for (int i = 0; i < list.size(); ++i) {
            SkyPoint skyPoint = list.get(i).getSkyPoint();
            for (int j = i + 1; j < list.size(); ++j) {
                SkyPoint skyPoint2 = list.get(j).getSkyPoint();
                double d3 = WorldCoords.dist((double)skyPoint2.getX(), (double)skyPoint2.getY(), (double)skyPoint.getX(), (double)skyPoint.getY());
                if (!(d3 > d2)) continue;
                Problem problem = DefaultProblem.createError(String.format("Sources separated by > %g degrees cannot include solar-system objects", d2), "Place the solar-system objects in separate Science Goals", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
                break block0;
            }
        }
        return list;
    }

    private void validateTJParameters(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("boCast is marked non-null but is null");
        }
        Log.logger(TechnicalJustificationValidator.class).finest("Entering Validation of TJ parameters ");
        if (TJ_REQUIRED && scienceGoal.isPhase1ScienceGoal()) {
            String string;
            int n;
            Problem problem;
            scienceGoal.resetTechnicalJustifications();
            if (scienceGoal.gettrueTechnicalJustification() == null) {
                problem = DefaultProblem.createError("No Technical Justification has been supplied", "Select the Science Goal's Technical Justification node in the Proposal tab and edit the Justication Text", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
            if ((n = (string = scienceGoal.getNote()).length()) > MAX_TEXTAREA_CHARACTERS) {
                problem = DefaultProblem.createError("Description contains too many characters (" + n + ")", "Select the Science Goal's General node in the Proposal tab and edit your description (max " + MAX_TEXTAREA_CHARACTERS + " characters)", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private ReceiverBand determineReceiverBand(@NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        return spectralSetupParameters.getReceiverBand();
    }

    private void checkTuningsAreDeployable(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ScienceGoal scienceGoal) throws BaseBandNotDeployableException {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        if (spectralSetupParameters.isSpectralScan()) {
            try {
                spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                return;
            }
            if (spectralScanTunings != null) {
                for (int i = 0; i < spectralScanTunings.getNumberOfTunings(); ++i) {
                    BaseBandDeployer baseBandDeployer = new BaseBandDeployer(spectralSetupParameters, i);
                    if (baseBandDeployer.isDeployable(true)) continue;
                    Problem problem = DefaultProblem.createError("SPWs associated with tuning " + i + " in the spectral scan cannot be deployed", DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                }
            }
        } else {
            BaseBandDeployer baseBandDeployer = new BaseBandDeployer(spectralSetupParameters);
            if (!baseBandDeployer.isDeployable(true)) {
                TargetParameters targetParameters = scienceGoal.getKeyTargetParameters();
                String string = String.format("Your spectral setup is not compatible with one or more of your targets (%s) in this ScienceGoal", targetParameters.getSourceName());
                Problem problem = DefaultProblem.createError(string, DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private boolean scienceGoalPrincipalArraySBHasMultipleExecs(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal);
        Array array = scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
        return observingTimeCalculator.getSBExecutionCount(array) > 1;
    }

    private void validateTPSpectralScansAreValid(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (!scienceGoal.isSpectralScan() || !scienceGoal.getPerformanceParameters().getUseTP()) {
            return;
        }
        ReceiverBand receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
        boolean bl = AlmaCapabilities.getInstance().getTPSpectralScanReceiverBands().stream().anyMatch(receiverBand2 -> receiverBand2.equals(receiverBand));
        if (!bl) {
            problemListModel.addProblemToBuffer(DefaultProblem.createError("TP cannot be scheduled with spectral scans in this band", "Please revise your setup", (IBusinessObject)scienceGoal));
        }
    }
}

