/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.VLBIFrequencyBands;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jsky.coords.WorldCoords;
import lombok.NonNull;

public class CalibrationSetupParametersValidator
extends AbstractValidator {
    private static final Map<String, Integer> MANDATORY_CALIBRATORS_FOR_USERDEFINED_SETUPS = new HashMap<String, Integer>();

    public CalibrationSetupParametersValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        CalibrationSetupParameters calibrationSetupParameters = (CalibrationSetupParameters)businessObject;
        if (calibrationSetupParameters.isUserDefinedCalibration()) {
            this.validateUserDefinedCalibration(businessObject, problemListModel, calibrationSetupParameters);
        }
        this.validationVLBIPassivePhasingConfiguration(businessObject, problemListModel, calibrationSetupParameters);
    }

    public void validateUserDefinedCalibration(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull CalibrationSetupParameters calibrationSetupParameters) {
        Problem problem;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (calibrationSetupParameters == null) {
            throw new NullPointerException("calibrationSetupParameters is marked non-null but is null");
        }
        if (calibrationSetupParameters.isForcedDGC()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CalibrationTargetParameters calibrationTargetParameters : calibrationSetupParameters.getCalibrationTargetParameters()) {
            arrayList.add(calibrationTargetParameters.getIntendedUse());
            if (!calibrationTargetParameters.isMaxElevationNeverVisible()) continue;
            problem = DefaultProblem.createError("Static calibrator for " + calibrationTargetParameters.getIntendedUse() + " has a target declination that is never visible", "Select the Calibration Setup node in the Science Goal and choose another target", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        for (QuerySource querySource : calibrationSetupParameters.getQuerySource()) {
            arrayList.add(querySource.getIntendedUse());
            if (!querySource.isMaxElevationNeverVisible()) continue;
            problem = DefaultProblem.createError("Dynamic calibrator  for " + querySource.getIntendedUse() + " has a target declination that is never visible", "Select the Calibration Setup node in the Science Goal and choose another target", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        ScienceGoal scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent();
        int n = 0;
        if (scienceGoal != null) {
            n = scienceGoal.getSpectralSetupParameters().isFullPolarisation() ? 1 : 0;
        }
        for (Map.Entry<String, Integer> entry : MANDATORY_CALIBRATORS_FOR_USERDEFINED_SETUPS.entrySet()) {
            String string = entry.getKey();
            if (string.equals(CalibrationTargetParameters.INTENDEDUSE_POLARIZATION) && n == 0) continue;
            int n2 = Collections.frequency(arrayList, string);
            if (entry.getValue() <= n2) continue;
            String string2 = "No " + string + " calibrator will be observed";
            problem = DefaultProblem.createWarning(string2, "Removal of system-defined calibrators must be justified.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            if (sourceClusterDetector.splitScienceGoalIntoSourceClusters().size() > 1) {
                problem = DefaultProblem.createWarning("User-defined calibration is selected but there are multiple source clusters", "Consider placing your sources into multiple Science Goals", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(CalibrationSetupParametersValidator.class).warning("Unable to determine clusters " + invalidObsProgramParametersException.getMessage());
        }
    }

    public void validationVLBIPassivePhasingConfiguration(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull CalibrationSetupParameters calibrationSetupParameters) {
        boolean bl;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (calibrationSetupParameters == null) {
            throw new NullPointerException("calibrationSetupParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent();
        boolean bl2 = false;
        try {
            bl2 = ObsProposal.isVLBIRelated();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(CalibrationSetupParametersValidator.class).warning("Unable to determine if the project is VLBI related");
            return;
        }
        if (bl2 && (bl = VLBIExpert.isPassivePhasingEnabled(scienceGoal))) {
            boolean bl3 = Arrays.asList(calibrationSetupParameters.getCalibrationTargetParameters()).stream().anyMatch(calibrationTargetParameters -> calibrationTargetParameters.getObsType().equals((Object)ObsType.PHASE));
            if (!bl3) {
                Problem problem = DefaultProblem.createError("A specific phase calibrator is required for passive phasing", "Change the phase calibrator to a specific source using the user-defined calibration interface.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            } else {
                this.verifyFixedPhaseCalibratorAngularSeparationIsWithLimits(scienceGoal, problemListModel, businessObject);
            }
        }
    }

    private void verifyFixedPhaseCalibratorAngularSeparationIsWithLimits(@NonNull ScienceGoal scienceGoal, @NonNull ProblemListModel problemListModel, @NonNull BusinessObject businessObject) {
        List<VLBIFrequencyBands.VLBIBands> list;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        try {
            list = ObsProposal.isProposalPhasedArray() ? almaCapabilities.getVLBIPhaserBands().getVLBIBands() : almaCapabilities.getVLBIBands().getVLBIBands();
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        Angle angle = OTConfigurationHelper.getAngle(list.stream().filter(vLBIBands -> vLBIBands.getBand() == receiverBand.getNumber()).findFirst().orElseThrow(RuntimeException::new).getPassivePhaseCalibratorSearchRadius());
        List list2 = Arrays.asList(scienceGoal.getCalibrationSetupParameters().getCalibrationTargetParameters()).stream().filter(calibrationTargetParameters -> calibrationTargetParameters.getObsType().equals((Object)ObsType.PHASE)).collect(Collectors.toList());
        TargetParameters targetParameters = scienceGoal.getTargetParameters()[0];
        SkyPoint skyPoint = targetParameters.getSourceCoordinates().getAbsoluteSkyPointInJ2000Deg();
        for (CalibrationTargetParameters calibrationTargetParameters2 : list2) {
            SkyPoint skyPoint2 = calibrationTargetParameters2.getSourceCoordinates().getAbsoluteSkyPointInJ2000Deg();
            double d = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0;
            if (!(d > angle.getDegs())) continue;
            problemListModel.addProblemToBuffer(DefaultProblem.createWarning("The selected fixed phase calibrator exceeds the default maximum separation", "Please justify this choice in the Calibrator for Passive Phasing Technical Justification.", (IBusinessObject)businessObject));
        }
    }

    static {
        MANDATORY_CALIBRATORS_FOR_USERDEFINED_SETUPS.put(CalibrationTargetParameters.INTENDEDUSE_BANDPASS, 1);
        MANDATORY_CALIBRATORS_FOR_USERDEFINED_SETUPS.put(CalibrationTargetParameters.INTENDEDUSE_PHASE, 1);
        MANDATORY_CALIBRATORS_FOR_USERDEFINED_SETUPS.put(CalibrationTargetParameters.INTENDEDUSE_AMPLITUDE, 1);
        MANDATORY_CALIBRATORS_FOR_USERDEFINED_SETUPS.put(CalibrationTargetParameters.INTENDEDUSE_POLARIZATION, 1);
    }
}

