/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.StoreInteractor;
import alma.obsprep.ot.actions.StorePerformer;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.ot.persistence.ProjectRepositoryHttp;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.OperationRequiresConfirmation;
import alma.obsprep.ot.scripting.PyAction;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.submission.NullRemoteProgressListener;
import alma.obsprep.services.submission.RemoteProgressListener;

public class PyStore
extends PyAction
implements StoreInteractor {
    private final ObsProject proj;
    private final ProjectRepository.StoreVariant variant;
    private final boolean asNew;
    private final boolean skipVal;
    public boolean confirmAsNew = false;
    public boolean confirmSubmit = false;
    public boolean confirmSubmitAsNonPI = false;
    public boolean confirmSubmitToNewerCycle = false;
    public boolean confirmSubmitForceUpdate = false;
    public boolean confirmResubmit = false;
    private ObsProject projectAfterStore;

    public PyStore(BatchOT batchOT, ObsProject obsProject, ProjectRepository.StoreVariant storeVariant, boolean bl, boolean bl2) {
        this.proj = obsProject;
        this.variant = storeVariant;
        this.asNew = bl;
        this.skipVal = bl2;
        ProjectRepositoryHttp projectRepositoryHttp = batchOT.heap().getProjectRepository();
        UserAuthenticator userAuthenticator = batchOT.heap().getUserAuthenticator();
        RoleDirectoryService roleDirectoryService = batchOT.heap().getRoleDirectory();
        StorePerformer storePerformer = new StorePerformer(this, projectRepositoryHttp, userAuthenticator, roleDirectoryService);
        this.setPerformer(storePerformer);
    }

    public ObsProject getProjectAfterStore() {
        return this.projectAfterStore;
    }

    @Override
    public ObsProject getObsProject() {
        return this.proj;
    }

    @Override
    public void error(Exception exception) {
        this.error(exception.getMessage(), exception);
        throw new RuntimeException(exception.getMessage(), exception);
    }

    @Override
    public ObsProject duplicate(ObsProject obsProject) {
        return null;
    }

    @Override
    public boolean isProjectToBeStoredAsNew() {
        return this.asNew;
    }

    @Override
    public boolean isValidationSkippable() {
        return this.skipVal;
    }

    @Override
    public ProjectRepository.StoreVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean confirmAsNew() {
        if (!this.confirmAsNew) {
            throw new OperationRequiresConfirmation("confirmAsNew");
        }
        return this.confirmAsNew;
    }

    @Override
    public boolean confirmSubmit(boolean bl, boolean bl2) {
        if (!this.confirmSubmit) {
            throw new OperationRequiresConfirmation("confirmSubmit");
        }
        return this.confirmSubmit;
    }

    @Override
    public boolean confirmSubmitAsNonPI(boolean bl) {
        if (!this.confirmSubmitAsNonPI) {
            throw new OperationRequiresConfirmation("confirmSubmitAsNonPI");
        }
        return this.confirmSubmitAsNonPI;
    }

    @Override
    public boolean confirmSubmitToNewerCycle(String string, boolean bl) {
        if (!this.confirmSubmitToNewerCycle) {
            throw new OperationRequiresConfirmation("confirmSubmitToNewerCycle");
        }
        return this.confirmSubmitToNewerCycle;
    }

    @Override
    public boolean confirmSubmitForceUpdate() {
        if (!this.confirmSubmitForceUpdate) {
            throw new OperationRequiresConfirmation("confirmSubmitForceUpdate");
        }
        return this.confirmSubmitForceUpdate;
    }

    @Override
    public boolean confirmResubmit() {
        if (!this.confirmResubmit) {
            throw new OperationRequiresConfirmation("confirmResubmit");
        }
        return this.confirmResubmit;
    }

    @Override
    public void busy(boolean bl, String string) {
    }

    @Override
    public void saveProjectAfterStore() {
    }

    @Override
    public void displayAfterStore(ObsProject obsProject) {
        this.projectAfterStore = obsProject;
    }

    @Override
    public RemoteProgressListener getProgressListener() {
        return new NullRemoteProgressListener();
    }

    @Override
    public void info(ObsProject obsProject) {
    }
}

