/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.OusCollection;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.ResourceCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.BOWithSpecificName;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.Circle;
import alma.obsprep.bo.obsproject.Ellipse;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Polygon;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.guiutil.Autocomplete;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.guiutil.mvc.View;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.OTActions;
import alma.obsprep.ot.actions.SearchProjectTree;
import alma.obsprep.ot.boEditors.MultiPageEditor;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersEditor;
import alma.obsprep.ot.editors.sciencegoals.FieldSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.ot.gui.feedback.ProblemTableModel;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.project.BONameTreeCellEditor;
import alma.obsprep.ot.project.OTTree;
import alma.obsprep.ot.project.ProjectModel;
import alma.obsprep.ot.project.ProjectTreeMouseListener;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.ot.project.ProjectTreeNodeRenderer;
import alma.obsprep.ot.project.ProjectTreeSelectionListener;
import alma.obsprep.ot.project.ProjectTreeStructuralUpdater;
import alma.obsprep.ot.project.ProjectTreeTransferHandler;
import alma.obsprep.ot.valdef.ProblemListEvent;
import alma.obsprep.ot.valdef.ProblemListListener;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.JavaFXHTMLWindow;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.ObjectFilter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ProjectTree
extends View
implements ProblemListListener {
    private boolean isDNDPending = false;
    private final boolean m_user;
    private final int m_phase;
    DefaultTreeModel tmodel;
    private List<Action> popupItemList = null;
    private ProjectTreeNode topProjectTreeNode;
    private OTTree tree;
    private ProjectTreeStructuralUpdater modelStructureListener;
    private static Set<String> s_logged = new HashSet<String>();
    private ProblemListModel problemModel;
    private OTTextField searchField;
    private JPanel treeSearchFacility;

    public ProjectTree(ProjectModel projectModel, int n, boolean bl) {
        this.setName("ProjectTree");
        this.setModel(projectModel);
        this.m_user = bl;
        this.m_phase = n;
        this.build();
    }

    @Override
    public void setGuiApi(GuiApi guiApi) {
        super.setGuiApi(guiApi);
        this.tree.setGuiApi(guiApi);
    }

    @Override
    protected void build() {
        this.buildTree();
        this.buildDndSupport();
        this.buildSelectionListener();
        this.buildModelStructureListener();
        this.buildCellRenderer();
        this.buildCellEditor();
        this.buildLayout();
    }

    protected void buildTree() {
        this.topProjectTreeNode = new ProjectTreeNode("");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.topProjectTreeNode);
        this.tree = new OTTree(defaultTreeModel, this.m_phase, this.m_user);
        this.tree.setName("JTree");
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    protected void buildDndSupport() {
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new ProjectTreeTransferHandler(this));
    }

    protected void buildSelectionListener() {
        ProjectTreeSelectionListener projectTreeSelectionListener = new ProjectTreeSelectionListener(this);
        this.tree.addTreeSelectionListener(projectTreeSelectionListener);
    }

    protected void buildModelStructureListener() {
        this.modelStructureListener = new ProjectTreeStructuralUpdater(this);
    }

    protected void buildCellRenderer() {
        ProjectTreeNodeRenderer projectTreeNodeRenderer = new ProjectTreeNodeRenderer();
        this.tree.setCellRenderer(projectTreeNodeRenderer);
    }

    protected void buildCellEditor() {
        BONameTreeCellEditor bONameTreeCellEditor = new BONameTreeCellEditor();
        bONameTreeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                try {
                    BONameTreeCellEditor bONameTreeCellEditor = (BONameTreeCellEditor)changeEvent.getSource();
                    BusinessObject businessObject = bONameTreeCellEditor.getSelectedBO();
                    ProjectTreeNode projectTreeNode = (ProjectTreeNode)ProjectTree.this.tree.getSelectionPath().getLastPathComponent();
                    projectTreeNode.setUserObject(businessObject);
                    ((BOWithSpecificName)businessObject).setName(bONameTreeCellEditor.getText());
                    ProjectTree.this.select(new TreePath(projectTreeNode.getPath()));
                    ProjectTree.this.tree.setEditable(false);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
        DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this.tree, defaultTreeCellRenderer, bONameTreeCellEditor){

            @Override
            public boolean stopCellEditing() {
                this.tree.setEditable(false);
                return super.stopCellEditing();
            }

            @Override
            public void cancelCellEditing() {
                this.tree.setEditable(false);
                super.cancelCellEditing();
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                if (ProjectTree.this.isDndReadonly()) {
                    return false;
                }
                ProjectTreeNode projectTreeNode = (ProjectTreeNode)this.tree.getSelectionPath().getLastPathComponent();
                return projectTreeNode.getUserObject() instanceof BOWithSpecificName;
            }
        };
        this.tree.setCellEditor(defaultTreeCellEditor);
    }

    protected void buildLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.treeSearchFacility = new JPanel();
        this.treeSearchFacility.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
        JLabel jLabel = new JLabel();
        jLabel.setIcon(Icons.searchProjectTree);
        this.treeSearchFacility.add((Component)jLabel, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.searchField = new OTTextField("", 15);
        ArrayList<String> arrayList = new ArrayList<String>();
        Autocomplete autocomplete = new Autocomplete(this.searchField, arrayList);
        this.searchField.getDocument().addDocumentListener(autocomplete);
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "commit");
        this.searchField.getActionMap().put("commit", new Autocomplete.CommitAction(autocomplete));
        this.searchField.setFocusTraversalKeysEnabled(false);
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "clear");
        this.searchField.getActionMap().put("clear", new ClearSearchFieldAction());
        gridBagConstraints2.weightx = 1.0;
        ++gridBagConstraints2.gridx;
        this.treeSearchFacility.add((Component)this.searchField, gridBagConstraints2);
        JButton jButton = new JButton("");
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        this.treeSearchFacility.add((Component)jButton, gridBagConstraints2);
        JButton jButton2 = new JButton("");
        jButton2.setFocusPainted(false);
        jButton2.setMargin(new Insets(1, 1, 1, 1));
        ++gridBagConstraints2.gridx;
        this.treeSearchFacility.add((Component)jButton2, gridBagConstraints2);
        JButton jButton3 = new JButton("");
        jButton3.setFocusPainted(false);
        jButton3.setIcon(Icons.questionMark);
        jButton3.setMargin(new Insets(1, 1, 1, 1));
        jButton3.addActionListener(actionEvent -> {
            JDialog jDialog;
            URL uRL = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/searchuserdoc.html");
            JavaFXHTMLWindow javaFXHTMLWindow = new JavaFXHTMLWindow();
            try {
                jDialog = javaFXHTMLWindow.buildHTMLWindow(uRL, "Search Help", 700, 700);
            }
            catch (IOException iOException) {
                Log.logger(ProjectTree.class).warning("Unable to display help text " + iOException.getMessage());
                return;
            }
            jDialog.setVisible(true);
        });
        ++gridBagConstraints2.gridx;
        this.treeSearchFacility.add((Component)jButton3, gridBagConstraints2);
        OTActions.ActionProperties actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "";
        actionProperties.shortDesc = "Search down through the project tree for the given string";
        actionProperties.longDesc = "Search down through the project tree for the given string";
        actionProperties.icon = Icons.searchDown;
        OTAction oTAction = (OTAction)OTActions.createAction(new SearchProjectTree(this, SearchProjectTree.SearchDirection.Down), actionProperties);
        this.searchField.addActionListener(oTAction);
        this.searchField.addActionListener(actionEvent -> {
            OTTextField oTTextField = (OTTextField)actionEvent.getSource();
            autocomplete.addKeyword(oTTextField.getText());
        });
        jButton2.setAction(oTAction);
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "";
        actionProperties.icon = Icons.searchUp;
        actionProperties.shortDesc = "Search upwards through project tree for the given string";
        actionProperties.longDesc = "Search upwards project tree for the given string";
        OTAction oTAction2 = (OTAction)OTActions.createAction(new SearchProjectTree(this, SearchProjectTree.SearchDirection.Up), actionProperties);
        jButton.setAction(oTAction2);
        this.add((Component)this.treeSearchFacility, gridBagConstraints);
    }

    public void reloadFromProjectModel() {
        ProjectTreeNode projectTreeNode;
        ProjectModel projectModel = (ProjectModel)this.getModel();
        ObsProject obsProject = projectModel.getObsProject();
        this.topProjectTreeNode = new ProjectTreeNode(obsProject);
        this.tmodel = new DefaultTreeModel(this.topProjectTreeNode);
        ObsProgram obsProgram = null;
        ObsProposal obsProposal = null;
        obsProgram = obsProject.getObsProgram();
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        if (this.m_phase == 1 && obsProposal != null) {
            projectTreeNode = this.makeNode((BusinessObject)obsProposal);
            this.topProjectTreeNode.add(projectTreeNode);
        }
        if (this.m_phase == 2 && obsProgram != null) {
            projectTreeNode = this.makeNode((BusinessObject)obsProgram);
            this.topProjectTreeNode.add(projectTreeNode);
        }
        this.tree.setModel(this.tmodel);
        this.modelStructureListener.switchToProject(obsProject);
        this.switchToProblemList(obsProject);
    }

    private EditorManager getEditors() {
        return this.getGuiApi().getEditors();
    }

    public void fillNode(ProjectTreeNode projectTreeNode, IBusinessObject iBusinessObject) {
        Class<?> clazz = iBusinessObject.getClass();
        if (clazz.equals(ObsProgram.class)) {
            this.fillNode(projectTreeNode, (ObsProgram)iBusinessObject);
        } else if (clazz.equals(ObsProject.class)) {
            this.fillNode(projectTreeNode, iBusinessObject);
        } else if (clazz.equals(ObsProposal.class)) {
            this.fillNode(projectTreeNode, (ObsProposal)iBusinessObject);
        } else if (clazz.equals(ObsUnitControl.class)) {
            this.fillNode(projectTreeNode, (ObsUnitControl)iBusinessObject);
        } else if (clazz.equals(ObsUnitSet.class)) {
            this.fillNode(projectTreeNode, (ObsUnitSet)iBusinessObject);
        } else if (clazz.equals(ObsUnit.class)) {
            this.fillNode(projectTreeNode, (ObsUnit)iBusinessObject);
        } else if (clazz.equals(FieldPattern.class)) {
            this.fillNode(projectTreeNode, (FieldPattern)iBusinessObject);
        } else if (clazz.equals(SchedBlock.class)) {
            this.fillNode(projectTreeNode, (SchedBlock)iBusinessObject);
        } else if (clazz.equals(SourceProperty.class)) {
            this.fillNode(projectTreeNode, (SourceProperty)iBusinessObject);
        } else if (clazz.equals(SpectralSpec.class)) {
            this.fillNode(projectTreeNode, (SpectralSpec)iBusinessObject);
        } else if (clazz.equals(Circle.class)) {
            this.fillNode(projectTreeNode, (Field)((Object)((Circle)iBusinessObject)));
        } else if (clazz.equals(Rectangle.class)) {
            this.fillNode(projectTreeNode, (Field)((Object)((Rectangle)iBusinessObject)));
        } else if (clazz.equals(Polygon.class)) {
            this.fillNode(projectTreeNode, (Field)((Object)((Polygon)iBusinessObject)));
        } else if (clazz.equals(Ellipse.class)) {
            this.fillNode(projectTreeNode, (Field)((Object)((Ellipse)iBusinessObject)));
        } else if (clazz.equals(Target.class)) {
            this.fillNode(projectTreeNode, (Target)iBusinessObject);
        } else if (clazz.equals(ObservingGroup.class)) {
            this.fillNode(projectTreeNode, (ObservingGroup)iBusinessObject);
        } else if (clazz.equals(ScienceParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(PhaseCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(PointingCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(AmplitudeCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(DGCReferenceCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(DGCScienceCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(PolarizationCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(FocusCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(AtmosphericCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(DelayCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(CheckSourceCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(SidebandRatioCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(BandpassCalParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(OpticalPointingParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(RadiometricPointingParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(HolographyParameters.class)) {
            this.fillNode(projectTreeNode, (ObservingParameters)iBusinessObject);
        } else if (clazz.equals(AbstractBaseBandConfig.class)) {
            this.fillNode(projectTreeNode, (AbstractBaseBandConfig)iBusinessObject);
        } else if (iBusinessObject instanceof OpticalPointingScienceGoal) {
            this.fillNode(projectTreeNode, (AbstractScienceGoal)((Object)((OpticalPointingScienceGoal)iBusinessObject)));
        } else if (iBusinessObject instanceof ObservatoryGoal) {
            this.fillNode(projectTreeNode, (AbstractScienceGoal)((Object)((ObservatoryGoal)iBusinessObject)));
        } else if (iBusinessObject instanceof ScienceGoal) {
            this.fillNode(projectTreeNode, (AbstractScienceGoal)((Object)((ScienceGoal)iBusinessObject)));
        } else if (iBusinessObject instanceof FieldSource) {
            this.fillNode(projectTreeNode, (FieldSource)iBusinessObject);
        } else if (iBusinessObject instanceof OpticalCameraSpec) {
            this.fillNode(projectTreeNode, (OpticalCameraSpec)iBusinessObject);
        } else if (iBusinessObject instanceof WorkbookPage) {
            this.fillNode(projectTreeNode, (WorkbookPage)iBusinessObject);
        } else if (iBusinessObject instanceof OusCollection) {
            this.fillNode(projectTreeNode, (OusCollection)iBusinessObject);
        } else if (s_logged.add(clazz.getName())) {
            Log.logger((Object)this).fine("Unsupported BO class " + clazz.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillNode(ProjectTreeNode projectTreeNode, ObsProgram obsProgram) {
        this.getEditors().useSummaryFormEditor((BusinessObject)obsProgram);
        if (this.isPhase2Tree()) {
            TreeMap treeMap = new TreeMap();
            for (AbstractScienceGoal abstractScienceGoal : obsProgram.getAbstractScienceGoal()) {
                void object;
                String string = abstractScienceGoal.getClass().getSimpleName();
                if (treeMap.containsKey(string)) {
                    List list = (List)treeMap.get(string);
                } else {
                    Vector vector = new Vector();
                    treeMap.put(string, vector);
                }
                object.add(abstractScienceGoal);
            }
            for (List list : treeMap.values()) {
                for (AbstractScienceGoal abstractScienceGoal : list) {
                    projectTreeNode.add(this.makeNode((BusinessObject)abstractScienceGoal));
                }
            }
            ObsUnitSet obsUnitSet = obsProgram.getObsPlan();
            if (obsUnitSet.getSchedBlockCount() > 0) {
                try {
                    ObsUnitSet obsUnitSet2 = ObsUnitSet.createObsUnitSet();
                    for (SchedBlock schedBlock : obsUnitSet.getSchedBlock()) {
                        obsUnitSet.removeSchedBlock(schedBlock);
                        obsUnitSet2.addSchedBlock(schedBlock);
                    }
                    obsUnitSet.addObsUnitSet(obsUnitSet2);
                }
                catch (UnknownEntityException unknownEntityException) {
                    // empty catch block
                }
            }
            ProjectTreeNode projectTreeNode2 = null;
            for (ObsUnitSet obsUnitSet2 : obsUnitSet.getObsUnitSet()) {
                if (obsUnitSet2.getGeneratingScienceGoal() != null) continue;
                if (projectTreeNode2 == null) {
                    projectTreeNode2 = this.getOusFolderNode(projectTreeNode);
                }
                projectTreeNode2.add(this.makeNode((BusinessObject)obsUnitSet2));
            }
        }
    }

    private void fillNode(ProjectTreeNode projectTreeNode, ObsProposal obsProposal) {
        PhaseISciencePlanCollection phaseISciencePlanCollection = new PhaseISciencePlanCollection(ScienceGoal.class, obsProposal);
        ProjectTreeNode projectTreeNode2 = this.makeNode(phaseISciencePlanCollection);
        this.getEditors().useSummaryFormEditor(phaseISciencePlanCollection);
        projectTreeNode.add(projectTreeNode2);
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            projectTreeNode2.add(this.makeNode((BusinessObject)abstractScienceGoal));
        }
    }

    private void fillNode(ProjectTreeNode projectTreeNode, ObsUnitControl obsUnitControl) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, ObsUnit obsUnit) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, ObsUnitSet obsUnitSet) {
        ProjectTreeNode projectTreeNode2;
        ObsUnitSetComponent obsUnitSetComponent;
        int n;
        this.fillNode(projectTreeNode, (ObsUnit)((Object)obsUnitSet));
        for (n = 0; n < obsUnitSet.getObsUnitSetCount(); ++n) {
            obsUnitSetComponent = obsUnitSet.getObsUnitSet(n);
            projectTreeNode2 = this.makeNode((BusinessObject)obsUnitSetComponent);
            projectTreeNode.add(projectTreeNode2);
        }
        for (n = 0; n < obsUnitSet.getSchedBlockCount(); ++n) {
            try {
                obsUnitSetComponent = obsUnitSet.getSchedBlock(n);
                projectTreeNode2 = this.makeNode((BusinessObject)obsUnitSetComponent);
                projectTreeNode.add(projectTreeNode2);
                continue;
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
    }

    private void fillNode(ProjectTreeNode projectTreeNode, FieldPattern fieldPattern) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, ObservingParameters observingParameters) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, AbstractScienceGoal abstractScienceGoal) {
        try {
            EditorManager editorManager = this.getEditors();
            MultiPageEditor multiPageEditor = (MultiPageEditor)editorManager.editorFor(EditorManager.EditorType.FORM, abstractScienceGoal.getClass());
            if (multiPageEditor == null) {
                return;
            }
            for (int i = 0; i < multiPageEditor.getNumPages(); ++i) {
                WorkbookPage workbookPage = new WorkbookPage(multiPageEditor, abstractScienceGoal, i);
                ProjectTreeNode projectTreeNode2 = this.makeNode(workbookPage);
                projectTreeNode.add(projectTreeNode2);
                editorManager.addFormEditor(workbookPage, multiPageEditor);
            }
            editorManager.useSummaryFormEditor((BusinessObject)abstractScienceGoal);
            ObsUnitSet obsUnitSet = abstractScienceGoal.getObsUnitSet();
            if (obsUnitSet != null) {
                projectTreeNode.add(this.makeNode((BusinessObject)obsUnitSet));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void fillNode(ProjectTreeNode projectTreeNode, WorkbookPage workbookPage) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, OusCollection ousCollection) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, FieldSource fieldSource) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, OpticalCameraSpec opticalCameraSpec) {
    }

    private void addNodesFor(ProjectTreeNode projectTreeNode, ObservingParameters[] observingParametersArray) {
        for (ObservingParameters observingParameters : observingParametersArray) {
            ProjectTreeNode projectTreeNode2 = this.makeNode((BusinessObject)observingParameters);
            projectTreeNode.add(projectTreeNode2);
        }
    }

    private void fillNode(ProjectTreeNode projectTreeNode, SchedBlock schedBlock) {
        int n;
        EditorManager editorManager = this.getEditors();
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            ProjectTreeNode projectTreeNode2 = this.makeNode((BusinessObject)observingGroup);
            projectTreeNode.add(projectTreeNode2);
        }
        TargetCollection targetCollection = new TargetCollection(schedBlock);
        ProjectTreeNode projectTreeNode3 = new ProjectTreeNode(targetCollection);
        projectTreeNode.add(projectTreeNode3);
        editorManager.useSummaryFormEditor(targetCollection);
        for (n = 0; n < schedBlock.getTargetCount(); ++n) {
            Target target = schedBlock.getTarget(n);
            ProjectTreeNode projectTreeNode4 = this.makeNode((BusinessObject)target);
            projectTreeNode3.add(projectTreeNode4);
        }
        ResourceCollection resourceCollection = new ResourceCollection(schedBlock);
        ProjectTreeNode projectTreeNode5 = new ProjectTreeNode(resourceCollection);
        projectTreeNode.add(projectTreeNode5);
        FieldSourceCollection fieldSourceCollection = new FieldSourceCollection(schedBlock);
        projectTreeNode3 = new ProjectTreeNode(fieldSourceCollection);
        projectTreeNode5.add(projectTreeNode3);
        for (n = 0; n < schedBlock.getFieldSourceCount(); ++n) {
            FieldSource fieldSource = schedBlock.getFieldSource(n);
            ProjectTreeNode projectTreeNode6 = this.makeNode((BusinessObject)fieldSource);
            projectTreeNode3.add(projectTreeNode6);
        }
        editorManager.useSummaryFormEditor(fieldSourceCollection);
        InstrumentSpecCollection instrumentSpecCollection = new InstrumentSpecCollection(schedBlock);
        projectTreeNode3 = new ProjectTreeNode(instrumentSpecCollection);
        projectTreeNode5.add(projectTreeNode3);
        editorManager.useSummaryFormEditor(instrumentSpecCollection);
        for (n = 0; n < schedBlock.getSpectralSpecCount(); ++n) {
            SpectralSpec spectralSpec = schedBlock.getSpectralSpec(n);
            ProjectTreeNode projectTreeNode7 = this.makeNode((BusinessObject)spectralSpec);
            projectTreeNode3.add(projectTreeNode7);
        }
        for (n = 0; n < schedBlock.getOpticalCameraSpecCount(); ++n) {
            OpticalCameraSpec opticalCameraSpec = schedBlock.getOpticalCameraSpec(n);
            ProjectTreeNode projectTreeNode8 = this.makeNode((BusinessObject)opticalCameraSpec);
            projectTreeNode3.add(projectTreeNode8);
        }
        ObservingParametersCollection observingParametersCollection = new ObservingParametersCollection(schedBlock);
        projectTreeNode3 = new ProjectTreeNode(observingParametersCollection);
        projectTreeNode5.add(projectTreeNode3);
        editorManager.useSummaryFormEditor(observingParametersCollection);
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersScienceParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersPhaseCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersPointingCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersAmplitudeCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersPolarizationCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersFocusCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersAtmosphericCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersDGCReferenceCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersDGCScienceCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersDelayCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersCheckSourceCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersSidebandRatioCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersBandpassCalParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersHolographyParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersReservationParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersOpticalPointingParameters());
        this.addNodesFor(projectTreeNode3, (ObservingParameters[])schedBlock.getObservingParametersRadiometricPointingParameters());
    }

    private void fillNode(ProjectTreeNode projectTreeNode, SpectralSpec spectralSpec) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, AbstractBaseBandConfig abstractBaseBandConfig) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, SourceProperty sourceProperty) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, ObservingGroup observingGroup) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, Target target) {
    }

    private void fillNode(ProjectTreeNode projectTreeNode, Field field) {
    }

    public void addNode(ProjectTreeNode projectTreeNode, ProjectTreeNode projectTreeNode2, int n) {
        int n2 = n == -1 ? projectTreeNode2.getChildCount() : n;
        try {
            this.tmodel.insertNodeInto(projectTreeNode, projectTreeNode2, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeNode(ProjectTreeNode projectTreeNode) {
        this.tmodel.removeNodeFromParent(projectTreeNode);
    }

    public List<Action> getPopupItemList() {
        return this.popupItemList;
    }

    public ProjectTreeNode getTop() {
        return this.topProjectTreeNode;
    }

    public ObsProject getProject() {
        ProjectModel projectModel = (ProjectModel)this.getModel();
        if (projectModel == null) {
            return null;
        }
        return projectModel.getObsProject();
    }

    public void insertNodeInto(BusinessObject businessObject, ProjectTreeNode projectTreeNode, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        ProjectTreeNode projectTreeNode2 = this.makeNode(businessObject);
        defaultTreeModel.insertNodeInto(projectTreeNode2, projectTreeNode, n);
        this.tree.scrollPathToVisible(new TreePath(projectTreeNode2.getPath()));
    }

    public void removeNodeFrom(ProjectTreeNode projectTreeNode, ProjectTreeNode projectTreeNode2) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.removeNodeFromParent(projectTreeNode);
        if (projectTreeNode2 != null) {
            this.tree.scrollPathToVisible(new TreePath(projectTreeNode2.getPath()));
        }
    }

    public void setDndPending(boolean bl) {
        this.isDNDPending = bl;
    }

    public boolean isDndPending() {
        return this.isDNDPending;
    }

    public boolean isDndExportable(ProjectTreeNode projectTreeNode, int n) {
        ProjectTreeTransferHandler projectTreeTransferHandler = (ProjectTreeTransferHandler)this.tree.getTransferHandler();
        return projectTreeTransferHandler.canExportToClipboard(projectTreeNode, n);
    }

    public boolean isDndImportable(ProjectTreeNode projectTreeNode) {
        ProjectTreeTransferHandler projectTreeTransferHandler = (ProjectTreeTransferHandler)this.tree.getTransferHandler();
        return projectTreeTransferHandler.canImportFromClipboard(projectTreeNode);
    }

    public void setDndReadonly(boolean bl) {
        ProjectTreeTransferHandler projectTreeTransferHandler = (ProjectTreeTransferHandler)this.tree.getTransferHandler();
        projectTreeTransferHandler.setReadonly(bl);
    }

    public boolean isDndReadonly() {
        ProjectTreeTransferHandler projectTreeTransferHandler = (ProjectTreeTransferHandler)this.tree.getTransferHandler();
        return projectTreeTransferHandler.isReadonly();
    }

    public boolean isOusCompProtected() {
        return this.getEditors().isOusCompProtected();
    }

    public boolean isPhase2Tree() {
        return this.m_phase == 2;
    }

    public ProjectTreeNode makeNode(BusinessObject businessObject) {
        ProjectTreeNode projectTreeNode = new ProjectTreeNode(businessObject);
        this.fillNode(projectTreeNode, (IBusinessObject)businessObject);
        return projectTreeNode;
    }

    public void makeVisible(TreePath treePath) {
        this.tree.makeVisible(treePath);
    }

    public void refresh(TreeNode treeNode) {
        this.tmodel.reload(treeNode);
    }

    public void scrollTo(TreePath treePath) {
        try {
            this.tree.scrollPathToVisible(treePath);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void select(TreePath treePath) {
        this.tree.clearSelection();
        this.tree.addSelectionPath(treePath);
    }

    public void setBusyCursor(boolean bl) {
        this.getTree().setCursor(bl ? Cursor.getPredefinedCursor(3) : null);
        this.treeSearchFacility.setCursor(bl ? Cursor.getPredefinedCursor(3) : null);
    }

    public void setPopupItemList(List<Action> list) {
        this.popupItemList = list;
        if (list != null) {
            ProjectTreeMouseListener projectTreeMouseListener = new ProjectTreeMouseListener(list);
            this.tree.addMouseListener(projectTreeMouseListener);
        }
    }

    public OTTree getTree() {
        return this.tree;
    }

    public ProjectTreeNode findNodeBelow(ProjectTreeNode projectTreeNode2, Class<?> clazz) {
        ObjectFilter<ProjectTreeNode> objectFilter = projectTreeNode -> {
            Object object = projectTreeNode.getUserObject();
            return object != null && object.getClass().equals(clazz);
        };
        return this.findNodeBelow(projectTreeNode2, objectFilter);
    }

    public ProjectTreeNode findNodeBelow(ProjectTreeNode projectTreeNode2, IBusinessObject iBusinessObject) {
        ObjectFilter<ProjectTreeNode> objectFilter = projectTreeNode -> projectTreeNode.getUserObject() == iBusinessObject;
        return this.findNodeBelow(projectTreeNode2, objectFilter);
    }

    public ProjectTreeNode findNodeBelow(ProjectTreeNode projectTreeNode, ObjectFilter<ProjectTreeNode> objectFilter) {
        Enumeration<TreeNode> enumeration = projectTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)enumeration.nextElement();
            if (!objectFilter.accept(projectTreeNode2)) continue;
            return projectTreeNode2;
        }
        return null;
    }

    public List<ProjectTreeNode> findNodesBelow(ProjectTreeNode projectTreeNode, ObjectFilter<ProjectTreeNode> objectFilter) {
        ArrayList<ProjectTreeNode> arrayList = new ArrayList<ProjectTreeNode>(40);
        Enumeration<TreeNode> enumeration = projectTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)enumeration.nextElement();
            if (!objectFilter.accept(projectTreeNode2)) continue;
            arrayList.add(projectTreeNode2);
        }
        return arrayList;
    }

    public ProjectTreeNode findNode(IBusinessObject iBusinessObject) {
        return this.findNodeBelow(this.topProjectTreeNode, iBusinessObject);
    }

    private void switchToProblemList(ObsProject obsProject) {
        ProblemTableModel problemTableModel = this.getGuiApi().getProblemModel(obsProject);
        if (this.problemModel != null) {
            this.problemModel.removeProblemListListener(this);
        }
        this.problemModel = problemTableModel;
        this.problemModel.addProblemListListener(this);
    }

    @Override
    public void problemListChanged(ProblemListEvent problemListEvent) {
        switch (problemListEvent.getType()) {
            case 1061: {
                Log.logger((Object)this).fine("Clearing all errors from " + this);
                this.topProjectTreeNode.clearAllErrors();
                break;
            }
            case 1062: {
                this.recordValidationResults();
                this.getTree().repaint();
                break;
            }
        }
    }

    private void recordValidationResults() {
        Map<BusinessObject, ProjectTreeNode> map = this.createBreadthFirstProjectTreeNodeLookup();
        for (int i = 0; i < this.problemModel.getSize(); ++i) {
            Problem problem = this.problemModel.getProblemAt(i);
            Object object = problem.getResource();
            if (!(object instanceof BusinessObject)) continue;
            BusinessObject businessObject = (BusinessObject)object;
            ProjectTreeNode projectTreeNode = this.findNodeRepresentingBo(businessObject, map);
            if (projectTreeNode != null) {
                if (problem.isError()) {
                    projectTreeNode.setErrorStatus(8);
                    continue;
                }
                if (!problem.isWarning()) continue;
                projectTreeNode.setErrorStatus(4);
                continue;
            }
            Log.logger(ProjectTree.class).fine("bo not found in project tree " + businessObject.toString() + " " + problem.getDescription());
            this.findNodeRepresentingBo(businessObject, map);
        }
    }

    public ProjectTreeNode findNodeRepresentingBo(BusinessObject businessObject) {
        return this.findNodeRepresentingBo(businessObject, this.createBreadthFirstProjectTreeNodeLookup());
    }

    public Map<BusinessObject, ProjectTreeNode> createBreadthFirstProjectTreeNodeLookup() {
        HashMap<BusinessObject, ProjectTreeNode> hashMap = new HashMap<BusinessObject, ProjectTreeNode>();
        Enumeration<TreeNode> enumeration = this.topProjectTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)enumeration.nextElement();
            BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
            hashMap.put(businessObject, projectTreeNode);
        }
        return hashMap;
    }

    private ProjectTreeNode findNodeRepresentingBo(BusinessObject businessObject, Map<BusinessObject, ProjectTreeNode> map) {
        ProjectTreeNode projectTreeNode = null;
        LinkedList<BusinessObject> linkedList = new LinkedList<BusinessObject>();
        linkedList.add(businessObject);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.poll();
            BusinessObject businessObject2 = (BusinessObject)e;
            projectTreeNode = WorkBookPhase1EditorBOCoupling.isAPhase1BOWithWorkBook(e.getClass()) ? this.searchWorkBooks(businessObject2, map) : map.get(businessObject2);
            if (projectTreeNode != null) break;
            linkedList.addAll(businessObject2.referrers.get(Referring.By.UmlAttribution));
            linkedList.addAll(businessObject2.referrers.get(Referring.By.UmlComposition));
        }
        return projectTreeNode;
    }

    private ProjectTreeNode searchWorkBooks(@NonNull BusinessObject businessObject, @NonNull Map<BusinessObject, ProjectTreeNode> map) {
        WorkBookPhase1EditorBOCoupling workBookPhase1EditorBOCoupling;
        if (businessObject == null) {
            throw new NullPointerException("boToFind is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (map.size() == 0) {
            throw new IllegalArgumentException("Illegal argument: map.size (" + map.size() + ") did not pass the test: map.size == 0");
        }
        try {
            workBookPhase1EditorBOCoupling = WorkBookPhase1EditorBOCoupling.getValue(businessObject.getClass());
        }
        catch (UnknownBOTypeException unknownBOTypeException) {
            return null;
        }
        assert (workBookPhase1EditorBOCoupling != null);
        for (BusinessObject businessObject2 : map.keySet()) {
            Editor editor;
            Object object;
            WorkbookPage workbookPage;
            View view;
            if (!(businessObject2 instanceof WorkbookPage) || (view = (workbookPage = (WorkbookPage)businessObject2).getCollector().getPageContent(workbookPage.getIndex())) == null || !workBookPhase1EditorBOCoupling.isUsingEditorType(view) || (object = (editor = (Editor)view).getModel().getDocument()) == null || !businessObject.getParent().equals(workbookPage.getParent())) continue;
            return map.get(businessObject2);
        }
        return null;
    }

    public ProjectTreeNode getOusFolderNode(ProjectTreeNode projectTreeNode) {
        Object object;
        ObsProgram obsProgram;
        try {
            obsProgram = (ObsProgram)projectTreeNode.getUserObject();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        ProjectTreeNode projectTreeNode2 = null;
        Enumeration<TreeNode> enumeration = projectTreeNode.children();
        while (enumeration.hasMoreElements()) {
            object = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(((DefaultMutableTreeNode)object).getUserObject() instanceof OusCollection)) continue;
            projectTreeNode2 = (ProjectTreeNode)object;
        }
        if (projectTreeNode2 == null) {
            object = new OusCollection(obsProgram);
            projectTreeNode2 = this.makeNode((BusinessObject)object);
            projectTreeNode.add(projectTreeNode2);
            this.refresh(projectTreeNode);
        }
        return projectTreeNode2;
    }

    public ProjectTreeNode getPhaseISciencePlanCollectionNode(ProjectTreeNode projectTreeNode) {
        if (!(projectTreeNode.getUserObject() instanceof ObsProposal)) {
            return null;
        }
        Enumeration<TreeNode> enumeration = projectTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof PhaseISciencePlanCollection)) continue;
            return (ProjectTreeNode)defaultMutableTreeNode;
        }
        return null;
    }

    public String getSearchString() {
        return StringUtils.trimToEmpty((String)this.searchField.getText());
    }

    public DefaultTreeModel getTmodel() {
        return this.tmodel;
    }

    private static enum WorkBookPhase1EditorBOCoupling {
        PERFORMANCEPARAMETERS(SfiControlParameterEditor.class, PerformanceParameters.class),
        TECHNICALJUSTIFICATION(TechnicalJustificationEditor.class, TechnicalJustification.class),
        CALIBRATIONSETUPPARAMETERS(CalibrationSetupParametersEditor.class, CalibrationSetupParameters.class),
        SPECTRALSETUPPARAMETERS(SfiSpectralSetupEditor.class, SpectralSetupParameters.class),
        TARGETPARAMETERS(FieldSetupEditor.class, TargetParameters.class);

        private Class<?> editor;
        private Class<?> bo;

        public boolean isUsingEditorType(View view) {
            if (!Editor.class.isAssignableFrom(view.getClass())) {
                return false;
            }
            return this.editor.equals(view.getClass());
        }

        public static boolean isAPhase1BOWithWorkBook(Class<? extends Object> clazz) {
            for (WorkBookPhase1EditorBOCoupling workBookPhase1EditorBOCoupling : WorkBookPhase1EditorBOCoupling.values()) {
                if (!workBookPhase1EditorBOCoupling.getBo().equals(clazz)) continue;
                return true;
            }
            return false;
        }

        public static WorkBookPhase1EditorBOCoupling getValue(Class<? extends BusinessObject> clazz) throws UnknownBOTypeException {
            for (WorkBookPhase1EditorBOCoupling workBookPhase1EditorBOCoupling : WorkBookPhase1EditorBOCoupling.values()) {
                if (!workBookPhase1EditorBOCoupling.getBo().equals(clazz)) continue;
                return workBookPhase1EditorBOCoupling;
            }
            throw new UnknownBOTypeException(String.format("BO of class %s is unknown", clazz.getClass()));
        }

        private WorkBookPhase1EditorBOCoupling(Class<?> clazz, Class<?> clazz2) {
            this.editor = clazz;
            this.bo = clazz2;
        }

        public Class<?> getBo() {
            return this.bo;
        }
    }

    public static class UnknownBOTypeException
    extends Exception {
        public UnknownBOTypeException(String string) {
            super(string);
        }
    }

    public class ClearSearchFieldAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OTTextField oTTextField = (OTTextField)actionEvent.getSource();
            oTTextField.setText("");
        }
    }
}

