/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.ReferencePointEditor;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReferencePointModel
extends Model {
    private CoordsModel referenceCoordinatesModel = new CoordsModel(null);
    private ValueUnitPairModel integrationTimeModel = new ValueUnitPairModel();
    private ValueUnitPairModel cycleTimeModel = new ValueUnitPairModel();
    private ValueUnitPairModel subScanDurationModel = new ValueUnitPairModel();

    public ReferencePointModel(Object object) {
        super(object);
        this.registerSubModel(this.referenceCoordinatesModel);
        this.registerSubModel(this.integrationTimeModel);
        this.registerSubModel(this.cycleTimeModel);
        this.registerSubModel(this.subScanDurationModel);
        this.setDocument(object);
    }

    protected Reference getReference() {
        return (Reference)this.getDocument();
    }

    @Override
    public void publish() {
        if (this.referenceCoordinatesModel != null) {
            this.referenceCoordinatesModel.publish();
        }
        if (this.integrationTimeModel != null) {
            this.integrationTimeModel.publish();
        }
        if (this.cycleTimeModel != null) {
            this.cycleTimeModel.publish();
        }
        if (this.subScanDurationModel != null) {
            this.subScanDurationModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        if (fieldID.equals(ReferencePointEditor.FID_REFADJUST_BUTTON)) {
            try {
                this.adjustSubscanDuration();
            }
            catch (UnableToAdjustSubscanDurationException unableToAdjustSubscanDurationException) {
                Log.logger(ReferencePointModel.class).warning("Unable to adjust the subscan duration");
                return object;
            }
        } else if (fieldID.equals(ReferencePointEditor.FID_COPY_REFERENCEPOSITION)) {
            this.copyReferencePositionToOtherFieldSources();
        }
        return string;
    }

    private void copyReferencePositionToOtherFieldSources() {
        Reference reference = this.getReference();
        FieldSource fieldSource3 = (FieldSource)reference.getParent();
        int n = 0;
        for (Reference reference2 : fieldSource3.getReference()) {
            if (reference2.equals(reference)) break;
            ++n;
        }
        if (GUIUtilities.confirm(null, "<html>Copy reference position to reference position " + n + "<p>in all other science field sources in this SB ?</html>", GUIUtilities.DefaultResponse.NO)) {
            SchedBlock schedBlock = (SchedBlock)fieldSource3.getParent();
            int n2 = n;
            List list = Arrays.asList(schedBlock.getFieldSource()).stream().filter(fieldSource2 -> this.isReferencePositionToBeCopied((FieldSource)fieldSource2, fieldSource3)).collect(Collectors.toList());
            List list2 = list.stream().filter(fieldSource2 -> !this.copyReferencePosition((FieldSource)fieldSource2, fieldSource3, n2)).collect(Collectors.toList());
            if (!list2.isEmpty()) {
                Object object = list2.stream().limit(3L).map(fieldSource -> fieldSource.getSourceName()).collect(Collectors.joining(","));
                if (list2.size() > 3) {
                    object = (String)object + "...";
                }
                GUIUtilities.info(null, "Unable to copy reference position to the following field sources: " + (String)object);
            }
        }
    }

    private boolean isReferencePositionToBeCopied(FieldSource fieldSource, FieldSource fieldSource2) {
        if (fieldSource == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetFieldSource");
        }
        if (fieldSource2 == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: fieldSourceOfCurrentReferencePosition");
        }
        SchedBlock schedBlock = (SchedBlock)fieldSource.getParent();
        Optional<Target> optional = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().filter(target -> target.getFieldSource().equals(fieldSource)).findFirst();
        return optional.isPresent() && !fieldSource.equals(fieldSource2);
    }

    private boolean copyReferencePosition(FieldSource fieldSource, FieldSource fieldSource2, int n) {
        Reference[] referenceArray = fieldSource.getReference();
        if (referenceArray.length == 0 || n + 1 != referenceArray.length) {
            return false;
        }
        referenceArray = fieldSource.getReference();
        referenceArray[n] = fieldSource2.getReference(n).deepCopy();
        fieldSource.setReference(referenceArray);
        return true;
    }

    public void adjustSubscanDuration() throws UnableToAdjustSubscanDurationException {
        FieldSource fieldSource = (FieldSource)this.getReference().getParent();
        Target[] targetArray = fieldSource.getTargetList();
        if (targetArray.length > 0 && targetArray[0].getAbstractInstrumentSpec() != null && !(targetArray[0].getAbstractInstrumentSpec() instanceof OpticalCameraSpec)) {
            SpectralSpec spectralSpec = (SpectralSpec)((Object)targetArray[0].getAbstractInstrumentSpec());
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            if (abstractCorrelatorConfiguration == null) {
                throw new UnableToAdjustSubscanDurationException();
            }
            CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
            double d = this.getReference().getSubScanDuration().getContentInUnits(Time.UNIT_S);
            double d2 = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
            double d3 = correlatorExpert.calcSubscanDuration(d, d2, 1);
            this.getReference().getSubScanDuration().setContentAndUnit((ValueUnitPair)Time.createTimeSec(d3));
            this.getSubScanDurationModel().publish();
        }
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        Reference reference = this.getReference();
        if (reference != null) {
            this.getReferenceCoordinatesModel().setDocument(reference);
            Time time = reference.getIntegrationTime();
            this.getIntegrationTimeModel().setDocument(time);
            time = reference.getCycleTime();
            this.getCycleTimeModel().setDocument(time);
            time = reference.getSubScanDuration();
            this.getSubScanDurationModel().setDocument(time);
        }
    }

    public CoordsModel getReferenceCoordinatesModel() {
        return this.referenceCoordinatesModel;
    }

    public ValueUnitPairModel getIntegrationTimeModel() {
        return this.integrationTimeModel;
    }

    public ValueUnitPairModel getCycleTimeModel() {
        return this.cycleTimeModel;
    }

    public ValueUnitPairModel getSubScanDurationModel() {
        return this.subScanDurationModel;
    }

    public static class UnableToAdjustSubscanDurationException
    extends Exception {
    }
}

