/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.AbstractSwitchingState;
import alma.obsprep.bo.schedblock.BeamSwitchingCycle;
import alma.obsprep.bo.schedblock.BeamSwitchingState;
import alma.obsprep.ot.models.schedblock.AbstractSwitchingStateTableModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;

public class BeamSwitchingStateTableModel
extends AbstractSwitchingStateTableModel {
    private static final long serialVersionUID = -8107131203716409533L;
    protected static final int COLUMN_COUNT = 4;
    public static final int COL_POSITION = 2;
    public static final int COL_TRANSITION = 3;

    public BeamSwitchingStateTableModel() {
        this.columnDescriptors.add(new AbstractSwitchingStateTableModel.ColumnDescriptor("Position", Angle.class));
        this.columnDescriptors.add(new AbstractSwitchingStateTableModel.ColumnDescriptor("Transition", Time.class));
    }

    private BeamSwitchingCycle getBeamSwitchingCycle() {
        return (BeamSwitchingCycle)((Object)this.abstractSwitchingCycle);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        BeamSwitchingState beamSwitchingState = this.getBeamSwitchingCycle().getBeamSwitchingState(n);
        switch (n2) {
            case 2: {
                return beamSwitchingState.getPosition();
            }
            case 3: {
                return beamSwitchingState.getTransition();
            }
        }
        return super.getValueAt(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        BeamSwitchingState beamSwitchingState = this.getBeamSwitchingCycle().getBeamSwitchingState(n);
        switch (n2) {
            case 2: {
                beamSwitchingState.setPosition((Angle)((Object)object));
                break;
            }
            case 3: {
                beamSwitchingState.setTransition((Time)object);
                break;
            }
            default: {
                super.setValueAt(object, n, n2);
            }
        }
    }

    @Override
    public Object[] getLongValuesInternal() {
        return new Object[]{"12345 arcmin", "12345 ms"};
    }

    @Override
    protected AbstractSwitchingState getAbstractSwitchingState(int n) {
        return this.getBeamSwitchingCycle().getBeamSwitchingState(n);
    }

    @Override
    protected AbstractSwitchingState[] getAbstractSwitchingStates() {
        if (this.getBeamSwitchingCycle() != null) {
            return this.getBeamSwitchingCycle().getBeamSwitchingState();
        }
        return null;
    }

    @Override
    public void createAndSetNewAbstractSwitchingState() {
        BeamSwitchingState beamSwitchingState = BeamSwitchingState.createBeamSwitchingState();
        beamSwitchingState.setBin(this.getNewMaxBin());
        beamSwitchingState.setDwellTime(Time.createTime((double)0.0, (String)Time.UNIT_MS));
        beamSwitchingState.setPosition(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN));
        beamSwitchingState.setTransition(Time.createTime((double)0.0, (String)Time.UNIT_MS));
        this.getBeamSwitchingCycle().addBeamSwitchingState(beamSwitchingState);
    }

    @Override
    public void removeAbstractSwitchingCycle(int n) {
        this.getBeamSwitchingCycle().removeBeamSwitchingState(this.getBeamSwitchingCycle().getBeamSwitchingState(n));
    }
}

