/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.JointProposalPartner;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelStatusSubscriber;
import alma.obsprep.ot.editors.jointproposals.JointProposalEditor;
import alma.obsprep.ot.editors.jointproposals.JointProposalTableModel;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.services.experts.Configuration;
import java.util.stream.Stream;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class JointProposalModel
extends Model
implements ModelStatusSubscriber,
ProjectResetListener,
TableModelListener {
    public static final String JOINTPROPOSAL_NO = "No";
    public static final String JOINTPROPOSAL_YES = "Yes";
    private JointProposalTableModel jointProposalTableModel;

    public JointProposalModel(Object object) {
        super(object);
    }

    public void setJointProposalTableModel(@NonNull JointProposalTableModel jointProposalTableModel) {
        if (jointProposalTableModel == null) {
            throw new NullPointerException("jointProposalTableModel is marked non-null but is null");
        }
        this.jointProposalTableModel = jointProposalTableModel;
        jointProposalTableModel.addTableModelListener(this);
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        if (object instanceof JointProposal && this.jointProposalTableModel != null) {
            this.jointProposalTableModel.resetTableDocument();
        }
        this.publish();
    }

    public JointProposal getJointProposal() {
        return (JointProposal)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        JointProposal jointProposal = this.getJointProposal();
        if (jointProposal == null) {
            return;
        }
        this.publish(JointProposalEditor.IS_JOINT_PROPOSAL_FID, jointProposal.getIsJointProposal() ? JOINTPROPOSAL_YES : JOINTPROPOSAL_NO);
        this.publish(JointProposalEditor.JOINT_PROPOSAL_TYPE_FID, StringUtils.capitalize((String)StringUtils.lowerCase((String)jointProposal.getJointProposalType())));
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        JointProposal jointProposal = this.getJointProposal();
        if (fieldID.equals(JointProposalEditor.IS_JOINT_PROPOSAL_FID) && object instanceof String) {
            String string = (String)object;
            boolean bl = string.equals(JOINTPROPOSAL_YES);
            if (jointProposal.getIsJointProposal() != bl) {
                Configuration.refreshArrayConfigurations(bl, jointProposal.getJointProposalType());
            }
            jointProposal.setIsJointProposal(bl);
        } else if (fieldID.equals(JointProposalEditor.JOINT_PROPOSAL_TYPE_FID) && object instanceof String) {
            boolean bl = jointProposal.getIsJointProposal();
            String string = StringUtils.upperCase((String)((String)object));
            if (!jointProposal.getJointProposalType().equals(string)) {
                Configuration.refreshArrayConfigurations(bl, string);
            }
            jointProposal.setJointProposalType(string);
        } else if (fieldID.getKey().contains("JointPartnerJustification") && object instanceof String) {
            int n = Integer.parseInt(fieldID.getKey().substring(fieldID.getKey().length() - 1));
            try {
                JointProposalPartner jointProposalPartner = jointProposal.getJointProposalPartner(n);
                jointProposalPartner.setJustification((String)object);
            }
            catch (Exception exception) {
                Log.logger(JointProposalModel.class).warning("Unable to find the partner " + n + " in the joint proposal " + exception.getMessage());
            }
        }
        return object;
    }

    @Override
    public void fieldInvalid(Model model, FieldID fieldID, String string) {
    }

    @Override
    public void fieldValid(Model model, FieldID fieldID) {
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(ObsProposalEditor.PROPOSALTYPE_FID) && object instanceof String) {
            String string = (String)object;
            if (StringUtils.isEmpty((CharSequence)string)) {
                return;
            }
            this.determineProposalTypeInfluenceOnJointProposals(string);
        }
    }

    private void determineProposalTypeInfluenceOnJointProposals(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = AlmaPolicies.getInstance().getCodeForProposalType(string);
        boolean bl = !ObsProposal.isProjectCodeVLBIRelated(string2) && !string2.equals("L");
        JointProposal jointProposal = this.getJointProposal();
        if (!bl) {
            // empty if block
        }
        this.publish(JointProposalEditor.IS_JOINT_PROPOSAL_EDITABLE_FID, new JointProposalUserControl(jointProposal.getIsJointProposal(), bl, true));
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.publish(JointProposalEditor.IS_JOINT_PROPOSAL_TABLE_FID, (Object)this.getJointProposal());
    }

    public void resetMainObservatorySelected() {
        Stream.of(this.getJointProposal().getJointProposalPartner()).forEach(jointProposalPartner -> jointProposalPartner.setIsMainObservatory(false));
    }

    public void setJointProposalsEnabled(boolean bl) {
        this.getJointProposal().setIsJointProposal(false);
        this.publish();
    }

    public boolean getJointProposalsEnabled() {
        return this.getJointProposal().getIsJointProposal();
    }

    public String getJointProposalType() {
        return this.getJointProposal().getJointProposalType();
    }

    public static class JointProposalUserControl {
        private boolean isJointPartnerProposal = false;
        private boolean isRequestedProjectTypePartnerJointProposalsCompatible = false;
        private boolean isRequestedProjectTypeMainJointProposalsCompatible = false;

        public boolean isJointProposalsUserControllable() {
            return this.isRequestedProjectTypeMainJointProposalsCompatible || this.isRequestedProjectTypePartnerJointProposalsCompatible;
        }

        public boolean isJointPartnerProposal() {
            return this.isJointPartnerProposal;
        }

        public boolean isRequestedProjectTypePartnerJointProposalsCompatible() {
            return this.isRequestedProjectTypePartnerJointProposalsCompatible;
        }

        public boolean isRequestedProjectTypeMainJointProposalsCompatible() {
            return this.isRequestedProjectTypeMainJointProposalsCompatible;
        }

        public void setJointPartnerProposal(boolean bl) {
            this.isJointPartnerProposal = bl;
        }

        public void setRequestedProjectTypePartnerJointProposalsCompatible(boolean bl) {
            this.isRequestedProjectTypePartnerJointProposalsCompatible = bl;
        }

        public void setRequestedProjectTypeMainJointProposalsCompatible(boolean bl) {
            this.isRequestedProjectTypeMainJointProposalsCompatible = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof JointProposalUserControl)) {
                return false;
            }
            JointProposalUserControl jointProposalUserControl = (JointProposalUserControl)object;
            if (!jointProposalUserControl.canEqual(this)) {
                return false;
            }
            if (this.isJointPartnerProposal() != jointProposalUserControl.isJointPartnerProposal()) {
                return false;
            }
            if (this.isRequestedProjectTypePartnerJointProposalsCompatible() != jointProposalUserControl.isRequestedProjectTypePartnerJointProposalsCompatible()) {
                return false;
            }
            return this.isRequestedProjectTypeMainJointProposalsCompatible() == jointProposalUserControl.isRequestedProjectTypeMainJointProposalsCompatible();
        }

        protected boolean canEqual(Object object) {
            return object instanceof JointProposalUserControl;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isJointPartnerProposal() ? 79 : 97);
            n = n * 59 + (this.isRequestedProjectTypePartnerJointProposalsCompatible() ? 79 : 97);
            n = n * 59 + (this.isRequestedProjectTypeMainJointProposalsCompatible() ? 79 : 97);
            return n;
        }

        public String toString() {
            return "JointProposalModel.JointProposalUserControl(isJointPartnerProposal=" + this.isJointPartnerProposal() + ", isRequestedProjectTypePartnerJointProposalsCompatible=" + this.isRequestedProjectTypePartnerJointProposalsCompatible() + ", isRequestedProjectTypeMainJointProposalsCompatible=" + this.isRequestedProjectTypeMainJointProposalsCompatible() + ")";
        }

        public JointProposalUserControl(boolean bl, boolean bl2, boolean bl3) {
            this.isJointPartnerProposal = bl;
            this.isRequestedProjectTypePartnerJointProposalsCompatible = bl2;
            this.isRequestedProjectTypeMainJointProposalsCompatible = bl3;
        }
    }
}

