/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.editors.valuetypes.UnitsToDisplayManagerInterface;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import alma.obsprep.util.TextUtils;
import java.awt.FlowLayout;
import java.util.IllegalFormatException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.commons.lang3.StringUtils;

public class ValueUnitPairView
extends Editor {
    public static double ILLEGAL_VALUE = 0.0;
    private String formatString = "%.5g %s";
    private int fieldWidth = 8;
    protected Map<String, String> uiToBOUnitMapping = null;
    protected OTTextField vupTextField;
    protected OTTextField textField;
    protected FieldID unitFID;
    protected JComboBox<String> units;
    protected FieldID valueFID;
    protected String[] unitList;
    private final UnitsToDisplayManagerInterface unitsToDisplayManager;
    private FieldID principalFieldId = null;
    private final boolean isLabel;

    @Override
    protected void build() {
        this.vupTextField = new OTTextField(this.fieldWidth);
        this.textField = new OTTextField(this.fieldWidth);
        if (this.isLabel) {
            this.vupTextField.setBorder(BorderFactory.createEmptyBorder());
            this.textField.setBorder(BorderFactory.createEmptyBorder());
        }
        this.units = this.unitList == null ? new JComboBox() : new JComboBox<String>(this.unitList);
        if (this.uiToBOUnitMapping != null) {
            for (String string : this.uiToBOUnitMapping.keySet()) {
                this.createUILabelMapping(this.units, this.uiToBOUnitMapping.get(string), string);
            }
        }
        this.initEvents(this.textField, this.valueFID);
        this.initEvents(this.units, this.unitFID);
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setAlignment(0);
        this.add(this.vupTextField);
        this.textField.setEditable(false);
        this.vupTextField.setEditable(false);
        this.units.setEnabled(false);
        this.textField.setEditable(false);
    }

    public OTTextField getInput() {
        return this.textField;
    }

    public JComboBox getUnits() {
        return this.units;
    }

    public String getSelectedUnit() {
        String string = (String)this.units.getSelectedItem();
        return this.getUILabelToBOMapping(this.units, string);
    }

    public FieldID getValueFID() {
        return this.valueFID;
    }

    public FieldID getUnitFID() {
        return this.unitFID;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEnabled(this.textField, bl);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public void setEditable(boolean bl) {
        throw new UnsupportedOperationException("This view cannot be made editable");
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    @Override
    public void setToolTipText(String string) {
        this.textField.setToolTipText(string);
    }

    private String getFriendlyUnit(AbstractValueUnitPairModel abstractValueUnitPairModel, String[] stringArray) {
        ValueUnitPair valueUnitPair = (ValueUnitPair)abstractValueUnitPairModel.getDocument();
        if (valueUnitPair == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: vup");
        }
        Object[] objectArray = valueUnitPair.unitMap().getUnitsSorted();
        String string = null;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            string = (String)objectArray[i];
            boolean bl = false;
            if (stringArray != null && stringArray.length > 0) {
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
            if (!bl || !(valueUnitPair.getContentInUnits(string) > 1.0)) continue;
            return string;
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return string;
    }

    public ValueUnitPair convertToFriendlyUnit(AbstractValueUnitPairModel abstractValueUnitPairModel) {
        ValueUnitPair valueUnitPair = (ValueUnitPair)abstractValueUnitPairModel.getDocument();
        if (valueUnitPair == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: vup");
        }
        if (valueUnitPair.isZero()) {
            return valueUnitPair;
        }
        valueUnitPair.convertToUnit(this.getFriendlyUnit(abstractValueUnitPairModel, null));
        return valueUnitPair;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        AbstractValueUnitPairModel abstractValueUnitPairModel = (AbstractValueUnitPairModel)this.getModel();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        if (fieldID.equals(this.unitFID)) {
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            if (this.unitList == null) {
                Object[] objectArray = abstractValueUnitPairModel.unitMap().getUnitsSorted();
                this.suspendEvents(jComboBox);
                for (Object object2 : objectArray) {
                    defaultComboBoxModel.addElement(object2);
                }
                jComboBox.setModel(defaultComboBoxModel);
                this.resumeEvents(jComboBox);
            }
            this.set(jComboBox, (String)object);
        } else {
            double d;
            ValueUnitPair valueUnitPair = abstractValueUnitPairModel.getVUP();
            assert (valueUnitPair != null);
            String string = null;
            String[] stringArray = null;
            if (this.unitsToDisplayManager != null) {
                stringArray = this.unitsToDisplayManager.getUnitCategoryForDisplay(this.principalFieldId, valueUnitPair);
            }
            try {
                string = this.getFriendlyUnit(abstractValueUnitPairModel, stringArray);
                d = valueUnitPair.getContentInUnits(string);
            }
            catch (Exception exception) {
                string = valueUnitPair.getUnit();
                d = valueUnitPair.getContentInUnits(string);
            }
            assert (string != null);
            try {
                String string2 = "";
                if (d != ILLEGAL_VALUE) {
                    string2 = StringUtils.replace((String)String.format(this.formatString, d, string), (String)"arcsec", (String)"\"");
                }
                this.set(this.vupTextField, string2);
            }
            catch (IllegalFormatException illegalFormatException) {
                Log.logger(ValueUnitPairView.class).warning("Unable to format " + d);
            }
            super.update(fieldID, object);
        }
    }

    @Override
    public Object widgetModified(FieldID fieldID, Object object) {
        if (fieldID.equals(this.unitFID)) {
            ValueUnitPair valueUnitPair = (ValueUnitPair)this.getModel().getDocument();
            String string = (String)object;
            valueUnitPair.convertToUnit(string);
            this.getModel().publish(this.valueFID, TextUtils.format(valueUnitPair.getContent(), 0, 5));
        }
        return object;
    }

    private ValueUnitPairView(Builder builder) {
        if (builder.abstractValueUnitPairModel == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: builder.abstractValueUnitPairModel");
        }
        if (builder.fieldWidth != null) {
            this.fieldWidth = builder.fieldWidth;
        }
        if (builder.formatString != null) {
            this.formatString = builder.formatString;
        }
        this.uiToBOUnitMapping = builder.uiToBOUnitMapping;
        this.valueFID = builder.abstractValueUnitPairModel.getValueFID();
        this.unitFID = builder.abstractValueUnitPairModel.getUnitFID();
        this.unitList = builder.unitList;
        this.unitsToDisplayManager = builder.unitsToDisplayManager;
        this.principalFieldId = builder.principalIdentifier;
        this.isLabel = builder.isLabel;
        if (this.unitsToDisplayManager != null && this.principalFieldId == null) {
            throw new RuntimeException("The principalIdentifier should be specified if the unitsToDisplayManager is to be used");
        }
        this.build();
        this.setModel(builder.abstractValueUnitPairModel);
    }

    public static class Builder {
        private Map<String, String> uiToBOUnitMapping = null;
        private AbstractValueUnitPairModel abstractValueUnitPairModel = null;
        private String[] unitList = null;
        private String formatString = null;
        private Integer fieldWidth = null;
        private UnitsToDisplayManagerInterface unitsToDisplayManager = null;
        private FieldID principalIdentifier = null;
        private boolean isLabel = false;

        public Builder uiToBOUnitMapping(Map<String, String> map) {
            this.uiToBOUnitMapping = map;
            return this;
        }

        public Builder abstractValueUnitPairModel(AbstractValueUnitPairModel abstractValueUnitPairModel) {
            this.abstractValueUnitPairModel = abstractValueUnitPairModel;
            return this;
        }

        public Builder principalIdentifier(FieldID fieldID) {
            this.principalIdentifier = fieldID;
            return this;
        }

        public Builder isLabel(boolean bl) {
            this.isLabel = bl;
            return this;
        }

        public Builder unitList(String[] stringArray) {
            this.unitList = stringArray;
            return this;
        }

        public Builder formatString(String string) {
            this.formatString = string;
            return this;
        }

        public Builder fieldWidth(int n) {
            this.fieldWidth = n;
            return this;
        }

        public Builder unitsToDisplayManager(UnitsToDisplayManagerInterface unitsToDisplayManagerInterface) {
            this.unitsToDisplayManager = unitsToDisplayManagerInterface;
            return this;
        }

        public ValueUnitPairView build() {
            return new ValueUnitPairView(this);
        }
    }
}

