/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.obsprep.bo.BOUtilities;
import alma.obsprep.bo.DefaultObservingFrequency;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.BLCorrelatorModes;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.valuetypes.ObservingFrequencyModel;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import java.util.Optional;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import lombok.NonNull;

public class ObservingFrequencyEditor
extends Editor {
    private CorrPolarization previousPolarisationSetting;
    public static final FieldID INPUT_FREQUENCY_VUP = new FieldID("ObservingFrequencyEditor.inputFrequencyVUP");
    private JComboBox<Integer> standardFrequencyBandJComboBox;
    private JButton resetToStandardButton;

    public ObservingFrequencyEditor(Model model2) {
        this.setModel(model2);
        this.build();
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            if (fieldID.equals(SfiSpectralSetupEditor.FID_POLARIZATION)) {
                CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization((String)object);
                this.setupPolarizationSpecificStandardFrequencies(corrPolarization);
            }
        };
        model2.getParentModel().subscribe(modelChangeSubscriber);
        model2.publish();
    }

    @Override
    public ObservingFrequencyModel getModel() {
        return (ObservingFrequencyModel)super.getModel();
    }

    @Override
    protected void build() {
        OTButtonGroup oTButtonGroup = new OTButtonGroup(ObservingFrequency.FrequencyType.getLabels());
        this.initEvents(oTButtonGroup, ObservingFrequencyModel.FREQUENCY_TYPE_FID);
        JLabel jLabel = new JLabel("Receiver Band");
        this.standardFrequencyBandJComboBox = new JComboBox();
        this.standardFrequencyBandJComboBox.setName("observingFrequencyEditor.standardFrequencyBandJComboBox");
        this.standardFrequencyBandJComboBox.setToolTipText("<html>List of bands available with the selected polarization.</html>");
        this.standardFrequencyBandJComboBox.setRenderer(new StandardFrequencyComboBoxRenderer());
        this.initEvents(this.standardFrequencyBandJComboBox, ObservingFrequencyModel.BAND_SELECTED_FID);
        this.addLabeledWidget(jLabel, this.standardFrequencyBandJComboBox);
        jLabel = new JLabel();
        this.register(jLabel, ObservingFrequencyModel.EDITOR_LABEL_FID);
        this.resetToStandardButton = new JButton("Reset to Standard Frequency");
        this.resetToStandardButton.setToolTipText("Reset the single continuum central frequency to the band default");
        this.resetToStandardButton.setName("observingFrequencyEditor.resetToStandardButton");
        this.initEvents(this.resetToStandardButton, ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID);
        this.addLabeledWidget(new JLabel(""), this.resetToStandardButton);
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(this.getModel().getFrequencyModel());
        valueUnitPairEditor.setToolTipText("<html>The continuum central frequency in the sky frame.</HTML>");
        this.register(valueUnitPairEditor, INPUT_FREQUENCY_VUP);
        this.registerSubView(valueUnitPairEditor);
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(valueUnitPairEditor, false));
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents(List.of(this.resetToStandardButton, jLabel, valueUnitPairEditor.getInput()));
        jLabel = new JLabel();
        this.register(jLabel, ObservingFrequencyModel.REST_FREQ_FEEDBACK_LABEL_FID);
        OTTextField oTTextField = new OTTextField();
        oTTextField.setToolTipText("Single continuum central frequency in the rest frame");
        oTTextField.setEditable(false);
        oTTextField.setFocusable(false);
        this.register(oTTextField, ObservingFrequencyModel.REST_FREQ_FEEDBACK_AREA_FID);
        this.addLabeledWidget(jLabel, oTTextField);
        OTButtonGroup oTButtonGroup2 = this.makeOTButtonGroup(ObservingFrequencyModel.CORRELATOR_MODE, BLCorrelatorModes.values(), null, 1);
        oTButtonGroup2.setSelectedItem(BLCorrelatorModes.TDM.getUILabel());
        this.initEvents(oTButtonGroup2, ObservingFrequencyModel.CORRELATOR_MODE);
        this.addLabeledWidget(new JLabel(""), oTButtonGroup2);
        this.setInsetAboveComponent(5);
        this.setInsetBelowComponent(5);
        this.layoutLabeledWidgets();
    }

    @Override
    public void configureEditorForView(ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        if (ScienceGoalEditorViewEnum.VLBI.equals((Object)scienceGoalEditorViewEnum)) {
            this.configureEditorForVLBIView();
        } else if (ScienceGoalEditorViewEnum.SOLAR.equals((Object)scienceGoalEditorViewEnum)) {
            this.configureEditorForSolarView();
        } else {
            this.configureEditorForStandardView();
        }
    }

    private void configureEditorForStandardView() {
        this.getComponent(ObservingFrequencyModel.CORRELATOR_MODE).setEnabled(true);
        this.getComponent(ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID).setEnabled(true);
        this.setupPolarizationSpecificStandardFrequencies();
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(INPUT_FREQUENCY_VUP);
        valueUnitPairEditor.setEnabled(true);
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)this.resetToStandardButton, (Object)valueUnitPairEditor.getInput()));
    }

    private void configureEditorForSolarView() {
        JComponent jComponent = this.getComponent(ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID);
        this.getComponent(ObservingFrequencyModel.CORRELATOR_MODE).setEnabled(false);
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(INPUT_FREQUENCY_VUP);
        valueUnitPairEditor.setEnabled(false);
        this.setupPolarizationSpecificStandardFrequencies(this.getModel().getPolarization());
        jComponent.setEnabled(false);
        UserEditRestrictionController.getInstance().removeUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)this.resetToStandardButton, (Object)valueUnitPairEditor.getInput()));
    }

    private void configureEditorForVLBIView() {
        this.getComponent(ObservingFrequencyModel.CORRELATOR_MODE).setEnabled(false);
        JComponent jComponent = this.getComponent(ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID);
        assert (jComponent != null);
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(INPUT_FREQUENCY_VUP);
        valueUnitPairEditor.setEnabled(false);
        boolean bl = false;
        try {
            bl = ObsProposal.isProposalPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ObservingFrequencyEditor.class).warning("Unable to determine if we are in VLBI pulsar mode " + unknownEntityException.getMessage());
        }
        List<Frequency> list = bl ? almaCapabilities.getVLBIPhaserFrequencies() : almaCapabilities.getVLBIFrequencies();
        String[] stringArray = OTConfigurationHelper.getFrequencyListAsStr(list, Frequency.UNIT_GHZ);
        this.configureStandardFrequenciesComboBox(stringArray, false);
        jComponent.setEnabled(false);
        UserEditRestrictionController.getInstance().removeUserChangeRestrictionAffectedComponents(List.of(this.resetToStandardButton, valueUnitPairEditor.getInput()));
    }

    private void setupPolarizationSpecificStandardFrequencies() {
        if (this.previousPolarisationSetting == null) {
            return;
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        String[] stringArray = this.previousPolarisationSetting.equals((Object)CorrPolarization.FULL) ? OTConfigurationHelper.getFrequencyListAsStr(almaCapabilities.getPolarizationFrequencies(), Frequency.UNIT_GHZ) : OTConfigurationHelper.getFrequencyListAsStr(almaCapabilities.getContinuumFrequencies(), Frequency.UNIT_GHZ);
        this.configureStandardFrequenciesComboBox(stringArray, true);
    }

    public void setupPolarizationSpecificStandardFrequencies(CorrPolarization corrPolarization) {
        Object object;
        String[] stringArray;
        if (this.previousPolarisationSetting != null && (this.previousPolarisationSetting.equals((Object)CorrPolarization.DOUBLE) && corrPolarization.equals((Object)CorrPolarization.SINGLE_X) || this.previousPolarisationSetting.equals((Object)CorrPolarization.SINGLE_X) && corrPolarization.equals((Object)CorrPolarization.DOUBLE))) {
            this.previousPolarisationSetting = corrPolarization;
        }
        Object object2 = this.getModel().getDocument();
        boolean bl = false;
        boolean bl2 = false;
        if (object2 != null) {
            stringArray = (String[])object2;
            object = stringArray.getSpectralSetupParameters();
            bl = this.isVLBI((SpectralSetupParameters)((Object)object));
            try {
                bl2 = ((SpectralSetupParameters)((Object)object)).getScienceGoal().isSolarScienceGoal();
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        object = AlmaCapabilities.getInstance();
        if (bl) {
            boolean bl3 = false;
            try {
                bl3 = ObsProposal.isProposalPhasedArray();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(ObservingFrequencyEditor.class).warning("Unable to determine if we are in VLBI pulsar mode " + unknownEntityException.getMessage());
            }
            List<Frequency> list = bl3 ? ((AlmaCapabilities)object).getVLBIPhaserFrequencies() : ((AlmaCapabilities)object).getVLBIFrequencies();
            stringArray = OTConfigurationHelper.getFrequencyListAsStr(list, Frequency.UNIT_GHZ);
        } else {
            boolean bl4 = corrPolarization.equals((Object)CorrPolarization.FULL);
            stringArray = bl2 ? (bl4 && Telescope.isOTConfiguredAs(Telescope.CSVALMA) ? OTConfigurationHelper.getSolarFrequenciesAsStr(((AlmaCapabilities)object).getSolarBandsForFullPolarization(), Frequency.UNIT_GHZ) : OTConfigurationHelper.getSolarFrequenciesAsStr(((AlmaCapabilities)object).getSolarBands(), Frequency.UNIT_GHZ)) : (bl4 ? OTConfigurationHelper.getFrequencyListAsStr(((AlmaCapabilities)object).getPolarizationFrequencies(), Frequency.UNIT_GHZ) : OTConfigurationHelper.getFrequencyListAsStr(((AlmaCapabilities)object).getContinuumFrequencies(), Frequency.UNIT_GHZ));
        }
        assert (stringArray.length > 0);
        this.configureStandardFrequenciesComboBox(stringArray, false);
        this.previousPolarisationSetting = corrPolarization;
    }

    private boolean isVLBI(@NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("spectralSetupParameters is marked non-null but is null");
        }
        boolean bl = false;
        BusinessObject businessObject = BOUtilities.findTreeRoot((BusinessObject)spectralSetupParameters);
        if (businessObject instanceof ObsProposal) {
            ObsProposal obsProposal = (ObsProposal)businessObject;
            bl = obsProposal.isVLBIorPhasedArray();
        } else if (businessObject instanceof ObsProject) {
            ObsProject obsProject = (ObsProject)businessObject;
            ObsProposal obsProposal = null;
            try {
                obsProposal = obsProject.getObsProposal();
                if (obsProposal != null) {
                    bl = obsProposal.isVLBIorPhasedArray();
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(ObservingFrequencyEditor.class).warning("Cannot determine if we are VLBI");
            }
        }
        return bl;
    }

    private void configureStandardFrequenciesComboBox(@NonNull String[] stringArray, boolean bl) {
        if (stringArray == null) {
            throw new NullPointerException("continuumStandardFrequencies is marked non-null but is null");
        }
        Optional<Integer> optional = Optional.empty();
        ObservingFrequency observingFrequency = this.getModel().getObservingFrequency();
        if (observingFrequency != null) {
            try {
                optional = Optional.of(ReceiverBand.getReceiverBand(observingFrequency.getSkyFrequency()).getNumber());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Integer n = optional.orElseGet(() -> (Integer)this.standardFrequencyBandJComboBox.getSelectedItem());
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>();
        Integer n2 = null;
        for (String string : stringArray) {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand(Frequency.createFrequencyGHZ(Double.valueOf(string)));
            int n3 = receiverBand.getNumber();
            if (n2 == null) {
                n2 = n3;
            }
            defaultComboBoxModel.addElement(n3);
            if (n == null || !n.equals(n3)) continue;
            defaultComboBoxModel.setSelectedItem(n);
            n2 = n;
        }
        this.standardFrequencyBandJComboBox.setModel(defaultComboBoxModel);
        SpectralSetupParametersModel spectralSetupParametersModel = (SpectralSetupParametersModel)this.getModel().getParentModel();
        if (!spectralSetupParametersModel.isConfiguring()) {
            if (!bl) {
                this.getModel().update(null, ObservingFrequencyModel.BAND_SELECTED_FID, n2.toString());
            } else {
                ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(INPUT_FREQUENCY_VUP);
                valueUnitPairEditor.getModel().publish();
            }
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(ObservingFrequencyModel.FREQUENCY_TYPE_FID)) {
            String string = (String)object;
            super.update(fieldID, string);
            this.updateLabels(ObservingFrequency.FrequencyType.getFrequencyType(string));
            return;
        }
        if (fieldID.equals(ObservingFrequencyModel.REST_FREQ_FEEDBACK_AREA_FID)) {
            Frequency frequency = (Frequency)((Object)object);
            super.update(fieldID, TextUtils.format(frequency));
            return;
        }
        if (fieldID.equals(ObservingFrequencyModel.BAND_SELECTED_FID)) {
            if (object instanceof Integer) {
                this.set2(this.standardFrequencyBandJComboBox, object);
            }
            return;
        }
        if (fieldID.equals(SpectralSetupParametersModel.FULL_POLARIZATION_MOSAICS_RESTRICTED)) {
            boolean bl = (Boolean)object;
            boolean bl2 = this.getModel().isContinuumSkyFrequencyMutable();
            this.getComponent(INPUT_FREQUENCY_VUP).setEnabled(!bl && !bl2);
            if (bl) {
                this.resetToStandardButton.doClick();
            }
        }
        if (fieldID.equals(ObservingFrequencyModel.RESOLUTION_MODE_SELECTABLE) && object instanceof Boolean) {
            this.getComponent(ObservingFrequencyModel.CORRELATOR_MODE).setEnabled((Boolean)object);
        }
        super.update(fieldID, object);
    }

    protected void updateLabels(@NonNull ObservingFrequency.FrequencyType frequencyType) {
        if (frequencyType == null) {
            throw new NullPointerException("inType is marked non-null but is null");
        }
        super.update(ObservingFrequencyModel.EDITOR_LABEL_FID, (Object)frequencyType);
        if (frequencyType == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            super.update(ObservingFrequencyModel.REST_FREQ_FEEDBACK_LABEL_FID, ObservingFrequency.FrequencyType.REST_FREQUENCY.toString());
        } else {
            super.update(ObservingFrequencyModel.REST_FREQ_FEEDBACK_LABEL_FID, ObservingFrequency.FrequencyType.SKY_FREQUENCY.toString());
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        Frequency frequency = Frequency.createFrequencyGHZ(230.0);
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(Speed.createSpeed((double)100000.0, (String)Speed.UNIT_KM_S));
        DefaultObservingFrequency defaultObservingFrequency = new DefaultObservingFrequency(frequency, velocity);
        ObservingFrequencyModel observingFrequencyModel = new ObservingFrequencyModel(null);
        ObservingFrequencyEditor observingFrequencyEditor = new ObservingFrequencyEditor(observingFrequencyModel);
        observingFrequencyModel.setDocument(defaultObservingFrequency);
        JButton jButton = new JButton("Print RestFrequency");
        jButton.addActionListener(actionEvent -> System.out.println("RestFrequency = " + observingFrequencyModel.getObservingFrequency().getRestFrequency()));
        JFrame jFrame = new JFrame("ObservingFrequencyEditor Test");
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.setLayout(new BoxLayout(container, 3));
        container.add(observingFrequencyEditor);
        container.add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class StandardFrequencyComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public StandardFrequencyComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand((Integer)object);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(receiverBand.getNumber() + " [" + receiverBand.getRFMin() + "-" + receiverBand.getRFMax() + " GHz]");
            return this;
        }
    }
}

