/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.subform;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameterEditor;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameters;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class MosaicParameterModel
extends Model
implements ModelChangeSubscriber {
    private ValueUnitPairModel frequencyModel = new ValueUnitPairModel();

    public MosaicParameterModel(Object object) {
        super(object);
        this.frequencyModel.subscribe(this);
        this.registerSubModel(this.frequencyModel);
        this.setDocument(object);
    }

    public MosaicParameters getMosaicParameters() {
        return (MosaicParameters)this.getDocument();
    }

    @Override
    public void publish() {
        this.frequencyModel.publish();
        if (this.document != null) {
            this.publish(MosaicParameterEditor.FID_LAYOUTTYPE, this.getMosaicParameters().getType());
            this.publish(MosaicParameterEditor.FID_ANTENNA, (Object)this.getMosaicParameters().getAntenna());
            this.publish(MosaicParameterEditor.FID_SPACING, this.getMosaicParameters().getSpacing());
            this.publish(MosaicParameterEditor.FID_OVERLAP, this.getMosaicParameters().getOverlap());
            this.publish(MosaicParameterEditor.FID_BEAMSIZE, (Object)this.getMosaicParameters().getBeamsize());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(MosaicParameterEditor.FID_ANTENNA)) {
            String string = (String)object;
            Antenna antenna = Antenna.getValue(string);
            this.getMosaicParameters().setAntenna(antenna);
            this.updateBeamsize();
            return antenna;
        }
        if (fieldID.equals(MosaicParameterEditor.FID_LAYOUTTYPE)) {
            String string = (String)object;
            this.getMosaicParameters().setType(string);
        } else {
            if (fieldID.equals(MosaicParameterEditor.FID_BEAMSIZE)) {
                return object;
            }
            if (fieldID.equals(MosaicParameterEditor.FID_OVERLAP)) {
                double d = 0.0;
                try {
                    d = DoubleVerifier.parseDouble((String)object);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.getMosaicParameters().setOverlap(d);
                this.getMosaicParameters().updateSpacing();
                this.publish(MosaicParameterEditor.FID_SPACING, this.getMosaicParameters().getSpacing());
                return d;
            }
            if (fieldID.equals(MosaicParameterEditor.FID_SPACING)) {
                double d = 0.0;
                try {
                    d = DoubleVerifier.parseDouble((String)object);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.getMosaicParameters().setSpacing(d);
                this.getMosaicParameters().updateOverlap();
                this.publish(MosaicParameterEditor.FID_OVERLAP, this.getMosaicParameters().getOverlap());
                return d;
            }
        }
        return object;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        if (object != null) {
            this.frequencyModel.setonlyDocument((Object)this.getMosaicParameters().getFrequency());
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    private void updateBeamsize() {
        this.publish(MosaicParameterEditor.FID_BEAMSIZE, (Object)this.getMosaicParameters().getBeamsize());
        this.getMosaicParameters().updateSpacing();
        this.publish(MosaicParameterEditor.FID_SPACING, this.getMosaicParameters().getSpacing());
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (model == this.frequencyModel) {
            this.updateBeamsize();
        }
    }
}

