/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.ot.editors.spatialvisual.ScienceGoalSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelper;
import alma.obsprep.ot.editors.spatialvisual.mapper.CenterMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.models.schedblock.FieldPatternChangeListener;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.sciencegoals.TargetParametersModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;

public class VisualModelHelperForTargetParameters
extends VisualModelHelper {
    protected TargetParametersModel targetParametersModel;

    public VisualModelHelperForTargetParameters(ScienceGoalSpatialVisualModel scienceGoalSpatialVisualModel) {
        super(scienceGoalSpatialVisualModel);
        this.targetParametersModel = scienceGoalSpatialVisualModel.getFormModel().getTargetParametersModel();
        this.getCenterMapperModel().setSingleMode(true);
        this.getPointingMapperModel().setSingleMode(false);
        this.getRoiMapperModel().setSingleMode(true);
        this.targetParametersModel.addFieldPatternChangeListener(this);
    }

    @Override
    public SkyCoordinates getTargetCenter() {
        return this.targetParametersModel.getTargetCenter();
    }

    @Override
    public SkyCoordinates[] getTargetCenters() {
        SkyCoordinates[] skyCoordinatesArray = new SkyCoordinates[]{this.getTargetCenter()};
        return skyCoordinatesArray;
    }

    @Override
    public FieldPatternI getFieldPattern() {
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null) {
            return null;
        }
        if (targetParameters.isRectanglePattern()) {
            return targetParameters.getSingleRectangle();
        }
        if (targetParameters.isPointingPattern()) {
            return targetParameters.getSecondaryArrayPointingPattern().orElse(targetParameters.getPointingPattern());
        }
        return null;
    }

    @Override
    public FieldPattern.FieldPatternType getFieldPatternType() {
        FieldPatternI fieldPatternI = this.getFieldPattern();
        if (fieldPatternI.isRectanglePattern()) {
            return FieldPattern.FieldPatternType.RECTANGLE;
        }
        if (fieldPatternI.isPointingPattern()) {
            return FieldPattern.FieldPatternType.POINT;
        }
        return null;
    }

    @Override
    public SkyCoordinates[] getPointings() {
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null || !targetParameters.isPointingPattern()) {
            return new SkyCoordinates[0];
        }
        return this.getPointingPatternModel().getPointings();
    }

    @Override
    public SkyCoordinates addPointing() {
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null || !targetParameters.isPointingPattern()) {
            return null;
        }
        SkyCoordinates skyCoordinates = this.getPointingPatternModel().addPointing(-1, targetParameters.isOffsetPointingPattern());
        return skyCoordinates;
    }

    @Override
    public void deletePointing(SkyCoordinates skyCoordinates) {
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null || !targetParameters.isPointingPattern()) {
            return;
        }
        PointingPatternModel pointingPatternModel = this.getPointingPatternModel();
        PointingPatternI pointingPatternI = pointingPatternModel.getPointingPattern();
        pointingPatternI.removePhaseCenterCoordinates(skyCoordinates);
        pointingPatternModel.getPointingPatternTableModel().fireTableDataChanged();
    }

    @Override
    public SkyCoordinates addTargetCenter() {
        return this.getTargetCenter();
    }

    @Override
    public RectanglePatternI[] getRectangleROIs() {
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null || !targetParameters.isRectanglePattern()) {
            return new RectanglePatternI[0];
        }
        RectanglePatternI[] rectanglePatternIArray = new RectanglePatternI[]{(RectanglePatternI)((Object)targetParameters)};
        return rectanglePatternIArray;
    }

    @Override
    public RectanglePatternI addRectangleROI() {
        FieldPatternI fieldPatternI = this.getFieldPattern();
        if (fieldPatternI.isRectanglePattern()) {
            return (RectanglePatternI)fieldPatternI;
        }
        TargetParameters targetParameters = this.getTargetParameters();
        for (Field field : targetParameters.getField()) {
            targetParameters.removeField(field);
        }
        Rectangle rectangle = Rectangle.createRectangle();
        targetParameters.addField((Field)((Object)rectangle));
        return rectangle;
    }

    @Override
    public void deleteRectangleRoi(RectanglePatternI rectanglePatternI) {
        Rectangle rectangle;
        try {
            rectangle = (Rectangle)rectanglePatternI;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Unexpected pattern : " + rectanglePatternI);
        }
        TargetParameters targetParameters = this.getTargetParameters();
        targetParameters.removeField((Field)((Object)rectangle));
    }

    @Override
    public void updateFormEditor(MapperModel mapperModel) {
        if (mapperModel instanceof CenterMapperModel) {
            SkyCoordsModel skyCoordsModel = this.getSourceCoordinatesModel();
            SkyCoordinates skyCoordinates = this.getTargetParameters().getTargetCenter();
            Longitude longitude = skyCoordinates.getLongitude();
            Latitude latitude = skyCoordinates.getLatitude();
            skyCoordsModel.publish(SkyCoordsModel.FID_LON, new Double(longitude.getContent()));
            skyCoordsModel.publish(SkyCoordsModel.FID_ULON, longitude.getUnit());
            skyCoordsModel.publish(SkyCoordsModel.FID_LAT, new Double(latitude.getContent()));
            skyCoordsModel.publish(SkyCoordsModel.FID_ULAT, latitude.getUnit());
        } else if (mapperModel instanceof PointingMapperModel) {
            this.getPointingPatternModel().getPointingPatternTableModel().fireTableDataChanged();
        } else if (mapperModel instanceof RoiMapperModel) {
            this.targetParametersModel.getFieldModel().publish();
        }
    }

    @Override
    public void changeFieldPattern(FieldPattern.FieldPatternType fieldPatternType) {
        String string = null;
        if (fieldPatternType == FieldPattern.FieldPatternType.POINT) {
            string = TargetParameters.TYPE_F_MULTIPLEPOINTS;
        } else if (fieldPatternType == FieldPattern.FieldPatternType.RECTANGLE) {
            string = TargetParameters.TYPE_F_SINGLERECTANGLE;
        }
        this.targetParametersModel.changeFieldType(string);
    }

    public SkyCoordsModel getSourceCoordinatesModel() {
        return this.targetParametersModel.getSourceCoordinatesModel();
    }

    public TargetParameters getTargetParameters() {
        return this.targetParametersModel.getTargetParameters();
    }

    private PointingPatternModel getPointingPatternModel() {
        return this.targetParametersModel.getFieldModel().getPointingPatternModel();
    }

    @Override
    public void addFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        this.targetParametersModel.addFieldPatternChangeListener(fieldPatternChangeListener);
    }

    @Override
    public boolean removeFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        return this.targetParametersModel.removeFieldPatternChangeListener(fieldPatternChangeListener);
    }
}

