/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.common.sourcecatalog.utilities.TextUtils;
import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.ot.editors.sciencegoals.EstimatedTimeInfoBuilder;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.services.etc.SchedBlockObservingTimeCalculator;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.valuetypes.Time;
import java.awt.Dimension;
import lombok.NonNull;

public class SolarTimeEstimate
implements TimeEstimateInterface {
    @Override
    public EstimatedTimeInfoBuilder.TimeEstimateModel generateTimeEstimateModel(@NonNull ScienceGoal scienceGoal) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator;
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel = new EstimatedTimeInfoBuilder.TimeEstimateModel();
        timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 722));
        Time time = Time.createTime();
        Integer n = 1;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Time time2 = performanceParameters.getDesiredTime();
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null && performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
            n = performanceParameters.getVisitConstraintCount();
        }
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = null;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to get details of configurations " + invalidObsProgramParametersException.getMessage());
        }
        timeEstimateModel.setScienceGoalConfigurations(scienceGoalConfigurations);
        if (targetParameters.getType().equals(FieldTypeInfo.F_SingleRectangle.getValue()) && ((object = targetParameters.getFieldRectangle()[0]).getLong().isZero() || object.getShort().isZero())) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Rectangle definition incomplete - please define the rectangle in your field setup correctly");
        }
        object = new SchedBlockObservingTimeCalculator.Builder();
        ((SchedBlockObservingTimeCalculator.Builder)object).scienceGoal(scienceGoal);
        try {
            schedBlockObservingTimeCalculator = new SchedBlockObservingTimeCalculator((SchedBlockObservingTimeCalculator.Builder)object);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidObsProgramParametersException.getMessage());
        }
        timeEstimateModel.addToHeader("<h3>Requested Solar Time</h3>", "");
        int n2 = scienceGoal.getReceiverBand().getNumber();
        SolarExecutionTimeCalculator solarExecutionTimeCalculator = new SolarExecutionTimeCalculator();
        for (ScienceGoal scienceGoal2 : schedBlockObservingTimeCalculator.getScienceGoalsWithClusters()) {
            int n3 = scienceGoal2.getTargetParametersCount();
            SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult = solarExecutionTimeCalculator.calculateSolarIntegrationTimes(time2, n2, n3, scienceGoal2.getIsTPSolarRegionalMappingEnabled());
            timeEstimateModel.setClusterSpecificScienceGoal(scienceGoal2);
            timeEstimateModel.addClusterSpecificKeyValuePair("<h3>Interferometric array</h3>", "");
            timeEstimateModel.addClusterSpecificKeyValuePair("Total time on-source", TextUtils.format((ValueUnitPair)solarExecutionTimeResult.t_t.convertToFriendlyUnit(), (int)2));
            timeEstimateModel.addClusterSpecificKeyValuePair("Total time for 1 SB execution", TextUtils.format((ValueUnitPair)solarExecutionTimeResult.t_int_EB.convertToFriendlyUnit(), (int)2));
            timeEstimateModel.addClusterSpecificKeyValuePair("Number of SB executions", Integer.toString(solarExecutionTimeResult.n_EB_int));
            timeEstimateModel.addClusterSpecificKeyValuePair("Total time to complete SB", TextUtils.format((ValueUnitPair)solarExecutionTimeResult.t_int_SB.convertToFriendlyUnit(), (int)2));
            Boolean bl = performanceParameters.gettrueUseTP();
            if (Boolean.TRUE.equals(bl)) {
                timeEstimateModel.addClusterSpecificKeyValuePair("<h3>Total power array</h3>", "");
                timeEstimateModel.addClusterSpecificKeyValuePair("Time for 1 SB execution", TextUtils.format((ValueUnitPair)solarExecutionTimeResult.t_tp.convertToFriendlyUnit(), (int)2));
                timeEstimateModel.addClusterSpecificKeyValuePair("Number of SB executions", Integer.toString(solarExecutionTimeResult.n_tp_EB));
                timeEstimateModel.addClusterSpecificKeyValuePair("Total TP time", TextUtils.format((ValueUnitPair)solarExecutionTimeResult.t_tp_SB.convertToFriendlyUnit(), (int)2));
            }
            Time time3 = ((Time)solarExecutionTimeResult.t_int_SB.plus((AbstractDoubleWithUnit)solarExecutionTimeResult.t_tp_SB)).convertToFriendlyUnit();
            if (n > 1) {
                timeEstimateModel.addClusterSpecificKeyValuePair("", "");
                timeEstimateModel.addClusterSpecificKeyValuePair("Number of visits", n.toString());
                timeEstimateModel.addClusterSpecificKeyValuePair("<h3>Total time </h3>", TextUtils.format((ValueUnitPair)((Time)time3.multiply(n.intValue())).convertToFriendlyUnit(), (int)2));
            } else {
                timeEstimateModel.addClusterSpecificKeyValuePair("<h3>Estimated total time</h3", TextUtils.format((ValueUnitPair)time3, (int)2));
            }
            time.aggregate((Time)time3.multiply(n.intValue()));
            timeEstimateModel.commitClusterSpecificData();
        }
        timeEstimateModel.addToHeader("Total requested solar time", TextUtils.format((ValueUnitPair)time.convertToFriendlyUnit(), (int)2));
        return timeEstimateModel;
    }
}

