/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.widgets.OTTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.ObservingToolGuiProjectCompartment;
import alma.obsprep.ot.models.misc.ExpertParametersModel;
import alma.obsprep.ot.models.sciencegoals.SgNoteModel;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SgNoteEditor
extends EditorWithGridBagLayout
implements RoleDirectoryService.UserAuthenticatesListener {
    private static final long serialVersionUID = -8028519786804534141L;
    public static final FieldID FID_NAME = new FieldID("SgNoteEditor.nameFID");
    public static final FieldID FID_NOTE = new FieldID("SgNoteEditor.noteFID");
    public static final FieldID FID_SG_DESCOPED = new FieldID("SgNoteEditor.sgDescopedFID");
    public static final FieldID FID_IS_RESUBMISSION = new FieldID("SgNoteEditor.isResubmission");
    public static final FieldID FID_RESUBMISSION_SGNAME = new FieldID("SgNoteEditor.resubmissionSGName");
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();
    private OTTextField nameText = null;
    private OTTextArea noteText = null;
    private String groupType = "Science Goal Note";
    private boolean isCollapsed = true;
    private JCheckBox descopedStatusCheckBox = null;
    private ExpertParametersEditor expertParameterEditor;

    public SgNoteEditor(SgNoteModel sgNoteModel, boolean bl) {
        this.setModel(sgNoteModel);
        this.isCollapsed = bl;
        this.build();
        sgNoteModel.publish();
        RoleDirectoryService.addUserAuthenticatesListener(this);
    }

    @Override
    protected void build() {
        super.build(this.groupType);
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.nameText = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FID_NAME, "Science Goal Name", tooltips.get(FID_NAME));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.descopedStatusCheckBox = this.makeCheckBox(FID_SG_DESCOPED, "De-scoped status", tooltips.get(FID_SG_DESCOPED));
        this.descopedStatusCheckBox.setEnabled(false);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.descopedStatusCheckBox, gridBagConstraints);
        JLabel jLabel = this.addLabel(jPanel, gridBagLayout, gridBagConstraints, FID_IS_RESUBMISSION, "", tooltips.get(FID_IS_RESUBMISSION));
        jLabel.setVisible(false);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.noteText = this.addOTTextArea(jPanel, gridBagLayout, gridBagConstraints, FID_NOTE, 500, 200, "Description", tooltips.get(FID_NOTE), true);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        ExpertParametersModel expertParametersModel = this.getMyModel().getExpertParametersModel();
        ExpertParametersEditor.Builder builder = new ExpertParametersEditor.Builder();
        this.expertParameterEditor = builder.model(expertParametersModel).panelLabel("Expert Parameters (Staff Only)").build();
        jPanel.add((Component)this.expertParameterEditor, gridBagConstraints);
        this.expertParameterEditor.setVisible(RoleDirectoryServiceHelper.isUserP2G());
        this.addGroup(jPanel, "General (Optional)");
    }

    public SgNoteModel getMyModel() {
        return (SgNoteModel)this.getModel();
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.isCollapsed) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_NAME)) {
            String string = (String)object;
            this.nameText.setText(string);
        } else if (fieldID.equals(FID_NOTE)) {
            String string = (String)object;
            this.noteText.setText(string);
        } else {
            if (fieldID.equals(FID_IS_RESUBMISSION)) {
                boolean bl = (Boolean)object;
                SgNoteModel sgNoteModel = (SgNoteModel)this.getModel();
                assert (sgNoteModel != null);
                JLabel jLabel = (JLabel)this.retrieve(FID_IS_RESUBMISSION);
                jLabel.setVisible(bl);
                if (sgNoteModel != null && bl) {
                    ScienceGoal scienceGoal = sgNoteModel.getScienceGoal();
                    this.set(jLabel, String.format("<html>Resubmission of <b>%s</b></html>", scienceGoal.getResubmissionOfName()));
                }
                return;
            }
            if (fieldID.equals(FID_SG_DESCOPED)) {
                boolean bl = (Boolean)object;
                this.descopedStatusCheckBox.setSelected(bl);
                Object object2 = this.getModel().getDocument();
                if (object2 instanceof ScienceGoal) {
                    ScienceGoal scienceGoal = (ScienceGoal)object2;
                    ObservingToolGui observingToolGui = ObservingToolController.getMyInstance().getGui();
                    ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = observingToolGui.primaryProjectCompartment();
                    if (observingToolGuiProjectCompartment != null && scienceGoal.isPhase2ScienceGoal()) {
                        this.descopedStatusCheckBox.setVisible(true);
                    } else {
                        this.descopedStatusCheckBox.setVisible(false);
                    }
                }
            }
        }
        super.update(fieldID, object);
    }

    @Override
    public void userHasAuthenticated() {
        this.expertParameterEditor.setVisible(RoleDirectoryServiceHelper.isUserP2G());
    }

    static {
        tooltips.put(FID_NAME, "The name of this science goal.");
        tooltips.put(FID_NOTE, "A brief note or comment about this science goal.");
        tooltips.put(FID_SG_DESCOPED, "Whether the science goal has been de-scoped or not.");
        tooltips.put(FID_IS_RESUBMISSION, "Whether the science goal is a resubmission.");
        tooltips.put(FID_RESUBMISSION_SGNAME, "The name of the science goal from which this science goal is a resubmission.");
    }
}

