/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralFeedback;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.NotSupportedYetPanel;
import alma.obsprep.ot.editors.sciencegoals.SfiScanSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SpectralSetupParametersEditor;
import alma.obsprep.ot.editors.sciencegoals.VLBIBandSelector;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.editors.valuetypes.ObservingFrequencyEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.models.sciencegoals.MultiResolutionElementTableModel;
import alma.obsprep.ot.models.sciencegoals.SelectedSpectralLineValidatorInterface;
import alma.obsprep.ot.models.sciencegoals.SfiScanSetupModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.spectralvisual.TargetParametersTableModel;
import alma.obsprep.ot.models.valuetypes.ObservingFrequencyModel;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Velocity;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SfiSpectralSetupEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    private Optional<VLBIProjectType> cacheProposalType = Optional.of(VLBIProjectType.Unknown);
    private static final int SOURCE_TABLE_UNINITIALISED = -100;
    private static final String REST_FREQ_MSG = "<html><P>Please set the rest frequencies of spectral lines that will be observed. These will be used during data reduction<br> to set the velocity scale and will enhance the ALMA Science Archive. We recommend that this be done<br>once the spectral setup is fully defined.";
    public static final FieldID FID_RESETVIEW = new FieldID("SfiSpectralSetup.resetView");
    public static final FieldID FID_SPECTRALTYPE = new FieldID("SfiSpectralSetup.SpectralType");
    public static final FieldID FID_WALSH_SWITCHING = new FieldID("SfiSpectralSetup.WalshSwitchingEnabled");
    public static final FieldID FID_POLARIZATION = new FieldID("SfiSpectralSetup.Polarization");
    public static final FieldID FID_VLBI_SELECT_BAND_DEFAULTS = new FieldID("SfiSpectralSetup.selectVLBIBandDefaults");
    public static final FieldID FID_FEEDBACK = new FieldID("SfiSpectralSetup.Feedback");
    public static final FieldID REST_FREQUENCIES_DEFINED_FID = new FieldID("SfiSpectralSetup.restFrequenciesDefined");
    public static final FieldID FID_WALSH_SWITCHING_USER_CONTROLLABLE = new FieldID("SfiSpectralSetup.walshSwitchingUserControllable");
    public static final FieldID FID_FULL_POLARIZATION_CHECK = new FieldID("SfiSpectralSetup.configurationFPUIComponents");
    private final FieldID FID_DEFINE_REST_FREQUENCIES = new FieldID("SfiSpectralSetupEditor.defineRestFrequencies");
    private final SpectralLineChooser lineChooser;
    private JTable sourceTable;
    private final TargetParametersTableModel targetsTableModel;
    protected SpectralSetupParametersEditor spectralLineEditor;
    protected SpectralSetupParametersEditor singleContinuumEditor;
    protected ObservingFrequencyEditor singleContinuumFrequencyEditor;
    protected SfiScanSetupEditor spectralScanEditor;
    protected AdvancedSpectralPanel advancedSpectralPanel;
    protected JLabel feedbackArea;
    JPanel spectralLineGroup;
    JPanel singleContinuumGroup;
    JPanel spectralScanGroup;
    JPanel advancedSpectralGroup;
    private boolean isFeedbackComplete = true;
    private OTButtonGroup polarisationButtonGroup;
    private final AtomicBoolean isAdvancedFeedbackTimerRunning = new AtomicBoolean(false);
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private final List<ScienceSpectralWindowSelectionListener> scienceSpectralWindowSelectionListeners = new ArrayList<ScienceSpectralWindowSelectionListener>();
    private OTButtonGroup spectralTypeButtonGroup;
    private SingleFieldScienceGoalModel singleFieldScienceGoalModel;
    private int lastSourceSelectedInSourceTableIndex = -100;
    private ScienceGoalEditorViewEnum currentView = null;
    private JLabel vlbiDefaultSetupLabel;

    public SfiSpectralSetupEditor(Model model, SpectralLineChooser spectralLineChooser) {
        this.setName("SfiSpectralSetup");
        this.lineChooser = spectralLineChooser;
        this.setModel(model);
        if (model != null) {
            Model model2 = this.getMyModel().getParentModel();
            if (model2 instanceof SingleFieldScienceGoalModel) {
                this.singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)model2;
                this.targetsTableModel = this.singleFieldScienceGoalModel.getTargetParametersTableModel();
            } else {
                this.targetsTableModel = null;
            }
        } else {
            this.targetsTableModel = null;
        }
        this.build();
        if (model != null) {
            model.publish();
        }
    }

    public SfiSpectralSetupEditor(Model model) {
        this(model, DialogSpectralLineChooser.getInstance());
    }

    public SpectralSetupParametersModel getMyModel() {
        return (SpectralSetupParametersModel)this.getModel();
    }

    public SelectedSpectralLineValidatorInterface getSpectralLineValidator() {
        return (SelectedSpectralLineValidatorInterface)((Object)this.getModel());
    }

    @Override
    protected void build() {
        super.build("Spectral Setup");
    }

    @Override
    public void addComponents(String string) {
        Object object2;
        this.constraints.anchor = 11;
        this.constraints.weightx = 1.0;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.spectralTypeButtonGroup = new OTButtonGroup(SpectralSetupParameters.SpectralSetupTypeChoice.getKnownTypeChoiceLabels(), 1, SpectralSetupParameters.SpectralSetupTypeChoice.getKnownTypeChoiceTooltips());
        this.spectralTypeButtonGroup.setSelectedItem(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.getLabel());
        this.initEvents(this.spectralTypeButtonGroup, FID_SPECTRALTYPE);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Spectral Type", (JComponent)this.spectralTypeButtonGroup);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 10);
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FID_WALSH_SWITCHING, "Produce image sidebands (Bands 9 and 10 only)", "Enable/Disable 90-degree Walsh switching");
        String[] stringArray = SpectralSetupParameters.getKnownPolarisationList();
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        for (String object32 : stringArray) {
            object2 = CorrPolarization.getCorrPolarization(object32);
            stringArray2[n] = object2.getLabel();
            stringArray3[n] = object2.tooltip;
            ++n;
        }
        this.polarisationButtonGroup = this.addOTButtonGroup((JComponent)jPanel, gridBagLayout, gridBagConstraints, FID_POLARIZATION, "Polarization products desired", stringArray3, stringArray2);
        JButton jButton = new JButton("Select Band");
        this.initEvents(jButton, FID_VLBI_SELECT_BAND_DEFAULTS);
        jButton.addActionListener(actionEvent -> this.initialiseVLBISpectralLineSetupToBandDefault());
        this.vlbiDefaultSetupLabel = this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "VLBI Default Setup", (JComponent)jButton);
        jButton.setVisible(false);
        this.vlbiDefaultSetupLabel.setVisible(false);
        JPanel jPanel2 = this.addGroup(jPanel, "Spectral Type");
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Type");
        this.spectralLineEditor = new SpectralSetupParametersEditor((Model)this.getMyModel(), this.lineChooser);
        this.registerSubView(this.spectralLineEditor);
        this.addSpectralSelectionListeners(this.spectralLineEditor);
        this.spectralLineEditor.addTableModelListener(tableModelEvent -> {
            if (this.spectralLineEditor.isVisible()) {
                try {
                    this.feedbackAdvancedSetup(tableModelEvent);
                }
                catch (InvalidGroupIndexException invalidGroupIndexException) {
                    invalidGroupIndexException.printStackTrace();
                    GUIUtilities.error(null, "Unexpected Error", invalidGroupIndexException);
                }
            }
        });
        this.feedbackArea = new JLabel();
        this.feedbackArea.setBorder(BorderFactory.createTitledBorder("Spectral Setup Errors"));
        this.feedbackArea.setForeground(Colors.OT_RED);
        this.feedbackArea.setBackground(this.getBackground());
        ObservingFrequencyModel observingFrequencyModel = this.getMyModel().getSingleContinuumModel();
        this.singleContinuumFrequencyEditor = new ObservingFrequencyEditor(observingFrequencyModel);
        this.registerSubView(this.singleContinuumFrequencyEditor);
        observingFrequencyModel.subscribe((model, fieldID, object) -> {
            if (this.singleContinuumGroup.isVisible() && this.getMyModel().getSpectralSetupParameters().isSingleContinuum()) {
                if (fieldID.equals(ObservingFrequencyModel.REST_FREQ_FEEDBACK_AREA_FID)) {
                    return;
                }
                this.feedbackSingleContinuumSetup();
                this.getMyModel().updateSpectralWindowsForContinuum();
            }
        });
        SfiScanSetupModel sfiScanSetupModel = this.getMyModel().getSpectralScanModel();
        sfiScanSetupModel.subscribe((model, fieldID, object) -> {
            if (this.spectralScanGroup != null && this.getMyModel().getSpectralSetupParameters().isSpectralScan()) {
                this.feedbackSpectralScanSetup();
            }
        });
        object2 = this.getMyModel().getSpectralScanModel();
        this.spectralScanEditor = new SfiScanSetupEditor((Model)object2);
        this.registerSubView(this.spectralScanEditor);
        this.addComponent(this.feedbackArea);
        this.advancedSpectralPanel = new AdvancedSpectralPanel(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.getLabel());
        this.spectralLineGroup = this.addGroup(this.spectralLineEditor, SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.getLabel());
        CSH.setHelpIDString((Component)this.spectralLineGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Line");
        this.singleContinuumEditor = new SpectralSetupParametersEditor((Model)this.getMyModel(), this.lineChooser);
        this.registerSubView(this.singleContinuumEditor);
        this.addSpectralSelectionListeners(this.singleContinuumEditor);
        this.singleContinuumEditor.addTableModelListener(tableModelEvent -> {
            if (this.singleContinuumEditor.isVisible()) {
                Runnable runnable = () -> {
                    try {
                        if (!this.isAdvancedFeedbackTimerRunning.get()) {
                            return;
                        }
                        TimeUnit.MILLISECONDS.sleep(300L);
                        SwingUtilities.invokeLater(() -> {
                            try {
                                this.feedbackAdvancedSetup(tableModelEvent);
                                this.isAdvancedFeedbackTimerRunning.set(false);
                            }
                            catch (InvalidGroupIndexException invalidGroupIndexException) {
                                Log.logger(SfiSpectralSetupEditor.class).warning("Problem calculating the advanced feedback on the spectral setup page " + invalidGroupIndexException.getMessage());
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        Log.logger(SfiSpectralSetupEditor.class).warning("Problem calculating the advanced feedback on the spectral setup page " + interruptedException.getMessage());
                    }
                };
                if (!this.isAdvancedFeedbackTimerRunning.get()) {
                    this.isAdvancedFeedbackTimerRunning.set(true);
                    this.executorService.execute(runnable);
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(this.singleContinuumFrequencyEditor);
        jPanel3.add(this.singleContinuumEditor);
        this.singleContinuumGroup = this.addGroup(jPanel3, SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM.getLabel());
        CSH.setHelpIDString((Component)this.singleContinuumGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Single Continuum");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(this.spectralScanEditor);
        this.spectralScanGroup = this.addGroup(jPanel3, SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN.getLabel());
        CSH.setHelpIDString((Component)this.spectralScanGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Scan");
        this.addComponent(this.advancedSpectralPanel);
        this.advancedSpectralGroup = this.advancedSpectralPanel;
        CSH.setHelpIDString((Component)this.advancedSpectralGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Scan");
        this.singleContinuumGroup.setVisible(false);
        this.spectralScanGroup.setVisible(false);
        this.advancedSpectralGroup.setVisible(false);
        this.constraints.weighty = 1.0;
        this.addComponent(new JPanel());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)new JLabel(REST_FREQ_MSG), gridBagConstraints2);
        JButton jButton2 = new JButton("Define Rest Frequencies");
        gridBagConstraints2.gridy = 1;
        this.initEvents(jButton2, this.FID_DEFINE_REST_FREQUENCIES);
        jPanel4.add((Component)jButton2, gridBagConstraints2);
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents(List.of(jButton2));
        JPanel jPanel5 = this.addGroup(jPanel4, "Rest Frequencies");
        CSH.setHelpIDString((Component)jPanel5, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Rest Frequencies");
        if (this.getMyModel().getParentModel() instanceof SingleFieldScienceGoalModel) {
            this.addSourceVelocityGroup();
        }
        if (this.sourceTable != null) {
            this.spectralLineEditor.addTargetTableListener(this.sourceTable);
            this.sourceTable.getSelectionModel().addListSelectionListener(this);
        }
    }

    protected void feedbackSpectralScanSetup() {
        SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        SpectralFeedback spectralFeedback = spectralSetupParameters.feedbackSpectralScanSetup();
        if (this.feedbackArea != null) {
            SwingUtilities.invokeLater(() -> {
                if (spectralFeedback == null) {
                    this.setSpectralSetupAdvisorySeverity(SpectralFeedback.AdvisoryType.ERROR);
                    this.feedbackArea.setText("");
                } else {
                    this.setSpectralSetupAdvisorySeverity(spectralFeedback.getAdvisoryType());
                    this.feedbackArea.setText(spectralFeedback.getMessage());
                }
            });
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_SPECTRALTYPE) {
            this.setupSpectralType(fieldID, object);
            return;
        }
        if (fieldID == FID_RESETVIEW) {
            this.currentView = null;
        } else {
            if (fieldID == FID_POLARIZATION) {
                CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization((String)object);
                String string = corrPolarization == null ? null : corrPolarization.getLabel();
                super.update(fieldID, string);
                return;
            }
            if (fieldID.equals(FID_FULL_POLARIZATION_CHECK)) {
                this.determineSpectralModeSpecificPolarisationOptions(this.getMyModel().getSpectralType());
            } else {
                if (fieldID == SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID) {
                    this.singleContinuumFrequencyEditor.update(fieldID, object);
                    ScienceGoalEditorViewEnum scienceGoalEditorViewEnum = (ScienceGoalEditorViewEnum)((Object)object);
                    this.configureEditorForView(scienceGoalEditorViewEnum);
                    return;
                }
                if (fieldID.equals(FID_FEEDBACK)) {
                    this.displaySpectralErrorWarning((String)object);
                } else if (fieldID.equals(FID_WALSH_SWITCHING)) {
                    JCheckBox jCheckBox = (JCheckBox)this.getComponent(FID_WALSH_SWITCHING);
                    this.set2(jCheckBox, (boolean)((Boolean)object));
                } else if (fieldID.equals(FID_WALSH_SWITCHING_USER_CONTROLLABLE)) {
                    this.getComponent(FID_WALSH_SWITCHING).setEnabled((Boolean)object);
                } else if (fieldID.equals(this.FID_DEFINE_REST_FREQUENCIES)) {
                    this.allowUserToSelectLinesFromSpectralLinePicker();
                } else if (fieldID.equals(SpectralSetupParametersModel.FULL_POLARIZATION_MOSAICS_RESTRICTED)) {
                    this.configureFullPolarizationWithMosaics(fieldID, object);
                }
            }
        }
        super.update(fieldID, object);
    }

    private void initialiseVLBISpectralLineSetupToBandDefault() {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        VLBIBandSelector.getInstance().show(jFrame).ifPresent(receiverBand -> this.getMyModel().setDefaultVLBISpectralLineSetup((ReceiverBand)receiverBand));
    }

    private void configureFullPolarizationWithMosaics(FieldID fieldID, Object object) {
        Object object2;
        boolean bl = (Boolean)object;
        if (bl) {
            object2 = SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM;
            super.update(fieldID, ((SpectralSetupParameters.SpectralSetupTypeChoice)((Object)object2)).getLabel());
            this.setSpectralTypeView((SpectralSetupParameters.SpectralSetupTypeChoice)((Object)object2));
            this.determineSpectralModeSpecificPolarisationOptions((SpectralSetupParameters.SpectralSetupTypeChoice)((Object)object2));
        }
        object2 = this.getMyModel();
        boolean bl2 = !bl && ((SpectralSetupParametersModel)object2).isSpectralTypeUserModifiable();
        this.spectralTypeButtonGroup.setEnabled(bl2);
        if (bl2 && !((SpectralSetupParametersModel)object2).isSpectralScanUserSelectable()) {
            this.spectralTypeButtonGroup.getButtonStream().filter(abstractButton -> abstractButton.getText().equals(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN.getLabel())).findFirst().ifPresent(abstractButton -> abstractButton.setEnabled(false));
        }
        this.singleContinuumFrequencyEditor.update(SpectralSetupParametersModel.FULL_POLARIZATION_MOSAICS_RESTRICTED, bl);
    }

    private void allowUserToSelectLinesFromSpectralLinePicker() {
        Velocity velocity;
        JButton jButton = (JButton)this.retrieve(this.FID_DEFINE_REST_FREQUENCIES);
        jButton.setEnabled(false);
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getMyModel().getDocument());
        if (spectralSetupParameters != null) {
            int n = this.sourceTable.getSelectionModel().getMaxSelectionIndex();
            if (n == -1) {
                n = 0;
            }
            TargetParameters targetParameters = spectralSetupParameters.getScienceGoal().getTargetParameters(n);
            velocity = targetParameters.getSourceVelocity();
        } else {
            velocity = Velocity.createVelocity();
        }
        if (this.isUserWantingToAddOverlayLinesToExpectedLines()) {
            this.getMyModel().addExistingOverlayLinesToRestFrequencies();
        }
        SpectralLinePublisher spectralLinePublisher = DialogSpectralLineChooser.getInstance().createPublisher(this, REST_FREQUENCIES_DEFINED_FID, jButton);
        DialogSpectralLineChooser.getInstance().chooseMultipleLinesForRestFrequencies(spectralLinePublisher, velocity, spectralSetupParameters, this.getSpectralLineValidator());
    }

    private void setupSpectralType(FieldID fieldID, Object object) {
        SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice;
        if (object instanceof String) {
            Log.logger((Object)this).warning("Unexpected value : " + object);
            spectralSetupTypeChoice = SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE;
        } else {
            spectralSetupTypeChoice = (SpectralSetupParameters.SpectralSetupTypeChoice)((Object)object);
        }
        super.update(fieldID, spectralSetupTypeChoice.getLabel());
        this.setSpectralTypeView(spectralSetupTypeChoice);
        this.determineSpectralModeSpecificPolarisationOptions(spectralSetupTypeChoice);
    }

    private boolean isUserWantingToAddOverlayLinesToExpectedLines() {
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel.isSpectralScan()) {
            return false;
        }
        if (spectralSetupParametersModel.isExpectedLinesToBeDefinedByPI() && spectralSetupParametersModel.isOverlayLinesDefined()) {
            return GUIUtilities.confirm(null, "Do you want to add the overlay lines to the expected rest frequencies associated with the spectral windows?");
        }
        return false;
    }

    private void displaySpectralErrorWarning(String string) {
        String string2;
        if (StringUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (StringUtils.startsWith((CharSequence)string, (CharSequence)"Warning:")) {
            string2 = StringUtils.removeStart((String)string, (String)"Warning:");
            this.feedbackArea.setForeground(Colors.OT_BLUE);
        } else {
            this.feedbackArea.setForeground(Colors.OT_RED);
            string2 = string;
        }
        SwingUtilities.invokeLater(() -> this.feedbackArea.setText(string2));
    }

    @Override
    public void configureEditorForView(ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        boolean bl = this.isVLBIViewToBeUpdated(scienceGoalEditorViewEnum);
        if (this.currentView == scienceGoalEditorViewEnum && !bl) {
            return;
        }
        Log.logger(SfiSpectralSetupEditor.class).fine("Instructed to display view : " + scienceGoalEditorViewEnum);
        this.singleContinuumFrequencyEditor.configureEditorForView(scienceGoalEditorViewEnum);
        switch (scienceGoalEditorViewEnum) {
            case DEFAULTVIEW: {
                this.configureSpectralSetupEditorForDefaultView();
                break;
            }
            case SOLAR: {
                this.configureSpectralEditorForSolar();
                break;
            }
            case VLBI: {
                this.configureSpectralSetupEditorForVLBI();
                break;
            }
            case ACASUPPLEMENTALCALL: {
                this.configureACASupplementalCall();
                break;
            }
            default: {
                throw new RuntimeException("Unknown view requested : " + scienceGoalEditorViewEnum);
            }
        }
        this.currentView = scienceGoalEditorViewEnum;
    }

    private boolean isVLBIViewToBeUpdated(@NonNull ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        boolean bl;
        block7: {
            if (scienceGoalEditorViewEnum == null) {
                throw new NullPointerException("view is marked non-null but is null");
            }
            if (!scienceGoalEditorViewEnum.equals((Object)ScienceGoalEditorViewEnum.VLBI)) {
                return false;
            }
            if (this.cacheProposalType.isEmpty()) {
                return true;
            }
            bl = true;
            try {
                if (ObsProposal.isProposalVLBI()) {
                    bl = !this.cacheProposalType.get().equals((Object)VLBIProjectType.VLBI);
                    this.cacheProposalType = Optional.of(VLBIProjectType.VLBI);
                    break block7;
                }
                if (ObsProposal.isProposalPhasedArray()) {
                    bl = !this.cacheProposalType.get().equals((Object)VLBIProjectType.PhasedArray);
                    this.cacheProposalType = Optional.of(VLBIProjectType.PhasedArray);
                    break block7;
                }
                return false;
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        return bl;
    }

    private void configureACASupplementalCall() {
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel == null) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = spectralSetupParametersModel.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        if (spectralSetupParameters.getPolarisation().equals(CorrPolarization.FULL.toString())) {
            spectralSetupParametersModel.update(this, FID_POLARIZATION, CorrPolarization.DOUBLE.polarization);
        }
        this.setFullPolarizationButtonVisibility(false);
        Enumeration<AbstractButton> enumeration = this.spectralTypeButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!abstractButton.getText().equals(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN.getLabel())) continue;
            abstractButton.setEnabled(false);
            break;
        }
    }

    private void configureSpectralSetupEditorForDefaultView() {
        SpectralSetupParameters spectralSetupParameters;
        this.spectralTypeButtonGroup.setEnabled(true);
        this.getComponent(FID_POLARIZATION).setEnabled(true);
        this.setFullPolarizationButtonVisibility(true);
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel != null && (spectralSetupParameters = spectralSetupParametersModel.getSpectralSetupParameters()) != null) {
            this.determineSpectralModeSpecificPolarisationOptions(spectralSetupParameters.getSpectralType());
        }
        this.getComponent(FID_VLBI_SELECT_BAND_DEFAULTS).setVisible(false);
        this.vlbiDefaultSetupLabel.setVisible(false);
    }

    private void configureSpectralEditorForSolar() {
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel == null) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = spectralSetupParametersModel.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        boolean bl = AlmaCapabilities.getInstance().getSolarBands().stream().anyMatch(OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand::isIsFullPolarizationEnabled);
        if (!bl && spectralSetupParameters.isFullPolarisation()) {
            spectralSetupParametersModel.update(this, FID_POLARIZATION, CorrPolarization.DOUBLE.polarization);
        }
        if (!bl) {
            this.setFullPolarizationButtonVisibility(false);
        }
        spectralSetupParametersModel.update(this, FID_SPECTRALTYPE, SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM.getLabel());
        this.spectralTypeButtonGroup.setEnabled(false);
        this.getComponent(FID_POLARIZATION).setEnabled(true);
        this.getComponent(FID_VLBI_SELECT_BAND_DEFAULTS).setVisible(false);
        this.vlbiDefaultSetupLabel.setVisible(false);
    }

    private void configureSpectralSetupEditorForVLBI() {
        Log.logger(SfiSpectralSetupEditor.class).fine("Configuring the spectral setup editor for VLBI");
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel == null) {
            return;
        }
        this.setFullPolarizationButtonVisibility(true);
        boolean bl = false;
        try {
            bl = ObsProposal.isProposalPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        spectralSetupParametersModel.update(this, FID_POLARIZATION, CorrPolarization.FULL.polarization);
        if (spectralSetupParametersModel.isSpectralScan() || spectralSetupParametersModel.isSpectralLine() && bl) {
            spectralSetupParametersModel.update(this, FID_SPECTRALTYPE, SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM.getLabel());
        }
        boolean bl2 = false;
        try {
            bl2 = ObsProposal.isVLBIRelated() && VLBIExpert.IS_VLBI_SPECTRALLINE_ENABLED;
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SfiSpectralSetupEditor.class).warning("Unable to determine if the project is VLBI" + unknownEntityException.getMessage());
        }
        Enumeration<AbstractButton> enumeration = this.spectralTypeButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            boolean bl3;
            AbstractButton abstractButton = enumeration.nextElement();
            if (bl2) {
                bl3 = abstractButton.getText().equals(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN.getLabel());
                abstractButton.setEnabled(!bl3);
            } else {
                abstractButton.setEnabled(false);
            }
            if (!(bl3 = abstractButton.getText().equals(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.getLabel())) || !bl) continue;
            abstractButton.setEnabled(false);
        }
        this.getComponent(FID_VLBI_SELECT_BAND_DEFAULTS).setVisible(true);
        this.vlbiDefaultSetupLabel.setVisible(true);
        this.getComponent(FID_POLARIZATION).setEnabled(false);
    }

    private void setFullPolarizationButtonVisibility(boolean bl) {
        OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(FID_POLARIZATION);
        assert (oTButtonGroup != null) : "Unable to find polarization buttons";
        Enumeration<AbstractButton> enumeration = oTButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!StringUtils.equals((CharSequence)abstractButton.getText(), (CharSequence)SpectralSetupParameters.POLARISATION_FULL)) continue;
            abstractButton.setVisible(bl);
            break;
        }
    }

    private void determineSpectralModeSpecificPolarisationOptions(SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)spectralSetupParametersModel.getDocument());
        if (spectralSetupParameters == null) {
            return;
        }
        boolean bl = false;
        try {
            bl = spectralSetupParameters.getScienceGoal().isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        AbstractButton abstractButton2 = this.polarisationButtonGroup.getButtonStream().filter(abstractButton -> abstractButton.getText().equals("FULL")).findFirst().orElseThrow(RuntimeException::new);
        if (bl) {
            List<OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand> list = AlmaCapabilities.getInstance().getSolarBandsForFullPolarization();
            boolean bl2 = list.stream().anyMatch(solarBand -> spectralSetupParameters.getReceiverBand() != null && solarBand.getBand() == spectralSetupParameters.getReceiverBand().getNumber() && solarBand.isIsFullPolarizationEnabled());
            abstractButton2.setEnabled(bl2);
            if (!bl2 && spectralSetupParameters.isFullPolarisation()) {
                spectralSetupParametersModel.update(this, FID_POLARIZATION, CorrPolarization.DOUBLE.polarization);
            }
        } else {
            boolean bl3;
            boolean bl4 = false;
            try {
                if (spectralSetupParameters.getObservatoryGoal() == null) {
                    bl4 = spectralSetupParameters.getScienceGoal().getObsProposal().isVLBIorPhasedArray();
                }
            }
            catch (UnknownEntityException | NullPointerException throwable) {
                bl4 = false;
            }
            if (bl4) {
                return;
            }
            this.polarisationButtonGroup.getButtonStream().forEach(abstractButton -> abstractButton.setEnabled(true));
            boolean bl5 = true;
            if (spectralSetupParameters.getReceiverBand() instanceof ReceiverBand) {
                bl5 = ReceiverBand.getFullPolarizationReceiverBands().contains(spectralSetupParameters.getReceiverBand());
            }
            boolean bl6 = Telescope.isOTConfiguredAs(Telescope.CSVALMA);
            boolean bl7 = spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN) && bl6;
            boolean bl8 = bl3 = AlmaCapabilities.getInstance().isFullPolarizationRestricted() && !spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE) && !spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM) && !bl6;
            if (!bl5 || bl3 || bl7) {
                abstractButton2.setEnabled(false);
                if (spectralSetupParameters.isFullPolarisation()) {
                    spectralSetupParametersModel.update(this, FID_POLARIZATION, CorrPolarization.DOUBLE.polarization);
                }
            } else {
                abstractButton2.setEnabled(true);
            }
        }
        if (spectralSetupParameters.isFullPolarisation()) {
            boolean bl9 = spectralSetupParametersModel.isFullPolarisationMosaicRestrictionsInEffect();
            this.spectralTypeButtonGroup.setEnabled(!bl9 && !bl);
            this.singleContinuumFrequencyEditor.update(SpectralSetupParametersModel.FULL_POLARIZATION_MOSAICS_RESTRICTED, bl9);
        }
    }

    private void setSpectralTypeView(SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        this.spectralLineGroup.setVisible(false);
        this.singleContinuumGroup.setVisible(false);
        this.spectralScanGroup.setVisible(false);
        this.spectralScanGroup.setVisible(false);
        this.advancedSpectralGroup.setVisible(false);
        this.feedbackArea.setText(null);
        switch (spectralSetupTypeChoice) {
            case SPECTRALLINE: {
                for (int i = 0; i < 4; ++i) {
                    this.spectralLineEditor.getMyModel().getSubModel(i).publish();
                }
                this.spectralLineEditor.setReadOnlyTable(false);
                this.spectralLineGroup.setVisible(true);
                this.singleContinuumGroup.setVisible(false);
                this.spectralScanGroup.setVisible(false);
                this.getMyModel().setWalshSwitchingUserAvailability();
                Object object = this.getMyModel().getParentModel().getDocument();
                if (!(object instanceof ScienceGoal)) break;
                boolean bl = VLBIExpert.isScienceGoalLegalVLBISpectralLine((ScienceGoal)object);
                this.getComponent(FID_VLBI_SELECT_BAND_DEFAULTS).setVisible(bl);
                this.vlbiDefaultSetupLabel.setVisible(bl);
                break;
            }
            case SINGLECONTINUUM: {
                for (int i = 0; i < 4; ++i) {
                    this.singleContinuumEditor.getMyModel().getSubModel(i).publish();
                }
                this.singleContinuumEditor.setButtonBoxesVisible(false);
                this.singleContinuumEditor.setReadOnlyTable(true);
                this.singleContinuumGroup.setVisible(true);
                this.spectralLineGroup.setVisible(false);
                this.spectralScanGroup.setVisible(false);
                this.getComponent(FID_VLBI_SELECT_BAND_DEFAULTS).setVisible(false);
                this.vlbiDefaultSetupLabel.setVisible(false);
                this.getMyModel().setWalshSwitchingUserAvailability();
                break;
            }
            case SPECTRALSCAN: {
                this.spectralLineGroup.setVisible(false);
                this.singleContinuumGroup.setVisible(false);
                this.spectralScanGroup.setVisible(true);
                this.getMyModel().setWalshSwitchingUserAvailability();
                this.getComponent(FID_VLBI_SELECT_BAND_DEFAULTS).setVisible(false);
                this.vlbiDefaultSetupLabel.setVisible(false);
                break;
            }
            default: {
                Log.logger((Object)this).warning("Unexpected TypeChoice : " + spectralSetupTypeChoice);
            }
        }
        this.getLayout().layoutContainer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedbackAdvancedSetup(TableModelEvent tableModelEvent) throws InvalidGroupIndexException {
        this.setSpectralSetupAdvisorySeverity(SpectralFeedback.AdvisoryType.ERROR);
        SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSpectralSetupParameters();
        if (spectralSetupParameters == null || !this.isFeedbackComplete) {
            return;
        }
        this.isFeedbackComplete = false;
        try {
            int n = ((MultiResolutionElementTableModel)tableModelEvent.getSource()).getTargetIndex();
            String string = spectralSetupParameters.feedbackAdvancedSetup(n);
            if (this.feedbackArea != null) {
                this.feedbackArea.setForeground(Colors.OT_RED);
                this.feedbackArea.setText(string);
            }
        }
        finally {
            this.isFeedbackComplete = true;
        }
    }

    private void feedbackSingleContinuumSetup() {
        this.setSpectralSetupAdvisorySeverity(SpectralFeedback.AdvisoryType.ERROR);
        SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSpectralSetupParameters();
        if (spectralSetupParameters == null || spectralSetupParameters.getSoleFrequency().isZero()) {
            return;
        }
        if (this.feedbackArea != null) {
            String string = spectralSetupParameters.feedbackSingleContinuumSetup();
            this.feedbackArea.setForeground(Colors.OT_RED);
            this.feedbackArea.setText(string);
        }
    }

    public void addScienceSpectralWindowSelectionListener(ScienceSpectralWindowSelectionListener scienceSpectralWindowSelectionListener) {
        this.scienceSpectralWindowSelectionListeners.add(scienceSpectralWindowSelectionListener);
    }

    private void scienceSpectralWindowSelectionChanged(AbstractScienceSpectralWindow abstractScienceSpectralWindow) {
        for (ScienceSpectralWindowSelectionListener scienceSpectralWindowSelectionListener : this.scienceSpectralWindowSelectionListeners) {
            scienceSpectralWindowSelectionListener.scienceSpectralWindowSelectionChanged(abstractScienceSpectralWindow);
        }
    }

    private void addSpectralSelectionListener(final SpectralSetupParametersEditor spectralSetupParametersEditor, final int n) {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){
            final SpectralSetupParametersEditor parentEditor;
            final int subEditorIndex;
            {
                this.parentEditor = spectralSetupParametersEditor;
                this.subEditorIndex = n;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n2 = this.parentEditor.getSelectedScienceSpectralWindowIndex(this.subEditorIndex);
                if (n2 < 0) {
                    return;
                }
                if (this.parentEditor.isVisible()) {
                    SfiSpectralSetupEditor.this.scienceSpectralWindowSelectionChanged(this.parentEditor.getSelectedScienceSpectralWindow(this.subEditorIndex));
                    for (int i = 0; i < 4; ++i) {
                        if (this.subEditorIndex == i) continue;
                        ListSelectionListener listSelectionListener = this.parentEditor.getListSelectionListener(i);
                        this.parentEditor.removeListSelectionListener(i, listSelectionListener);
                        this.parentEditor.clearSelection(i);
                        this.parentEditor.addListSelectionListener(i, listSelectionListener);
                    }
                }
            }
        };
        spectralSetupParametersEditor.addListSelectionListener(n, listSelectionListener);
    }

    private void addSpectralSelectionListeners(SpectralSetupParametersEditor spectralSetupParametersEditor) {
        for (int i = 0; i < 4; ++i) {
            this.addSpectralSelectionListener(spectralSetupParametersEditor, i);
        }
    }

    private void addSourceVelocityGroup() {
        JPanel jPanel = null;
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.sourceTable = new Table(this.targetsTableModel);
        this.sourceTable.setName("SfiSpectralSetupEditor.targetsTable");
        this.sourceTable.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        this.sourceTable.setDefaultRenderer(Double.class, new ResourceColumnRenderer());
        this.sourceTable.setSelectionMode(0);
        this.sourceTable.setColumnSelectionAllowed(false);
        this.sourceTable.setRowSelectionAllowed(true);
        this.sourceTable.getTableHeader().setReorderingAllowed(false);
        ColumnResizer.initColumnSizes(this.sourceTable, this.targetsTableModel.getLongValues());
        this.addSourceVelocitySelectionListener(this.sourceTable);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.sourceTable);
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = this.addGroup(jPanel, "Sources");
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Targets");
    }

    private void setSpectralSetupAdvisorySeverity(@NonNull SpectralFeedback.AdvisoryType advisoryType) {
        if (advisoryType == null) {
            throw new NullPointerException("severity is marked non-null but is null");
        }
        this.feedbackArea.setBorder(BorderFactory.createTitledBorder("Spectral Setup " + advisoryType.getLabel()));
    }

    public void addSourceVelocitySelectionListener(@NonNull JTable jTable) {
        if (jTable == null) {
            throw new NullPointerException("targetTable is marked non-null but is null");
        }
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private int previousKeyTarget = -1;

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.getValueIsAdjusting()) {
                    int n = listSelectionModel.getMaxSelectionIndex();
                    if (n == -1 || n == this.previousKeyTarget) {
                        return;
                    }
                    this.previousKeyTarget = n;
                    if (SfiSpectralSetupEditor.this.spectralLineGroup.isVisible()) {
                        for (int i = 0; i < 4; ++i) {
                            MultiResolutionElementTableModel multiResolutionElementTableModel = SfiSpectralSetupEditor.this.spectralLineEditor.getSpectralWindowGroupEditor(i).getMyModel().getTableModel();
                            multiResolutionElementTableModel.setTargetIndex(n);
                        }
                    } else if (SfiSpectralSetupEditor.this.singleContinuumGroup.isVisible()) {
                        for (int i = 0; i < 4; ++i) {
                            MultiResolutionElementTableModel multiResolutionElementTableModel = SfiSpectralSetupEditor.this.singleContinuumEditor.getSpectralWindowGroupEditor(i).getMyModel().getTableModel();
                            multiResolutionElementTableModel.setTargetIndex(n);
                        }
                        ObservingFrequencyModel observingFrequencyModel = SfiSpectralSetupEditor.this.singleContinuumFrequencyEditor.getModel();
                        observingFrequencyModel.getObservingFrequency().setTargetIndex(n);
                        observingFrequencyModel.publish();
                    } else if (SfiSpectralSetupEditor.this.spectralScanGroup.isVisible()) {
                        SfiSpectralSetupEditor.this.spectralScanEditor.getModel().setTargetIndex(n);
                    }
                }
            }
        });
    }

    @Override
    public void finalizeUserEdits() {
        this.spectralLineEditor.finalizeUserEdits();
    }

    @Override
    public void valueChanged(@NonNull ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (!listSelectionEvent.getValueIsAdjusting()) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getMaxSelectionIndex();
            if (n == -1 && n != this.lastSourceSelectedInSourceTableIndex) {
                return;
            }
            this.lastSourceSelectedInSourceTableIndex = n;
            this.singleFieldScienceGoalModel.setKeyTargetParameter(n);
        }
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        super.modelChanged(model, fieldID, object);
        if (this.sourceTable != null && fieldID.equals(SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID)) {
            boolean bl;
            int n = this.sourceTable.getSelectedRow();
            boolean bl2 = bl = n != -1 && n >= this.sourceTable.getRowCount();
            if (this.sourceTable.getRowCount() > 0 && n == -1 || bl) {
                this.sourceTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void editorSelected(Object object) {
        if (object instanceof JTable) {
            JTable jTable = (JTable)object;
            int n = jTable.getSelectedRow();
            this.sourceTable.setRowSelectionInterval(n, n);
        }
    }

    @Override
    public Object getEditorUnselectedInfo() {
        return this.sourceTable;
    }

    public JTable getSourceTable() {
        return this.sourceTable;
    }

    public SpectralSetupParametersEditor getSpectralLineEditor() {
        return this.spectralLineEditor;
    }

    public SpectralSetupParametersEditor getSingleContinuumEditor() {
        return this.singleContinuumEditor;
    }

    public static interface ScienceSpectralWindowSelectionListener
    extends EventListener {
        public void scienceSpectralWindowSelectionChanged(AbstractScienceSpectralWindow var1);
    }

    public static interface ScienceSpectralWindowSelector {
        public AbstractScienceSpectralWindow getSelectedScienceSpectralWindow();
    }

    protected class AdvancedSpectralPanel
    extends NotSupportedYetPanel
    implements ScienceSpectralWindowSelector {
        AdvancedSpectralPanel(String string) {
            super(string);
        }

        @Override
        public AbstractScienceSpectralWindow getSelectedScienceSpectralWindow() {
            return null;
        }
    }

    private static enum VLBIProjectType {
        Unknown,
        PhasedArray,
        VLBI;

    }
}

