/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.OpticalPointingTargetParameters;
import alma.obsprep.bo.obsproject.OpticalPointingTargetQueryParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DecVerifier;
import alma.obsprep.guiutil.mvc.verifiers.ISODateVerifier;
import alma.obsprep.guiutil.mvc.verifiers.RAVerifier;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.OpticalPointingTargetQueryModel;
import alma.obsprep.util.Convert;
import alma.valuetypes.Angle;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OpticalPointingTargetQueryEditor
extends EditorWithGridBagLayout
implements ChangeListener {
    public static FieldID CATALOG_LOCATION_FID = new FieldID("optCatalogLocationFID");
    public static FieldID FILENAME_FID = new FieldID("optFilenameFID");
    public static FieldID BROWSE_BUTTON_FID = new FieldID("optBrowseButtonFID");
    public static FieldID RA_MIN_FID = new FieldID("optQueryRAMinFID");
    public static FieldID RA_MAX_FID = new FieldID("optQueryRAMaxFID");
    public static FieldID DEC_MIN_FID = new FieldID("optQueryDecMinFID");
    public static FieldID DEC_MAX_FID = new FieldID("optQueryDecMaxFID");
    public static FieldID MAG_BRIGHTEST_FID = new FieldID("optQueryMagBrightFID");
    public static FieldID MAG_FAINTEST_FID = new FieldID("optQueryMagFaintFID");
    public static FieldID AZ_MIN_FID = new FieldID("optQueryAzMinFID");
    public static FieldID AZ_MAX_FID = new FieldID("optQueryAzMaxFID");
    public static FieldID EL_MIN_FID = new FieldID("optQueryElMinFID");
    public static FieldID EL_MAX_FID = new FieldID("optQueryElMaxFID");
    public static FieldID LST_FID = new FieldID("optQueryDateFID");
    public static FieldID NOW_BUTTON_FID = new FieldID("optQueryNowButtonFID");
    public static FieldID SELECTION_FACTOR_FID = new FieldID("optQuerySelectionFactorFID");
    public static FieldID LOAD_SEPARATION_FID = new FieldID("optQueryLoadMinSeparationValueFID");
    public static FieldID QUERY_BUTTON_FID = new FieldID("optQueryButtonFID");
    public static FieldID LOAD_BUTTON_FID = new FieldID("optLoadButtonFID");
    public static FieldID FILTER_BUTTON_FID = new FieldID("optFilterButtonFID");
    public static FieldID UNDO_BUTTON_FID = new FieldID("optUndoButtonFID");
    public static FieldID SEPARATION_FID = new FieldID("optQueryMinSeparationValueFID");
    public static FieldID SEP_BUTTON_FID = new FieldID("optSeparationFilterButtonFID");
    public static FieldID N_STARS_FID = new FieldID("optQueryNStarsFID");
    public static FieldID RANDOM_BUTTON_FID = new FieldID("optRandomButtonFID");
    public static final String TIME_LST = "LST";
    private JButton newQueryButton = new JButton("New Query");
    private JButton undoButton = new JButton("Undo Filtering");
    private JButton loadButton = new JButton("Load & Filter");
    private JButton filterButton = new JButton("Filter");
    private JLabel lstLabel;
    private final String LST_LABEL_STRING = "Time[LST]@";
    JComponent c1;
    JComponent c2;
    JComponent c3;

    public OpticalPointingTargetQueryEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
        SiteCharacteristics.addChangeListener(this);
    }

    @Override
    public void build() {
        this.build("OpticalPointingTargetQuery");
    }

    private static String getDateString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UT"));
        simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.S");
        return simpleDateFormat.format(date);
    }

    private OpticalPointingTargetQueryModel getMyModel() {
        return (OpticalPointingTargetQueryModel)this.getModel();
    }

    @Override
    public void addComponents(String string) {
        this.constraints.weightx = 1.0;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        OTButtonGroup oTButtonGroup = this.addOTButtonGroup((JComponent)jPanel, gridBagLayout, gridBagConstraints, CATALOG_LOCATION_FID, "Catalog Location", "Select location of the catalog", OpticalPointingTargetQueryParameters.getKnownLocationList());
        ComponentCollection componentCollection = new ComponentCollection();
        this.c1 = this.makeLabel("File");
        componentCollection.remember(this.c1);
        JComponent[] jComponentArray = new JComponent[1];
        OTTextField oTTextField = this.makeTextField(FILENAME_FID, "Local File");
        this.c2 = oTTextField;
        jComponentArray[0] = oTTextField;
        componentCollection.remember(jComponentArray);
        oTTextField.setColumns(35);
        this.c3 = this.makeButton(BROWSE_BUTTON_FID, "Browse", "Select a file");
        componentCollection.remember(this.c3);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addNonCollapsingGroup(jPanel, "Tycho Catalog Location");
        JPanel jPanel2 = this.createNewGroup();
        gridBagLayout = this.createNewLayout(jPanel2);
        gridBagConstraints = this.createNewConstraints();
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("RA limits"));
        componentCollection.remember(this.makeLabel("Min"));
        JComponent[] jComponentArray2 = new JComponent[1];
        OTTextField oTTextField2 = this.makeTextField(RA_MIN_FID, "Min RA to query/filter");
        jComponentArray2[0] = oTTextField2;
        componentCollection.remember(jComponentArray2);
        componentCollection.remember(this.makeLabel("Max"));
        JComponent[] jComponentArray3 = new JComponent[1];
        OTTextField oTTextField3 = this.makeTextField(RA_MAX_FID, "Max RA to query/filter");
        jComponentArray3[0] = oTTextField3;
        componentCollection.remember(jComponentArray3);
        this.setVerifier(oTTextField2, "FOCUSLOST_VERIFIER", new RAVerifier(this, oTTextField2));
        this.setVerifier(oTTextField3, "FOCUSLOST_VERIFIER", new RAVerifier(this, oTTextField3));
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Dec limits"));
        componentCollection.remember(this.makeLabel("Min"));
        JComponent[] jComponentArray4 = new JComponent[1];
        oTTextField2 = this.makeTextField(DEC_MIN_FID, "Min Dec to query/filter");
        jComponentArray4[0] = oTTextField2;
        componentCollection.remember(jComponentArray4);
        componentCollection.remember(this.makeLabel("Max"));
        JComponent[] jComponentArray5 = new JComponent[1];
        oTTextField3 = this.makeTextField(DEC_MAX_FID, "Max Dec to query/filter");
        jComponentArray5[0] = oTTextField3;
        componentCollection.remember(jComponentArray5);
        this.setVerifier(oTTextField2, "FOCUSLOST_VERIFIER", new DecVerifier(this, oTTextField2));
        this.setVerifier(oTTextField3, "FOCUSLOST_VERIFIER", new DecVerifier(this, oTTextField3));
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Magnitude limits"));
        componentCollection.remember(this.makeLabel("Brightest"));
        JComponent[] jComponentArray6 = new JComponent[1];
        oTTextField2 = this.makeTextFieldWithDoubleVerifier(MAG_BRIGHTEST_FID, "Brightest Magnitude to query/filter", -1.7976931348623157E308, Double.MAX_VALUE);
        jComponentArray6[0] = oTTextField2;
        componentCollection.remember(jComponentArray6);
        componentCollection.remember(this.makeLabel("Faintest"));
        JComponent[] jComponentArray7 = new JComponent[1];
        oTTextField3 = this.makeTextFieldWithDoubleVerifier(MAG_FAINTEST_FID, "Faintest Magnitude to query/filter", -1.7976931348623157E308, Double.MAX_VALUE);
        jComponentArray7[0] = oTTextField3;
        componentCollection.remember(jComponentArray7);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel2, gridBagLayout, gridBagConstraints, new JSeparator());
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Azimuth limits"));
        componentCollection.remember(this.makeLabel("Min"));
        componentCollection.remember(this.makeTextFieldWithDoubleVerifier(AZ_MIN_FID, "Min Azimuth to filter (" + Angle.UNIT_DEG + ")", 0.0, 360.0));
        componentCollection.remember(this.makeLabel("Max"));
        componentCollection.remember(this.makeTextFieldWithDoubleVerifier(AZ_MAX_FID, "Max Azimuth to filter (" + Angle.UNIT_DEG + ")", 0.0, 360.0));
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Elevation limits"));
        componentCollection.remember(this.makeLabel("Min"));
        componentCollection.remember(this.makeTextFieldWithDoubleVerifier(EL_MIN_FID, "Min Elevation to filter (" + Angle.UNIT_DEG + ")", -90.0, 90.0));
        componentCollection.remember(this.makeLabel("Max"));
        componentCollection.remember(this.makeTextFieldWithDoubleVerifier(EL_MAX_FID, "Max Elevation to filter (" + Angle.UNIT_DEG + ")", -90.0, 90.0));
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        Box box = Box.createHorizontalBox();
        OTTextField oTTextField4 = this.makeTextField(LST_FID, "Date : YYYY-MM-DD hh:mm:ss");
        ISODateVerifier iSODateVerifier = new ISODateVerifier(this, oTTextField4){

            @Override
            public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
                Object object = null;
                try {
                    object = super.validate(jTextField);
                }
                catch (NumberFormatException numberFormatException) {
                    if (jTextField.getText() == null || jTextField.getText().length() == 0) {
                        return "";
                    }
                    throw numberFormatException;
                }
                return object;
            }
        };
        this.setVerifier(oTTextField4, "FOCUSLOST_VERIFIER", iSODateVerifier);
        componentCollection = new ComponentCollection();
        String string2 = SiteCharacteristics.getInstance().getObsName();
        JComponent[] jComponentArray8 = new JComponent[1];
        this.lstLabel = this.makeLabel("Time[LST]@" + string2);
        jComponentArray8[0] = this.lstLabel;
        componentCollection.remember(jComponentArray8);
        componentCollection.remember((JComponent)oTTextField4, 2);
        componentCollection.remember(this.makeButton(NOW_BUTTON_FID, "Now", "Set current time"));
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel2, gridBagLayout, gridBagConstraints, new JSeparator());
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints);
        this.addTextComponent(jPanel2, gridBagLayout, gridBagConstraints, SELECTION_FACTOR_FID, "Select one target in every ", "<html>Select only every nth target which matches the criteria.<br>This will help to cut down the total number of targets,<br>but maintain good sky coverage</html>");
        oTTextField = this.addTextComponent(jPanel2, gridBagLayout, gridBagConstraints, LOAD_SEPARATION_FID, "Field Min Separation", "<html>Minimum required separation between<br>any two stars in the field (" + Angle.UNIT_ARCMIN + ")</html>");
        this.initEvents(this.newQueryButton, QUERY_BUTTON_FID);
        this.newQueryButton.setToolTipText("Query the Tycho catalog on the archive");
        this.initEvents(this.loadButton, LOAD_BUTTON_FID);
        this.loadButton.setToolTipText("Load the Tycho-2 catalogue from local file");
        this.loadButton.setEnabled(false);
        this.initEvents(this.filterButton, FILTER_BUTTON_FID);
        this.filterButton.setToolTipText("Narrow the list filtering with the criteria");
        this.initEvents(this.undoButton, UNDO_BUTTON_FID);
        this.undoButton.setToolTipText("Undo the previous filtering");
        this.undoButton.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.newQueryButton);
        jPanel3.add(this.loadButton);
        jPanel3.add(this.filterButton);
        jPanel3.add(this.undoButton);
        this.addComponent(jPanel2, gridBagLayout, gridBagConstraints, jPanel3);
        this.addNonCollapsingGroup(jPanel2, "Query Parameters");
        JPanel jPanel4 = this.createNewGroup();
        gridBagLayout = this.createNewLayout(jPanel4);
        gridBagConstraints = this.createNewConstraints();
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Target List Min Separation"));
        componentCollection.remember(this.makeTextField(SEPARATION_FID, "Minimum separation between any two stars in the target list (" + Angle.UNIT_ARCMIN + ")"));
        componentCollection.remember(this.makeButton(SEP_BUTTON_FID, "Filter", "Narrow the list filtering with separation"));
        this.addComponentArray(jPanel4, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Max Number of Stars"));
        componentCollection.remember(this.makeTextField(N_STARS_FID, "Maximum number of stars"));
        componentCollection.remember(this.makeButton(RANDOM_BUTTON_FID, "Random Selection", "<html>Randomly select the specified number<br>of targets from the list"));
        this.addComponentArray(jPanel4, gridBagLayout, gridBagConstraints, componentCollection);
        this.addNonCollapsingGroup(jPanel4, "Optional Filters");
    }

    private ArrayList<OpticalPointingTargetParameters> getNewArrayList() {
        return new ArrayList<OpticalPointingTargetParameters>();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == CATALOG_LOCATION_FID) {
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.retrieve(fieldID);
            oTButtonGroup.setSelectedItem((String)object);
            this.setSource((String)object);
        } else {
            if (fieldID.equals(BROWSE_BUTTON_FID)) {
                JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
                if (jFileChooser.showOpenDialog(this) == 0 && jFileChooser.getSelectedFile() != null) {
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getAbsolutePath();
                    this.update(FILENAME_FID, this.getMyModel().update(this, FILENAME_FID, string));
                }
                return;
            }
            if (fieldID.equals(RA_MAX_FID) || fieldID.equals(RA_MIN_FID)) {
                String string = null;
                try {
                    string = Convert.degToHHMMSS((Double)object);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (InvalidCoordException invalidCoordException) {
                }
                catch (OutOfRangeException outOfRangeException) {
                    // empty catch block
                }
                super.update(fieldID, string);
            } else if (fieldID.equals(DEC_MAX_FID) || fieldID.equals(DEC_MIN_FID)) {
                String string = null;
                try {
                    string = Convert.degToDDMMSS((Double)object);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (InvalidCoordException invalidCoordException) {
                }
                catch (OutOfRangeException outOfRangeException) {
                    // empty catch block
                }
                super.update(fieldID, string);
            } else if (fieldID.equals(NOW_BUTTON_FID)) {
                Date date = OpticalPointingScienceGoal.getLst(new Date());
                this.update(LST_FID, this.getMyModel().update(this, LST_FID, OpticalPointingTargetQueryEditor.getDateString(date)));
            } else if (fieldID.equals(LST_FID)) {
                if (object == null || object == "") {
                    super.update(fieldID, null);
                } else {
                    Calendar calendar = (Calendar)object;
                    super.update(fieldID, OpticalPointingTargetQueryEditor.getDateString(calendar.getTime()));
                }
            } else if (fieldID.equals(QUERY_BUTTON_FID) || fieldID.equals(LOAD_BUTTON_FID) || fieldID.equals(FILTER_BUTTON_FID) || fieldID.equals(UNDO_BUTTON_FID) || fieldID.equals(SEP_BUTTON_FID) || fieldID.equals(RANDOM_BUTTON_FID)) {
                this.setUndoButton();
            } else {
                super.update(fieldID, object);
            }
        }
    }

    private void setSource(String string) {
        if (string.equalsIgnoreCase("Local File")) {
            this.loadButton.setEnabled(false);
            this.c2.setEnabled(true);
            this.c3.setEnabled(true);
            this.newQueryButton.setEnabled(false);
            this.filterButton.setEnabled(true);
        } else if (string.equalsIgnoreCase("Local Catalogue")) {
            this.loadButton.setEnabled(true);
            this.c2.setEnabled(false);
            this.c3.setEnabled(false);
            this.newQueryButton.setEnabled(false);
            this.filterButton.setEnabled(false);
        } else {
            this.loadButton.setEnabled(false);
            this.c2.setEnabled(false);
            this.c3.setEnabled(false);
            this.newQueryButton.setEnabled(true);
            this.filterButton.setEnabled(true);
        }
    }

    private void setUndoButton() {
        OpticalPointingTargetQueryParameters opticalPointingTargetQueryParameters = this.getMyModel().getQueryParameters();
        OpticalPointingScienceGoal opticalPointingScienceGoal = (OpticalPointingScienceGoal)opticalPointingTargetQueryParameters.getParent();
        if (opticalPointingScienceGoal != null) {
            this.undoButton.setEnabled(opticalPointingScienceGoal.canUndo());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == SiteCharacteristics.class) {
            String string = SiteCharacteristics.getInstance().getObsName();
            if (this.lstLabel != null) {
                this.lstLabel.setText("Time[LST]@" + string);
            }
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        System.setProperty("Telescope", "ALMA");
        OpticalPointingScienceGoal opticalPointingScienceGoal = OpticalPointingScienceGoal.createOpticalPointingScienceGoal();
        OpticalPointingTargetQueryParameters opticalPointingTargetQueryParameters = opticalPointingScienceGoal.getOpticalPointingTargetQueryParameters();
        OpticalPointingTargetQueryModel opticalPointingTargetQueryModel = new OpticalPointingTargetQueryModel((Object)opticalPointingTargetQueryParameters);
        OpticalPointingTargetQueryEditor opticalPointingTargetQueryEditor = new OpticalPointingTargetQueryEditor(opticalPointingTargetQueryModel);
        OpticalPointingTargetQueryEditor.runTestApp(opticalPointingTargetQueryEditor);
    }
}

