/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.DecVerifier;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.guiutil.mvc.verifiers.RAVerifier;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.boEditors.TimeVerifier;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class QuerySourceEditor
extends EditorWithGridBagLayout {
    public static final int AMPLITUDE_CALIBRATOR = 0;
    public static final int PHASE_CALIBRATOR = 1;
    public static final int POINTING_CALIBRATOR = 2;
    public static final int POLARIZATION_CALIBRATOR = 3;
    public static final int FOCUS_CALIBRATOR = 4;
    public static final int BANDPASS_CALIBRATOR = 5;
    public static final int NO_CALIBRATOR = 6;
    public static final FieldID catlocFID = new FieldID("Calibrator Expert catlocFID");
    public static final FieldID raFID = new FieldID("Calibrator Expert raFID");
    public static final FieldID decFID = new FieldID("Calibrator Expert decFID");
    public static final FieldID radiusFID = new FieldID("Calibrator Expert radiusFID");
    public static final FieldID freqminFID_value = new FieldID("Calibrator Expert freqminValFID");
    public static final FieldID freqminFID_unit = new FieldID("Calibrator Expert freqminUnitFID");
    public static final FieldID freqmaxFID_value = new FieldID("Calibrator Expert freqmaxValFID");
    public static final FieldID freqmaxFID_unit = new FieldID("Calibrator Expert freqmaxUnitFID");
    public static final FieldID fluxminFID_value = new FieldID("Calibrator Expert fluxminValFID");
    public static final FieldID fluxminFID_unit = new FieldID("Calibrator Expert fluxminUnitFID");
    public static final FieldID fluxmaxFID_value = new FieldID("Calibrator Expert fluxmaxValFID");
    public static final FieldID fluxmaxFID_unit = new FieldID("Calibrator Expert fluxmaxUnitFID");
    public static final FieldID timeminFID_value = new FieldID("Calibrator Expert timeminValFID");
    public static final FieldID timeminFID_unit = new FieldID("Calibrator Expert timeminUnitFID");
    public static final FieldID timemaxFID_value = new FieldID("Calibrator Expert timemaxValFID");
    public static final FieldID timemaxFID_unit = new FieldID("Calibrator Expert timemaxUnitFID");
    public static final FieldID caltypeFID = new FieldID("Calibrator Expert caltypeFID");
    public static final FieldID filterFID = new FieldID("Calibrator Expert filterFID");
    public static final FieldID sortByFID = new FieldID("Calibrator Expert sortByFID");
    public static final FieldID maxSourcesFID = new FieldID("Calibrator Expert maxSourcesFID");
    public static final FieldID sortAscendingFID = new FieldID("Calibrator Expert sortAscendingFID");
    public static final FieldID sourceTypeFID = new FieldID("CalibratorExpert sourceTypeFID");
    private JLabel calibratorTagLabel;
    private JLabel searchLabel;
    private JLabel fluxLabel;
    private JLabel frequencyLabel;
    private JLabel timeLabel;
    private JLabel minTimeLabel;
    private JLabel maxTimeLabel;
    private JPanel searchParametersPanel;
    private ValueUnitPairEditor minTime;
    private ValueUnitPairEditor maxTime;
    private JPanel cataloguePanel;

    public QuerySourceEditor(Model model) {
        this.setModel(model);
        this.buildCatalogueLocationPanel();
        this.buildQueryEditorPanel();
        this.build();
        model.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        super.modelChanged(model, fieldID, object);
        CalibratorExpertModel calibratorExpertModel = this.getCalibratorExpertModel();
        ICalibratorExpertDocument iCalibratorExpertDocument = (ICalibratorExpertDocument)calibratorExpertModel.getDocument();
        if (iCalibratorExpertDocument == null) {
            return;
        }
        if (iCalibratorExpertDocument.getMinFlux().getContent() == 0.0 && iCalibratorExpertDocument.getMaxFlux().getContent() == 0.0) {
            this.fluxLabel.setIcon(Icons.filterDisabled);
        } else {
            this.fluxLabel.setIcon(Icons.filterEnabled);
        }
        if (iCalibratorExpertDocument.getMinFrequency().getContent() == 0.0 && iCalibratorExpertDocument.getMaxFrequency().getContent() == 0.0) {
            this.frequencyLabel.setIcon(Icons.filterDisabled);
        } else {
            this.frequencyLabel.setIcon(Icons.filterEnabled);
        }
        if (iCalibratorExpertDocument.getLatestObservation() == null && iCalibratorExpertDocument.getEarliestObservation() == null) {
            this.timeLabel.setIcon(Icons.filterDisabled);
        } else {
            this.timeLabel.setIcon(Icons.filterEnabled);
        }
        if (iCalibratorExpertDocument.getRadius() == 0.0) {
            this.searchLabel.setIcon(Icons.filterDisabled);
        } else {
            this.searchLabel.setIcon(Icons.filterEnabled);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (timeminFID_value.equals(fieldID) || timemaxFID_value.equals(fieldID)) {
            if (object instanceof String && !((String)object).isEmpty()) {
                Double d = Double.valueOf((String)object);
                Double d2 = d / 86400.0;
                object = d2;
            }
        } else if (catlocFID.equals(fieldID)) {
            if (CalibratorExpert.SourceCatalog.OFFLINE.getName().equals(object)) {
                this.calibratorTagLabel.setVisible(false);
                this.minTime.setVisible(false);
                this.minTimeLabel.setVisible(false);
                this.maxTime.setVisible(false);
                this.maxTimeLabel.setVisible(false);
                this.timeLabel.setVisible(false);
            } else {
                this.calibratorTagLabel.setVisible(true);
                this.minTime.setVisible(false);
                this.minTimeLabel.setVisible(false);
                this.maxTime.setVisible(false);
                this.maxTimeLabel.setVisible(false);
                this.timeLabel.setVisible(false);
            }
        }
        super.update(fieldID, object);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (timeminFID_value.equals(fieldID) || timemaxFID_value.equals(fieldID)) {
            Double d = Double.parseDouble((String)object);
            Double d2 = d * 86400.0;
            object = d2.toString();
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.addNonCollapsingGroup(4, this, gridBagLayout, gridBagConstraints, this.searchParametersPanel, "Source Catalog Search Parameters");
    }

    private void buildCatalogueLocationPanel() {
        this.cataloguePanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(this.cataloguePanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.addOTButtonGroup((JComponent)this.cataloguePanel, gridBagLayout, gridBagConstraints, catlocFID, "Catalogue Location ", "Select location of the catalogue", CalibratorExpert.SourceCatalog.getNames());
    }

    private void buildQueryEditorPanel() {
        CalibratorExpertModel calibratorExpertModel = this.getCalibratorExpertModel();
        this.searchParametersPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.searchLabel = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.frequencyLabel = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.fluxLabel = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.timeLabel = new JLabel();
        this.minTimeLabel = new JLabel();
        this.maxTimeLabel = new JLabel();
        this.calibratorTagLabel = new JLabel();
        this.fluxLabel.setIconTextGap(12);
        this.frequencyLabel.setIconTextGap(12);
        this.timeLabel.setIconTextGap(12);
        this.searchLabel.setIconTextGap(12);
        OTTextField oTTextField = this.makeTextField(raFID, 14, true, "Centre Right Ascension of Cone Search");
        OTTextField oTTextField2 = this.makeTextField(decFID, 14, true, "Centre Declination of Cone Search");
        OTTextField oTTextField3 = this.makeTextField(radiusFID, 14, true, "Search radius of cone search, in degrees");
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor(calibratorExpertModel.getMinFreqModel(), "Minimum Frequency");
        ValueUnitPairEditor valueUnitPairEditor2 = this.makeValueUnitPairEditor(calibratorExpertModel.getMaxFreqModel(), "Maximum Frequency");
        ValueUnitPairEditor valueUnitPairEditor3 = this.makeValueUnitPairEditor(calibratorExpertModel.getMinFluxModel(), "Minimum Flux");
        ValueUnitPairEditor valueUnitPairEditor4 = this.makeValueUnitPairEditor(calibratorExpertModel.getMaxFluxModel(), "Maximum Flux");
        this.minTime = this.makeValueUnitPairEditor(calibratorExpertModel.getMinLastObservedModel(), "Minimum Time Since Last Observation");
        this.maxTime = this.makeValueUnitPairEditor(calibratorExpertModel.getMaxLastObservedModel(), "Maximum Time Since Last Observation");
        OTTextField oTTextField4 = this.makeTextField(maxSourcesFID, 3, true, "Maximum number of sources to return. Must be between 1-100.");
        this.setVerifier(oTTextField, "FOCUSLOST_VERIFIER", new RAVerifier(this, oTTextField));
        this.setVerifier(oTTextField2, "FOCUSLOST_VERIFIER", new DecVerifier(this, oTTextField2));
        this.setVerifier(oTTextField3, "FOCUSLOST_VERIFIER", new DoubleVerifier((Editor)this, (JTextField)oTTextField3, 0.0, 360.0));
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(valueUnitPairEditor, 0.0, 100000.0));
        valueUnitPairEditor2.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(valueUnitPairEditor2, 0.0, 100000.0));
        valueUnitPairEditor3.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor3));
        valueUnitPairEditor4.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor4));
        this.minTime.setVerifier("FOCUSLOST_VERIFIER", new TimeVerifier(this.minTime));
        this.maxTime.setVerifier("FOCUSLOST_VERIFIER", new TimeVerifier(this.maxTime));
        this.setVerifier(oTTextField4, "FOCUSLOST_VERIFIER", new IntegerVerifier(this, oTTextField4, 0, 100));
        this.searchParametersPanel.setLayout(new GridBagLayout());
        jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getStyle() & 0xFFFFFFFE));
        jLabel2.setText("<html><ul><li>Set a non-zero value to enable a filter</li><li>A maximum of 100 results can be returned</li></ul></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.searchParametersPanel.add((Component)jLabel2, gridBagConstraints);
        this.searchLabel.setText("Cone Search");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.searchLabel, gridBagConstraints);
        jLabel3.setText("RA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)oTTextField, gridBagConstraints);
        jLabel4.setText("Dec");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)oTTextField2, gridBagConstraints);
        jLabel5.setText("Radius (\u00b0)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.searchParametersPanel.add((Component)oTTextField3, gridBagConstraints);
        this.fluxLabel.setText("Flux");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.fluxLabel, gridBagConstraints);
        jLabel8.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)valueUnitPairEditor3, gridBagConstraints);
        jLabel9.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.searchParametersPanel.add((Component)valueUnitPairEditor4, gridBagConstraints);
        this.frequencyLabel.setText("Frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.frequencyLabel, gridBagConstraints);
        jLabel6.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)valueUnitPairEditor, gridBagConstraints);
        jLabel7.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.searchParametersPanel.add((Component)valueUnitPairEditor2, gridBagConstraints);
        this.timeLabel.setText("Last Observed");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.timeLabel, gridBagConstraints);
        this.minTimeLabel.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minTimeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minTime, gridBagConstraints);
        this.maxTimeLabel.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.maxTimeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.searchParametersPanel.add((Component)this.maxTime, gridBagConstraints);
        JLabel jLabel10 = new JLabel("Max Results");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.searchParametersPanel.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)oTTextField4, gridBagConstraints);
        this.calibratorTagLabel.setName("QuerySourceEditor.calibratorTagLabel");
        this.cataloguePanel.setName("QuerySourceEditor.cataloguePanel");
        oTTextField2.setName("QuerySourceEditor.dec");
        jLabel4.setName("QuerySourceEditor.decLabel");
        this.fluxLabel.setName("QuerySourceEditor.fluxLabel");
        this.frequencyLabel.setName("QuerySourceEditor.frequencyLabel");
        jLabel2.setName("QuerySourceEditor.helpLabel");
        valueUnitPairEditor4.setName("QuerySourceEditor.maxFlux");
        jLabel9.setName("QuerySourceEditor.maxFluxLabel");
        valueUnitPairEditor2.setName("QuerySourceEditor.maxFrequency");
        jLabel7.setName("QuerySourceEditor.maxFrequencyLabel");
        oTTextField4.setName("QuerySourceEditor.maxSources");
        jLabel10.setName("QuerySourceEditor.maxSourcesLabel");
        this.maxTime.setName("QuerySourceEditor.maxTime");
        this.maxTimeLabel.setName("QuerySourceEditor.maxTimeLabel");
        valueUnitPairEditor3.setName("QuerySourceEditor.minFlux");
        jLabel8.setName("QuerySourceEditor.minFluxLabel");
        valueUnitPairEditor.setName("QuerySourceEditor.minFrequency");
        jLabel6.setName("QuerySourceEditor.minFrequencyLabel");
        this.minTime.setName("QuerySourceEditor.minTime");
        this.minTimeLabel.setName("QuerySourceEditor.minTimeLabel");
        oTTextField.setName("QuerySourceEditor.ra");
        jLabel3.setName("QuerySourceEditor.raLabel");
        this.searchLabel.setName("QuerySourceEditor.searchLabel");
        this.searchParametersPanel.setName("QuerySourceEditor.searchParametersPanel");
        oTTextField3.setName("QuerySourceEditor.searchRadius");
        jLabel5.setName("QuerySourceEditor.searchRadiusLabel");
        this.timeLabel.setName("QuerySourceEditor.timeLabel");
        jLabel.setName("QuerySourceEditor.zeroLabel");
    }

    @Override
    protected void build() {
        super.build("QuerySourceEditor");
    }

    private CalibratorExpertModel getCalibratorExpertModel() {
        return (CalibratorExpertModel)this.getModel();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        QuerySource querySource = QuerySource.createQuerySource();
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            QuerySourceEditor querySourceEditor = new QuerySourceEditor(calibratorExpertModel);
            JFrame jFrame = new JFrame("QuerySourceEditor");
            jFrame.setDefaultCloseOperation(3);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jFrame.setLayout(gridBagLayout);
            jFrame.getContentPane().add((Component)querySourceEditor, gridBagConstraints);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }
}

