/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetSelectorEditor;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.toplevel.Dialog;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;

public class ObservatoryGoalTargetSelectorDialog
extends Dialog {
    private final QuerySourceEditor queryEditor;
    private final ObservatoryGoalTargetSelectorEditor targetsEditor;
    private final List<Measurement> selected = new ArrayList<Measurement>();

    public ObservatoryGoalTargetSelectorDialog(Model model, boolean bl) {
        this.setModal(true);
        this.queryEditor = new QuerySourceEditor(model);
        this.targetsEditor = new ObservatoryGoalTargetSelectorEditor(model, bl);
        this.targetsEditor.addOkButtonActionListener(actionEvent -> {
            this.setVisible(false);
            this.selected.clear();
            this.selected.addAll(this.targetsEditor.getSelectedCalibrators());
            this.dispose();
        });
        this.targetsEditor.addCancelButtonActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
            this.selected.clear();
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ObservatoryGoalTargetSelectorDialog.this.setVisible(false);
                ObservatoryGoalTargetSelectorDialog.this.selected.clear();
                ObservatoryGoalTargetSelectorDialog.this.dispose();
            }
        });
        this.initComponents();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.rescaleToMonitor(0.8);
        }
        super.setVisible(bl);
    }

    public List<Measurement> getSelected() {
        return this.selected;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Target List Selector");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.queryEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.targetsEditor.setBorder(new TitledBorder("Search Results"));
        this.add((Component)this.targetsEditor, gridBagConstraints);
        this.pack();
        this.getRootPane().setDefaultButton(this.targetsEditor.getSubmitQueryButton());
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        QuerySource querySource = QuerySource.createQuerySource();
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
            }
            ObservatoryGoalTargetSelectorDialog observatoryGoalTargetSelectorDialog = new ObservatoryGoalTargetSelectorDialog(calibratorExpertModel, false);
            observatoryGoalTargetSelectorDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            observatoryGoalTargetSelectorDialog.setVisible(true);
        });
    }
}

